#include <windows.h>
#include <windowsx.h>
#include <dos.h>
#include <errno.h>

#include "ws_glob.h"
#include "winftp.h"

#ifdef WIN32

void CreateUniqueName (LPSTR localname, LPSTR szName, LPSTR Ext)
{
  int nIndex;
  char szUniq[_MAX_PATH];
   
    nIndex = 0;
    lstrcpy (szUniq, localname);
    while ((GetFileAttributes (szUniq)!=0xFFFFFFFF) && (nIndex<99))
    {
      DoPrintf ("[recvuniq] %s - %s - %s", szName, Ext, szUniq);
      switch (Ext[0])
      {
        case '\0': wsprintf (szUniq, "%s.%03u", szName, nIndex); break;
        default  : if (lstrlen (szName)>5) szName[5]='\0';
                   wsprintf (szUniq, "%s%3.3d.%s", szName, nIndex, Ext);
      }
      nIndex++;
    }
    lstrcpy (localname, szUniq);
}

#else

void CreateUniqueName (LPSTR localname, LPSTR szName, LPSTR Ext)
{
  int nIndex;
  char szUniq[80];
  struct _find_t f;
    
    nIndex = 0;
    lstrcpy (szUniq, localname);
    while ((int) _dos_findfirst (szUniq, _A_NORMAL, &f)==0 && nIndex<99) 
    {
      DoPrintf ("[recvuniq] %s - %s - %s", szName, Ext, szUniq);
      switch (Ext[0])
      {
        case '\0': wsprintf (szUniq, "%s.%03u", szName, nIndex); break;
        default  : if (lstrlen (szName)>5) szName[5]='\0';
                   wsprintf (szUniq, "%s%3.3d.%s", szName, nIndex, Ext);
      }
      nIndex++;
    }
    lstrcpy (localname, szUniq);
}

#endif

//*****************************************************************************
//*****************************************************************************
BOOL OnCmdInitHostList (HWND hDlg, WPARAM wParam, LPARAM lParam)
{
  int nI;
  char szHost[40];
  char szType[30];
  char szBuf[80];

  for (nI=0; nI<nCfgNum; nI++)
  {
      lstrcpy (szHost, GetHostName (nI));
      if (lstrlen (szHost)>0)
      {
        lstrcpy (szType, GetHostType (nI));
        wsprintf (szBuf, "%-30s  %s", szHost, szType);
        SendDlgItemMessage (hDlg, LBX_HOSTLIST, LB_ADDSTRING, (WPARAM) 0, (LPARAM)(LPCSTR) szBuf);
      }
  }
  if (bConnected)
  {
    lstrcpy (szType, GetHostTypeValue (nHostType));
    wsprintf (szBuf, "Connected Host Type is %s", szType);
    SetDlgItemText (hDlg, TXT_CURHOST, szBuf);
  }
  else
  {
    SetDlgItemText (hDlg, TXT_CURHOST, "Not Connected to Remote Host");
  }
  SendDlgItemMessage (hDlg, LBX_HOSTLIST, WM_SETFONT, 
      (WPARAM) GetStockObject (ANSI_FIXED_FONT), (LPARAM) MAKELONG (TRUE, 0));
  return TRUE;
}

//*****************************************************************************
//*****************************************************************************
BOOL OnCmdHostListCmd (HWND hDlg, WPARAM wParam, LPARAM lParam)
{
  WORD wNotifyCode;
  WORD wCtlID;

#ifdef WIN32
  wNotifyCode = HIWORD (wParam);
  wCtlID      = LOWORD (wParam);
#else
  wNotifyCode = HIWORD (lParam);
  wCtlID      = wParam;
#endif
  
  switch (wCtlID)
  {
    case IDOK : EndDialog (hDlg, TRUE);
                return TRUE;
    default   : return FALSE;
  }
  return FALSE;
}


//*****************************************************************************
//*****************************************************************************
BOOL CALLBACK WS_HostListProc (HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  switch (Msg)
  {
    case WM_INITDIALOG: return OnCmdInitHostList (hDlg, wParam, lParam); 
    case WM_COMMAND   : return OnCmdHostListCmd (hDlg, wParam, lParam);
    default           : return FALSE;
  }
  return FALSE;
}

//*****************************************************************************
//*****************************************************************************
OnCmdDisplayHostList (HWND hWnd, WORD wCtlID, WORD wNotifyCode)
{
  FARPROC lpfnMsgProc;
  
  lpfnMsgProc = MakeProcInstance ((FARPROC) WS_HostListProc, hInst);
  DialogBox (hInst, (LPSTR) "DLG_HOSTLIST", hWnd, lpfnMsgProc);
  FreeProcInstance (lpfnMsgProc);
  return 0;
}

//*****************************************************************************
//*****************************************************************************
OnCmdDropFiles (HWND hWnd, LPSTR *lpPtr)
{
  char szRemoteName[_MAX_FNAME+_MAX_EXT+2], szExt[_MAX_EXT];
  int nCount, nRC, nIndex;
  u_char szTmp[150];

  if (!bConnected) return 0;
  if (lpPtr==NULL) return 0;
  if (lpPtr[0]==NULL) return 0;
  
  nCount=0; 
  while (lpPtr[nCount]!=NULL) nCount++;
  bCancelXfer = FALSE;
  bOpInProgress = TRUE;
  CreateXferWindow();
  for (nIndex=0; (nIndex<nCount)&(!bCancelXfer); nIndex++) 
  {
    if (lpPtr[nIndex]!=NULL)
    {
      _splitpath (lpPtr[nIndex], NULL, NULL, szRemoteName, szExt);
      lstrcat (szRemoteName, szExt);
      if (bInteractive)
      {
        FARPROC lpfnMsgProc;
      
        wsprintf (szDlgPrompt, "Enter remote file name for %s:", lpPtr[nIndex]);
        lstrcpy (szDlgEdit, szRemoteName);
        lpfnMsgProc = MakeProcInstance ((FARPROC) WS_InputMsgProc, hInst);
        DialogBox (hInst, (LPSTR) "DLG_INPUT", hWnd, lpfnMsgProc);
        FreeProcInstance (lpfnMsgProc);
        lstrcpy (szRemoteName, szDlgEdit);
      }
      DoPrintf (szTmp, "Sending %s as %s (%u of %u)", lpPtr[nIndex], szRemoteName, nIndex+1, nCount);
      wsprintf (szTmp, "STOR %s", szRemoteName);
      nRC = SendFile (ctrl_socket, szTmp, lpPtr[nIndex], fType);
      GlobalFreePtr (lpPtr[nIndex]);
    }
  }
  DeleteXferWindow();
  GetRemoteDirForWnd (hWnd);
  bOpInProgress = FALSE;
  GlobalFreePtr (lpPtr);
  return 0;
}

/************************************************************************/
/************************************************************************/
DoRunScript (HWND hWnd, LPSTR lpScript)
{
  FILE *fp;
  char szCmd[150];
  LPSTR lpParm;
  
  if ((fp=fopen (lpScript, "rt"))==NULL)
  {
    DoPrintf ("Could not execute Script: %s", lpScript);
    return 0;
  }
  while (fgets (szCmd, 145, fp)!=NULL)
  {
    strtok (szCmd, "\n");
    lpParm = strchr (szCmd, ' ');
    if (lpParm!=NULL) *lpParm++ = '\0';
    if (lstrcmpi (szCmd, "CMD") == 0) command (ctrl_socket, lpParm);
  }
  fclose (fp);
  return 0;
}

static LONG lTotalBytes=0, lXferBytes=0;
static int  nPercentXfer;
static HWND hWndXfer=NULL;

/************************************************************************/
/************************************************************************/
void PaintXfer (HDC hDC)
{
  RECT rc;
  char szBuf[10];

  CreateButtonPens();
  SelectObject (hDC, GetStockObject (WHITE_BRUSH));
  Rectangle (hDC, (nWndx*20)/4, (nWndy*10)/8, (nWndx*122)/4, (nWndy*20)/8);
  rc.left = (nWndx*21)/4;  rc.right = (nWndx*(nPercentXfer+21))/4;
  rc.top  = (nWndy*11)/8;  rc.bottom= (nWndy*19)/8;
  FillRect (hDC, &rc, GetStockObject (GRAY_BRUSH));
  rc.right = (nWndx*121)/4;
  SetBkMode (hDC, TRANSPARENT);
  wsprintf (szBuf, "%d%%", nPercentXfer);
  DrawText (hDC, szBuf, lstrlen (szBuf), &rc, DT_CENTER | DT_VCENTER);
  SetBkMode (hDC, OPAQUE);
  BoxIt (hDC, 18, 8, 106, 14, FALSE);
  DeleteButtonPens();
}

/************************************************************************/
/************************************************************************/
void OnPaintXfer (HWND hWnd)
{
  HDC hDC;
  PAINTSTRUCT ps;
  
  hDC = BeginPaint (hWnd, &ps);
  PaintXfer (hDC);
  EndPaint (hWnd, &ps);
}

/************************************************************************/
/************************************************************************/
void ForcePaintXfer (HWND hWnd)
{
}

/************************************************************************/
/************************************************************************/
void SetTotalBytes (LONG lBytes)
{
  lTotalBytes = lBytes;
}

/************************************************************************/
/************************************************************************/
void SetXmitBytes (LONG lBytes)
{
  int nOld;
  
  lXferBytes = lBytes;
  if ((lTotalBytes==0)||(hWndXfer==NULL)) return;
  nOld = nPercentXfer;
  nPercentXfer = (int) ((lBytes*100)/lTotalBytes);
  if (nOld!=nPercentXfer) 
  {
    HDC hDC;
  
    hDC = GetDC (hWndXfer);
    PaintXfer (hDC);
    ReleaseDC (hWndXfer, hDC);
  }
}

/************************************************************************/
/************************************************************************/
LRESULT CALLBACK WndXferProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  switch (Msg)
  {
    case WM_GETMINMAXINFO: 
    {
      MINMAXINFO FAR *lpmmi=(MINMAXINFO FAR *) lParam;
      lpmmi->ptMaxSize.x = (nWndx*140)/4;
      lpmmi->ptMaxSize.y = (nWndy*45)/8;
      lpmmi->ptMaxTrackSize.x = (nWndx*140)/4;
      lpmmi->ptMaxTrackSize.y = (nWndy*45)/8;
      lpmmi->ptMinTrackSize.x = (nWndx*140)/4;
      lpmmi->ptMinTrackSize.y = (nWndy*45)/8;
    } break;
    case WM_PAINT: OnPaintXfer (hWnd); return 0L;
  }
  return (LRESULT) DefWindowProc (hWnd, Msg, wParam, lParam);
}

/************************************************************************/
/************************************************************************/
void CreateXferWindow()
{
  if (hWndXfer!=NULL) return;
  hWndXfer = CreateWindowEx ( WS_EX_TOPMOST, 
       szXferWnd, "",  WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_CAPTION,
       CW_USEDEFAULT, CW_USEDEFAULT, (nWndx*140)/4, (nWndy*40)/8, (HWND) NULL, 
       (HMENU) NULL, hInst,  NULL);
  lTotalBytes = 0L;
  lXferBytes  = 0L;
  nPercentXfer = 0L;
}

/************************************************************************/
/************************************************************************/
void DeleteXferWindow()
{
  if (hWndXfer==NULL) return;
  DestroyWindow (hWndXfer);
  lTotalBytes  = lXferBytes = 0l;
  nPercentXfer = 0;
  hWndXfer = NULL;
}

/************************************************************************/
/************************************************************************/
void SetXferWindowText (LPSTR lpStr)
{
  SetWindowText (hWndXfer, lpStr);
}

static HWND hWndViewMsg = (HWND) NULL;
static LPSTR *lpMsg;
static int nMaxMsg, nCurMsg, nVertPos, nHorzPos, nHorzMax;

static int nHorzTab = 20;
static int nHorzSiz, nVertSiz;
static LPSTR szNoMem = "Unable to allocate memory!";
static LPSTR szZoomErr = "Zoom Error";
static BOOL bZoomFlag=FALSE;

//*****************************************************************************
//*****************************************************************************
OnCmdZoomInfo (HWND hWnd)
{
  int nI, nMax;
  LPSTR lp;
  
  if (GetStatusLine (0)==NULL) return 0;
  switch (bZoomFlag)
  {
    case FALSE: bZoomFlag = TRUE;
                ClearZoomInfo();
                nMax = GetMaxStatusLines();
                for (nI=0; nI<nMax; nI++)
                {
                  lp = GetStatusLine (nI);
                  if (lstrlen (lp) > 0) AddMessageToView (lp, "WinFTP: Zoom WinDow");
                } break;
    case TRUE : bZoomFlag = FALSE;
                SendMessage (hWndViewMsg, WM_CLOSE, 0, 0L);
  }
  return 0;
}

//*************************************************************************
//*************************************************************************
void AddMessageToView (LPSTR lpBuf, LPSTR lpHdr)
{
  if (lpBuf==NULL) return;
  if (lpBuf[0]=='[') return;
  nMaxMsg = 150; 
  if (lpMsg==NULL)
  {
    lpMsg = (LPSTR *) GlobalAllocPtr (GHND, nMaxMsg * sizeof (LPSTR));
    nCurMsg = 0;
  }
  if (lpMsg==NULL) 
  {
    MessageBox (hWndMain, szNoMem, szZoomErr, MB_OK);
    return;
  }
  if (hWndViewMsg==(HWND) NULL) hWndViewMsg = CreateWindow (szMsgWnd, lpHdr,  
       WS_OVERLAPPEDWINDOW | WS_HSCROLL | WS_VSCROLL | WS_VISIBLE, 
        CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, 
         (HWND) NULL, (HMENU) NULL, hInst, NULL);

  if ((hWndViewMsg!=(HWND) NULL))
  {
    LPSTR lp;
    
    if (nCurMsg>=nMaxMsg)
    {
      GlobalFreePtr (lpMsg[0]);
      memmove (lpMsg, lpMsg+1, (nMaxMsg-1)*sizeof (LPSTR));
      nCurMsg = nMaxMsg-1;
    }
    lp = lpMsg[nCurMsg] = (LPSTR) GlobalAllocPtr (GHND, lstrlen (lpBuf) + 5);
    if (lp!=NULL) 
    {
      HDC hDC;
      SIZE siz;
      
      lstrcpy (lp, lpBuf);
      hDC = GetDC (hWndViewMsg);
      GetTextExtentPoint (hDC, lp, lstrlen (lp), &siz);
      ReleaseDC (hWndViewMsg, hDC);
      nHorzMax = __max (nHorzMax, siz.cx);
      SetScrollRange (hWndViewMsg, SB_HORZ, 0, nHorzMax, TRUE);
      SetScrollRange (hWndViewMsg, SB_VERT, 0, nCurMsg, TRUE);
      InvalidateRect (hWndViewMsg, NULL, TRUE);
      nCurMsg++;
    }
    else 
    {
      MessageBox (hWndMain, szNoMem, szZoomErr, MB_OK);
      return;
    }
  }
}

//*************************************************************************
//*************************************************************************
void ClearZoomInfo()
{
  int nI;
  
  if (lpMsg!=NULL) 
  {
    for (nI=0; nI<nMaxMsg; nI++) 
    {
      if (lpMsg[nI]!=NULL) GlobalFreePtr (lpMsg[nI]);
      lpMsg[nI] = NULL;
    }
  }
  nCurMsg = nVertPos = nHorzPos = nHorzMax = 0;
  SetScrollPos (hWndViewMsg, SB_HORZ, 0, TRUE);
  SetScrollPos (hWndViewMsg, SB_VERT, 0, TRUE);
  SetScrollRange (hWndViewMsg, SB_HORZ, 0, 1, TRUE);
  SetScrollRange (hWndViewMsg, SB_VERT, 0, 1, TRUE);
}

//*************************************************************************
//*************************************************************************
void ReleaseMsgMem()
{
  int nI;
  
  if (lpMsg==NULL) return;
  for (nI=0; nI<nMaxMsg; nI++) if (lpMsg[nI]!=NULL) GlobalFreePtr (lpMsg[nI]);
  GlobalFreePtr (lpMsg);
  lpMsg = NULL;
}

//*************************************************************************
//*************************************************************************
LRESULT PaintViewMessage (HWND hWnd, int nVertPos)
{
  HDC         hDC;
  PAINTSTRUCT ps;
  int         nI, nRows, nLine, nPos, nHt;
  RECT        rRect;
  TEXTMETRIC  tm;

  hDC = BeginPaint (hWnd, &ps);
  GetTextMetrics (hDC,&tm);
  nHt = tm.tmHeight + tm.tmExternalLeading;
  GetClientRect (hWnd, &rRect);
  nHorzSiz = rRect.right;
  nVertSiz = nRows = rRect.bottom/nHt;
  ShowScrollBar (hWnd, SB_VERT, (nRows<nCurMsg));
  nLine = nVertPos;
  if (lpMsg!=NULL)
  {
    for (nI=nPos=0; (nI<nRows) && (nLine<nCurMsg); nI++, nLine++, nPos+=nHt) 
    {
      if (lpMsg[nLine]!=NULL) 
      {
        TextOut (hDC, 20-nHorzPos, nPos, lpMsg[nLine], lstrlen (lpMsg[nLine]));
      }
    }
  }
  EndPaint(hWnd, &ps);
  return 0L;
}

//*************************************************************************
//*************************************************************************
LRESULT CALLBACK WndMsgProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
  switch (Msg)
  {
    case WM_CREATE: nVertPos = nHorzPos = nHorzMax = 0;
                    return 0L;

    case WM_PAINT:  return PaintViewMessage (hWnd, nVertPos);

    case WM_VSCROLL: switch (wParam)
      {
        case SB_LINEDOWN     : if (nVertPos<(nCurMsg-(nVertSiz>>1))) nVertPos++;  break;
        case SB_LINEUP       : if (nVertPos>0) --nVertPos; break;
        case SB_THUMBPOSITION: nVertPos = __min ((WORD) (nCurMsg-(nVertSiz>>1)), LOWORD (lParam)); break;
        case SB_PAGEUP       : nVertPos = (nVertPos>10) ? (nVertPos-10) : 0; break;
        case SB_PAGEDOWN     : nVertPos = (nVertPos<(nCurMsg-nVertSiz)) ? (nVertPos+nVertSiz) : nCurMsg-(nVertSiz>>1); break;
        default              : return 0L;
      }
      SetScrollPos (hWnd, SB_VERT, nVertPos, TRUE);
      InvalidateRect (hWnd, NULL, TRUE); 
      return 0L;
    
    case WM_HSCROLL: switch (wParam)
      {
        case SB_LINEDOWN     : nHorzPos = (nHorzPos<(nHorzMax-nHorzTab)) ? (nHorzPos+nHorzTab) : nHorzMax; break;
        case SB_LINEUP       : nHorzPos = (nHorzPos>nHorzTab) ? (nHorzPos-nHorzTab) : 0; break;
        case SB_THUMBPOSITION: nHorzPos = __min ((WORD) nHorzMax, LOWORD (lParam)); break;
        case SB_PAGEUP       : nHorzPos = (nHorzPos>nHorzSiz) ? (nHorzPos-nHorzSiz) : 0; break;
        case SB_PAGEDOWN     : nHorzPos = (nHorzPos<(nHorzMax-nHorzSiz)) ? (nHorzPos+nHorzSiz) : nHorzMax; break;
        default              : return 0L;
      }
      SetScrollPos (hWnd, SB_HORZ, nHorzPos, TRUE);
      InvalidateRect (hWnd, NULL, TRUE); 
      return 0L;
    
    case WM_CLOSE  : ReleaseMsgMem();
                     DestroyWindow (hWnd);
                     hWndViewMsg = (HWND) NULL;
                     nMaxMsg = nCurMsg = 0;
                     bZoomFlag = FALSE;
                     return 0;
      
    default        : return DefWindowProc (hWnd, Msg, wParam, lParam);
  }
  return 0L;
}

