/***********************************************************
 * mtime.c : real time in milliseconds (Solaris, SysVR4(?))
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 ***********************************************************/

#include <sys/time.h>
#include "connect.h"

unsigned long mtime()
{
  static long _t = 0;
  struct timeval stv;

  gettimeofday(&stv);

  if (!_t)
    _t = stv.tv_sec;

  return(((stv.tv_sec - _t) * 1000) + ( stv.tv_usec / 1000));
}
