/*
 * (c) Peter Mueller, 2008
 *
 * All rights reserved. Reproduction, modification,
 * use or disclosure to third parties without express
 * authority is forbidden.
 */

/* This file is generated from first_example_step3.cdd - do not edit manually*/
/* Generated on: Thu Apr 17 16:40:08 CEST 2008 / version 0.97 */


#include "mydefs.h"
#include "oven.h"
#include "oven_ext.h"
#include "oven_hlp.h"
#include <stdio.h>

extern unsigned char msg;
extern T_PWR pwr;

void oven(OVEN_INSTANCEDATA_T *instanceVar){

	OVEN_EV_CONSUMED_FLAG_T evConsumed = 0U;

	/*execute entry code of default state once to init machine */
	if(instanceVar->superEntry==1U){
		instanceVar->superEntry=0U;
		ovenOff();
	}
	/* action code */
	/* just a comment */

	switch(instanceVar->stateVar){

			case Super:

				switch(instanceVar->stateVarSuper){

					/*
					 * Code for transitions starting from innter states
					 */
					case Idle:
						if((msg==(OVEN_EVENT_T)evDoorClosed) && (timer_preset()>0)){
							/*Transition from Idle to Cooking*/
							evConsumed = 1U;

							/*Action code for transition */
							timer_start();

							/*onEntry code of state Cooking */
							ovenOn();
							ovenChangeToStateSuper(instanceVar,Cooking);
						}
						else
						{
							/* Intentionally left blank */
						}
					break;

					case Cooking:
						if((msg==(OVEN_EVENT_T)evDoorOpen)){
							/*Transition from Cooking to CookingPause*/
							evConsumed = 1U;

							/*Action code for transition */
							ovenOff();
							timer_pause();
							ovenChangeToStateSuper(instanceVar,CookingPause);
						}else if((msg==(OVEN_EVENT_T)evTimeout)){
							/*Transition from Cooking to Completed*/
							evConsumed = 1U;

							/*Action code for transition */
							ovenOff();
							timer_clear();
							ovenChangeToStateSuper(instanceVar,Completed);
						}
						else
						{
							/* Intentionally left blank */
						}
					break;

					case Completed:
						if((msg==(OVEN_EVENT_T)evDoorOpen)){
							/*Transition from Completed to Idle*/
							evConsumed = 1U;

							/*Action code for transition */
							

							/*onEntry code of state Idle */
							ovenOff();
							ovenChangeToStateSuper(instanceVar,Idle);
						}
						else
						{
							/* Intentionally left blank */
						}
					break;

					case CookingPause:
						if((msg==(OVEN_EVENT_T)evDoorClosed)){
							/*Transition from CookingPause to Cooking*/
							evConsumed = 1U;

							/*Action code for transition */
							timer_cont();

							/*onEntry code of state Cooking */
							ovenOn();
							ovenChangeToStateSuper(instanceVar,Cooking);
						}
						else
						{
							/* Intentionally left blank */
						}
					break;

					default:
						/*Intentionally left blank*/
					break;
				}
				if(evConsumed == 0U){
				/*Event not consumed by inner states, handover to parent */
				if((msg==(OVEN_EVENT_T)evPwr)){
					/*Check what the inner state is and call     */
					/*the correspoing onExit code (if available) */
					if(instanceVar->stateVarSuper==Idle){
						/* No onExit for state Idle*/
					}else if(instanceVar->stateVarSuper==Cooking){
						/* No onExit for state Cooking*/
					}else if(instanceVar->stateVarSuper==Completed){
						/* No onExit for state Completed*/
					}else if(instanceVar->stateVarSuper==CookingPause){
						/* No onExit for state CookingPause*/
					}
					/*inner statevar must not be adjusted due to history state */

					/*Action code for transition*/
					ovenSetPwr(pwr);

					/*Find out which child state to enter */
					/*as target state is a history state  */
					if(instanceVar->stateVarSuper==Idle){
						/*onEntry code of state Idle*/
						ovenOff();
					}
					else if(instanceVar->stateVarSuper==Cooking){
						/*onEntry code of state Cooking*/
						ovenOn();
					}
					else if(instanceVar->stateVarSuper==Completed){
					}
					else if(instanceVar->stateVarSuper==CookingPause){
					}
					/*Outer statevar must not be adjusted due */
					/*to start and target are the same states */
				}else if((msg==(OVEN_EVENT_T)evInc)){
					/*Check what the inner state is and call     */
					/*the correspoing onExit code (if available) */
					if(instanceVar->stateVarSuper==Idle){
						/* No onExit for state Idle*/
					}else if(instanceVar->stateVarSuper==Cooking){
						/* No onExit for state Cooking*/
					}else if(instanceVar->stateVarSuper==Completed){
						/* No onExit for state Completed*/
					}else if(instanceVar->stateVarSuper==CookingPause){
						/* No onExit for state CookingPause*/
					}
					/*inner statevar must not be adjusted due to history state */

					/*Action code for transition*/
					timer_inc();

					/*Find out which child state to enter */
					/*as target state is a history state  */
					if(instanceVar->stateVarSuper==Idle){
						/*onEntry code of state Idle*/
						ovenOff();
					}
					else if(instanceVar->stateVarSuper==Cooking){
						/*onEntry code of state Cooking*/
						ovenOn();
					}
					else if(instanceVar->stateVarSuper==Completed){
					}
					else if(instanceVar->stateVarSuper==CookingPause){
					}
					/*Outer statevar must not be adjusted due */
					/*to start and target are the same states */
				}else if((msg==(OVEN_EVENT_T)evDec)){
					/*Check what the inner state is and call     */
					/*the correspoing onExit code (if available) */
					if(instanceVar->stateVarSuper==Idle){
						/* No onExit for state Idle*/
					}else if(instanceVar->stateVarSuper==Cooking){
						/* No onExit for state Cooking*/
					}else if(instanceVar->stateVarSuper==Completed){
						/* No onExit for state Completed*/
					}else if(instanceVar->stateVarSuper==CookingPause){
						/* No onExit for state CookingPause*/
					}
					/*inner statevar must not be adjusted due to history state */

					/*Action code for transition*/
					timer_dec();

					/*Find out which child state to enter */
					/*as target state is a history state  */
					if(instanceVar->stateVarSuper==Idle){
						/*onEntry code of state Idle*/
						ovenOff();
					}
					else if(instanceVar->stateVarSuper==Cooking){
						/*onEntry code of state Cooking*/
						ovenOn();
					}
					else if(instanceVar->stateVarSuper==Completed){
					}
					else if(instanceVar->stateVarSuper==CookingPause){
					}
					/*Outer statevar must not be adjusted due */
					/*to start and target are the same states */
				}
				else
				{
					/* Intentionally left blank */
				}
				}
			break;

			default:
				/*Intentionally left blank*/
			break;
	}
}
