/*
 * Decompiled with CFR 0.152.
 */
package org.freeshell.zs.mediasniper;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import org.freeshell.zs.common.Debug;
import org.freeshell.zs.common.Downloader;
import org.freeshell.zs.common.SwingManipulator;
import org.freeshell.zs.mediasniper.Definition;
import org.freeshell.zs.mediasniper.Download;
import org.freeshell.zs.mediasniper.MediaSniper;
import org.freeshell.zs.mediasniper.TableStringCell;
import org.freeshell.zs.mediasniper.TableStringCellEditor;
import org.freeshell.zs.mediasniper.TableStringCellRenderer;

class WebpageParser
extends JFrame
implements Runnable,
ListSelectionListener {
    private static final long REFRESH_INTERVAL_MILLISECONDS = 100L;
    private final MediaSniper parent;
    private final URL url;
    private final CandidatesTableModel candidatesTableModel = new CandidatesTableModel();
    private final List<Download> candidates = new ArrayList<Download>();
    private volatile boolean cancelled = false;
    private volatile boolean completed = false;
    private volatile Downloader downloader = null;
    private JButton allButton;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JScrollPane candidatesPane;
    private JPanel candidatesPanel;
    private JTable candidatesTable;
    private JProgressBar progress;
    private JButton selectedButton;
    private JScrollPane urlPane;
    private JTextArea urlText;
    private JPanel webpagePanel;

    WebpageParser(MediaSniper parent, URL url) throws UnsupportedOperationException {
        this.parent = parent;
        this.url = url;
        parent.addParser(this);
        this.initComponents();
        this.setTitle("Webpage Parser - " + parent.getTitle());
        try {
            this.setAlwaysOnTop(parent.isAlwaysOnTop());
        }
        catch (Exception e) {
            // empty catch block
        }
        List<Image> icons = parent.getIconImages();
        if (!icons.isEmpty()) {
            this.setIconImage(icons.get(0));
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowIconified(WindowEvent e) {
                WebpageParser.this.minimizeParser();
            }

            public void windowDeiconified(WindowEvent e) {
                WebpageParser.this.restoreParser();
            }

            public void windowClosing(WindowEvent e) {
                WebpageParser.this.cancelWithoutAddingCandidates();
            }
        });
        this.urlText.setText(url.toString());
        SwingManipulator.addStandardEditingPopupMenu(new JTextComponent[]{this.urlText});
        SwingManipulator.updateProgressBar(this.progress, "Waiting to start", -1);
        this.candidatesTable.setAutoResizeMode(2);
        TableColumnModel colModel = this.candidatesTable.getColumnModel();
        colModel.getColumn(0).setMinWidth(0);
        colModel.getColumn(1).setMinWidth(0);
        colModel.getColumn(0).setPreferredWidth(50);
        colModel.getColumn(1).setPreferredWidth(80);
        this.candidatesTable.setToolTipText("Mouse-over any row for more information");
        this.candidatesTable.setDefaultRenderer(TableStringCell.class, new TableStringCellRenderer(this.candidatesTable.getForeground(), this.candidatesTable.getBackground(), this.candidatesTable.getSelectionForeground(), this.candidatesTable.getSelectionBackground()));
        this.candidatesTable.setDefaultEditor(TableStringCell.class, new TableStringCellEditor());
        this.candidatesTable.getSelectionModel().addListSelectionListener(this);
        this.allButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebpageParser.this.addAllCandidates();
            }
        });
        this.selectedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebpageParser.this.addSelectedCandidates();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebpageParser.this.cancelWithoutAddingCandidates();
            }
        });
        this.refreshButtons();
        this.setLocationRelativeTo(parent);
        new Thread(new Runnable(){

            public void run() {
                while (!WebpageParser.this.cancelled) {
                    if (WebpageParser.this.downloader != null) {
                        WebpageParser.this.downloader.run();
                        WebpageParser.this.downloader = null;
                    }
                    Debug.sleep(100L);
                }
            }
        }).start();
    }

    private void closeParser() {
        this.cancelled = true;
        this.parent.removeParser(this);
        this.setVisible(false);
        this.dispose();
    }

    private void minimizeParser() {
        this.setExtendedState(1);
    }

    private void restoreParser() {
        this.setExtendedState(0);
        this.toFront();
    }

    private void refreshButtons() {
        int rowCount = this.candidatesTable.getRowCount();
        if (rowCount > 0) {
            this.allButton.setText("Add All (" + rowCount + ")");
            this.allButton.setEnabled(true);
        } else {
            this.allButton.setText("Add All");
            this.allButton.setEnabled(false);
        }
        int selectedRowCount = this.candidatesTable.getSelectedRowCount();
        if (selectedRowCount > 0) {
            this.selectedButton.setText("Add Selected (" + selectedRowCount + ")");
            this.selectedButton.setEnabled(true);
        } else {
            this.selectedButton.setText("Add Selected");
            this.selectedButton.setEnabled(false);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.refreshButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCandidate(Download d) {
        int numCandidates;
        List<Download> list = this.candidates;
        synchronized (list) {
            this.candidates.add(d);
            numCandidates = this.candidates.size();
        }
        this.candidatesTableModel.fireTableRowsInserted(numCandidates - 1, numCandidates - 1);
        this.refreshButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllCandidates() {
        List<Download> list = this.candidates;
        synchronized (list) {
            for (Download d : this.candidates) {
                this.parent.addDownload(d);
            }
            this.closeParser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSelectedCandidates() {
        List<Download> list = this.candidates;
        synchronized (list) {
            boolean[] selected = new boolean[this.candidates.size()];
            Arrays.fill(selected, false);
            for (int i : this.candidatesTable.getSelectedRows()) {
                selected[this.candidatesTable.convertRowIndexToModel((int)i)] = true;
            }
            for (int i = 0; i < selected.length; ++i) {
                Download d = this.candidates.get(i);
                if (selected[i]) {
                    this.parent.addDownload(d);
                    continue;
                }
                this.parent.localFilenameManager.releaseFilename(d.getFile());
            }
            this.closeParser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelWithoutAddingCandidates() {
        int choice;
        if (!this.cancelled && !this.completed && (choice = JOptionPane.showConfirmDialog(this, this.parent.properties.getString("name") + " has not finished parsing this webpage. Cancel parsing now?", "Confirm Cancel - " + this.getTitle(), 0, 2)) != 0) {
            return;
        }
        List<Download> list = this.candidates;
        synchronized (list) {
            for (Download d : this.candidates) {
                this.parent.localFilenameManager.releaseFilename(d.getFile());
            }
        }
        this.closeParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block52: {
            while (this.parent.definitions == null) {
                if (this.cancelled) {
                    return;
                }
                Debug.sleep(100L);
            }
            matchedPatterns = new HashMap<String, String[]>();
            urls = new ArrayDeque<URL>();
            urls.push(this.url);
            visitedLinks = new HashSet<String>();
            visitedLinks.add(this.url.toString());
            firstUrl = true;
            parsingFailed = false;
            recurseUrls = new ArrayDeque<URL>();
            sb = new StringBuilder();
            try {
                while (!urls.isEmpty()) {
                    u = (URL)urls.pop();
                    urlString = u.toString();
                    if (this.parent.properties.getBoolean("debug")) {
                        Debug.p("WebpageParser: \"" + urlString + "\"");
                    }
                    sb.delete(0, sb.length());
                    this.downloader = dl = new Downloader(u, sb);
                    while (true) {
                        this.checkState();
                        d = this.downloader;
                        if (d == null) break;
                        if (d.isProgressUpdated()) {
                            SwingManipulator.updateProgressBar(this.progress, d.getProgressString(), d.getProgressPercent());
                        }
                        Debug.sleep(100L);
                    }
                    try {
                        dl.waitUntilCompleted();
                    }
                    catch (Exception e) {
                        if (!firstUrl) continue;
                        parsingFailed = true;
                        throw e;
                    }
                    block30: for (final Definition def : this.parent.definitions) {
                        this.checkState();
                        try {
                            urlMatcher = def.getPattern("url.match").matcher(urlString);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        if (!urlMatcher.matches()) continue;
                        matchedPatterns.put("url.match", Definition.capturingGroupsAsArray(urlMatcher));
                        SwingManipulator.updateProgressBar(this.progress, "Finding candidate media file downloads", -1);
                        block31: for (k = 0; k < 0x7FFFFFFF; ++k) {
                            downloadKey = k == 0 ? "download" : "download" + k;
                            try {
                                downloadMatcher = def.getPattern(downloadKey + ".match").matcher(sb);
                            }
                            catch (Exception e) {
                                break;
                            }
                            while (downloadMatcher.find()) {
                                this.checkState();
                                if (firstUrl) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            WebpageParser.this.setTitle(def.getName() + " - " + WebpageParser.this.parent.getTitle());
                                        }
                                    });
                                    firstUrl = false;
                                }
                                matchedPatterns.put(downloadKey + ".match", Definition.capturingGroupsAsArray(downloadMatcher));
                                try {
                                    downloadUrlString = def.evaluateTargetString(downloadKey + ".url", matchedPatterns).trim();
                                    downloadTitle = def.evaluateTargetString(downloadKey + ".title", matchedPatterns).trim();
                                    downloadFilename = def.evaluateTargetString(downloadKey + ".filename", matchedPatterns).trim();
                                    downloadFileext = def.evaluateTargetString(downloadKey + ".fileext", matchedPatterns).trim();
                                }
                                catch (Exception e) {
                                    continue block31;
                                }
                                if (visitedLinks.contains(downloadUrlString)) continue;
                                visitedLinks.add(downloadUrlString);
                                try {
                                    downloadUrl = new URL(downloadUrlString);
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                if (downloadTitle.isEmpty()) {
                                    downloadTitle = def.getName();
                                }
                                if ((downloadFile = this.parent.localFilenameManager.getCleanFilename(downloadFilename, downloadFileext, this.parent.properties.getFile("download.directory"), this.parent.properties.getBoolean("restricted.ascii.filenames"), this.parent.properties.getBoolean("short.filenames"))) == null) {
                                    SwingManipulator.showWarningDialog(this, this.getTitle(), "Failed to generate local filename for candidate media file at URL \"" + downloadUrlString + "\" using title \"" + downloadTitle + "\". This media file will be ignored.");
                                    continue;
                                }
                                this.registerCandidate(new Download(this.parent, downloadTitle, downloadUrl, downloadFile));
                            }
                        }
                        SwingManipulator.updateProgressBar(this.progress, "Finding recursive webpage URLs", -1);
                        block33: for (k = 0; k < 0x7FFFFFFF; ++k) {
                            recurseKey = k == 0 ? "recurse" : "recurse" + k;
                            try {
                                recurseMatcher = def.getPattern(recurseKey + ".match").matcher(sb);
                            }
                            catch (Exception e) {
                                continue block30;
                            }
                            while (recurseMatcher.find()) {
                                this.checkState();
                                if (firstUrl) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            WebpageParser.this.setTitle(def.getName() + " - " + WebpageParser.this.parent.getTitle());
                                        }
                                    });
                                    firstUrl = false;
                                }
                                matchedPatterns.put(recurseKey + ".match", Definition.capturingGroupsAsArray(recurseMatcher));
                                try {
                                    recurseUrlString = def.evaluateTargetString(recurseKey + ".url", matchedPatterns).trim();
                                }
                                catch (Exception e) {
                                    continue block33;
                                }
                                try {
                                    if (visitedLinks.contains(recurseUrlString)) continue;
                                    visitedLinks.add(recurseUrlString);
                                    recurseUrls.push(new URL(recurseUrlString));
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                    while (!recurseUrls.isEmpty()) {
                        urls.push((URL)recurseUrls.pop());
                    }
                }
                SwingManipulator.updateProgressBar(this.progress, "Completed parsing webpage", 100);
                var24_32 = null;
                this.completed = true;
                if (this.cancelled) break block52;
                ** if (!parsingFailed) goto lbl-1000
            }
            catch (Throwable var23_41) {
                var24_34 = null;
                this.completed = true;
                if (!this.cancelled) {
                    if (parsingFailed) {
                        SwingManipulator.showErrorDialog(this, this.getTitle(), this.parent.properties.getString("name") + " could not access this webpage.");
                        this.cancelButton.doClick();
                    } else {
                        var25_37 = this.candidates;
                        synchronized (var25_37) {
                            if (this.candidates.isEmpty()) {
                                SwingManipulator.showWarningDialog(this, this.getTitle(), this.parent.properties.getString("name") + " could not find any candidate media file downloads on this webpage.");
                                this.cancelButton.doClick();
                            }
                        }
                    }
                }
                throw var23_41;
            }
lbl-1000:
            // 1 sources

            {
                SwingManipulator.showErrorDialog(this, this.getTitle(), this.parent.properties.getString("name") + " could not access this webpage.");
                this.cancelButton.doClick();
                ** GOTO lbl179
            }
lbl-1000:
            // 1 sources

            {
                var25_35 = this.candidates;
                synchronized (var25_35) {
                    if (this.candidates.isEmpty()) {
                        SwingManipulator.showWarningDialog(this, this.getTitle(), this.parent.properties.getString("name") + " could not find any candidate media file downloads on this webpage.");
                        this.cancelButton.doClick();
                    }
                }
            }
            {
                catch (Exception e) {
                    var24_33 = null;
                    this.completed = true;
                    if (this.cancelled) break block52;
                    if (parsingFailed) {
                        SwingManipulator.showErrorDialog(this, this.getTitle(), this.parent.properties.getString("name") + " could not access this webpage.");
                        this.cancelButton.doClick();
                        break block52;
                    }
                    var25_36 = this.candidates;
                    synchronized (var25_36) {
                        if (this.candidates.isEmpty()) {
                            SwingManipulator.showWarningDialog(this, this.getTitle(), this.parent.properties.getString("name") + " could not find any candidate media file downloads on this webpage.");
                            this.cancelButton.doClick();
                        }
                    }
                }
            }
        }
    }

    private void checkState() throws Exception {
        if (this.cancelled) {
            throw new Exception();
        }
    }

    private void initComponents() {
        this.webpagePanel = new JPanel();
        this.urlPane = new JScrollPane();
        this.urlText = new JTextArea();
        this.progress = new JProgressBar();
        this.candidatesPanel = new JPanel();
        this.candidatesPane = new JScrollPane();
        this.candidatesTable = new JTable();
        this.buttonsPanel = new JPanel();
        this.allButton = new JButton();
        this.selectedButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.webpagePanel.setBorder(BorderFactory.createTitledBorder("Webpage URL"));
        this.webpagePanel.setLayout(new BorderLayout());
        this.urlPane.setHorizontalScrollBarPolicy(31);
        this.urlText.setColumns(20);
        this.urlText.setEditable(false);
        this.urlText.setLineWrap(true);
        this.urlText.setRows(3);
        this.urlText.setToolTipText("Webpage URL being parsed");
        this.urlPane.setViewportView(this.urlText);
        this.webpagePanel.add((Component)this.urlPane, "Center");
        this.progress.setStringPainted(true);
        this.webpagePanel.add((Component)this.progress, "Last");
        this.getContentPane().add((Component)this.webpagePanel, "First");
        this.candidatesPanel.setBorder(BorderFactory.createTitledBorder("Candidate Media File Downloads"));
        this.candidatesPanel.setLayout(new BorderLayout());
        this.candidatesPane.setPreferredSize(new Dimension(600, 200));
        this.candidatesTable.setAutoCreateRowSorter(true);
        this.candidatesTable.setModel(this.candidatesTableModel);
        this.candidatesPane.setViewportView(this.candidatesTable);
        this.candidatesPanel.add((Component)this.candidatesPane, "Center");
        this.buttonsPanel.setLayout(new GridLayout(1, 3));
        this.allButton.setIcon(new ImageIcon(this.getClass().getResource("/org/freeshell/zs/mediasniper/resources/add.png")));
        this.allButton.setMnemonic('a');
        this.allButton.setText("Add All");
        this.allButton.setToolTipText("Add all candidate media file downloads");
        this.buttonsPanel.add(this.allButton);
        this.selectedButton.setIcon(new ImageIcon(this.getClass().getResource("/org/freeshell/zs/mediasniper/resources/add.png")));
        this.selectedButton.setMnemonic('s');
        this.selectedButton.setText("Add Selected");
        this.selectedButton.setToolTipText("Add selected candidate media file downloads");
        this.buttonsPanel.add(this.selectedButton);
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/org/freeshell/zs/mediasniper/resources/cross.png")));
        this.cancelButton.setMnemonic('c');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Cancel parsing of this webpage");
        this.buttonsPanel.add(this.cancelButton);
        this.candidatesPanel.add((Component)this.buttonsPanel, "Last");
        this.getContentPane().add((Component)this.candidatesPanel, "Center");
        this.pack();
    }

    private class CandidatesTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Title", "<html>Local Filename <font color='blue'>(double-click cell to edit)</font></html>"};
        private final Class[] columnClasses = new Class[]{TableStringCell.class, TableStringCell.class};
        private final boolean[] columnEditable = new boolean[]{false, true};
        private final Map<Download, Object[]> contents = new HashMap<Download, Object[]>();

        private CandidatesTableModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            List list = WebpageParser.this.candidates;
            synchronized (list) {
                return WebpageParser.this.candidates.size();
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int col) {
            return this.columnClasses[col];
        }

        public boolean isCellEditable(int row, int col) {
            return this.columnEditable[col];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int row, int col) {
            Download d;
            List list = WebpageParser.this.candidates;
            synchronized (list) {
                d = (Download)WebpageParser.this.candidates.get(row);
            }
            Object[] c = this.contents.get(d);
            if (c == null) {
                c = new Object[]{new TableStringCell(d), new TableStringCell(d)};
                this.contents.put(d, c);
                ((TableStringCell)c[0]).align = 2;
                ((TableStringCell)c[1]).align = 2;
            }
            switch (col) {
                case 0: {
                    ((TableStringCell)c[0]).text = "<html>" + d.getTitle() + "</html>";
                    break;
                }
                case 1: {
                    ((TableStringCell)c[1]).text = d.getFilename();
                    break;
                }
                default: {
                    return null;
                }
            }
            return c[col];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValueAt(Object val, int row, int col) {
            Download d;
            List list = WebpageParser.this.candidates;
            synchronized (list) {
                d = (Download)WebpageParser.this.candidates.get(row);
            }
            switch (col) {
                case 1: {
                    boolean success = d.setFilename((String)val);
                    if (success) {
                        this.fireTableCellUpdated(row, col);
                        break;
                    }
                    SwingManipulator.showErrorDialog(WebpageParser.this, WebpageParser.this.getTitle(), "The specified filename is invalid.\nIt may contain illegal characters, or be already in use.");
                    break;
                }
            }
        }
    }
}

