/*
 * Decompiled with CFR 0.152.
 */
package org.freeshell.zs.mediasniper;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import org.freeshell.zs.common.Debug;
import org.freeshell.zs.common.Downloader;
import org.freeshell.zs.common.ResourceManipulator;
import org.freeshell.zs.common.SimpleProperties;
import org.freeshell.zs.common.StringManipulator;
import org.freeshell.zs.common.SwingManipulator;
import org.freeshell.zs.common.TerminatingException;
import org.freeshell.zs.mediasniper.About;
import org.freeshell.zs.mediasniper.Definition;
import org.freeshell.zs.mediasniper.Download;
import org.freeshell.zs.mediasniper.LocalFilenameManager;
import org.freeshell.zs.mediasniper.TableProgressCell;
import org.freeshell.zs.mediasniper.TableProgressCellRenderer;
import org.freeshell.zs.mediasniper.TableStringCell;
import org.freeshell.zs.mediasniper.TableStringCellRenderer;
import org.freeshell.zs.mediasniper.WebpageParser;

class MediaSniper
extends JFrame {
    private static final String DEFAULT_PROGRAM_PROPERTIES = "/org/freeshell/zs/mediasniper/resources/properties.txt";
    private static final long REFRESH_INTERVAL_MILLISECONDS = 100L;
    private final ExecutorService parsersThreadPool = Executors.newCachedThreadPool();
    private final ExecutorService downloadsThreadPool;
    private final HashSet<WebpageParser> parsers = new HashSet();
    private final List<Download> downloads = new ArrayList<Download>();
    private final DownloadsTableModel downloadsTableModel = new DownloadsTableModel();
    final SimpleProperties properties;
    volatile List<Definition> definitions = null;
    final LocalFilenameManager localFilenameManager = new LocalFilenameManager();
    private About about = null;
    private TrayIcon trayIcon = null;
    private volatile boolean refreshStatus = true;
    private JMenuItem aboutItem;
    private JPanel buttonsPanel;
    private JMenuItem checkItem;
    private JButton clearButton;
    private JScrollPane downloadsPane;
    private JPanel downloadsPanel;
    private JTable downloadsTable;
    private JMenuItem exitItem;
    private JMenu fileMenu;
    private JButton goButton;
    private JMenu helpMenu;
    private JMenuBar menuBar;
    private JMenu optionsMenu;
    private JSeparator optionsSeparator;
    private JButton pasteButton;
    private JCheckBoxMenuItem proxyItem;
    private JCheckBoxMenuItem restrictedItem;
    private JCheckBoxMenuItem shortItem;
    private JLabel status;
    private JCheckBoxMenuItem topItem;
    private JCheckBoxMenuItem trayItem;
    private JScrollPane urlPane;
    private JPanel urlPanel;
    private JTextArea urlText;
    private JMenuItem usageItem;

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    MediaSniper ms = new MediaSniper(args);
                    ms.setVisible(true);
                }
                catch (TerminatingException e) {
                    SwingManipulator.showErrorDialog(null, "Initialization Error", e.getMessage() + "\nPlease see Help > Usage for more information.");
                    System.exit(1);
                }
                catch (Exception e) {
                    SwingManipulator.showErrorDialog(null, "Initialization Error", "Failed to initialize program because of an unexpected error: " + e + "\nPlease file a bug report to help improve this program." + "\n\n" + Debug.getSystemInformationString() + "\n\n" + Debug.getStackTraceString(e));
                    System.exit(1);
                }
            }
        });
    }

    MediaSniper(String[] args) {
        BufferedImage iconImage;
        SimpleProperties editableProperties;
        try {
            this.properties = new SimpleProperties(ResourceManipulator.resourceAsString(DEFAULT_PROGRAM_PROPERTIES));
        }
        catch (Exception ex) {
            throw new TerminatingException("(INTERNAL) Failed to load default program properties (" + ex + ").");
        }
        try {
            editableProperties = new SimpleProperties(ResourceManipulator.resourceAsString(this.properties.getString("editable.properties")));
        }
        catch (Exception ex) {
            throw new TerminatingException("(INTERNAL) Failed to load user-editable program properties (" + ex + ").");
        }
        for (String s : args) {
            String[] kv = StringManipulator.parseKeyValueString(s);
            if (editableProperties.get(kv[0]) == null) {
                if (this.properties.get(kv[0]) == null) {
                    throw new TerminatingException("\"" + kv[0] + "\" is not a valid program property.");
                }
                throw new TerminatingException("\"" + kv[0] + "\" is not a user-editable program property.");
            }
            this.properties.set(kv[0], kv[1]);
        }
        this.downloadsThreadPool = Executors.newFixedThreadPool(this.properties.getInt("max.concurrent.downloads"));
        this.initComponents();
        this.setTitle(this.properties.getString("name"));
        this.setAlwaysOnTop(this.properties.getBoolean("always.on.top"));
        this.addWindowListener(new WindowAdapter(){

            public void windowIconified(WindowEvent e) {
                MediaSniper.this.minimizeProgram();
            }

            public void windowDeiconified(WindowEvent e) {
                MediaSniper.this.restoreProgram();
            }

            public void windowClosing(WindowEvent e) {
                MediaSniper.this.closeProgram();
            }
        });
        ToolTipManager.sharedInstance().setInitialDelay(0);
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MediaSniper.this.closeProgram();
            }
        });
        this.topItem.setSelected(this.properties.getBoolean("always.on.top"));
        this.topItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MediaSniper.this.properties.setBoolean("always.on.top", MediaSniper.this.topItem.isSelected());
                MediaSniper.this.refreshAlwaysOnTopMode();
            }
        });
        this.trayItem.setSelected(this.properties.getBoolean("minimize.to.tray"));
        this.trayItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MediaSniper.this.properties.setBoolean("minimize.to.tray", MediaSniper.this.trayItem.isSelected());
            }
        });
        this.restrictedItem.setSelected(this.properties.getBoolean("restricted.ascii.filenames"));
        this.restrictedItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MediaSniper.this.properties.setBoolean("restricted.ascii.filenames", MediaSniper.this.restrictedItem.isSelected());
            }
        });
        this.shortItem.setSelected(this.properties.getBoolean("short.filenames"));
        this.shortItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MediaSniper.this.properties.setBoolean("short.filenames", MediaSniper.this.shortItem.isSelected());
            }
        });
        this.proxyItem.setSelected(this.properties.getBoolean("proxy"));
        this.proxyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MediaSniper.this.properties.setBoolean("proxy", MediaSniper.this.proxyItem.isSelected());
                MediaSniper.this.refreshProxyMode();
            }
        });
        this.usageItem.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> lines = new ArrayList<String>();
                SimpleProperties simpleProperties = editableProperties;
                synchronized (simpleProperties) {
                    for (String s : editableProperties.keySet()) {
                        lines.add("* " + s + " - " + editableProperties.getString(s) + " (\"" + MediaSniper.this.properties.getAsString(s) + "\")");
                    }
                }
                Collections.sort(lines);
                StringBuilder sb = new StringBuilder();
                for (String s : lines) {
                    sb.append("\n");
                    sb.append(s);
                }
                try {
                    SwingManipulator.showInfoDialog(MediaSniper.this, "Usage - " + MediaSniper.this.properties.getString("name"), "Usage information for " + MediaSniper.this.properties.getString("name"), ResourceManipulator.resourceAsString(MediaSniper.this.properties.getString("usage")) + sb.toString(), 10);
                }
                catch (Exception ee) {
                    SwingManipulator.showErrorDialog(MediaSniper.this, MediaSniper.this.getTitle(), "(INTERNAL) Failed to read \"Usage\" text from JAR file.");
                }
            }
        });
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MediaSniper.this.about == null) {
                    MediaSniper.this.about = new About(MediaSniper.this);
                }
                MediaSniper.this.about.setVisible(true);
                MediaSniper.this.about.setExtendedState(0);
                MediaSniper.this.about.toFront();
            }
        });
        this.checkItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    public void run() {
                        MediaSniper.this.checkForUpdate(true, true);
                    }
                }).start();
            }
        });
        SwingManipulator.addStandardEditingPopupMenu(new JTextComponent[]{this.urlText});
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MediaSniper.this.urlText.requestFocus();
                MediaSniper.this.parseWebpage();
            }
        });
        this.pasteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MediaSniper.this.urlText.selectAll();
                MediaSniper.this.urlText.paste();
                MediaSniper.this.urlText.requestFocus();
                MediaSniper.this.parseWebpage();
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MediaSniper.this.urlText.setText("");
                MediaSniper.this.urlText.requestFocus();
            }
        });
        this.downloadsTable.setAutoResizeMode(2);
        TableColumnModel colModel = this.downloadsTable.getColumnModel();
        colModel.getColumn(0).setMinWidth(0);
        colModel.getColumn(1).setMinWidth(0);
        colModel.getColumn(2).setMinWidth(0);
        colModel.getColumn(0).setPreferredWidth(80);
        colModel.getColumn(1).setPreferredWidth(10);
        colModel.getColumn(2).setPreferredWidth(40);
        this.downloadsTable.setToolTipText("Mouse-over any row for more information");
        this.downloadsTable.setDefaultRenderer(TableStringCell.class, new TableStringCellRenderer(this.downloadsTable.getForeground(), this.downloadsTable.getBackground(), this.downloadsTable.getSelectionForeground(), this.downloadsTable.getSelectionBackground()));
        this.downloadsTable.setDefaultRenderer(TableProgressCell.class, new TableProgressCellRenderer());
        try {
            iconImage = ImageIO.read(MediaSniper.class.getResource("/org/freeshell/zs/mediasniper/resources/icon.png"));
        }
        catch (Exception e) {
            throw new TerminatingException("Failed to load program icon image.");
        }
        this.setIconImage(iconImage);
        try {
            this.trayIcon = new TrayIcon(iconImage, this.properties.getString("name") + " (click to restore)");
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MediaSniper.this.restoreProgram();
                }
            });
            this.trayIcon.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    MediaSniper.this.restoreProgram();
                }
            });
        }
        catch (Exception e) {
            this.trayIcon = null;
        }
        this.setLocationRelativeTo(null);
        new Thread(new Runnable(){

            public void run() {
                MediaSniper.this.checkForUpdate(false, false);
                MediaSniper.this.loadDefinitions();
            }
        }).start();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    if (MediaSniper.this.refreshStatus) {
                        int numActiveDownloads = 0;
                        List list = MediaSniper.this.downloads;
                        synchronized (list) {
                            for (Download d : MediaSniper.this.downloads) {
                                if (d.isCompleted()) continue;
                                ++numActiveDownloads;
                            }
                        }
                        String statusString = numActiveDownloads == 0 ? "No active downloads" : (numActiveDownloads == 1 ? "1 active download" : numActiveDownloads + " active downloads");
                        SwingManipulator.updateLabel(MediaSniper.this.status, statusString);
                    }
                    Debug.sleep(1000L);
                }
            }
        }).start();
        this.refreshAlwaysOnTopMode();
        this.refreshProxyMode();
        this.refreshDownloadDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForUpdate(boolean showPromptIfLatest, boolean showPromptOnError) {
        block17: {
            this.refreshStatus = false;
            SwingManipulator.updateLabel(this.status, "Checking for update...");
            try {
                String[] lines;
                StringBuilder sb = new StringBuilder();
                Downloader d = new Downloader(new URL(this.properties.getString("update.url")), sb);
                new Thread(d).start();
                while (true) {
                    if (d.isProgressUpdated()) {
                        int percent = d.getProgressPercent();
                        SwingManipulator.updateLabel(this.status, "Checking for update: " + d.getProgressString() + (percent >= 0 ? " (" + percent + "%)" : ""));
                    }
                    if (d.isCompleted()) break;
                    Debug.sleep(100L);
                }
                d.waitUntilCompleted();
                StringBuilder stringBuilder = sb;
                synchronized (stringBuilder) {
                    lines = sb.toString().split("[\n\r\u0085\u2028\u2028]++");
                }
                SwingManipulator.updateLabel(this.status, "Checking for update...");
                for (String s : lines) {
                    if (s.isEmpty() || s.startsWith("#") || !s.contains(":")) continue;
                    String[] kv = StringManipulator.parseKeyValueString(s);
                    this.properties.setString(kv[0], kv[1]);
                }
            }
            catch (Exception e) {
                if (showPromptOnError) {
                    SwingManipulator.showErrorDialog(this, "Check for Update - " + this.getTitle(), "Failed to retrieve update information from the " + this.properties.getString("name") + " homepage (" + e + ").\nPlease try again later. If the problem persists, please visit the homepage manually.");
                }
                SwingManipulator.updateLabel(this.status, " ");
                this.refreshStatus = true;
                return;
            }
            try {
                String version = this.properties.getString("update.version");
                String date = this.properties.getString("update.date");
                String download = this.properties.getString("update.download");
                String comment = this.properties.getString("update.comment");
                if (this.properties.getString("date").compareTo(date) < 0) {
                    int choice = SwingManipulator.showOptionTextDialog(this, "A new release of " + this.properties.getString("name") + " is available", this.properties.getString("name") + " " + version + " (" + date + ") is available for download. " + (Double.parseDouble(this.properties.getString("version")) < Double.parseDouble(version) ? "This is a major update and is strongly recommended." : "This is a minor update and is recommended if you are currently experiencing problems.") + "\n\n" + comment, 8, "Check for Update - " + this.getTitle(), -1, 1, null, new String[]{"Download Now", "Cancel"}, 0);
                    if (choice == 0 && Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(new URI(download));
                        }
                        catch (Exception ex) {}
                    }
                } else if (showPromptIfLatest) {
                    SwingManipulator.showInfoDialog(this, "Check for Update - " + this.getTitle(), "No update found", "This release of " + this.properties.getString("name") + " " + this.properties.getString("version") + " (" + this.properties.getString("date") + ") is already up-to-date.", 5);
                }
            }
            catch (Exception e) {
                if (!showPromptOnError) break block17;
                SwingManipulator.showWarningDialog(this, "Check for Update - " + this.getTitle(), "Failed to parse update information from the " + this.properties.getString("name") + " homepage (" + e + ").\nPlease try again later. If the problem persists, please visit the homepage manually.");
            }
        }
        SwingManipulator.updateLabel(this.status, " ");
        this.refreshStatus = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefinitions() {
        this.refreshStatus = false;
        SwingManipulator.updateLabel(this.status, "Loading definitions...");
        String content = null;
        try {
            StringBuilder sb = new StringBuilder();
            Downloader d = new Downloader(new URL(this.properties.getString("definitions.url")), sb);
            new Thread(d).start();
            while (true) {
                if (d.isProgressUpdated()) {
                    int percent = d.getProgressPercent();
                    SwingManipulator.updateLabel(this.status, "Loading definitions: " + d.getProgressString() + (percent >= 0 ? " (" + percent + "%)" : ""));
                }
                if (d.isCompleted()) break;
                Debug.sleep(100L);
            }
            d.waitUntilCompleted();
            StringBuilder percent = sb;
            synchronized (percent) {
                content = sb.toString();
            }
        }
        catch (Exception e) {
            SwingManipulator.showWarningDialog(this, "Loading Definitions - " + this.getTitle(), "Failed to retrieve the latest definitions from the " + this.properties.getString("name") + " webpage (" + e + ").\nBuilt-in definitions will be used instead.");
            try {
                content = ResourceManipulator.resourceAsString(this.properties.getString("definitions.local"));
            }
            catch (Exception ex) {
                SwingManipulator.showErrorDialog(this, "Loading Definitions - " + this.getTitle(), "(INTERNAL) Failed to read built-in definitions (" + ex + ").\nProgram terminated.");
                System.exit(1);
            }
        }
        String[] lines = content.split("[\n\r\u0085\u2028\u2028]++");
        SwingManipulator.updateLabel(this.status, "Loading definitions...");
        ArrayList<Definition> defs = new ArrayList<Definition>();
        Definition current = null;
        for (String s : lines) {
            if (s.isEmpty() || s.startsWith("#")) continue;
            if (s.startsWith("[") && s.endsWith("]")) {
                current = new Definition(s.substring(1, s.length() - 1).trim());
                defs.add(current);
                continue;
            }
            if (!s.contains(":")) continue;
            String[] kv = StringManipulator.parseKeyValueString(s);
            if (current == null) {
                this.properties.setString(kv[0], kv[1]);
                continue;
            }
            current.put(kv[0], kv[1]);
        }
        this.definitions = defs;
        SwingManipulator.updateLabel(this.status, " ");
        this.refreshStatus = true;
    }

    private void parseWebpage() {
        URL url;
        String u = this.urlText.getText().replace("\n", "").trim();
        if (u.isEmpty()) {
            return;
        }
        try {
            url = u.contains("://") ? new URL(u) : new URL("http://" + u);
        }
        catch (Exception e) {
            SwingManipulator.showErrorDialog(this, this.properties.getString("name"), "Invalid webpage URL.");
            return;
        }
        try {
            WebpageParser parser = new WebpageParser(this, url);
            parser.setVisible(true);
            parser.toFront();
            this.parsersThreadPool.submit(parser);
            this.urlText.setText("");
        }
        catch (UnsupportedOperationException e) {
            SwingManipulator.showErrorDialog(this, this.properties.getString("name"), this.properties.getString("name") + " does not know how to parse this webpage.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeProgram() {
        int choice;
        int numActiveParsers;
        int choice2;
        int numActiveDownloads = 0;
        List<Download> list = this.downloads;
        synchronized (list) {
            for (Download d : this.downloads) {
                if (d.isCompleted()) continue;
                ++numActiveDownloads;
            }
        }
        if (numActiveDownloads > 0 && (choice2 = JOptionPane.showConfirmDialog(this, "There" + (numActiveDownloads == 1 ? " is" : " are") + " still " + numActiveDownloads + " active" + (numActiveDownloads == 1 ? " download" : " downloads") + ". Exit now?", "Confirm Exit - " + this.properties.getString("name"), 0, 2)) != 0) {
            return;
        }
        HashSet<WebpageParser> i$ = this.parsers;
        synchronized (i$) {
            numActiveParsers = this.parsers.size();
        }
        if (numActiveParsers > 0 && (choice = JOptionPane.showConfirmDialog(this, "There" + (numActiveParsers == 1 ? " is" : " are") + " still " + numActiveParsers + " active webpage" + (numActiveParsers == 1 ? " parser" : " parsers") + ". Exit now?", "Confirm Exit - " + this.properties.getString("name"), 0, 2)) != 0) {
            return;
        }
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void minimizeProgram() {
        JFrame[] frames;
        if (this.properties.getBoolean("minimize.to.tray") && this.trayIcon != null) {
            try {
                SystemTray.getSystemTray().add(this.trayIcon);
                this.setVisible(false);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.setExtendedState(1);
        for (JFrame f : frames = new JFrame[]{this.about}) {
            if (f == null) continue;
            f.setVisible(false);
        }
        HashSet<WebpageParser> hashSet = this.parsers;
        synchronized (hashSet) {
            for (WebpageParser parser : this.parsers) {
                parser.setVisible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreProgram() {
        this.setVisible(true);
        HashSet<WebpageParser> hashSet = this.parsers;
        synchronized (hashSet) {
            for (WebpageParser parser : this.parsers) {
                parser.setVisible(true);
            }
        }
        if (this.trayIcon != null) {
            try {
                SystemTray.getSystemTray().remove(this.trayIcon);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setExtendedState(0);
        this.toFront();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshDownloadOnTable(Download d) {
        List<Download> list = this.downloads;
        synchronized (list) {
            int i = this.downloads.indexOf(d);
            if (i >= 0) {
                this.downloadsTableModel.fireTableRowsUpdated(i, i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDownload(Download d) {
        List<Download> list = this.downloads;
        synchronized (list) {
            this.downloads.add(d);
        }
        this.downloadsThreadPool.submit(d);
        this.downloadsTableModel.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addParser(WebpageParser p) {
        HashSet<WebpageParser> hashSet = this.parsers;
        synchronized (hashSet) {
            this.parsers.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeParser(WebpageParser p) {
        HashSet<WebpageParser> hashSet = this.parsers;
        synchronized (hashSet) {
            this.parsers.remove(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAlwaysOnTopMode() {
        JFrame[] frames;
        boolean state = this.properties.getBoolean("always.on.top");
        for (JFrame f : frames = new JFrame[]{this, this.about}) {
            if (f == null) continue;
            try {
                f.setAlwaysOnTop(state);
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
        HashSet<WebpageParser> hashSet = this.parsers;
        synchronized (hashSet) {
            for (WebpageParser p : this.parsers) {
                try {
                    p.setAlwaysOnTop(state);
                }
                catch (Exception ee) {}
            }
        }
    }

    private void refreshProxyMode() {
        if (this.properties.getBoolean("proxy")) {
            Debug.setSystemProperty("socksProxyHost", this.properties.getString("proxy.host"));
            Debug.setSystemProperty("socksProxyPort", this.properties.getString("proxy.port"));
            Debug.setSystemProperty("java.net.socks.username", this.properties.getString("proxy.username"));
            Debug.setSystemProperty("java.net.socks.password", this.properties.getString("proxy.password"));
        } else {
            Debug.setSystemProperty("socksProxyHost", "");
            Debug.setSystemProperty("socksProxyPort", "");
            Debug.setSystemProperty("java.net.socks.username", "");
            Debug.setSystemProperty("java.net.socks.password", "");
        }
    }

    private void refreshDownloadDirectory() {
        try {
            this.properties.setFile("download.directory", this.properties.getFile("download.directory").getCanonicalFile());
        }
        catch (Exception e) {
            try {
                this.properties.setFile("download.directory", new File(".").getCanonicalFile());
            }
            catch (Exception ex) {
                try {
                    this.properties.setFile("download.directory", new File(System.getProperty("user.dir")).getCanonicalFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void initComponents() {
        this.status = new JLabel();
        this.urlPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.goButton = new JButton();
        this.pasteButton = new JButton();
        this.clearButton = new JButton();
        this.urlPane = new JScrollPane();
        this.urlText = new JTextArea();
        this.downloadsPanel = new JPanel();
        this.downloadsPane = new JScrollPane();
        this.downloadsTable = new JTable();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitItem = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.topItem = new JCheckBoxMenuItem();
        this.trayItem = new JCheckBoxMenuItem();
        this.optionsSeparator = new JSeparator();
        this.restrictedItem = new JCheckBoxMenuItem();
        this.shortItem = new JCheckBoxMenuItem();
        this.proxyItem = new JCheckBoxMenuItem();
        this.helpMenu = new JMenu();
        this.usageItem = new JMenuItem();
        this.aboutItem = new JMenuItem();
        this.checkItem = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.status.setText(" ");
        this.getContentPane().add((Component)this.status, "Last");
        this.urlPanel.setBorder(BorderFactory.createTitledBorder("Webpage URL"));
        this.urlPanel.setLayout(new BorderLayout());
        this.buttonsPanel.setLayout(new GridLayout(3, 1));
        this.goButton.setIcon(new ImageIcon(this.getClass().getResource("/org/freeshell/zs/mediasniper/resources/wand.png")));
        this.goButton.setMnemonic('g');
        this.goButton.setText("Go!");
        this.goButton.setToolTipText("Parse this webpage URL");
        this.goButton.setHorizontalAlignment(10);
        this.buttonsPanel.add(this.goButton);
        this.pasteButton.setIcon(new ImageIcon(this.getClass().getResource("/org/freeshell/zs/mediasniper/resources/page_paste.png")));
        this.pasteButton.setMnemonic('p');
        this.pasteButton.setText("Paste and Go!");
        this.pasteButton.setToolTipText("Paste the webpage URL from the clipboard and parse it");
        this.pasteButton.setHorizontalAlignment(10);
        this.buttonsPanel.add(this.pasteButton);
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/org/freeshell/zs/mediasniper/resources/bin_closed.png")));
        this.clearButton.setMnemonic('c');
        this.clearButton.setText("Clear");
        this.clearButton.setToolTipText("Clear this webpage URL");
        this.clearButton.setHorizontalAlignment(10);
        this.buttonsPanel.add(this.clearButton);
        this.urlPanel.add((Component)this.buttonsPanel, "After");
        this.urlPane.setHorizontalScrollBarPolicy(31);
        this.urlText.setColumns(20);
        this.urlText.setLineWrap(true);
        this.urlText.setRows(5);
        this.urlPane.setViewportView(this.urlText);
        this.urlPanel.add((Component)this.urlPane, "Center");
        this.getContentPane().add((Component)this.urlPanel, "First");
        this.downloadsPanel.setBorder(BorderFactory.createTitledBorder("Media File Downloads"));
        this.downloadsPane.setPreferredSize(new Dimension(500, 250));
        this.downloadsTable.setAutoCreateRowSorter(true);
        this.downloadsTable.setModel(this.downloadsTableModel);
        this.downloadsPane.setViewportView(this.downloadsTable);
        GroupLayout downloadsPanelLayout = new GroupLayout(this.downloadsPanel);
        this.downloadsPanel.setLayout(downloadsPanelLayout);
        downloadsPanelLayout.setHorizontalGroup(downloadsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.downloadsPane, -1, 474, Short.MAX_VALUE));
        downloadsPanelLayout.setVerticalGroup(downloadsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.downloadsPane, -1, 195, Short.MAX_VALUE));
        this.getContentPane().add((Component)this.downloadsPanel, "Center");
        this.fileMenu.setMnemonic('f');
        this.fileMenu.setText("File");
        this.exitItem.setMnemonic('x');
        this.exitItem.setText("Exit");
        this.fileMenu.add(this.exitItem);
        this.menuBar.add(this.fileMenu);
        this.optionsMenu.setMnemonic('o');
        this.optionsMenu.setText("Options");
        this.topItem.setMnemonic('t');
        this.topItem.setSelected(true);
        this.topItem.setText("Always on Top");
        this.optionsMenu.add(this.topItem);
        this.trayItem.setMnemonic('m');
        this.trayItem.setSelected(true);
        this.trayItem.setText("Minimize to Tray");
        this.optionsMenu.add(this.trayItem);
        this.optionsMenu.add(this.optionsSeparator);
        this.restrictedItem.setMnemonic('r');
        this.restrictedItem.setSelected(true);
        this.restrictedItem.setText("Restricted ASCII Filenames");
        this.optionsMenu.add(this.restrictedItem);
        this.shortItem.setMnemonic('s');
        this.shortItem.setSelected(true);
        this.shortItem.setText("Short (8.3) Filenames");
        this.optionsMenu.add(this.shortItem);
        this.proxyItem.setSelected(true);
        this.proxyItem.setText("SOCKS Proxy");
        this.optionsMenu.add(this.proxyItem);
        this.menuBar.add(this.optionsMenu);
        this.helpMenu.setMnemonic('h');
        this.helpMenu.setText("Help");
        this.usageItem.setMnemonic('u');
        this.usageItem.setText("Usage...");
        this.helpMenu.add(this.usageItem);
        this.aboutItem.setMnemonic('a');
        this.aboutItem.setText("About...");
        this.helpMenu.add(this.aboutItem);
        this.checkItem.setMnemonic('c');
        this.checkItem.setText("Check for Update");
        this.helpMenu.add(this.checkItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private class DownloadsTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Title", "Size", "Progress"};
        private final Class[] columnClasses = new Class[]{TableStringCell.class, TableStringCell.class, TableProgressCell.class};
        private final Map<Download, Object[]> contents = new HashMap<Download, Object[]>();

        private DownloadsTableModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            List list = MediaSniper.this.downloads;
            synchronized (list) {
                return MediaSniper.this.downloads.size();
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int col) {
            return this.columnClasses[col];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int row, int col) {
            Download d;
            List list = MediaSniper.this.downloads;
            synchronized (list) {
                d = (Download)MediaSniper.this.downloads.get(row);
            }
            Object[] c = this.contents.get(d);
            if (c == null) {
                c = new Object[]{new TableStringCell(d), new TableStringCell(d), new TableProgressCell(d)};
                this.contents.put(d, c);
                ((TableStringCell)c[0]).align = 2;
                ((TableStringCell)c[1]).align = 4;
            }
            switch (col) {
                case 0: {
                    ((TableStringCell)c[0]).text = "<html>" + d.getTitle() + "</html>";
                    break;
                }
                case 1: {
                    ((TableStringCell)c[1]).value = d.getLength();
                    ((TableStringCell)c[1]).text = d.getLengthString();
                    break;
                }
                case 2: {
                    ((TableProgressCell)c[2]).percent = d.getProgressPercent();
                    ((TableProgressCell)c[2]).text = d.getProgressString();
                    break;
                }
                default: {
                    return null;
                }
            }
            return c[col];
        }
    }
}

