/*
 * Decompiled with CFR 0.152.
 */
package org.freeshell.zs.mediasniper;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.freeshell.zs.common.HtmlManipulator;
import org.freeshell.zs.common.StringManipulator;

class LocalFilenameManager {
    private static final String ILLEGAL_FILENAME_CHARS = "\\/:*?\"<>|";
    private static final String[] RESERVED_DEVICE_NAMES = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    private static final String RESTRICTED_ASCII_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 `~!@#$%^&()-=_+[]{};',.";
    private static final String[] CHAR_SUBSTITUTION_TABLE_RAW = new String[]{"\"", "'", "<", "(", ">", ")", ":", "-", "?*|/\\", " "};
    private static final Map<Character, String> CHAR_SUBSTITUTION_TABLE = new HashMap<Character, String>();
    private final Set<File> filenames = new HashSet<File>();

    LocalFilenameManager() {
    }

    static String isValidPathname(String pathname) {
        if (pathname.isEmpty()) {
            return "Empty pathname";
        }
        String parent = File.separatorChar == '/' ? pathname : pathname.replace(File.separatorChar, '/');
        int doubleFileSeparator = parent.indexOf("//", 1);
        if (doubleFileSeparator >= 0) {
            return "Pathname contains double file separator \"" + pathname.substring(doubleFileSeparator, doubleFileSeparator + 2) + "\"";
        }
        if (!parent.isEmpty() && !"/".equals(parent) && !"//".equals(parent) && parent.endsWith("/")) {
            parent = parent.substring(0, parent.length() - 1);
        }
        while (!(parent.isEmpty() || "/".equals(parent) || "//".equals(parent) || parent.length() == 2 && parent.charAt(1) == ':')) {
            String component = null;
            int lastSlash = parent.lastIndexOf(47);
            if (lastSlash >= 0) {
                component = parent.substring(lastSlash + 1);
                parent = parent.substring(0, lastSlash);
            } else {
                component = parent;
                parent = "";
            }
            if (component.isEmpty()) {
                return "Pathname contains empty component";
            }
            if (component.length() > 255) {
                return "Pathname component \"" + component + "\" is longer than 255 characters";
            }
            for (char c : component.toCharArray()) {
                if (c < ' ') {
                    return "Pathname component \"" + component + "\" contains illegal character of value " + c + " (i.e. in the range 0 to 31)";
                }
                if (!ILLEGAL_FILENAME_CHARS.contains(c + "")) continue;
                return "Pathname component \"" + component + "\" contains illegal character '" + c + "' (characters " + ILLEGAL_FILENAME_CHARS + " are not allowed)";
            }
            if (component.endsWith(" ")) {
                return "Pathname component \"" + component + "\" contains trailing space ' '";
            }
            if (component.endsWith(".")) {
                return "Pathname component \"" + component + "\" contains trailing period '.'";
            }
            String nameUpperCase = component.toUpperCase(Locale.ENGLISH);
            for (String s : RESERVED_DEVICE_NAMES) {
                if (!nameUpperCase.equals(s) && !nameUpperCase.startsWith(s + ".")) continue;
                return "Pathname component \"" + component + "\" clashes with reserved device name \"" + s + "\"";
            }
        }
        File f = null;
        try {
            f = new File(pathname).getCanonicalFile();
        }
        catch (Exception e) {
            String error = e.getMessage();
            return "Failed to create Java File object for pathname" + (error == null ? "" : " (" + error + ")");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getCleanFilename(String base, String ext, File parentDirectory, boolean restrictedAsciiFilenamesMode, boolean shortFilenamesMode) {
        String cleanBase = base;
        cleanBase = HtmlManipulator.replaceHtmlEntities(cleanBase);
        StringBuilder t = new StringBuilder();
        for (char c : cleanBase.toCharArray()) {
            String s = CHAR_SUBSTITUTION_TABLE.get(Character.valueOf(c));
            if (s == null) {
                t.append(c);
                continue;
            }
            t.append(s);
        }
        cleanBase = t.toString();
        t.delete(0, t.length());
        for (char c : cleanBase.toCharArray()) {
            if (c < ' ' || ILLEGAL_FILENAME_CHARS.contains(c + "") || restrictedAsciiFilenamesMode && !RESTRICTED_ASCII_CHARS.contains(c + "")) continue;
            t.append(c);
        }
        cleanBase = t.toString();
        cleanBase = StringManipulator.deleteExtraWhitespace(cleanBase);
        cleanBase = StringManipulator.trimTrailingStrings(cleanBase, new String[]{".", " ", ext});
        cleanBase = StringManipulator.trimLeadingStrings(cleanBase, new String[]{".", " "});
        String cleanBaseUpperCase = cleanBase.toUpperCase(Locale.ENGLISH);
        for (String s : RESERVED_DEVICE_NAMES) {
            if (!cleanBaseUpperCase.equals(s) && !cleanBaseUpperCase.startsWith(s + ".")) continue;
            cleanBase = "_" + cleanBase;
            cleanBaseUpperCase = "_" + cleanBaseUpperCase;
        }
        String cleanExt = ext;
        if (shortFilenamesMode) {
            if (cleanBase.length() > 8) {
                cleanBase = cleanBase.substring(0, 8);
            }
            if (cleanExt.length() > 3) {
                cleanExt = cleanExt.substring(0, 3);
            }
        } else if (cleanBase.length() + 1 + cleanExt.length() > 255) {
            int truncatedBaseLength = 255 - (1 + cleanExt.length());
            if (truncatedBaseLength < 1) {
                return null;
            }
            cleanBase = cleanBase.substring(0, truncatedBaseLength);
        }
        String name = cleanBase + "." + cleanExt;
        if (cleanBase.isEmpty() || LocalFilenameManager.isValidPathname(name) != null) {
            return null;
        }
        File f = new File(parentDirectory, name);
        Set<File> set = this.filenames;
        synchronized (set) {
            if (this.filenames.contains(f) || f.exists()) {
                f = null;
                for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                    int truncatedBaseLength;
                    String baseSuffix = "-" + i;
                    if (shortFilenamesMode) {
                        if (cleanBase.length() + baseSuffix.length() > 8) {
                            truncatedBaseLength = 8 - baseSuffix.length();
                            if (truncatedBaseLength < 1) {
                                return null;
                            }
                            name = cleanBase.substring(0, truncatedBaseLength) + baseSuffix + "." + cleanExt;
                        } else {
                            name = cleanBase + baseSuffix + "." + cleanExt;
                        }
                    } else if (cleanBase.length() + baseSuffix.length() + 1 + cleanExt.length() > 255) {
                        truncatedBaseLength = 255 - (baseSuffix.length() + 1 + cleanExt.length());
                        if (truncatedBaseLength < 1) {
                            return null;
                        }
                        name = cleanBase.substring(0, truncatedBaseLength) + baseSuffix + "." + cleanExt;
                    } else {
                        name = cleanBase + baseSuffix + "." + cleanExt;
                    }
                    f = new File(parentDirectory, name);
                    if (!this.filenames.contains(f) && !f.exists()) break;
                    f = null;
                }
            }
            if (f != null) {
                this.filenames.add(f);
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File replaceFilename(File oldFile, File parentDirectory, String newFilename) {
        if (LocalFilenameManager.isValidPathname(newFilename) != null) {
            return null;
        }
        File newFile = new File(newFilename);
        try {
            newFile = newFile.isAbsolute() ? newFile.getCanonicalFile() : new File(parentDirectory, newFilename).getCanonicalFile();
        }
        catch (Exception e) {
            return null;
        }
        if (newFile.equals(oldFile) && newFile.getPath().equals(oldFile.getPath())) {
            return oldFile;
        }
        if (newFile.exists()) {
            return null;
        }
        Set<File> set = this.filenames;
        synchronized (set) {
            if (!this.filenames.contains(oldFile)) {
                return null;
            }
            if (!newFile.equals(oldFile) && this.filenames.contains(newFile)) {
                return null;
            }
            if (!this.filenames.remove(oldFile)) {
                return null;
            }
            this.filenames.add(newFile);
        }
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFilename(File releaseFile) {
        Set<File> set = this.filenames;
        synchronized (set) {
            this.filenames.remove(releaseFile);
        }
    }

    static {
        if (CHAR_SUBSTITUTION_TABLE_RAW.length % 2 != 0) {
            throw new RuntimeException("(INTERNAL) Malformed CHAR_SUBSTITUTION_TABLE_RAW in LocalFilenameManager.");
        }
        for (int i = 0; i < CHAR_SUBSTITUTION_TABLE_RAW.length; i += 2) {
            for (char c : CHAR_SUBSTITUTION_TABLE_RAW[i].toCharArray()) {
                CHAR_SUBSTITUTION_TABLE.put(Character.valueOf(c), CHAR_SUBSTITUTION_TABLE_RAW[i + 1]);
            }
        }
    }
}

