/*
 * Decompiled with CFR 0.152.
 */
package org.freeshell.zs.mediasniper;

import java.awt.Desktop;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.freeshell.zs.common.ResourceManipulator;
import org.freeshell.zs.common.SwingManipulator;
import org.freeshell.zs.mediasniper.MediaSniper;

class About
extends JFrame {
    private final MediaSniper parent;
    private JScrollPane aboutPane;
    private JTextArea aboutText;
    private JButton bugButton;
    private JPanel buttonsPanel;
    private JButton closeButton;
    private JButton forumButton;
    private JButton homeButton;
    private JLabel title;

    About(final MediaSniper parent) {
        this.parent = parent;
        this.initComponents();
        this.setTitle("About - " + parent.getTitle());
        String header = parent.properties.getString("name") + " " + parent.properties.getString("version") + " (" + parent.properties.getString("date") + ")\n" + parent.properties.getString("copyright") + "\n" + parent.properties.getString("email") + "\n" + parent.properties.getString("homepage") + "\n" + "\nDefinitions last updated on " + parent.properties.getString("definitions.last.updated") + "." + "\n" + parent.properties.getString("definitions.comment");
        try {
            this.aboutText.setText(header + "\n\n" + ResourceManipulator.resourceAsString(parent.properties.getString("about")));
        }
        catch (Exception e) {
            this.aboutText.setText(header);
            SwingManipulator.showErrorDialog(parent, this.getTitle(), "(INTERNAL) Failed to read \"About\" text from JAR file.");
        }
        this.aboutText.setToolTipText("About " + parent.properties.getString("name"));
        this.aboutText.setCaretPosition(0);
        this.aboutText.setFont(new Font("Dialog", 0, this.aboutText.getFont().getSize() - 2));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                About.this.closeForm();
            }
        });
        try {
            this.setAlwaysOnTop(parent.isAlwaysOnTop());
        }
        catch (Exception e) {
            // empty catch block
        }
        List<Image> icons = parent.getIconImages();
        if (!icons.isEmpty()) {
            this.setIconImage(icons.get(0));
        }
        this.forumButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI(parent.properties.getString("forum")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI(parent.properties.getString("homepage")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.bugButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI(parent.properties.getString("bug.report")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                About.this.closeForm();
            }
        });
        this.aboutPane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_CANCEL_BUTTON");
        this.aboutPane.getActionMap().put("ESCAPE_CANCEL_BUTTON", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                About.this.closeButton.doClick();
            }
        });
        this.setLocationRelativeTo(parent);
    }

    private void closeForm() {
        this.setVisible(false);
    }

    private void initComponents() {
        this.title = new JLabel();
        this.aboutPane = new JScrollPane();
        this.aboutText = new JTextArea();
        this.closeButton = new JButton();
        this.buttonsPanel = new JPanel();
        this.homeButton = new JButton();
        this.forumButton = new JButton();
        this.bugButton = new JButton();
        this.setResizable(false);
        this.title.setHorizontalAlignment(0);
        this.title.setIcon(new ImageIcon(this.getClass().getResource("/org/freeshell/zs/mediasniper/resources/splashscreen.png")));
        this.aboutText.setColumns(20);
        this.aboutText.setEditable(false);
        this.aboutText.setFont(this.aboutText.getFont());
        this.aboutText.setLineWrap(true);
        this.aboutText.setRows(5);
        this.aboutText.setTabSize(4);
        this.aboutText.setWrapStyleWord(true);
        this.aboutPane.setViewportView(this.aboutText);
        this.closeButton.setMnemonic('C');
        this.closeButton.setText("Close");
        this.closeButton.setNextFocusableComponent(this.closeButton);
        this.buttonsPanel.setLayout(new GridLayout(1, 0));
        this.homeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/freeshell/zs/mediasniper/resources/house.png")));
        this.homeButton.setMnemonic('h');
        this.homeButton.setText("<html>Visit<br /><u>H</u>omepage</html>");
        this.homeButton.setIconTextGap(8);
        this.homeButton.setNextFocusableComponent(this.homeButton);
        this.buttonsPanel.add(this.homeButton);
        this.forumButton.setIcon(new ImageIcon(this.getClass().getResource("/org/freeshell/zs/mediasniper/resources/comments.png")));
        this.forumButton.setMnemonic('f');
        this.forumButton.setText("<html>Visit<br /><u>F</u>orum</html>");
        this.forumButton.setIconTextGap(8);
        this.forumButton.setNextFocusableComponent(this.forumButton);
        this.buttonsPanel.add(this.forumButton);
        this.bugButton.setIcon(new ImageIcon(this.getClass().getResource("/org/freeshell/zs/mediasniper/resources/bug.png")));
        this.bugButton.setMnemonic('b');
        this.bugButton.setText("<html>Report<br /><u>B</u>ug</hmtl>");
        this.bugButton.setIconTextGap(8);
        this.bugButton.setNextFocusableComponent(this.bugButton);
        this.buttonsPanel.add(this.bugButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonsPanel, GroupLayout.Alignment.CENTER, -1, 374, Short.MAX_VALUE).addComponent(this.aboutPane, GroupLayout.Alignment.CENTER, -1, 374, Short.MAX_VALUE).addComponent(this.title, GroupLayout.Alignment.CENTER, -1, 374, Short.MAX_VALUE).addComponent(this.closeButton, GroupLayout.Alignment.TRAILING, -2, 74, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.title).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.aboutPane, -1, 234, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonsPanel, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton, -2, 31, -2).addContainerGap()));
        this.pack();
    }
}

