/*
 * Decompiled with CFR 0.152.
 */
package org.freeshell.zs.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeshell.zs.common.Debug;

public class Downloader
implements Runnable {
    private static final long WAIT_INTERVAL_MILLISECONDS = 100L;
    private static final int BUFFER_SIZE = 1024;
    private final URL url;
    private final Object target;
    private int totalLength = -1;
    private int downloadedLength = 0;
    private final Object lengthLock = new Object();
    private volatile String progressString = "Waiting to start";
    private volatile boolean progressUpdated = false;
    private volatile Exception error = null;
    private boolean started = false;
    private boolean running = false;
    private boolean cancelled = false;
    private boolean completed = false;
    private final Object stateLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Downloader(URL url, Object target) {
        if (!(target instanceof File) && !(target instanceof StringBuilder)) {
            throw new IllegalArgumentException("Target must be a File or StringBuilder object.");
        }
        this.target = target;
        this.url = url;
        Object object = this.stateLock;
        synchronized (object) {
            this.started = false;
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        Object object = this.lengthLock;
        synchronized (object) {
            return this.totalLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadedLength() {
        Object object = this.lengthLock;
        synchronized (object) {
            return this.downloadedLength;
        }
    }

    public String getProgressString() {
        return this.progressString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProgressPercent() {
        Object object = this.lengthLock;
        synchronized (object) {
            if (this.totalLength <= 0 || this.downloadedLength > this.totalLength) {
                return -1;
            }
            if (this.downloadedLength == this.totalLength) {
                return 100;
            }
            return (int)(100.0 * (double)this.downloadedLength / (double)this.totalLength);
        }
    }

    public boolean isProgressUpdated() {
        if (this.progressUpdated) {
            this.progressUpdated = false;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.stateLock;
        synchronized (object) {
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.completed) {
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.stateLock;
        synchronized (object) {
            this.cancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.started;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleted() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilCompleted() throws Exception {
        while (true) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.completed) {
                    if (this.error == null) {
                        return;
                    }
                    throw this.error;
                }
            }
            Debug.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.running = true;
        }
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        BufferedReader br = null;
        try {
            block55: {
                Object charset;
                block54: {
                    URLConnection uRLConnection;
                    this.checkState();
                    this.progressString = "Opening connection to remote resource";
                    this.progressUpdated = true;
                    try {
                        uRLConnection = this.url.openConnection();
                        uRLConnection.connect();
                    }
                    catch (Exception e) {
                        this.progressString = "Failed to open connection to remote resource";
                        this.progressUpdated = true;
                        throw e;
                    }
                    this.checkState();
                    this.progressString = "Getting length of remote resource";
                    this.progressUpdated = true;
                    int length = uRLConnection.getContentLength();
                    Object object2 = this.lengthLock;
                    synchronized (object2) {
                        this.totalLength = length;
                    }
                    this.progressUpdated = true;
                    this.checkState();
                    this.progressString = "Opening input stream to remote resource";
                    this.progressUpdated = true;
                    try {
                        InputStream input = uRLConnection.getInputStream();
                        if (this.target instanceof File) {
                            bis = new BufferedInputStream(input);
                            break block54;
                        }
                        if (!(this.target instanceof StringBuilder)) break block54;
                        String contentType = uRLConnection.getContentType().toLowerCase(Locale.ENGLISH);
                        charset = null;
                        Matcher m = Pattern.compile(".*charset[\\s]*=([^;]++).*").matcher(contentType);
                        if (m.find()) {
                            charset = m.group(1).trim();
                        }
                        if (charset != null && !((String)charset).isEmpty()) {
                            try {
                                br = new BufferedReader(new InputStreamReader(input, (String)charset));
                            }
                            catch (Exception e) {
                                br = null;
                            }
                        }
                        if (br == null) {
                            br = new BufferedReader(new InputStreamReader(input));
                        }
                    }
                    catch (Exception e) {
                        this.progressString = "Failed to open input stream to remote resource";
                        this.progressUpdated = true;
                        throw e;
                    }
                }
                if (this.target instanceof File) {
                    this.checkState();
                    this.progressString = "Opening output stream to local file";
                    this.progressUpdated = true;
                    try {
                        File f = (File)this.target;
                        File parent = f.getParentFile();
                        if (parent != null && !parent.exists()) {
                            parent.mkdirs();
                        }
                        bos = new BufferedOutputStream(new FileOutputStream(f));
                    }
                    catch (Exception e) {
                        this.progressString = "Failed to open output stream to local file";
                        this.progressUpdated = true;
                        throw e;
                    }
                }
                this.progressString = "Downloading";
                this.progressUpdated = true;
                try {
                    if (this.target instanceof File) {
                        byte[] byteBuffer = new byte[1024];
                        while (true) {
                            this.checkState();
                            int byteCount = bis.read(byteBuffer, 0, 1024);
                            if (byteCount == -1) break block55;
                            bos.write(byteBuffer, 0, byteCount);
                            charset = this.lengthLock;
                            synchronized (charset) {
                                this.downloadedLength += byteCount;
                            }
                            this.progressUpdated = true;
                        }
                    }
                    if (!(this.target instanceof StringBuilder)) break block55;
                    char[] charBuffer = new char[1024];
                    StringBuilder sb = (StringBuilder)this.target;
                    while (true) {
                        this.checkState();
                        int charCount = br.read(charBuffer, 0, 1024);
                        if (charCount == -1) break;
                        sb.append(charBuffer, 0, charCount);
                        Object object3 = this.lengthLock;
                        synchronized (object3) {
                            this.downloadedLength += charCount;
                        }
                        this.progressUpdated = true;
                    }
                }
                catch (Exception e) {
                    this.progressString = "Failed to download remote resource";
                    this.progressUpdated = true;
                    throw e;
                }
            }
            this.progressString = "Download completed";
            this.progressUpdated = true;
        }
        catch (Exception exception) {
            try {
                this.error = exception;
            }
            catch (Throwable throwable) {
                for (Closeable c : new Closeable[]{bis, br, bos}) {
                    if (c == null) continue;
                    try {
                        c.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                Object object4 = this.stateLock;
                synchronized (object4) {
                    this.running = false;
                    this.completed = true;
                }
                throw throwable;
            }
            for (Closeable c : new Closeable[]{bis, br, bos}) {
                if (c == null) continue;
                try {
                    c.close();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
            Object object5 = this.stateLock;
            synchronized (object5) {
                this.running = false;
                this.completed = true;
            }
        }
        for (Closeable c : new Closeable[]{bis, br, bos}) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Object object5 = this.stateLock;
        synchronized (object5) {
            this.running = false;
            this.completed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() throws Exception {
        while (true) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.cancelled) {
                    this.progressString = "Download cancelled";
                    this.progressUpdated = true;
                    throw new Exception("Download cancelled");
                }
                if (this.running) {
                    return;
                }
            }
            Debug.sleep(100L);
        }
    }
}

