/*
 * Decompiled with CFR 0.152.
 */
package org.freeshell.zs.common;

import java.io.Console;
import java.io.PrintWriter;
import java.util.Date;

public class Debug {
    private static PrintWriter err;

    public static void p(Object o) {
        err.println(o + "");
        err.flush();
    }

    public static void pt(Object o) {
        err.println(new Date() + ": " + o);
        err.flush();
    }

    public static String getStackTraceString(Exception ex) {
        StringBuilder sb = new StringBuilder("Exception stack trace:");
        for (StackTraceElement e : ex.getStackTrace()) {
            sb.append("\n  ");
            sb.append(e);
        }
        return sb.toString();
    }

    public static String getSystemInformationString() {
        return "System Information:\n  " + Debug.getSystemProperty("os.name") + " (" + Debug.getSystemProperty("os.version") + ", " + Debug.getSystemProperty("os.arch") + ")" + "\n  JRE " + Debug.getSystemProperty("java.version") + " (" + Debug.getSystemProperty("java.vendor") + ")" + "\n  " + Debug.getSystemProperty("java.vm.name") + " " + Debug.getSystemProperty("java.vm.version") + " (" + Debug.getSystemProperty("java.vm.vendor") + ")";
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (Exception e) {
            return "Failed to get system property \"" + key + "\" (" + e + ")";
        }
    }

    public static void setSystemProperty(String key, String value) {
        try {
            System.setProperty(key, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        Console c = System.console();
        err = c == null ? new PrintWriter(System.out) : c.writer();
    }
}

