// VcDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VcDemo.h"
#include "VcDemoDlg.h"
#include "R2VInterface.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();
	
	// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA
	
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL
	
	// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
//{{AFX_MSG_MAP(CAboutDlg)
// No message handlers
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVcDemoDlg dialog

CVcDemoDlg::CVcDemoDlg(CWnd* pParent /*=NULL*/)
: CDialog(CVcDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVcDemoDlg)
	m_bRecCircle = TRUE;
	m_Threshold = -1;
	m_Straighten = 2.0;
	m_RasterFileName = _T("");
	m_bCustomAngle = FALSE;
	m_bCustomWidth = FALSE;
	m_bAngleAdjust = TRUE;
	m_bCalcWidth = FALSE;
	m_FillPattern = FALSE;
	m_FillSpace = 5.0;
	m_FillType = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVcDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVcDemoDlg)
	DDX_Control(pDX, IDC_OUTPUT_TYPE, m_OutputType);
	DDX_Control(pDX, IDC_PROGRESS_LAB, m_Progress_Lab);
	DDX_Control(pDX, IDC_PROGRESS1, m_Progress);
	DDX_Control(pDX, IDC_RUN, m_Run);
	DDX_Control(pDX, IDC_DELLEN_COMBO2, m_DelLenList);
	DDX_Control(pDX, IDC_CONNECT_COMBO1, m_ConnectList);
	DDX_Check(pDX, IDC_bRecCircle, m_bRecCircle);
	DDX_Text(pDX, IDC_THRESHOLD_EDIT, m_Threshold);
	DDV_MinMaxInt(pDX, m_Threshold, -1, 255);
	DDX_Text(pDX, IDC_Straighten, m_Straighten);
	DDV_MinMaxDouble(pDX, m_Straighten, -1., 20.);
	DDX_Text(pDX, IDC_RASTER_FILE, m_RasterFileName);
	DDV_MaxChars(pDX, m_RasterFileName, 255);
	DDX_Check(pDX, IDC_bAngle, m_bCustomAngle);
	DDX_Check(pDX, IDC_bWidth, m_bCustomWidth);
	DDX_Check(pDX, IDC_ANGLE_ADJUST, m_bAngleAdjust);
	DDX_Check(pDX, IDC_OUT_WIDTH, m_bCalcWidth);
	DDX_Check(pDX, IDC_FILL_CHK, m_FillPattern);
	DDX_Text(pDX, IDC_FILL_SPACE_EDIT, m_FillSpace);
	DDX_CBIndex(pDX, IDC_FILL_TYPE_COMBO, m_FillType);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVcDemoDlg, CDialog)
//{{AFX_MSG_MAP(CVcDemoDlg)
ON_WM_SYSCOMMAND()
ON_WM_PAINT()
ON_WM_QUERYDRAGICON()
ON_BN_CLICKED(IDC_OPEN_RASTER_BUTTON, OnOpenRasterButton)
ON_BN_CLICKED(IDC_RUN, OnRun)
	ON_BN_CLICKED(IDC_CENTER_RADIO1, OnCenterRadio1)
	ON_BN_CLICKED(IDC_OUTLINE_RADIO2, OnOutlineRadio2)
	//}}AFX_MSG_MAP
ON_MESSAGE(WM_USER_TRACE_PROGRESS_BEGIN, OnProgressBegin)
ON_MESSAGE(WM_USER_TRACE_PROGRESS, OnProgressPosition)
ON_MESSAGE(WM_USER_TRACE_PROGRESS_END, OnProgressEnd)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVcDemoDlg message handlers

BOOL CVcDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);
	
	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}
	
	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	int i=0;
	
	m_RasterFileName="none raster file.";
	//Init Connect list
	m_ConnectList.AddString("Cann\'t connect");
	for(i=1 ; i<=15 ;i++)
	{
		CString	str;
		str.Format("%d",i);
		
		m_ConnectList.AddString((LPCTSTR)str);
	}
	m_ConnectList.SetCurSel(9);
	////Init Delect length list
	m_DelLenList.AddString("Cann\'t Delect line");
	for(i=1 ; i<=20 ;i++)
	{
		CString	str;
		str.Format("%d",i);
		
		m_DelLenList.AddString((LPCTSTR)str);
	}
	m_DelLenList.SetCurSel(5);

	//Set output type ComboBox
	m_OutputType.AddString("DXF");
	m_OutputType.AddString("TEXT");
	m_OutputType.AddString("HP/GL");
	m_OutputType.AddString("SVG");
	m_OutputType.AddString("EPS");
	m_OutputType.SetCurSel(0);

	CButton	*pButton;

	pButton=(CButton *)GetDlgItem(IDC_CENTER_RADIO1);
	pButton->SetCheck(1);		//set to trace center mode
	
	UpdateData(FALSE);
	//-------------------------------------------------------
	m_Run.EnableWindow(FALSE);
	UpdateUI();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CVcDemoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVcDemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting
		
		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);
		
		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;
		
		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVcDemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVcDemoDlg::OnOpenRasterButton() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	
	CString Filter;
	
	Filter="All Raster format(*.bmp;*.jpg;*.jpeg;*.tif;*.tiff;*.tga;*.pcx)";
	Filter+="|*.bmp;*.jpg;*.jpeg;*.tif;*.tiff;*.tga;*.pcx|";
	Filter+="Windows bitmap file(*.bmp)|*.bmp|";
	Filter+="Jpeg file(*.jpg,*.jpeg)|*.jpg,*.jpeg|";
	Filter+="TIFF file(*.tif,*.tiff)|*.tif,*.tiff|";
	Filter+="TGA file(*.tga)|*.tga|"; 
	Filter+="PCX file(*.pcx)|*.pcx||";
	
	CFileDialog FileDialog(true,"bmp",NULL,OFN_HIDEREADONLY,Filter);
	if(FileDialog.DoModal() == IDOK)
	{
		m_RasterFileName=FileDialog.GetPathName();

		m_Run.EnableWindow(TRUE);
	
		UpdateData(FALSE);
	}	
}
void CVcDemoDlg::UpdateUI(void)
{
	CButton	*p=(CButton *)GetDlgItem(IDC_CENTER_RADIO1);

	int	iTraceType=p->GetCheck();	//TraceType :	1-Center mode 
									//				0-Outline mode

  //Center line parameters
	GetDlgItem(IDC_CONNECT_COMBO1)->EnableWindow(iTraceType);
	GetDlgItem(IDC_DELLEN_COMBO2)->EnableWindow(iTraceType);
	GetDlgItem(IDC_bWidth)->EnableWindow(iTraceType);
	GetDlgItem(IDC_OUT_WIDTH)->EnableWindow(iTraceType);
	GetDlgItem(IDC_bAngle)->EnableWindow(iTraceType);
	GetDlgItem(IDC_ANGLE_ADJUST)->EnableWindow(iTraceType);
  GetDlgItem(IDC_CONNECT_LAB)->EnableWindow(iTraceType);
  GetDlgItem(IDC_DEL_LAB)->EnableWindow(iTraceType);

  //Outline parameters
  GetDlgItem(IDC_FILL_CHK)->EnableWindow(!iTraceType);
  GetDlgItem(IDC_FILL_PAT_LAB)->EnableWindow(!iTraceType);
  GetDlgItem(IDC_FILL_TYPE_COMBO)->EnableWindow(!iTraceType);
  GetDlgItem(IDC_FILL_SPACE_LAB)->EnableWindow(!iTraceType);
  GetDlgItem(IDC_FILL_SPACE_EDIT)->EnableWindow(!iTraceType);
}

//Respond the message of beginning a progress
//and the lParam is LPCTSTR type, which is the name of the progress
LRESULT CVcDemoDlg::OnProgressBegin(WPARAM,LPARAM lParam)
{
  m_Progress_Lab.SetWindowText(LPCTSTR(lParam));
  m_Progress_Lab.RedrawWindow();
  m_Progress.SetPos(0);
  return 0;
}

//Respond the message of showing the current position of the progress
LRESULT CVcDemoDlg::OnProgressPosition(WPARAM Position,LPARAM)
{
  m_Progress.SetPos(Position);
  return 0;
}

//Respond the message of ending a progress
LRESULT CVcDemoDlg::OnProgressEnd(WPARAM,LPARAM)
{
  m_Progress.SetPos(100);
  return 0;
}

void CVcDemoDlg::OnCenterRadio1() 
{
	// TODO: Add your control notification handler code here
	UpdateUI();
}

void CVcDemoDlg::OnOutlineRadio2() 
{
	// TODO: Add your control notification handler code here
	UpdateUI();
}
	
void CVcDemoDlg::OnRun()
{
	// TODO: Add your control notification handler code here
	if(!g_R2V.IsReady())
	{
		AfxMessageBox("STOP : Can\'t load R2VDLL.DLL !");
		return;
	}

	UpdateData(TRUE);

	CButton	*p=(CButton *)GetDlgItem(IDC_CENTER_RADIO1);
	int iConnectDis	=m_ConnectList.GetCurSel();
	int iDeleteLen	=m_DelLenList.GetCurSel();
	int	iTraceType  =p->GetCheck();
		
	g_R2V.SetConnectDistance((iConnectDis > 0 ? TRUE : FALSE),iConnectDis);
	g_R2V.SetDeleteLength((iDeleteLen > 0 ? TRUE : FALSE), iDeleteLen);

	if(iTraceType != 0)	//if type == center mode then
	{
		if(m_bCustomWidth)
		{
			g_R2V.DeleteAllWidthSeries();
			
			g_R2V.AddWidthSeriesValue(0.0);
			g_R2V.AddWidthSeriesValue(0.5);
			g_R2V.AddWidthSeriesValue(1.0);
			g_R2V.AddWidthSeriesValue(2.0);
      //Set width units to mm
      //Note: 0 - inch, 1 - cm, 2 - mm, 3 - pixel
      g_R2V.SetWidthUnit(2);
      // Set the mode of processing more width
      g_R2V.SetMoreWidthMode(1);
		}else	{
			g_R2V.SetDefaultWidthSeries();
		}
		g_R2V.SetCalcWidth(m_bCalcWidth);
		
		if(m_bCustomAngle)
		{
			g_R2V.DeleteAllAngleSeries();
	
      const double PI=3.1415926535897932384626433832795;
			g_R2V.AddAngleSeriesValue(0.0   , 1.0/180.0*PI   , 0.0);
			g_R2V.AddAngleSeriesValue(29.0/180.0*PI  , 31.0/180.0*PI  , 30.0/180.0*PI);
			g_R2V.AddAngleSeriesValue(44.0/180.0*PI  , 46.0/180.0*PI  , 45.0/180.0*PI);
			g_R2V.AddAngleSeriesValue(59.0/180.0*PI  , 61.0/180.0*PI  , 60.0/180.0*PI);
			g_R2V.AddAngleSeriesValue(89.0/180.0*PI  , 91.0/180.0*PI  , 90.0/180.0*PI);
			g_R2V.AddAngleSeriesValue(119.0/180.0*PI , 121.0/180.0*PI , 120.0/180.0*PI);
			g_R2V.AddAngleSeriesValue(134.0/180.0*PI , 136.0/180.0*PI , 135.0/180.0*PI);
			g_R2V.AddAngleSeriesValue(149.0/180.0*PI , 151.0/180.0*PI , 150.0/180.0*PI);
			g_R2V.AddAngleSeriesValue(179.0/180.0*PI , 181.0/180.0*PI , 180.0/180.0*PI);
		}else	{
			g_R2V.SetDefaultAngleSeries();
		}
		g_R2V.SetAdjustAngle(m_bAngleAdjust);
	}else  // if type == outline mode
  {
    g_R2V.SetFillType(m_FillType);
    g_R2V.SetFillSpace(m_FillSpace);
  }

	CString	sOutputFile;

  //Generate the output filename
	switch(m_OutputType.GetCurSel())
	{
	case 0	:	sOutputFile="C:\\R2VTest.dxf";	break;
	case 1	:	sOutputFile="C:\\R2VTest.txt";	break;
	case 2	:	sOutputFile="C:\\R2VTest.plt";	break;
	case 3	:	sOutputFile="C:\\R2VTest.svg";	break;
	case 4	:	sOutputFile="C:\\R2VTest.eps";	break;
	}

	CWaitCursor cursor;
  long res=g_R2V.TraceRasterFile(	GetSafeHwnd(),			      // The window which receive the message sent by DLL
									                m_RasterFileName,		      // Source raster filename
      									          sOutputFile,			        // Vector filename
			      						          m_OutputType.GetCurSel(), // Vector file type: 0-Dxf, 1-text, 2-HP/GL, 3-Svg, 4-EPS
						      			          iTraceType,				        // Trace method: 0 - Trace Outline, 1 - Trace Center line
									                m_Threshold,  			      // Threshold - the threshold converting into 1-bit image, not greater than 255,
												      			                        // If this value is negative, DLL will calculate the threshold auto
      									          m_Straighten,		          // Straighten - Straighten indicates when curve is pulled into beeline,
			      												                        // the dot in the curve is the maximum distance from the beeline
						        			        m_bRecCircle,             // RecCircle - if 0, don't recognise circle or arc, if none 0, recognise the circle and arc	
                                  m_FillPattern);   		    // Fill pattern - if 0, don't fill pattern, if none 0, fill pattern
	if(res > 0)
  {
    //multi-page raster file will output multi result file
    //and the result file will like these:  R2VTest_0.dxf, R2VTest_1.dxf, R2VTest_2.dxf, R2VTest_3.dxf, etc
    if(res > 1)
    {
      CString s("Succeed ! And the follows are the output files:");
      CString s1;
      char dir[MAX_PATH], path[MAX_PATH], name[MAX_PATH], ext[MAX_PATH];
      _splitpath(sOutputFile,dir,path,name,ext);
      for(int i=0; i < res; i++)
      {
        s1.Format("\n%s%s%s_%d%s",dir,path,name,i,ext);
        s+=s1;
      }
      AfxMessageBox(s);
    }else
	    AfxMessageBox("Succeed ! [ output >> "+sOutputFile+" ]"); 
  }else
	  AfxMessageBox("Failed.");
}

