// R2VInterface.cpp: implementation of the CR2VInterface class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "R2VInterface.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CR2VInterface	g_R2V;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CR2VInterface::CR2VInterface()
{
	Init();
	if((m_hModule=LoadLibrary("R2VDLL.dll")) != NULL)	//Load R2VDLL.DLL
	{
		m_pTraceRasterFileFun		=(TraceRasterFileFun *)		GetProcAddress(m_hModule,"TraceRasterFile");
    m_pSetFillTypeFun = (SetFillTypeFun *) GetProcAddress(m_hModule,"SetFillType");
    m_pSetFillSpaceFun = (SetFillSpaceFun *)GetProcAddress(m_hModule,"SetFillSpace");
		m_pSetConnectDistanceFun	=(SetConnectDistanceFun *)	GetProcAddress(m_hModule,"SetConnectDistance");
		m_pSetDeleteLengthFun		=(SetDeleteLengthFun *)		GetProcAddress(m_hModule,"SetDeleteLength");
		m_pSetCalcWidthFun			=(SetCalcWidthFun *)		GetProcAddress(m_hModule,"SetCalcWidth");
		m_pDeleteAllWidthSeriesFun	=(DeleteAllWidthSeriesFun *)GetProcAddress(m_hModule,"DeleteAllWidthSeries");
		m_pAddWidthSeriesValueFun	=(AddWidthSeriesValueFun *)	GetProcAddress(m_hModule,"AddWidthSeriesValue");
		m_pSetMoreWidthModeFun		=(SetMoreWidthModeFun *)	GetProcAddress(m_hModule,"SetMoreWidthMode");
    m_pSetWidthUnitFun  = (SetWidthUnitFun *)GetProcAddress(m_hModule,"SetWidthUnit");
		m_pSetDefaultWidthSeriesFun	=(SetDefaultWidthSeriesFun *)GetProcAddress(m_hModule,"SetDefaultWidthSeries");
		m_pSetAdjustAngleFun		=(SetAdjustAngleFun *)		GetProcAddress(m_hModule,"SetAdjustAngle");
		m_pDeleteAllAngleSeriesFun	=(DeleteAllAngleSeriesFun *)GetProcAddress(m_hModule,"DeleteAllAngleSeries");
		m_pAddAngleSeriesValueFun	=(AddAngleSeriesValueFun *)	GetProcAddress(m_hModule,"AddAngleSeriesValue");
		m_pSetDefaultAngleSeriesFun	=(SetDefaultAngleSeriesFun *)GetProcAddress(m_hModule,"SetDefaultAngleSeries");
		m_pSetOrthoAngleSeriesFun	=(SetOrthoAngleSeriesFun *)	GetProcAddress(m_hModule,"SetOrthoAngleSeries");
	}else	{
		::MessageBox(NULL,"Error: Load R2VDLL.dll\n------------------------------\n\nFile not found !",NULL,MB_ICONINFORMATION | MB_OK);
	}
}

CR2VInterface::~CR2VInterface()
{
	if(m_hModule)
	{
		FreeLibrary(m_hModule);
		m_hModule	=NULL;
	}
}
void	CR2VInterface::Init(void)
{
	m_pTraceRasterFileFun		=NULL;
	m_pSetConnectDistanceFun	=NULL;
	m_pSetDeleteLengthFun		=NULL;
	m_pSetCalcWidthFun			=NULL;
	m_pDeleteAllWidthSeriesFun	=NULL;
	m_pAddWidthSeriesValueFun	=NULL;
	m_pSetMoreWidthModeFun		=NULL;
	m_pSetDefaultWidthSeriesFun	=NULL;
	m_pSetAdjustAngleFun		=NULL;
	m_pDeleteAllAngleSeriesFun	=NULL;
	m_pAddAngleSeriesValueFun	=NULL;
	m_pSetDefaultAngleSeriesFun	=NULL;
	m_pSetOrthoAngleSeriesFun	=NULL;
}