Attribute VB_Name = "Module1"
Rem The follow functions hook the window message processing to respond the message
Rem sent by TraceART DLL, and show the tracing progress
Option Explicit
Private Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" _
(ByVal lpPrevWndFunc As Long, _
 ByVal hwnd As Long, _
 ByVal Msg As Long, _
 ByVal wParam As Long, _
 ByVal lParam As Long _
) As Long

Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" _
(ByVal hwnd As Long, _
 ByVal nIndex As Long, _
 ByVal dwNewLong As Long _
) As Long

Public Declare Function lstrlenA Lib "kernel32.dll" (lpString As Any) As Long
Public Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)

Const GWL_WNDPROC = (-4)
Dim OldProc As Long
Dim OwnerWinHwnd As Long

Rem the follow messages are sent by DLL
Rem Converting is completed
Rem if successfully, the WPARAM is 0
Rem Otherwise the WPARAM is none 0
Const WM_USER_TRACE_FINISHED = 32868

Rem The follow messages are messages about progress
Rem begin a progress, and the LPARAM is the LPCTSTR type, shows the progress name
Const WM_USER_TRACE_PROGRESS_BEGIN = 32869

Rem The position of current progress, the max value is 100
Const WM_USER_TRACE_PROGRESS = 32870

Rem End the progress
Const WM_USER_TRACE_PROGRESS_END = 32871


Function MyWndProc(ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

Dim TempBytes() As Byte
Dim StrLen As Long
Dim TempStr As String

Select Case wMsg
Case WM_USER_TRACE_FINISHED
 MsgBox "Tracing completed!"
 MyWndProc = 0
 Exit Function
 
Case WM_USER_TRACE_PROGRESS_BEGIN
  Rem convert LPCTSTR into VB string
  StrLen = lstrlenA(ByVal lParam)
  ReDim TempBytes(1 To StrLen)
  CopyMemory TempBytes(1), ByVal lParam, StrLen
  TempStr = StrConv(TempBytes, vbUnicode)
  Rem show progress name
  Form1.Label7.Caption = TempStr
  Form1.ProgressBar1.Value = 0
  MyWndProc = 0
  Exit Function
  
Case WM_USER_TRACE_PROGRESS
  Form1.ProgressBar1.Value = wParam
  MyWndProc = 0
  Exit Function
  
Case WM_USER_TRACE_PROGRESS_END
  Form1.ProgressBar1.Value = 100
  MyWndProc = 0
  Exit Function
End Select

MyWndProc = CallWindowProc(OldProc, hwnd, wMsg, wParam, lParam)
End Function

Rem hook the message handler process function
Public Sub SetProgressForm(frm As Form1)

If OldProc <> 0 Then Exit Sub

OwnerWinHwnd = frm.hwnd
OldProc = SetWindowLong(OwnerWinHwnd, GWL_WNDPROC, AddressOf MyWndProc)

End Sub

Rem release the hook
Public Sub Release()

If OldProc = 0 Then Exit Sub

SetWindowLong OwnerWinHwnd, GWL_WNDPROC, OldProc

OldProc = 0
End Sub

