package dom;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.*;
import org.w3c.dom.Document;

import java.util.List;

import core.BasicSample;

/**
 * This sample fills form controls with values.
 *
 * @author Alexei Orischenko
 */
public class FormValuesSample extends BasicSample
{
    private static final String HTML_CONTENT = "<html>" +
            "<body><form id='formId' name='theForm' method='POST'>" +
            "<table>" +
            "<tr><td>Text: </td><td><input type='text' id='loginId' name='login'/></td></tr>" +
            "<tr><td>Password: </td><td><input type='password' id='passwordId' name='password'/></td></tr>" +
            "<tr><td>Checkbox: </td><td><input type='checkbox' id='isorderId' name='isorder'/></td></tr>" +
            "<tr><td>Radio: </td><td><input type='radio' id='c1' name='product' value='c1'/><label for='c1'>one</label>" +
            "<input type='radio' name='product' id='c2' value='c2'><label for='c2'>two</label></td></tr>" +
            "<tr><td>File: </td><td><input type='file' name='picId' name='pic'/></td></tr>" +
            "<tr><td>Text Area: </td><td><textarea cols=20 rows=5 name='areaId'></textarea></td></tr>" +
            "<tr><td>Select: </td><td>" +
            "<select id='stateId' name='state'>" +
            "<option id='sel' value='-1'>Please select...</option>" +
            "<option id='st_ny' value='ny'>New York</option>" +
            "<option id='st_ca' value='ca'>California</option>" +
            "</select>" +
            "</td></tr>" +
            "</table>" +
            "</form>" +
            "</body>" +
            "</html>";
    private static final String CARRIAGE_RETURN = "\r\n";

    public FormValuesSample()
    {
        super("Form Values");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        browser.setContent(HTML_CONTENT);
        browser.waitReady();

        HTMLForm form = (HTMLForm) browser.getDocument().getForms().get(0);

        int controlsCount = form.getControls().size();

        Document document = browser.getDocument();
        TextControl text = (TextControl) document.getElementById("loginId");
        TextControl password = (TextControl) document.getElementById("passwordId");
        CheckControl checkbox = (CheckControl) document.getElementById("isorderId");
        CheckControl radio1 = (CheckControl) document.getElementById("c1");
        CheckControl radio2 = (CheckControl) document.getElementById("c2");
        TextControl pic = (TextControl) document.getElementById("picId");
        TextControl area = (TextControl) document.getElementById("areaId");
        SelectElement select = (SelectElement) document.getElementById("stateId");

        showMessage("Set form values");

        text.setValue("Alex");
        password.setValue("secret");

        // set mark in checkbox
        checkbox.setValue(true);

        // select radio
        radio1.setValue(true);

        // set multiline value
        area.setValue("1st line" + CARRIAGE_RETURN + "2nd line");

        // select option
        List options = select.getOptions();
        OptionElement option1 = (OptionElement) options.get(1);
        option1.select();

        // not implemented: doesn't set value now
        pic.setValue("e:\\test.pdf");

        showMessage("Set another form values");

        checkbox.setValue(false);
        radio2.setValue(true);

        // select option
        OptionElement option2 = (OptionElement) options.get(2);
        option2.select();
    }

    public static void main(String[] args) throws Exception
    {
        new FormValuesSample().run();
    }
}
