package dom;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.scripting.Robot;
import com.jniwrapper.win32.ie.dom.HTMLDocument;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import core.BasicSample;

/**
 * This sample demonstates how to fill the file input control using {@link Robot} ability.
 *
 * @author Serge Piletsky
 */
public class FileInputSample extends BasicSample
{
    private static final String HTML_CONTENT = "<html>" +
            "<body><form id='formId' name='theForm' method='POST'>" +
            "File: <input type='file' name='id1' name='id1'/><BR>" +
            "</form>" +
            "</body>" +
            "</html>";

    public FileInputSample()
    {
        super("File Input Sample");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();
        browser.setContent(HTML_CONTENT);
        browser.waitReady();

        Robot robot = new Robot(browser);
        robot.inputFileName("id1", "C:\\test.ico");
    }

    public static void main(String[] args) throws Exception
    {
        new FileInputSample().run();
    }
}
