package dom;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import org.w3c.dom.Element;

import javax.swing.*;
import java.awt.*;

import core.BasicSample;

/**
 * This sample demonstrates the technique of getting, setting attributes of element.
 *
 * @author Alexei Orischenko
 */
public class ElementAttributesSample extends BasicSample
{
    private static final String HTML_CONTENT = "<html><body>" +
            "<span>Please input login and password:</span>" +
            "<form name='loginForm'>" +
            "Login: <input id='i1' name='login' value='' size='20' />" +
            "Password: <input id='i2' type='password' name='password' value='' size='20' />" +
            "</form>" +
            "</body></html>";

    public ElementAttributesSample()
    {
        super("Element Attributes");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        // wait when the browser will be ready to work
        browser.waitReady();

        browser.setContent(HTML_CONTENT);
        browser.waitReady();

        Element login = browser.getDocument().getElementById("i1");

        // Get element attributes
        String type = login.getAttribute("type");
        String size = login.getAttribute("size");
        String name = login.getAttribute("name");
        String value = login.getAttribute("value");

        showMessage("Login element attributes",
                "type: " + type + "\r\nsize: " + size + "\r\nname: " + name + "\r\nvalue: " + value);

        showMessage("Input login, password");

        // Set element attributes
        login.setAttribute("value", "leha");
        Element password = browser.getDocument().getElementById("i2");
        password.setAttribute("value", "secure");

        // updated value
        value = login.getAttribute("value");


        HTMLElement span = (HTMLElement) browser.getDocument().getElementsByTagName("span").item(0);

        // Getting text inside element
        String text = span.getAttribute("innerHTML");

        text = span.getText();
    }

    public static void main(String[] args) throws Exception
    {
        new ElementAttributesSample().run();
    }
}
