package dom;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.*;
import core.BasicSample;

/**
 * This sample demonstrates adding table element to the HTML document.
 *
 * @author Alexei Orischenko
 */
public class CreateTableSample extends BasicSample
{
    public CreateTableSample()
    {
        super("Create Table");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();
        HTMLDocument document = browser.getDocument();

        Table table = (Table)document.createElement("table");
        table.setAttribute("border", "1");
        document.getBody().appendChild(table);

        TableRow row = table.createRow(0);

        TableCell cell1 = row.createCell(0);
        TableCell cell2 = row.createCell(1);

        cell1.setText("cell 1");
        cell2.setText("cell 2");
    }

    public static void main(String[] args) throws Exception
    {
        new CreateTableSample().run();
    }
}
