package core;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;

/**
 * This sample demonstrates the technique of loading HTML documents from String object.
 *
 * @author Alexei Orischenko
 */
public class SetBrowserContentSample extends BasicSample
{
    private static final String HTML_CONTENT = "<html><body><h1>Simple document</h1></body></html>";

    public SetBrowserContentSample()
    {
        super("Set Browser Content");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        // wait when the browser will be ready to work
        browser.waitReady();

        browser.setContent(HTML_CONTENT);
        browser.waitReady();

        String browserContent = browser.getContent();
        showMessage("Page source:\n" + browserContent);
    }

    public static void main(String[] args) throws Exception
    {
        new SetBrowserContentSample().run();
    }
}
