package core;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.automation.types.BStr;
import com.jniwrapper.win32.ie.Browsers;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.mshtml.IHTMLDocument2;
import com.jniwrapper.win32.mshtml.impl.IHTMLDocument2Impl;
import com.jniwrapper.win32.shdocvw.IWebBrowser2;

/**
 * This sample demonstrates technique of setting document encoding (charset).
 *
 * @author Alexei Orischenko
 */
public class DocumentEncodingSample extends BasicSample
{
    private static final String CHARSET_RUSSIAN = "windows-1251";

    public DocumentEncodingSample()
    {
        super("Document Encoding");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();
        browser.navigate("http://www.google.com");
        browser.waitReady();

        IWebBrowser2 browser2 = Browsers.getBrowserPeer(browser);
        IHTMLDocument2 document2 = new IHTMLDocument2Impl(browser2.getDocument());
        String charset = document2.getCharset().getValue();

        showMessage("Current charset is " + charset + "\r\nChange document charset to " + CHARSET_RUSSIAN);

        charset = CHARSET_RUSSIAN;
        document2.setCharset(new BStr(charset));

        browser2.refresh();
    }

    public static void main(String[] args) throws Exception
    {
        new DocumentEncodingSample().run();
    }
}
