package core;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.Browser;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import java.awt.BorderLayout;

/**
 * This sample creates browser added to a Swing container and demonstrates how to handle NewWindow browser's event.
 *
 * @author Serge Piletsky
 */
public class ChildBrowserSample
{
    private static final String HTML_CONTENT =
            "<html><body>" +
            "<script> function openAnotherWindow() { window.open(\"http://www.google.com\", \"Test\", \"width=500,height=300\"); } </script>" +
            "<a id='theLink' href=\"javascript:openAnotherWindow()\" >Open Google in another window.</a> " +
            "</body></html>";

    public static void main(String[] args) throws Exception
    {
        UIManager.setLookAndFeel(WindowsLookAndFeel.class.getName());

        JFrame frame = new JFrame("JExplorer - Child Browser Sample");
        frame.setSize(800, 600);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLocationRelativeTo(null);

        Browser browser = new Browser();
        browser.setContent(HTML_CONTENT);

        JPanel panel = new JPanel();

        // set layout
        panel.setLayout(new BorderLayout());
        panel.add(browser, BorderLayout.CENTER);

        frame.getContentPane().add(panel);

        frame.setVisible(true);

        browser.waitReady();

        JOptionPane.showMessageDialog(frame, "Click link that opens child window.", "JExplorer", JOptionPane.INFORMATION_MESSAGE);

        final HTMLElement element = (HTMLElement)browser.getDocument().getElementById("theLink");

        // execute operation that opens child and get reference to the opened child (new method)
        WebBrowser child = waitChild1(browser, element);

/*
        // execute operation that opens child and get reference to the opened child (old method)
        WebBrowser child = waitChild2(browser, element);
*/
        String childTitle = child.getDocument().getTitle();
        JOptionPane.showMessageDialog(frame, "Child title: " + childTitle + ".", "JExplorer", JOptionPane.INFORMATION_MESSAGE);
    }

    private static WebBrowser waitChild1(WebBrowser browser, final HTMLElement element)
    {
        return browser.waitChildCreation(new Runnable()
        {
            public void run()
            {
                // click on link that opens popup window
                element.click();
            }
        });
    }

    private static WebBrowser waitChild2(WebBrowser browser, final HTMLElement element)
    {
        // Start track child window creation
        browser.trackChildren();

        // click on link that opens popup window
        element.click();

        // get reference to popup window
        return browser.waitChildCreation();
    }
}