package core;

import com.jniwrapper.win32.ie.Browser;
import com.jniwrapper.win32.registry.RegistryKey;
import com.jniwrapper.win32.registry.RegistryKeyValues;
import com.jniwrapper.win32.registry.RegistryKeyType;

import javax.swing.*;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * @author Ikryanov Vladimir
 */
public class BrowserSettingsSample
{
    private static final String KEY_PATH = "Software\\JExplorer";
    private static final String CONTENT = "<html>\n" +
            "<body>\n" +
            "<a href=\"http://www.google.com\">Excecute JavaScript</a>\n" +
            "</body>\n" +
            "</html>";

    public static void main(String[] args)
    {
        JFrame frame = new JFrame("JExplorer - Create Browser with new settings");
        frame.setSize(800, 600);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLocationRelativeTo(null);

        createRegistrySettings();

        Browser browser = new Browser(KEY_PATH);

        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(browser, BorderLayout.CENTER);

        frame.setContentPane(contentPane);
        frame.setVisible(true);

        browser.setContent(CONTENT);
        browser.waitReady();

        frame.addWindowListener(new WindowAdapter()
        {
            public void windowClosing(WindowEvent e)
            {
                removeRegistrySettings();
                System.exit(0);
            }
        });
    }

    public static void createRegistrySettings()
    {
        RegistryKey pathKey = RegistryKey.CURRENT_USER.createSubKey(KEY_PATH);

        RegistryKey settingsKey = pathKey.createSubKey("Settings", true);
        RegistryKeyValues settingsKeyValues = settingsKey.values();
        settingsKeyValues.put("Anchor Color", "0,0,0", RegistryKeyType.SZ);
        settingsKeyValues.put("Anchor Color Hover", "255,255,255", RegistryKeyType.SZ);
        settingsKeyValues.put("Use Anchor Hover Color", "yes", RegistryKeyType.SZ);

        RegistryKey mainKey = pathKey.createSubKey("Main", true);
        RegistryKeyValues mainKeyValues = mainKey.values();
        mainKeyValues.put("Use_DlgBox_Colors", "no", RegistryKeyType.SZ);
    }

    public static void removeRegistrySettings()
    {
        RegistryKey pathKey = RegistryKey.CURRENT_USER.openSubKey(KEY_PATH, true);
        pathKey.getRootKey().deleteSubTree(pathKey.getName());
    }
}
