package contextmenu;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.Browser;
import com.jniwrapper.win32.ie.ContextMenuProvider;
import org.w3c.dom.Element;

import javax.swing.JPopupMenu;

import core.BasicSample;

/**
 * This sample demnostrates technique of disabling context menu.
 *
 * @author Alexei Orischenko
 */
public class DisableContextMenuSample extends BasicSample
{
    public DisableContextMenuSample()
    {
        super("Disable Context Menu");
    }

    protected void execute()
    {
        Browser browser = (Browser)getBrowser();

        ContextMenuProvider provider = new ContextMenuProvider()
        {
            public JPopupMenu getPopupMenu(Element contextElement)
            {
                // don't show any menu
                return null;
            }
        };

        browser.setContextMenuProvider(provider);

        browser.navigate("http://google.com");
        browser.waitReady();

        showMessage("Context menu is disabled");
    }

    public static void main(String[] args) throws Exception
    {
        new DisableContextMenuSample().run();
    }
}
