/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
package com.jniwrapper.win32.ie.samples.demo;

import com.jniwrapper.win32.ie.WebBrowser;

import java.util.EventObject;

class CommandStateChangeEvent extends EventObject
{
    private boolean _isBackButton;
    private boolean _enabled;

    public CommandStateChangeEvent()
    {
        super(new Object());
    }

    public CommandStateChangeEvent(WebBrowser browser, boolean isBackButton, boolean enabled)
    {
        super(browser);
        _isBackButton = isBackButton;
        _enabled = enabled;
    }

    public WebBrowser getBrowser()
    {
        return (WebBrowser)getSource();
    }

    public boolean isEnabled()
    {
        return _enabled;
    }

    public boolean isBackButton()
    {
        return _isBackButton;
    }

    public String toString()
    {
        return "CommandStateChangeEvent: back button=" + _isBackButton + "; enabled=" + _enabled;
    }
}
