@echo off

REM Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.

set ROOT_DIR=..

set LIB_DIRECTORY=%ROOT_DIR%/lib
set BIN_DIRECTORY=%ROOT_DIR%/bin

set CORE_CLASSES=%LIB_DIRECTORY%/jniwrap-3.6.1.jar;%LIB_DIRECTORY%/winpack-3.6.jar;%LIB_DIRECTORY%/comfyj-2.4.jar;%LIB_DIRECTORY%/jexplorer-1.8.jar;
set CUSTOM_CLASSES=%ROOT_DIR%/demo/jexplorerdemo.jar;

set SAMPLE_CLASSPATH=%CORE_CLASSES%;%CUSTOM_CLASSES%
set SAMPLE_MAINCLASS=com.jniwrapper.win32.ie.samples.demo.JExplorerDemo

set PATH=%BIN_DIRECTORY%;%PATH%

if not exist %BIN_DIRECTORY%/jniwrap.lic goto noJNIWrapperLic 
if not exist %BIN_DIRECTORY%/comfyj.lic goto noComfyJLic
if not exist %BIN_DIRECTORY%/jexplorer.lic goto noJExplorerLic

start "" javaw.exe -classpath %SAMPLE_CLASSPATH% %SAMPLE_MAINCLASS%
goto end

:noJNIWrapperLic
echo Cannot start JExplorer: no JNIWrapper license file (jniwrap.lic) found in the 'bin' directory.
echo.
pause
goto end

:noComfyJLic
echo Cannot start JExplorer: no ComfyJ license file (comfyj.lic) found in the 'bin' directory.
echo.
pause
goto end

:noJExplorerLic
echo Cannot start JExplorer: no JExplorer license file (jexplorer.lic) found in the 'bin' directory.
echo.
pause
goto end

:end