/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ie.samples.demo;

import com.jniwrapper.win32.ie.samples.demo.NodeDetailsTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DOMAttributeTableModel
extends AbstractTableModel
implements NodeDetailsTableModel {
    private static final String HEADER_ATTRIBUTE_NAME = "Name";
    private static final String HEADER_ATTRIBUTE_VALUE = "Value";
    private Node _browserNode;
    private List _attributes;
    private boolean _onlySpecified;

    public Node getBrowserNode() {
        return this._browserNode;
    }

    public synchronized void setBrowserNode(Node browserNode) {
        this._browserNode = browserNode;
        this._attributes = null;
    }

    private void readAttributes() {
        if (this._attributes != null) {
            return;
        }
        NamedNodeMap attributes = null;
        int len = this._browserNode == null ? 0 : ((attributes = this._browserNode.getAttributes()) == null ? 0 : attributes.getLength());
        this._attributes = new ArrayList(len);
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)attributes.item(i);
            if (this.isOnlySpecified()) {
                if (!attr.getSpecified()) continue;
                this._attributes.add(new Attribute(attr));
                continue;
            }
            this._attributes.add(new Attribute(attr));
        }
        this.sortAttributes();
    }

    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        Attribute attr = (Attribute)this._attributes.get(rowIndex);
        if (columnIndex == 0) {
            return attr.getName();
        }
        if (columnIndex == 1) {
            return attr.getValue();
        }
        return null;
    }

    public int getColumnCount() {
        return 2;
    }

    public synchronized int getRowCount() {
        this.readAttributes();
        return this._attributes.size();
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return HEADER_ATTRIBUTE_NAME;
        }
        if (column == 1) {
            return HEADER_ATTRIBUTE_VALUE;
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public boolean isOnlySpecified() {
        return this._onlySpecified;
    }

    public synchronized void setOnlySpecified(boolean onlySpecified) {
        this._attributes = null;
        this._onlySpecified = onlySpecified;
        this.readAttributes();
    }

    private void sortAttributes() {
        if (this._attributes != null) {
            Collections.sort(this._attributes);
        }
    }

    static class Attribute
    implements Comparable {
        private String _name;
        private String _value;

        public Attribute(String name, String value) {
            this._name = name;
            this._value = value;
        }

        public Attribute(Attr attr) {
            this._name = attr.getName();
            this._value = attr.getSpecified() ? attr.getValue() : "";
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public int compareTo(Object o) {
            return this.getName().compareTo(((Attribute)o).getName());
        }
    }
}

