/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.com;

import com.jniwrapper.AnsiString;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.win32.HResult;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.com.ComException;
import com.jniwrapper.win32.com.ComFunctions;
import com.jniwrapper.win32.com.IClassFactory;
import com.jniwrapper.win32.com.impl.IClassFactoryImpl;
import com.jniwrapper.win32.com.types.CLSID;
import com.jniwrapper.win32.system.Kernel32;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DllClassFactory {
    private Handle a = new Handle();

    public DllClassFactory(File file) throws IOException {
        this.load(file);
    }

    protected void load(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("Unable to find specified library: " + file);
        }
        Handle handle = ComFunctions.coLoadLibrary(file);
        if (handle.isNull()) {
            throw new RuntimeException("Failed to load library: " + file);
        }
        this.a.setValue(handle.getValue());
    }

    public IClassFactory getClassFactory(CLSID cLSID) {
        Function function = Kernel32.getInstance().getFunction("GetProcAddress");
        Handle handle = new Handle();
        function.invoke((Parameter)handle, (Parameter)this.a, (Parameter)new AnsiString("DllGetClassObject"));
        if (handle.isNull()) {
            throw new RuntimeException("Failed to get 'DllGetClassObject' function from specified library");
        }
        Function function2 = handle.asFunction();
        HResult hResult = new HResult();
        IClassFactoryImpl iClassFactoryImpl = new IClassFactoryImpl();
        function2.invoke((Parameter)hResult, (Parameter)new Pointer((Parameter)cLSID), (Parameter)new Pointer((Parameter)iClassFactoryImpl.getIID()), (Parameter)new Pointer((Parameter)iClassFactoryImpl));
        ComException.checkResult(hResult);
        return iClassFactoryImpl;
    }

    public void freeLibrary() {
        if (!this.a.isNull()) {
            ComFunctions.coFreeLibrary(this.a);
        }
    }
}

