header
{
package com.jniwrapper.generator.objectivec.parser;
}

class ObjectiveCParser extends Parser;

options
{
	k = 3;
	buildAST = true;
}

externalDeclaration
	:	
	(	classInterface
	|	protocolDeclaration
	|	classDeclarationList
	|	strucuresOrUnionsOrEnums
	|	typedefDeclaration
	|	staticVarOrFunction
	)*
	;

strucuresOrUnionsOrEnums
	:	structureDefination
	|	unionDefination
	|	enumDefination
	;

classInterface:
	KEYWORD_INTERFACE^ className interfaceHeader
		methods
	KEYWORD_END!
	;

interfaceHeader: (LPAREN) => categoryExpr protocols | superClassExpr protocols varsBlock ;

className: ID ;

superClassExpr: COLON^ superclassName | { #superClassExpr = #(#[COLON, "superclass"]); } ;

superclassName: ID ;

categoryExpr: LPAREN^ categoryName RPAREN! | { #categoryExpr = #(#[LPAREN, "category"]); } ;

categoryName: ID ;

protocols: protocolReferenceList | { #protocols = #(#[LT, "protocols"]); } ;

protocolDeclaration:
	KEYWORD_PROTOCOL^ protocolName
		protocols
		methods
	KEYWORD_END!
	;

protocolName: ID ;

classDeclarationList: KEYWORD_CLASS^ classList SEMI! ;

classList: className (COMMA! className)* ;

protocolReferenceList: LT^ protocolList GT! ;

protocolList: protocolName (COMMA! protocolName)* ;

varsBlock: (LCURLY! instanceVariables RCURLY!)? { #varsBlock = #(#[LCURLY, "varsBlock"], varsBlock); } ;

instanceVariables: (visibilitySpecification | instanceVariable)* ;

visibilitySpecification	
	: 	KEYWORD_PRIVATE 
	|	KEYWORD_PROTECTED 
	|	KEYWORD_PUBLIC
	;

//-------------------------------------------------------------------------------------------------

structureDefination
	:	(KEYWORD_STRUCT LCURLY) => KEYWORD_STRUCT^ varsBlock (varList)? SEMI!
	|	KEYWORD_STRUCT^ ID varsBlock (varList)? SEMI!
	;

varList: varName (COMMA! varName)* ;

varName: pointerGroup ID (arrayDeclaration)? ;

unionDefination
	:	(KEYWORD_UNION LCURLY) => KEYWORD_UNION^ varsBlock (varList)? SEMI!
	|	KEYWORD_UNION^ ID varsBlock (varList)? SEMI!
	;

enumDefination
	:	(KEYWORD_ENUM LCURLY) => KEYWORD_ENUM^ enumBlock (ID)? SEMI!
	|	(KEYWORD_ENUM ID LCURLY) => KEYWORD_ENUM^ ID enumBlock (ID)? SEMI!
	|	KEYWORD_ENUM^ ID ID SEMI!
	;

enumBlock: LCURLY^ enumValueList RCURLY! ;

enumValueList: enumValueName (COMMA! enumValueName)* ;

enumValueName: ID^ (ASSIGN! enumValueExpr)? ;

enumValueExpr: expr ;

//-------------------------------------------------------------------------------------------------

instanceVariable
	:	(complexType LPAREN) => functionVariable SEMI! 
	|	(typeQualifier KEYWORD_STRUCT) => typeQualifier! strucuresOrUnionsOrEnums
	{ #instanceVariable = #(#[LCURLY, "variable"], instanceVariable); }
	|	(strucuresOrUnionsOrEnums | complexType variableName (COMMA! pointerGroup variableName)* SEMI!) 
	{ #instanceVariable = #(#[LCURLY, "variable"], instanceVariable); }
	;

variableName: bitModifier | ID^ (arrayDeclaration)? (bitModifier)? ;

arrayDeclaration: LBRACKET^ (expr)? RBRACKET! ;

bitModifier: COLON^ expr ;

complexType: (typeQualifier)? aType pointerGroup { #complexType = #(#[LCURLY, "complexType"], complexType); } ;

aType: modifier (typeSpecifier)* | (typeSpecifier)+ | ID (LT! ID GT!)? ;

pointerGroup: (STAR (typeQualifier)?)* ;

functionVariable: complexType LPAREN! (STAR)* ID^ RPAREN! functionParameters 
	{ #functionVariable = #(#[LCURLY, "callback"], functionVariable); }
	;

//-------------------------------------------------------------------------------------------------

methods: (methodDeclaration)* { #methods = #(#[SEMI, "methods"], #methods); } ;

methodDeclaration
	:	(PLUS | MINUS) (returnType)? ID^ parametersList SEMI! 
	|	strucuresOrUnionsOrEnums
	|	typedefDeclaration
	;

returnType: (LPAREN! complexType RPAREN!) { #returnType = #(#[COLON, "returnType"], #returnType); } ;

parametersList: (COLON! parameters)? { #parametersList = #(#[COLON, "parameters"], #parametersList); } ;

parameters: parameterDeclaration (COMMA! parameterDeclaration | parameterPrefix)* ;

parameterDeclaration
	:	LPAREN! parameterType RPAREN! ID^
	|	ID
	|	ELLIPSIS
	;

parameterType
	:	(complexType LPAREN) => complexType LPAREN! (STAR)* (ID)? RPAREN! functionParameters
	|	complexType
	;

parameterPrefix: ID^ COLON! parameterDeclaration ;

//-------------------------------------------------------------------------------------------------

staticVarOrFunction
	: 	(externModifier complexType ID LPAREN) => functionDeclaration
	|	staticVarDeclaration;

staticVarDeclaration: externModifier instanceVariable { #staticVarDeclaration = #(#[COLON, "static"], #staticVarDeclaration); } ;

externModifier: "extern" | ID! ;

functionDeclaration: externModifier functionReturnType ID^ functionParameters SEMI! { #functionDeclaration = #(#[COLON, "function"], #functionDeclaration); } ;

functionReturnType: complexType { #functionReturnType = #(#[COLON, "returnType"], #functionReturnType); } ;

functionParameters: LPAREN! (functionParameter)? (COMMA! (functionParameter | ELLIPSIS))* RPAREN! ;

functionParameter
	:	(complexType LPAREN) => complexType LPAREN! (STAR)* (ID)? RPAREN! functionParameters 	
	|	complexType functionParameterName (arrayDeclaration)? 
	{ #functionParameter = #(#[COLON, "parameter"], #functionParameter); } 
	;

functionParameterName: ID | { #functionParameterName = #(#[COLON, "noname"], #functionParameterName); } ;

//-------------------------------------------------------------------------------------------------

typedefDeclaration:  KEYWORD_TYPEDEF^ instanceVariable ;

//-------------------------------------------------------------------------------------------------

modifier: "signed" | "unsigned" ;

typeSpecifier
	:	"void"
	|	"char"
	|	"short"
	|	"int"
	|	"long"
	|	"float"
	|	"double"
	;

typeQualifier
	:	"const"!
	|	"volatile"
	|	"extern"
	;

//-------------------------------------------------------------------------------------------------

expr: assignExpr ;

assignExpr
        :       conditionalExpr ( a:assignOperator! assignExpr { ## = #( #a, ## );} )?
        ;

assignOperator
        :       ASSIGN
        |       DIV_ASSIGN
        |       PLUS_ASSIGN
        |       MINUS_ASSIGN
        |       STAR_ASSIGN
        |       MOD_ASSIGN
        |       RSHIFT_ASSIGN
        |       LSHIFT_ASSIGN
        |       BAND_ASSIGN
        |       BOR_ASSIGN
        |       BXOR_ASSIGN
        ;

conditionalExpr
        :       logicalOrExpr
                ( QUESTION^ expr COLON! conditionalExpr )?
        ;

constExpr
        :       conditionalExpr
        ;

logicalOrExpr
        :       logicalAndExpr ( LOR^ logicalAndExpr )*
        ;

logicalAndExpr
        :       inclusiveOrExpr ( LAND^ inclusiveOrExpr )*
        ;

inclusiveOrExpr
        :       exclusiveOrExpr ( BOR^ exclusiveOrExpr )*
        ;

exclusiveOrExpr
        :       bitAndExpr ( BXOR^ bitAndExpr )*
        ;

bitAndExpr
        :       equalityExpr ( BAND^ equalityExpr )*
        ;

equalityExpr
        :       relationalExpr
                ( ( EQUAL^ | NOT_EQUAL^ ) relationalExpr )*
        ;

relationalExpr
        :       shiftExpr
                ( ( LT^ | LTE^ | GT^ | GTE^ ) shiftExpr )*
        ;

shiftExpr
        :       additiveExpr
                ( ( LSHIFT^ | RSHIFT^ ) additiveExpr )*
        ;

additiveExpr
        :       multExpr
                ( ( PLUS^ | MINUS^ ) multExpr )*
        ;

multExpr
        :       castExpr
                ( ( STAR^ | DIV^ | MOD^ ) castExpr )*
        ;

castExpr
        :       ( LPAREN typeName RPAREN )=>
                LPAREN! typeName RPAREN! ( castExpr )
                            { ## = #( #[NCast, "("], ## ); }
        |       unaryExpr
        ;

typeName: ID ;

unaryExpr
        :       postfixExpr
        |       INC^ unaryExpr
        |       DEC^ unaryExpr
        |       u:unaryOperator castExpr { ## = #( #[NUnaryExpr], ## ); }
        |       "sizeof"^
                ( ( LPAREN typeName )=> LPAREN typeName RPAREN
                | unaryExpr
                )
        ;

unaryOperator
        :       BAND
        |       STAR
        |       PLUS
        |       MINUS
        |       BNOT
        |       LNOT
        ;

postfixExpr
        :       primaryExpr
                ( 
                postfixSuffix                   {## = #( #[NPostfixExpr], ## );} 
                )?
        ;

postfixSuffix
        :
                ( PTR ID
                | DOT ID
                | LBRACKET expr RBRACKET
                | INC
                | DEC
                )+
        ;

primaryExpr
        :       ID
        |       charConst
        |       intConst
        |       floatConst
        |       stringConst
        |       LPAREN! expr RPAREN!        { ## = #( #[NExpressionGroup, "("], ## ); }
        ;

protected
charConst
        :       CharLiteral
        ;

protected
stringConst
        :       (StringLiteral)+                { ## = #(#[NStringSeq], ##); }
        ;

protected
intConst
        :       IntOctalConst
        |       LongOctalConst
        |       UnsignedOctalConst
        |       IntIntConst
        |       LongIntConst
        |       UnsignedIntConst
        |       IntHexConst
        |       LongHexConst
        |       UnsignedHexConst
        ;

protected
floatConst
        :       FloatDoubleConst
        |       DoubleDoubleConst
        |       LongDoubleConst
        ;

dummy
        :       NCast
	|	NExpressionGroup
        |       NUnaryExpr
        |       NPostfixExpr
        |       NStringSeq
        ;

//-------------------------------------------------------------------------------------------------

class ObjectiveCLexer extends Lexer;

options
{
        k = 3;
        testLiterals = true;
}

tokens
{
	KEYWORD_STRUCT		= "struct";
	KEYWORD_UNION		= "union";
	KEYWORD_ENUM		= "enum";
	KEYWORD_TYPEDEF		= "typedef";

	KEYWORD_INTERFACE	= "@interface";
	KEYWORD_PROTOCOL	= "@protocol";
	KEYWORD_END		= "@end";
	KEYWORD_CLASS		= "@class";

	KEYWORD_PRIVATE		= "@private";
	KEYWORD_PROTECTED	= "@protected";
	KEYWORD_PUBLIC		= "@public";

	PREPROCESSOR_INCLUDE	= "#include";
	PREPROCESSOR_IMPORT	= "#import";
	PREPROCESSOR_DEFINE	= "#define";
	PREPROCESSOR_IF		= "#if";
	PREPROCESSOR_IFDEF	= "#ifdef";
	PREPROCESSOR_ELSE	= "#else";
	PREPROCESSOR_ELIF	= "#elif";
	PREPROCESSOR_ENDIF	= "#endif";
	PREPROCESSOR_LINE	= "#line";
	PREPROCESSOR_WARNING	= "#warning";
}

ASSIGN          : '=' ;
COLON           : ':' ;
COMMA           : ',' ;
QUESTION        : '?' ;
SEMI            : ';' ;

LPAREN          : '(' ;
RPAREN          : ')' ;
LBRACKET        : '[' ;
RBRACKET        : ']' ;
LCURLY          : '{' ;
RCURLY          : '}' ;

ELLIPSIS	: "...";

EQUAL           : "==" ;
NOT_EQUAL       : "!=" ;
LTE             : "<=" ;
LT              : "<" ;
GTE             : ">=" ;
GT              : ">" ;

DIV             : '/' ;
PLUS            : '+' ;
MINUS           : '-' ;
STAR            : '*' ;
MOD             : '%' ;
RSHIFT          : ">>" ;
LSHIFT          : "<<" ;

LAND            : "&&" ;
LNOT            : '!' ;
LOR             : "||" ;

BAND            : '&' ;
BNOT            : '~' ;
BOR             : '|' ;
BXOR            : '^' ;

protected
VARARGS:;

Whitespace
        :       ( ( '\003'..'\010' | '\t' | '\013' | '\f' | '\016'.. '\037' | '\177'..'\377' | ' ' )
                | "\r\n"                { newline(); }
                | ( '\n' | '\r' )       { newline(); }
                )                       { _ttype = Token.SKIP;  }
        ;

Comment
        :       "/*"
                ( { LA(2) != '/' }? '*'
                | "\r\n"                
                | ( '\r' | '\n' )       
                | ~( '*'| '\r' | '\n' )
                )*
                "*/"                    { _ttype = Token.SKIP; }
        ;


CPPComment
        :
                "//" ( ~('\n') )* 	{ _ttype = Token.SKIP; }
        ;

PreprocessorDerectives: PREPROCESSOR (~( '\r' | '\n' ))*  { _ttype = Token.SKIP; } ;

/* Literals: */

/*
 * Note that we do NOT handle tri-graphs nor multi-byte sequences.
 */


/*
 * Note that we can't have empty character constants (even though we
 * can have empty strings :-).
 */

CharLiteral
        :       '\'' ( Escape | ~( '\'' ) )* '\''
        ;

/*
 * Can't have raw imbedded newlines in string constants.  Strict reading of
 * the standard gives odd dichotomy between newlines & carriage returns.
 * Go figure.
 */

StringLiteral
        :       '"'
                ( Escape
                | ( 
                    '\r'        
                  | '\n'        {
                                _ttype = BadStringLiteral;
                                }
                  | '\\' '\n'
                  )
                | ~( '"' | '\r' | '\n' | '\\' )
                )*
                '"'
        ;

protected BadStringLiteral
        :       // Imaginary token.
        ;

/*
 * Handle the various escape sequences.
 *
 * Note carefully that these numeric escape *sequences* are *not* of the
 * same form as the C language numeric *constants*.
 *
 * There is no such thing as a binary numeric escape sequence.
 *
 * Octal escape sequences are either 1, 2, or 3 octal digits exactly.
 *
 * There is no such thing as a decimal escape sequence.
 *
 * Hexadecimal escape sequences are begun with a leading \x and continue
 * until a non-hexadecimal character is found.
 *
 * No real handling of tri-graph sequences, yet.
 */

protected
Escape  
        :       '\\'
                ( options{warnWhenFollowAmbig=false;}:
                  'a'
                | 'b'
                | 'f'
                | 'n'
                | 'r'
                | 't'
                | 'v'
                | '"'
                | '\''
                | '\\'
                | '?'
                | ('0'..'3') ( options{warnWhenFollowAmbig=false;}: Digit ( options{warnWhenFollowAmbig=false;}: Digit )? )?
                | ('4'..'7') ( options{warnWhenFollowAmbig=false;}: Digit )?
                | 'x' ( options{warnWhenFollowAmbig=false;}: Digit | 'a'..'f' | 'A'..'F' )+
                )
        ;

/* Numeric Constants: */

protected
Digit
        :       '0'..'9'
        ;

protected
LongSuffix
        :       'l'
        |       'L'
        ;

protected
UnsignedSuffix
        :       'u'
        |       'U'
        ;

protected
FloatSuffix
        :       'f'
        |       'F'
        ;

protected
Exponent
        :       ( 'e' | 'E' ) ( '+' | '-' )? ( Digit )+
        ;


protected
DoubleDoubleConst:;

protected
FloatDoubleConst:;

protected
LongDoubleConst:;

protected
IntOctalConst:;

protected
LongOctalConst:;

protected
UnsignedOctalConst:;

protected
IntIntConst:;

protected
LongIntConst:;

protected
UnsignedIntConst:;

protected
IntHexConst:;

protected
LongHexConst:;

protected
UnsignedHexConst:;

Number
        :       ( ( Digit )+ ( '.' | 'e' | 'E' ) )=> ( Digit )+
                ( '.' ( Digit )* ( Exponent )?
                | Exponent
                )                       { _ttype = DoubleDoubleConst;   }
                ( FloatSuffix           { _ttype = FloatDoubleConst;    }
                | LongSuffix            { _ttype = LongDoubleConst;     }
                )?

        |       ( "..." )=> "..."       { _ttype = VARARGS;     }

        |       '.'                     { _ttype = DOT; }
                ( ( Digit )+ ( Exponent )?
                                        { _ttype = DoubleDoubleConst;   }
                  ( FloatSuffix         { _ttype = FloatDoubleConst;    }
                  | LongSuffix          { _ttype = LongDoubleConst;     }
                  )?
                )?

        |       '0' ( '0'..'7' )*       { _ttype = IntOctalConst;       }
                ( LongSuffix            { _ttype = LongOctalConst;      }
                | UnsignedSuffix        { _ttype = UnsignedOctalConst;  }
                )?

        |       '1'..'9' ( Digit )*     { _ttype = IntIntConst;         }
                ( LongSuffix            { _ttype = LongIntConst;        }
                | UnsignedSuffix        { _ttype = UnsignedIntConst;    }
                )?

        |       '0' ( 'x' | 'X' ) ( 'a'..'f' | 'A'..'F' | Digit )+
                                        { _ttype = IntHexConst;         }
                ( LongSuffix            { _ttype = LongHexConst;        }
                | UnsignedSuffix        { _ttype = UnsignedHexConst;    }
                )?
        ;

ID
        options
	{
                testLiterals = true; 
	}
        :       ( 'a'..'z' | 'A'..'Z' | '_' )
                ( 'a'..'z' | 'A'..'Z' | '_' | '0'..'9' )*
        ;

KEYWORD
        options
	{
                testLiterals = true; 
	}
        :       '@' ( 'a'..'z' | 'A'..'Z' )+
        ;

PREPROCESSOR
        options
	{
                testLiterals = true; 
	}
        :       '#' ( 'a'..'z' | 'A'..'Z' )+
        ;
