/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/comfyj/license.jsf
 */
import com.jniwrapper.win32.ole.OleFunctions;
import com.jniwrapper.win32.com.ComException;

public abstract class ComSample
{
    public final void execute()
    {
        init();

        int result = 0;
        try
        {
            doWork();
        }
        catch (ComException e)
        {
            e.printStackTrace();
            result = -1;
        }
        finally
        {
            shutdown();
        }

        System.exit(result);
    }

    private void init()
    {
        OleFunctions.oleInitialize();
    }

    private void shutdown()
    {
        OleFunctions.oleUninitialize();
    }

    protected abstract void doWork();
}


