/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.system.Kernel32;

public class Mutex
extends Handle {
    private static final FunctionName FUNCTION_CREATE_MUTEX = new FunctionName("CreateMutex");
    private static final FunctionName FUNCTION_OPEN_MUTEX = new FunctionName("OpenMutex");

    private Mutex() {
    }

    public boolean exists() {
        return !this.isNull();
    }

    public static Mutex openMutex(int desiredAccess, boolean inheritHandle, String mutexName) {
        Function openMutex = Kernel32.getInstance().getFunction(FUNCTION_OPEN_MUTEX.toString());
        Mutex mutexHandle = new Mutex();
        openMutex.invoke((Parameter)mutexHandle, (Parameter)new UInt32((long)desiredAccess), (Parameter)new Bool(inheritHandle), (Parameter)new Str(mutexName));
        return mutexHandle;
    }

    public static Mutex createMutex(Parameter mutexAttributes, boolean initialOwner, String mutexName) {
        Function createMutex = Kernel32.getInstance().getFunction(FUNCTION_CREATE_MUTEX.toString());
        Mutex mutexHandle = new Mutex();
        long result = createMutex.invoke((Parameter)mutexHandle, mutexAttributes, (Parameter)new Bool(initialOwner), (Parameter)new Str(mutexName));
        if (mutexHandle.isNull()) {
            throw new LastErrorException(result, "Mutex creation failed.", true);
        }
        return mutexHandle;
    }

    public static Mutex createMutex(boolean initialOwner, String mutexName) {
        return Mutex.createMutex((Parameter)new Handle(), initialOwner, mutexName);
    }
}

