/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.io;

import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class FileTime
extends Structure {
    private static final long MILLISECONDS_IN_SECOND = 1000L;
    private static final long MILLISECONDS_IN_MINUTE = 60000L;
    private static final long MILLISECONDS_IN_HOUR = 3600000L;
    private static final long MILLISECONDS_IN_DAY = 86400000L;
    private static long TIME_DIFFERENCE_IN_MILLISECONDS = 11644473600000L;
    private UInt32 _dwLowDateTime;
    private UInt32 _dwHighDateTime;

    private void init() {
        this.init(new Parameter[]{this._dwLowDateTime, this._dwHighDateTime});
    }

    public FileTime() {
        this._dwLowDateTime = new UInt32();
        this._dwHighDateTime = new UInt32();
        this.init();
    }

    public FileTime(long lowDateTime, long highDateTime) {
        this();
        this.setLowDateTime(lowDateTime);
        this.setHighDateTime(highDateTime);
    }

    public FileTime(FileTime that) {
        this._dwLowDateTime = (UInt32)that._dwLowDateTime.clone();
        this._dwHighDateTime = (UInt32)that._dwHighDateTime.clone();
        this.init();
    }

    public long getLowDateTime() {
        return this._dwLowDateTime.getValue();
    }

    public void setLowDateTime(long value) {
        this._dwLowDateTime.setValue(value);
    }

    public long getHighDateTime() {
        return this._dwHighDateTime.getValue();
    }

    public void setHighDateTime(long value) {
        this._dwHighDateTime.setValue(value);
    }

    public Date toDate() {
        long lowDateTime = this.getLowDateTime();
        long highDateTime = this.getHighDateTime();
        long numberOf100NanosecondIntervals = highDateTime << 32 | lowDateTime;
        long milliseconds = numberOf100NanosecondIntervals / 10000L;
        long days = milliseconds / 86400000L;
        long hours = (milliseconds -= days * 86400000L) / 3600000L;
        long minutes = (milliseconds -= hours * 3600000L) / 60000L;
        long seconds = (milliseconds -= minutes * 60000L) / 1000L;
        milliseconds -= seconds * 1000L;
        Calendar calendar = this.getGMTCalendar();
        calendar.set(1601, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        calendar.add(5, (int)days);
        calendar.add(11, (int)hours);
        calendar.add(12, (int)minutes);
        calendar.add(13, (int)seconds);
        calendar.add(14, (int)milliseconds);
        return calendar.getTime();
    }

    private Calendar getGMTCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }

    public void fromDate(Date date) {
        long milliseconds = date.getTime() + TIME_DIFFERENCE_IN_MILLISECONDS;
        long numberOf100NanosecondIntervals = milliseconds * 10000L;
        long highDateTime = numberOf100NanosecondIntervals >> 32;
        long lowDateTime = numberOf100NanosecondIntervals & 0xFFFFFFFFL;
        this.setHighDateTime(highDateTime);
        this.setLowDateTime(lowDateTime);
    }

    public Object clone() {
        return new FileTime(this);
    }
}

