/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.io;

import com.jniwrapper.util.FlagSet;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.io.FileSystemEvent;
import com.jniwrapper.win32.io.FileSystemEventListener;
import com.jniwrapper.win32.io.FileSystemException;
import com.jniwrapper.win32.io.WatcherStrategy;
import com.jniwrapper.win32.system.VersionInfo;
import java.io.FileFilter;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FileSystemWatcher {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$io$FileSystemWatcher == null ? (class$com$jniwrapper$win32$io$FileSystemWatcher = FileSystemWatcher.class$("com.jniwrapper.win32.io.FileSystemWatcher")) : class$com$jniwrapper$win32$io$FileSystemWatcher));
    private String _path;
    private FileFilter _fileFilter;
    private WatcherOptions _notifyOptions = new WatcherOptions();
    private boolean _watchSubree = false;
    private List _fileSystemListeners = new LinkedList();
    private WatcherStrategy _watcherStrategy;
    static /* synthetic */ Class class$com$jniwrapper$win32$io$FileSystemWatcher;
    static /* synthetic */ Class class$com$jniwrapper$win32$io$WinNTWatcherStrategy;
    static /* synthetic */ Class class$com$jniwrapper$win32$io$Win9xWatcherStrategy;
    static /* synthetic */ Class class$com$jniwrapper$win32$io$WatcherStrategy;

    public FileSystemWatcher(String path) {
        this._path = path;
        VersionInfo versionInfo = new VersionInfo();
        if (versionInfo.isNT()) {
            this.setStrategy(class$com$jniwrapper$win32$io$WinNTWatcherStrategy == null ? (class$com$jniwrapper$win32$io$WinNTWatcherStrategy = FileSystemWatcher.class$("com.jniwrapper.win32.io.WinNTWatcherStrategy")) : class$com$jniwrapper$win32$io$WinNTWatcherStrategy);
        } else {
            this.setStrategy(class$com$jniwrapper$win32$io$Win9xWatcherStrategy == null ? (class$com$jniwrapper$win32$io$Win9xWatcherStrategy = FileSystemWatcher.class$("com.jniwrapper.win32.io.Win9xWatcherStrategy")) : class$com$jniwrapper$win32$io$Win9xWatcherStrategy);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                if (FileSystemWatcher.this.isWatching()) {
                    try {
                        FileSystemWatcher.this.stop();
                    }
                    catch (FileSystemException e) {
                        LOG.error((Object)"", (Throwable)e);
                    }
                }
            }
        }, "FileSystemWatcher.stop"));
    }

    public FileSystemWatcher(String path, FileFilter fileFilter, boolean watchSubree) {
        this(path, watchSubree);
        this._fileFilter = fileFilter;
    }

    public FileSystemWatcher(String path, FileFilter fileFilter) {
        this(path);
        this._fileFilter = fileFilter;
    }

    public FileSystemWatcher(String path, boolean watchSubree) {
        this(path);
        this._watchSubree = watchSubree;
    }

    public void setStrategy(Class strategyClass) {
        if (strategyClass == null) {
            throw new NullPointerException();
        }
        if (this._watcherStrategy != null) {
            if (strategyClass.equals(this._watcherStrategy.getClass())) {
                return;
            }
            if (this._watcherStrategy.isWatching()) {
                throw new IllegalStateException("Unable to change stragetgy while watcher is running.");
            }
        }
        if (!(class$com$jniwrapper$win32$io$WatcherStrategy == null ? (class$com$jniwrapper$win32$io$WatcherStrategy = FileSystemWatcher.class$("com.jniwrapper.win32.io.WatcherStrategy")) : class$com$jniwrapper$win32$io$WatcherStrategy).isAssignableFrom(strategyClass)) {
            throw new IllegalArgumentException("Stategy class must be derived from WatcherStrategy class.");
        }
        this._watcherStrategy = this.createStrategy(strategyClass);
    }

    protected WatcherStrategy createStrategy(Class strategyClass) {
        WatcherStrategy result = null;
        try {
            Constructor constructor = strategyClass.getConstructor(class$com$jniwrapper$win32$io$FileSystemWatcher == null ? (class$com$jniwrapper$win32$io$FileSystemWatcher = FileSystemWatcher.class$("com.jniwrapper.win32.io.FileSystemWatcher")) : class$com$jniwrapper$win32$io$FileSystemWatcher);
            result = (WatcherStrategy)constructor.newInstance(this);
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
        return result;
    }

    public String getPath() {
        return this._path;
    }

    public FileFilter getFileFilter() {
        return this._fileFilter;
    }

    public boolean isWatchSubree() {
        return this._watchSubree;
    }

    public WatcherOptions getOptions() {
        return this._notifyOptions;
    }

    public void addFileSystemListener(FileSystemEventListener listener) {
        if (!this._fileSystemListeners.contains(listener)) {
            this._fileSystemListeners.add(listener);
        }
    }

    public void removeFileSystemListener(FileSystemEventListener listener) {
        this._fileSystemListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFileSystemEvent(FileSystemEvent event) {
        LinkedList listeners = null;
        FileSystemWatcher fileSystemWatcher = this;
        synchronized (fileSystemWatcher) {
            listeners = new LinkedList(this._fileSystemListeners);
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                FileSystemEventListener listener = (FileSystemEventListener)i.next();
                listener.handle(event);
            }
        }
    }

    public void start() throws FileSystemException {
        this._watcherStrategy.start();
    }

    public void stop() throws FileSystemException {
        this._watcherStrategy.stop();
    }

    public boolean isWatching() {
        return this._watcherStrategy.isWatching();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class WatcherOptions
    extends FlagSet {
        public static final int NOTIFY_CHANGE_FILE_NAME = 1;
        public static final int NOTIFY_CHANGE_DIR_NAME = 2;
        public static final int NOTIFY_CHANGE_ATTRIBUTES = 4;
        public static final int NOTIFY_CHANGE_SIZE = 8;
        public static final int NOTIFY_CHANGE_LAST_WRITE = 16;
        public static final int NOTIFY_CHANGE_LAST_ACCESS = 32;
        public static final int NOTIFY_CHANGE_CREATION = 64;
        public static final int NOTIFY_CHANGE_SECURITY = 256;

        public WatcherOptions() {
            this.reset();
        }

        public void reset() {
            this.clear();
            this.add(31L);
        }

        public boolean isNotifyChangeFileName() {
            return this.contains(1L);
        }

        public void setNotifyChangeFileName(boolean value) {
            this.setupFlag(1L, value);
        }

        public boolean isNotifyChangeDirName() {
            return this.contains(2L);
        }

        public void setNotifyChangeDirName(boolean value) {
            this.setupFlag(2L, value);
        }

        public boolean isNotifyChangeAttributes() {
            return this.contains(4L);
        }

        public void setNotifyChangeAttributes(boolean value) {
            this.setupFlag(4L, value);
        }

        public boolean isNotifyChangeSize() {
            return this.contains(8L);
        }

        public void setNotifyChangeSize(boolean value) {
            this.setupFlag(8L, value);
        }

        public boolean isNotifyLastModified() {
            return this.contains(16L);
        }

        public void setNotifyLastModified(boolean value) {
            this.setupFlag(16L, value);
        }

        public boolean isNotifyLastAccess() {
            return this.contains(32L);
        }

        public void setNotifyLastAccess(boolean value) {
            this.setupFlag(32L, value);
        }
    }
}

