/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.dde;

public class DdeException
extends Exception {
    public static final int NO_ERROR = 0;
    public static final int ADVACKTIMEOUT = 16384;
    public static final int BUSY = 16385;
    public static final int DATAACKTIMEOUT = 16386;
    public static final int DLL_NOT_INITIALIZED = 16387;
    public static final int DLL_USAGE = 16388;
    public static final int EXECACKTIMEOUT = 16389;
    public static final int INVALIDPARAMETER = 16390;
    public static final int LOW_MEMORY = 16391;
    public static final int MEMORY_ERROR = 16392;
    public static final int NOTPROCESSED = 16393;
    public static final int NO_CONV_ESTABLISHED = 16394;
    public static final int POKEACKTIMEOUT = 16395;
    public static final int POSTMSG_FAILED = 16396;
    public static final int REENTRANCY = 16397;
    public static final int SERVER_DIED = 16398;
    public static final int SYS_ERROR = 16399;
    public static final int UNADVACKTIMEOUT = 16400;
    public static final int UNFOUND_QUEUE_ID = 16401;
    private int _errorCode;

    public DdeException(int errorCode) {
        super(DdeException.getMessage(errorCode));
        this._errorCode = errorCode;
    }

    public DdeException(String message) {
        super(message);
        this._errorCode = -1;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    private static String getMessage(int errorcode) {
        String message = null;
        switch (errorcode) {
            case 0: {
                message = "No errors.";
                break;
            }
            case 16384: {
                message = "A request for a synchronous advise transaction has timed out.";
                break;
            }
            case 16385: {
                message = "The response to the transaction caused the DDE_FBUSY flag to be set.";
                break;
            }
            case 16386: {
                message = "A request for a synchronous data transaction has timed out.";
                break;
            }
            case 16387: {
                message = "A DDEML function was called without first calling the DdeInitialize function.";
                break;
            }
            case 16388: {
                message = "An application has attempted to perform illegal transaction.";
                break;
            }
            case 16389: {
                message = "A request for a synchronous execute transaction has timed out.";
                break;
            }
            case 16390: {
                message = "A parameter failed to be validated by the DDEML.";
                break;
            }
            case 16391: {
                message = "Low memory.";
                break;
            }
            case 16392: {
                message = "A memory allocation has failed.";
                break;
            }
            case 16393: {
                message = "A transaction has failed.";
                break;
            }
            case 16394: {
                message = "A client's attempt to establish a conversation has failed.";
                break;
            }
            case 16395: {
                message = "A request for a synchronous poke transaction has timed out.";
                break;
            }
            case 16396: {
                message = "An internal call to the PostMessage function has failed.";
                break;
            }
            case 16397: {
                message = "A synchronous transaction already in progress.";
                break;
            }
            case 16398: {
                message = "A server-side transaction was attempted on a conversation terminated by the client.";
                break;
            }
            case 16399: {
                message = "An internal error has occurred in the DDEML.";
                break;
            }
            case 16400: {
                message = "A request to end an advise transaction has timed out.";
                break;
            }
            case 16401: {
                message = "An invalid transaction identifier was passed to a DDEML function.";
            }
        }
        return message;
    }
}

