/*
 * Decompiled with CFR 0.152.
 */
package comfyj.generator.eclipseplugin.utility;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ResourcesUtility {
    private static final String COMFYJ_TITLE = "ComfyJ";
    private static final double COMFYJ_VERSION = 2.2;

    public static void createFileList(IResource file, List fileList) {
        if (file instanceof IContainer) {
            IResource[] children = null;
            try {
                children = ((IContainer)file).members();
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int i = 0; i < children.length; ++i) {
                IResource child = children[i];
                if (!(child instanceof IContainer)) {
                    fileList.add(child);
                    continue;
                }
                ResourcesUtility.createFileList(child, fileList);
            }
        }
    }

    public static String findJars(String comfyJPath) {
        String jarString = "\"";
        File libFolder = new File(comfyJPath + "/lib/");
        if (libFolder.exists() && libFolder.isDirectory()) {
            File[] jars = libFolder.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".jar");
                }
            });
            for (int i = 0; i < jars.length; ++i) {
                jarString = jarString + jars[i].getAbsolutePath();
                if (i + 1 >= jars.length) continue;
                jarString = jarString + ";";
            }
            jarString = jarString + "\"";
        }
        return jarString;
    }

    public static boolean isJavaProject(IProject project) throws CoreException {
        String[] natureIds = project.getDescription().getNatureIds();
        for (int i = 0; i < natureIds.length; ++i) {
            if (!"org.eclipse.jdt.core.javanature".equals(natureIds[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean checkComfyJVersion(String path) {
        File comfyJDirectory = new File(path + "/lib");
        if (comfyJDirectory.exists() && comfyJDirectory.isDirectory()) {
            File[] files = comfyJDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Manifest manifest;
                try {
                    JarFile jarFile = new JarFile(files[i]);
                    manifest = jarFile.getManifest();
                }
                catch (IOException e) {
                    continue;
                }
                Attributes mainAttributes = manifest.getMainAttributes();
                String version = mainAttributes.getValue("Version");
                String title = mainAttributes.getValue("Title");
                if (version == null || !(Double.parseDouble(version) >= 2.2) || title == null || !title.equalsIgnoreCase(COMFYJ_TITLE)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkComfyJLocation(String path) {
        File comfyJDirectory = new File(path + "/lib");
        if (comfyJDirectory.exists() && comfyJDirectory.isDirectory()) {
            File[] files = comfyJDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Manifest manifest;
                try {
                    JarFile jarFile = new JarFile(files[i]);
                    manifest = jarFile.getManifest();
                }
                catch (IOException e) {
                    continue;
                }
                Attributes mainAttributes = manifest.getMainAttributes();
                String title = mainAttributes.getValue("Title");
                if (title == null || !title.equalsIgnoreCase(COMFYJ_TITLE)) continue;
                return true;
            }
        }
        return false;
    }
}

