/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo.operations;

import com.jniwrapper.win32.automation.FileOperationsHandler;
import com.jniwrapper.win32.automation.OleContainer;
import com.jniwrapper.win32.ui.dialogs.OpenSaveFileDialog;
import java.awt.Container;
import java.awt.Window;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class OfficeFileOperationsHandler
implements FileOperationsHandler {
    public static final int TYPE_EXCEL = 1;
    public static final int TYPE_WORD = 2;
    public static final int TYPE_POWERPOINT = 3;
    private static Map _filters = new HashMap();
    private static Map _extensions = new HashMap();
    private OleContainer _container;
    private Integer _documentType = new Integer(1);
    private static final String MSG_INCORRECT_TYPE = "Incorrect type of document: type should be equals to TYPE_EXCEL, TYPE_WORD or TYPE_POWERPOINT";

    public OfficeFileOperationsHandler(int documentType) {
        this.checkType(documentType);
        this._documentType = new Integer(documentType);
    }

    private void checkType(int type) {
        if (type != 1 && type != 2 && type != 3) {
            throw new RuntimeException(MSG_INCORRECT_TYPE);
        }
    }

    public void setContainer(OleContainer container) {
        this._container = container;
    }

    public File getOpenFile() {
        OpenSaveFileDialog dialog = new OpenSaveFileDialog(this.getParentWindow());
        dialog.setFilter(this.getFilter());
        if (dialog.getOpenFileName()) {
            return new File(dialog.getFileName());
        }
        return null;
    }

    public File getSaveFile() {
        OpenSaveFileDialog dialog = new OpenSaveFileDialog(this.getParentWindow());
        dialog.setFilter(this.getFilter());
        dialog.setDefaultExt(this.getExtension());
        if (dialog.getSaveFileName()) {
            return new File(dialog.getFileName());
        }
        return null;
    }

    public void newDocumentCreated() {
    }

    public void documentOpened(File file) {
    }

    public void documentSaved(File file) {
    }

    private String getExtension() {
        return (String)_extensions.get(this._documentType);
    }

    private String getFilter() {
        return (String)_filters.get(this._documentType);
    }

    private Window getParentWindow() {
        Container parent;
        for (parent = this._container.getParent(); parent != null && !(parent instanceof Window); parent = parent.getParent()) {
        }
        return (Window)parent;
    }

    static {
        _filters.put(new Integer(1), "Excel File | *.xls");
        _filters.put(new Integer(2), "Word Document | *.doc");
        _filters.put(new Integer(3), "PowerPoint Presentation | *.ppt");
        _extensions.put(new Integer(1), "xls");
        _extensions.put(new Integer(2), "doc");
        _extensions.put(new Integer(3), "ppt");
    }
}

