/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.automation.Automation;
import com.jniwrapper.win32.automation.OleContainer;
import com.jniwrapper.win32.automation.types.Variant;
import com.jniwrapper.win32.com.ComException;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.com.types.CLSID;
import com.jniwrapper.win32.samples.demo.OleContainerInfoBean;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class PDFContainer
extends OleContainerInfoBean {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$samples$demo$PDFContainer == null ? (class$com$jniwrapper$win32$samples$demo$PDFContainer = PDFContainer.class$("com.jniwrapper.win32.samples.demo.PDFContainer")) : class$com$jniwrapper$win32$samples$demo$PDFContainer));
    private static final String AcrobatProgID = "PDF.PdfCtrl.5";
    private static final String Acrobat7ProgID = "AcroPDF.PDF";
    private static String _progID;
    private JCheckBox cbShowToolbar;
    private JCheckBox cbShowScrollBars;
    static /* synthetic */ Class class$com$jniwrapper$win32$samples$demo$PDFContainer;
    static /* synthetic */ Class class$com$jniwrapper$win32$samples$demo$ExcelContainer;

    public PDFContainer() {
        super(_progID, "PDF Files (*.pdf)|*.pdf", "This page demonstrates OLE Container with PDF ActiveX control.", "pdf");
    }

    public void loadFile(String fileName) {
        OleContainer container = this.getContainer();
        Automation automation = new Automation((IUnknown)container.getOleObject());
        automation.setProperty("src", (Object)fileName);
        if (_progID.equals(Acrobat7ProgID)) {
            automation.invoke("LoadFile", new Object[]{fileName});
        }
        this.cbShowScrollBars.setSelected(true);
        this.cbShowScrollBars.setEnabled(true);
        this.cbShowToolbar.setSelected(true);
        this.cbShowToolbar.setEnabled(true);
    }

    public JPanel createFileInfoPanel() {
        JPanel acrobatCustomization = new JPanel(new GridBagLayout());
        acrobatCustomization.setBorder(BorderFactory.createTitledBorder("Acrobar Reader Customization"));
        acrobatCustomization.setPreferredSize(new Dimension(100, 75));
        final Automation acrobat = new Automation((IUnknown)this.getContainer().getOleObject());
        this.cbShowToolbar = new JCheckBox("Display Toolbar", true);
        this.cbShowToolbar.setEnabled(false);
        this.cbShowToolbar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                acrobat.invoke("setShowToolbar", new Variant[]{new Variant(PDFContainer.this.cbShowToolbar.isSelected())});
            }
        });
        this.cbShowScrollBars = new JCheckBox("Display Scrollbars", true);
        this.cbShowScrollBars.setEnabled(false);
        this.cbShowScrollBars.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                acrobat.invoke("setShowScrollbars", new Variant[]{new Variant(PDFContainer.this.cbShowScrollBars.isSelected())});
            }
        });
        acrobatCustomization.add((Component)this.cbShowToolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 10), 0, 0));
        acrobatCustomization.add((Component)this.cbShowScrollBars, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        acrobatCustomization.add((Component)new Panel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return acrobatCustomization;
    }

    public ImageIcon getIcon() {
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(ImageIO.read((class$com$jniwrapper$win32$samples$demo$ExcelContainer == null ? (class$com$jniwrapper$win32$samples$demo$ExcelContainer = PDFContainer.class$("com.jniwrapper.win32.samples.demo.ExcelContainer")) : class$com$jniwrapper$win32$samples$demo$ExcelContainer).getResourceAsStream("res/acrobat.png")));
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
        return icon;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            CLSID.createFromProgID((String)Acrobat7ProgID);
            _progID = Acrobat7ProgID;
        }
        catch (ComException e) {
            if (e.getHResult() == -2147221005) {
                _progID = AcrobatProgID;
            }
            throw e;
        }
    }
}

