/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.win32.automation.Automation;
import com.jniwrapper.win32.automation.OleContainer;
import com.jniwrapper.win32.com.ComException;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.com.types.CLSID;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DVDPlayerContainer
extends LazyPanel {
    private OleContainer _container;
    private JLabel lblAdvisoryText;
    private JButton btnPlay;
    private JButton btnPause;
    private JButton btnStop;
    private JButton btnEject;
    private JLabel lblNotInstalled;
    private boolean _activated = false;
    private Automation _dvdPlayer;
    private boolean _installed;

    public DVDPlayerContainer(Window parent) {
        super(parent);
        parent.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (DVDPlayerContainer.this._activated) {
                    DVDPlayerContainer.this._container.destroyObject();
                }
            }
        });
        try {
            CLSID.createFromProgID((String)"MSWebDVD.MSWebDVD");
            this._installed = true;
        }
        catch (ComException e) {
            if (e.getHResult() == -2147221005) {
                this._installed = false;
            }
            throw e;
        }
    }

    public void initialize() throws Exception {
        this.lblAdvisoryText = new HTMLText("This page demonstrates the MS DVD ActiveX component embedded into OleContainer.");
        this._container = new OleContainer();
        this._container.createObject("MSWebDVD.MSWebDVD");
        this._dvdPlayer = new Automation((IUnknown)this._container.getOleObject());
        this.setLayout(new GridBagLayout());
        JPanel navigation = new JPanel();
        navigation.setBorder(BorderFactory.createTitledBorder("Navigation Bar"));
        this.btnPlay = new JButton(new AbstractAction("Play"){

            public void actionPerformed(ActionEvent e) {
                try {
                    DVDPlayerContainer.this._dvdPlayer.invoke("Play");
                }
                catch (ComException ex) {
                    DVDPlayerContainer.this.displayErrorMessage();
                }
            }
        });
        this.btnPause = new JButton(new AbstractAction("Pause"){

            public void actionPerformed(ActionEvent e) {
                try {
                    DVDPlayerContainer.this._dvdPlayer.invoke("Pause");
                }
                catch (ComException ex) {
                    DVDPlayerContainer.this.displayErrorMessage();
                }
            }
        });
        this.btnStop = new JButton(new AbstractAction("Stop"){

            public void actionPerformed(ActionEvent e) {
                try {
                    DVDPlayerContainer.this._dvdPlayer.invoke("Stop");
                }
                catch (ComException ex) {
                    DVDPlayerContainer.this.displayErrorMessage();
                }
            }
        });
        this.btnEject = new JButton(new AbstractAction("Eject"){

            public void actionPerformed(ActionEvent e) {
                try {
                    DVDPlayerContainer.this._dvdPlayer.invoke("Eject");
                }
                catch (ComException ex) {
                    DVDPlayerContainer.this.displayErrorMessage();
                }
            }
        });
        navigation.add(this.btnPlay);
        navigation.add(this.btnPause);
        navigation.add(this.btnStop);
        navigation.add(this.btnEject);
        this.lblNotInstalled = new HTMLText("<b><FONT color = red>ERROR:</FONT> Unable to initialize the sample, because the necessary ActiveX control is not installed.");
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        if (this._installed) {
            this.add((Component)this._container, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.add((Component)navigation, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 10, 10), 0, 0));
        } else {
            this.add((Component)this.lblNotInstalled, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
            this.add((Component)new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
        }
        super.initialize();
    }

    private void displayErrorMessage() {
        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), "MS DVD: Unable to process the command.");
    }

    public void activate() throws Exception {
        super.activate();
        if (!this._activated) {
            this._container.doVerb(-5);
            this._activated = true;
        }
    }
}

