/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.com.generator.ideaplugin.util;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.jniwrapper.win32.com.generator.ideaplugin.util.ApplicationManager;
import com.jniwrapper.win32.com.generator.ideaplugin.util.ProcessManager;
import com.jniwrapper.win32.com.generator.ideaplugin.util.ProgressManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class VersionManager {
    private static VersionManager INSTANCE = new VersionManager();
    private static final int BUILD_NUMBER = 5581;

    public static VersionManager getInstance() {
        return INSTANCE;
    }

    private VersionManager() {
    }

    public ProcessManager getProcessManager() {
        if (this.getBuidNumber() >= 5581) {
            return ProgressManager.getInstance();
        }
        return ApplicationManager.getInstance();
    }

    public ModulesProvider createModulesProvider(Project project) {
        if (this.getBuidNumber() >= 5581) {
            Object rootConfigurable = this.getProjectRootConfigurable(project);
            return this.getModulesConfigurator(project, rootConfigurable);
        }
        return this.getModulesConfigurator(project);
    }

    private ModulesConfigurator getModulesConfigurator(Project project) {
        try {
            Class<?> modulesConfigurator = Class.forName("com.intellij.openapi.roots.ui.configuration.ModulesConfigurator");
            Constructor<?> constructor = modulesConfigurator.getConstructor(Project.class);
            return (ModulesConfigurator)constructor.newInstance(project);
        }
        catch (Exception e) {
            return null;
        }
    }

    private ModulesConfigurator getModulesConfigurator(Project project, Object rootConfigurable) {
        if (rootConfigurable == null) {
            return null;
        }
        try {
            Class<?> modulesConfigurator = Class.forName("com.intellij.openapi.roots.ui.configuration.ModulesConfigurator");
            Constructor<?> constructor = modulesConfigurator.getConstructor(Project.class, rootConfigurable.getClass());
            return (ModulesConfigurator)constructor.newInstance(project, rootConfigurable);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object getProjectRootConfigurable(Project project) {
        try {
            Class<?> projectRootConfigurable = Class.forName("com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectRootConfigurable");
            Method method = projectRootConfigurable.getMethod("getInstance", Project.class);
            return method.invoke(null, project);
        }
        catch (Exception e) {
            return null;
        }
    }

    private int getBuidNumber() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        String buildNumber = applicationInfo.getBuildNumber();
        return Integer.valueOf(buildNumber);
    }
}

