/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.com.generator.ideaplugin.ui;

import com.intellij.ide.util.projectWizard.ProjectJdkListRenderer;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;

public class ProjectJDKComboBox
extends JComboBox {
    public ProjectJDKComboBox() {
        super(new JdkComboBoxModel());
        Dimension dimension = new Dimension();
        dimension.height = 21;
        this.setPreferredSize(dimension);
        this.setRenderer(new ProjectJdkListRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (ProjectJDKComboBox.this.isEnabled()) {
                    super.customizeCellRenderer(list, (Object)((JdkComboBoxElement)value).getProjectJDK(), index, isSelected, cellHasFocus);
                }
            }
        });
    }

    public void update(ProjectJdk projectJDK) {
        if (this.isEnabled()) {
            int index;
            ProjectJdk selectedJDK;
            this.setModel(new JdkComboBoxModel());
            ProjectJdk projectJdk = selectedJDK = projectJDK == null ? this.getSelectedJDK() : projectJDK;
            if (selectedJDK != null && (index = this.getProjectJDKIndex(selectedJDK)) >= 0) {
                this.setSelectedIndex(index);
            }
        } else {
            this.removeAllItems();
            Container parent = this.getParent();
            if (parent != null) {
                parent.validate();
            }
        }
    }

    private int getProjectJDKIndex(ProjectJdk selectedJDK) {
        JdkComboBoxModel model = (JdkComboBoxModel)this.getModel();
        int modelSize = model.getSize();
        for (int i = 0; i < modelSize; ++i) {
            ProjectJdk projectJDK = ((JdkComboBoxElement)model.getElementAt(i)).getProjectJDK();
            if (projectJDK == null || !selectedJDK.equals(projectJDK)) continue;
            return i;
        }
        return -1;
    }

    public ProjectJdk getSelectedJDK() {
        JdkComboBoxElement projectJDK = (JdkComboBoxElement)this.getSelectedItem();
        return projectJDK == null ? null : projectJDK.getProjectJDK();
    }

    public Object getSelectedItem() {
        return super.getSelectedItem();
    }

    private static class NoneJdkComboBoxElement
    extends JdkComboBoxElement {
        public NoneJdkComboBoxElement() {
            super(null);
        }

        public String toString() {
            return "<None>";
        }
    }

    private static class JdkComboBoxElement {
        private final ProjectJdk _projectJDK;

        public JdkComboBoxElement(ProjectJdk projectJDK) {
            this._projectJDK = projectJDK;
        }

        public ProjectJdk getProjectJDK() {
            return this._projectJDK;
        }

        public String toString() {
            return this._projectJDK.getName();
        }
    }

    private static class JdkComboBoxModel
    extends DefaultComboBoxModel {
        public Object getElementAt(int i) {
            return super.getElementAt(i);
        }

        public JdkComboBoxModel() {
            this.addElement(new NoneJdkComboBoxElement());
            ProjectJdk[] projectJDKs = ProjectJdkTable.getInstance().getAllJdks();
            for (int i = 0; i < projectJDKs.length; ++i) {
                this.addElement(new JdkComboBoxElement(projectJDKs[i]));
            }
        }
    }
}

