/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.com.generator.ideaplugin.ation;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.jniwrapper.win32.com.generator.ideaplugin.ui.ModeSelectionDialog;
import com.jniwrapper.win32.com.generator.ideaplugin.util.FileUtils;
import com.jniwrapper.win32.com.generator.ideaplugin.util.GeneratorPreferences;
import com.jniwrapper.win32.com.generator.ideaplugin.util.VersionManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class ComfyJGeneratorAction
extends AnAction {
    private Map _oldFiles = new LinkedHashMap();

    public void update(AnActionEvent event) {
        Project project = (Project)event.getDataContext().getData("project");
        event.getPresentation().setEnabled(project != null);
    }

    public void actionPerformed(AnActionEvent event) {
        final Project project = (Project)event.getDataContext().getData("project");
        GeneratorPreferences preferences = GeneratorPreferences.getInstance();
        ProjectJdk selectedJDK = preferences.getSelectedJDK();
        if (selectedJDK == null) {
            Messages.showErrorDialog((Project)project, (String)"Unable to start the Code Generator for ComfyJ.\nMake sure the selected JDK is specified correctly in plugin settings.", (String)"Execution error");
            return;
        }
        final ModeSelectionDialog dialog = new ModeSelectionDialog(project);
        dialog.show();
        if (dialog.isOK()) {
            final SourceFolder sourceFolder = dialog.getSourceFolder();
            preferences.setSourceFolder(sourceFolder);
            String selectedJDKPath = selectedJDK.getHomeDirectory().getPath();
            final String comfyJPath = preferences.getComfyJPath();
            String jars = "\"";
            File[] jarFiles = FileUtils.getInstance().findJars(comfyJPath);
            for (int i = 0; i < jarFiles.length; ++i) {
                File jarFile = jarFiles[i];
                jars = jars + jarFile.getAbsolutePath();
                if (i + 1 >= jarFiles.length) continue;
                jars = jars + ";";
            }
            jars = jars + ";" + selectedJDKPath + "\\lib\\tools.jar";
            jars = jars + "\"";
            String options = "";
            if (dialog.isPackToJar()) {
                options = options + " -jar \"" + dialog.getJarLocation() + "\"";
            } else {
                VirtualFile file = sourceFolder.getFile();
                if (file != null) {
                    options = options + " -path \"" + file.getPath() + "\"";
                }
            }
            if (dialog.isGenerateJavaDocs()) {
                options = options + " -javadoc \"" + dialog.getJavaDocsPath() + "\"";
            }
            final String cmd = MessageFormat.format("{0}/bin/java.exe -cp {1} com.jniwrapper.win32.com.generator.Application " + options + " -plugin", selectedJDKPath, jars);
            new Thread(new Runnable(){

                public void run() {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                Process process = Runtime.getRuntime().exec(cmd, null, new File(comfyJPath + "/bin"));
                                InputStream is = process.getInputStream();
                                is.close();
                                InputStream err = process.getErrorStream();
                                BufferedReader errorReader = new BufferedReader(new InputStreamReader(err));
                                try {
                                    String line;
                                    String output = "";
                                    while ((line = errorReader.readLine()) != null) {
                                        output = output + line + "\n";
                                    }
                                    if (output.contains("java.lang.ExceptionInInitializerError")) {
                                        Messages.showErrorDialog((Project)project, (String)"Unable to start the Code Generator for ComfyJ.\nMake sure the JNIWrapper and ComfyJ license \nfiles are located in the ComfyJ folder.", (String)"Execution error");
                                    }
                                }
                                finally {
                                    is.close();
                                    err.close();
                                    errorReader.close();
                                }
                                process.waitFor();
                            }
                            catch (Exception e) {
                                Messages.showErrorDialog((Project)project, (String)"Unable to start the Code Generator for ComfyJ.\nMake sure the path to the ComfyJ folder is specified correctly in plugin settings.", (String)"Execution error");
                                return;
                            }
                            if (dialog.isPackToJar()) {
                                ComfyJGeneratorAction.this.attachJar(project, dialog.getJarLocation());
                            } else {
                                ComfyJGeneratorAction.this.reformatCode(sourceFolder.getFile(), project);
                            }
                        }
                    });
                }
            }).start();
        }
    }

    private void attachJar(Project project, String jarLocation) {
        LibraryTable libTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
        Library newLibrary = libTable.createLibrary("ComLib");
        String url = VirtualFileManager.constructUrl((String)"jar", (String)(jarLocation + "!/"));
        VirtualFile jarVirtualFile = VirtualFileManager.getInstance().findFileByUrl(url);
        Library.ModifiableModel libraryModel = newLibrary.getModifiableModel();
        libraryModel.addRoot(jarVirtualFile, OrderRootType.CLASSES);
        libraryModel.commit();
    }

    private void reformatCode(final VirtualFile file, final Project project) {
        this._oldFiles.clear();
        LinkedList files = new LinkedList();
        FileUtils.getInstance().createFileList(file, files);
        for (int i = 0; i < files.size(); ++i) {
            VirtualFile virtualFile = (VirtualFile)files.get(i);
            long modificationStamp = virtualFile.getModificationStamp();
            this._oldFiles.put(virtualFile.getPath(), modificationStamp);
        }
        VersionManager versionManager = VersionManager.getInstance();
        versionManager.getProcessManager().runProcessWithProgressSynchronously(new Runnable(){

            public void run() {
                file.refresh(true, true, (Runnable)new ReformatCodeRunnable(project, file));
            }
        }, "", false, project);
    }

    private class ReformatCodeRunnable
    implements Runnable {
        private Project _project;
        private VirtualFile _file;

        public ReformatCodeRunnable(Project project, VirtualFile file) {
            this._project = project;
            this._file = file;
        }

        public void run() {
            final LinkedList<VirtualFile> filesForReformat = new LinkedList<VirtualFile>();
            LinkedList files = new LinkedList();
            FileUtils.getInstance().createFileList(this._file, files);
            for (int i = 0; i < files.size(); ++i) {
                VirtualFile virtualFile = (VirtualFile)files.get(i);
                Long aLong = (Long)ComfyJGeneratorAction.this._oldFiles.get(virtualFile.getPath());
                if (aLong != null && aLong.longValue() == virtualFile.getModificationStamp()) continue;
                filesForReformat.add(virtualFile);
            }
            if (filesForReformat.isEmpty()) {
                return;
            }
            VersionManager versionManager = VersionManager.getInstance();
            versionManager.getProcessManager().runProcessWithProgressSynchronously(new Runnable(){

                public void run() {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    indicator.setText("Reformat code. Please wait...");
                    PsiManager psiManager = PsiManager.getInstance((Project)ReformatCodeRunnable.this._project);
                    int totalSize = filesForReformat.size();
                    for (int i = 0; i < totalSize; ++i) {
                        VirtualFile virtualFile = (VirtualFile)filesForReformat.get(i);
                        final PsiFile psiFile = psiManager.findFile(virtualFile);
                        if (psiFile == null) continue;
                        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                            public void run() {
                                CommandProcessor.getInstance().executeCommand(ReformatCodeRunnable.this._project, new Runnable(){

                                    public void run() {
                                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                            public void run() {
                                                try {
                                                    CodeStyleManager.getInstance((Project)ReformatCodeRunnable.this._project).reformatText(psiFile, 0, psiFile.getTextRange().getEndOffset());
                                                }
                                                catch (IncorrectOperationException e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        });
                                    }
                                }, null, null);
                            }
                        }, ModalityState.defaultModalityState());
                        VirtualFile currentVirtualFile = psiFile.getVirtualFile();
                        if (currentVirtualFile == null) continue;
                        indicator.setText2("File: " + currentVirtualFile.getPath());
                        indicator.setFraction((double)(i + 1) / (double)totalSize);
                    }
                    ReformatCodeRunnable.this._file.refresh(true, true);
                }
            }, "Reformat Code", false, this._project);
        }
    }
}

