/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.windows;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import edu.stanford.ejalbert.launching.windows.WindowsBrowser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.sf.wraplog.AbstractLogger;

public class WindowsBrowserLaunching
implements IBrowserLaunching {
    private static final String CONFIGFILE_WINDOWS = "/edu/stanford/ejalbert/launching/windows/windowsConfig.properties";
    public static final String WINKEY_WIN2000 = "windows.win2000";
    public static final String WINKEY_WIN9X = "windows.win9x";
    public static final String WINKEY_WINNT = "windows.winNT";
    private static final String[] WIN_KEYS = new String[]{"windows.win2000", "windows.win9x", "windows.winNT"};
    protected final AbstractLogger logger;
    private Map browserNameAndExeMap = null;
    private List browsersToCheck = new ArrayList();
    private String commandsDefaultBrowser;
    private String commandsTargettedBrowser;
    private final String windowsKey;
    private boolean forceNewWindow = false;
    private static final int REGEDIT_TYPE_APPPATHS = 0;
    private static String[] regeditQueries;
    static /* synthetic */ Class class$edu$stanford$ejalbert$launching$windows$WindowsBrowserLaunching;

    public WindowsBrowserLaunching(AbstractLogger logger, String windowsKey) {
        if (windowsKey == null) {
            throw new IllegalArgumentException("windowsKey cannot be null");
        }
        if (Arrays.binarySearch(WIN_KEYS, windowsKey) < 0) {
            throw new IllegalArgumentException(windowsKey + " is invalid");
        }
        this.logger = logger;
        this.windowsKey = windowsKey;
        logger.info(windowsKey);
    }

    private String getArrayAsString(String[] array) {
        return Arrays.asList(array).toString();
    }

    private String getProtocol(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        return url.getProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getBrowserMap() {
        Class clazz = class$edu$stanford$ejalbert$launching$windows$WindowsBrowserLaunching == null ? (class$edu$stanford$ejalbert$launching$windows$WindowsBrowserLaunching = WindowsBrowserLaunching.class$("edu.stanford.ejalbert.launching.windows.WindowsBrowserLaunching")) : class$edu$stanford$ejalbert$launching$windows$WindowsBrowserLaunching;
        synchronized (clazz) {
            if (this.browserNameAndExeMap == null) {
                this.browserNameAndExeMap = this.getAvailableBrowsers(this.browsersToCheck);
            }
        }
        return this.browserNameAndExeMap;
    }

    private void processFilePathsForBrowsers(String iePath, Map browsersAvailable, List tmpBrowsersToCheck) {
        this.logger.debug("checking for browsers in program files path");
        File exePath = new File(iePath);
        File progFilesPath = exePath.getParentFile();
        this.logger.debug("program files path: " + progFilesPath.getPath());
        File[] subDirs = progFilesPath.listFiles(new DirFileFilter());
        int subDirsCnt = subDirs != null ? subDirs.length : 0;
        Iterator iter = tmpBrowsersToCheck.iterator();
        HashMap<String, WindowsBrowser> dirNameToBrowser = new HashMap<String, WindowsBrowser>();
        while (iter.hasNext()) {
            WindowsBrowser wBrowser = (WindowsBrowser)iter.next();
            dirNameToBrowser.put(wBrowser.getSubDirName(), wBrowser);
        }
        for (int idx = 0; idx < subDirsCnt && !tmpBrowsersToCheck.isEmpty(); ++idx) {
            if (!dirNameToBrowser.containsKey(subDirs[idx].getName())) continue;
            WindowsBrowser wBrowser = (WindowsBrowser)dirNameToBrowser.get(subDirs[idx].getName());
            this.logger.debug("Adding browser " + wBrowser.getBrowserDisplayName() + " to available list.");
            wBrowser.setPathToExe(subDirs[idx].getPath());
            this.logger.debug(wBrowser.getPathToExe());
            browsersAvailable.put(wBrowser.getBrowserDisplayName(), wBrowser);
            browsersAvailable.put(wBrowser.getBrowserApplicationName(), wBrowser);
            tmpBrowsersToCheck.remove(wBrowser);
        }
    }

    private void processFileForBrowsers(File tmpFile, Map browsersAvailable, List tmpBrowsersToCheck, int regeditType) throws FileNotFoundException, IOException {
        String line;
        FileInputStream fis = new FileInputStream(tmpFile);
        byte[] magic = new byte[2];
        fis.read(magic);
        fis.close();
        InputStreamReader in = null;
        in = magic[0] == -1 && magic[1] == -2 ? new InputStreamReader((InputStream)new FileInputStream(tmpFile), "UTF-16") : new InputStreamReader(new FileInputStream(tmpFile));
        BufferedReader reader = new BufferedReader(in);
        HashMap<String, WindowsBrowser> exeNamesToBrowsers = new HashMap<String, WindowsBrowser>();
        Iterator iter = tmpBrowsersToCheck.iterator();
        while (iter.hasNext()) {
            WindowsBrowser winBrowser = (WindowsBrowser)iter.next();
            String exeName = winBrowser.getBrowserApplicationName().toLowerCase() + ".exe";
            exeNamesToBrowsers.put(exeName, winBrowser);
        }
        while ((line = reader.readLine()) != null) {
            String lastItemName;
            String linePath;
            int lastItem;
            if (0 != regeditType || !line.startsWith("@=") || (lastItem = (linePath = line.substring(3, line.length() - 1)).lastIndexOf(92) + 1) <= 1 || lastItem >= linePath.length() || !exeNamesToBrowsers.containsKey(lastItemName = linePath.toLowerCase().substring(lastItem))) continue;
            WindowsBrowser winBrowser = (WindowsBrowser)exeNamesToBrowsers.get(lastItemName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(line);
                this.logger.debug(linePath);
                this.logger.debug("Adding browser " + winBrowser.getBrowserDisplayName() + " to available list.");
            }
            StringTokenizer tokenizer = new StringTokenizer(linePath, "\\", false);
            StringBuffer pathBuf = new StringBuffer();
            int tokCnt = tokenizer.countTokens();
            for (int idx = 1; idx < tokCnt; ++idx) {
                pathBuf.append(tokenizer.nextToken());
                pathBuf.append('\\');
            }
            winBrowser.setPathToExe(pathBuf.toString());
            this.logger.debug(winBrowser.getPathToExe());
            browsersAvailable.put(winBrowser.getBrowserDisplayName(), winBrowser);
            browsersAvailable.put(winBrowser.getBrowserApplicationName(), winBrowser);
            tmpBrowsersToCheck.remove(winBrowser);
        }
        in.close();
    }

    private Map getAvailableBrowsers(List browsersToCheck) {
        WindowsBrowser ieBrowser;
        ArrayList tempBrowsersToCheck = new ArrayList(browsersToCheck);
        this.logger.debug("entering getAvailableBrowsers");
        this.logger.debug("browsers to check: " + browsersToCheck);
        TreeMap browsersAvailable = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        try {
            for (int idx = 0; idx < regeditQueries.length && !tempBrowsersToCheck.isEmpty(); ++idx) {
                File tmpFile = File.createTempFile("bl2-app-paths", ".reg");
                String[] cmdArgs = new String[]{"regedit.exe", "/E", "\"" + tmpFile.getAbsolutePath() + "\"", regeditQueries[idx]};
                Process process = Runtime.getRuntime().exec(cmdArgs);
                int exitCode = -1;
                try {
                    exitCode = process.waitFor();
                }
                catch (InterruptedException e) {
                    this.logger.error("InterruptedException exec'ing regedit.exe: " + e.getMessage());
                }
                if (exitCode != 0) {
                    this.logger.error("Unable to exec regedit.exe to extract available browsers.");
                    tmpFile.delete();
                    return browsersAvailable;
                }
                this.processFileForBrowsers(tmpFile, browsersAvailable, tempBrowsersToCheck, idx);
                tmpFile.delete();
            }
        }
        catch (IOException e) {
            this.logger.error("Error listing available browsers: " + e.getMessage());
        }
        if (!tempBrowsersToCheck.isEmpty() && (ieBrowser = (WindowsBrowser)browsersAvailable.get("IE")) != null) {
            this.processFilePathsForBrowsers(ieBrowser.getPathToExe(), browsersAvailable, tempBrowsersToCheck);
        }
        return browsersAvailable;
    }

    private String[] getCommandArgs(String protocol, String urlString) {
        String commandArgs = this.commandsDefaultBrowser.replaceAll("<url>", urlString);
        return commandArgs.split("[ ]");
    }

    private String getCommandArgs(String protocol, WindowsBrowser winbrowser, String urlString, boolean forceNewWindow) {
        int pathLoc;
        String commandArgs = this.commandsTargettedBrowser.replaceAll("<url>", urlString);
        commandArgs = commandArgs.replaceAll("<browser>", winbrowser.getBrowserApplicationName());
        String args = "";
        if (forceNewWindow) {
            args = winbrowser.getForceNewWindowArgs();
        }
        if ((pathLoc = (commandArgs = commandArgs.replaceAll("<args>", args)).indexOf("<path>")) > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append(commandArgs.substring(0, pathLoc));
            buf.append(winbrowser.getPathToExe());
            buf.append(commandArgs.substring(pathLoc + 6));
            commandArgs = buf.toString();
        }
        return commandArgs;
    }

    private boolean openUrlWithBrowser(WindowsBrowser winBrowser, String protocol, String urlString) throws BrowserLaunchingExecutionException {
        boolean success = false;
        try {
            this.logger.info(winBrowser.getBrowserDisplayName());
            this.logger.info(urlString);
            this.logger.info(protocol);
            String args = this.getCommandArgs(protocol, winBrowser, urlString, this.forceNewWindow);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(args);
            }
            Process process = Runtime.getRuntime().exec(args);
            process.waitFor();
            int exitValue = process.exitValue();
            success = exitValue == 0 || exitValue == 1;
        }
        catch (Exception e) {
            throw new BrowserLaunchingExecutionException(e);
        }
        return success;
    }

    public void initialize() throws BrowserLaunchingInitializingException {
        try {
            URL configUrl = this.getClass().getResource(CONFIGFILE_WINDOWS);
            if (configUrl == null) {
                throw new BrowserLaunchingInitializingException("unable to find config file: /edu/stanford/ejalbert/launching/windows/windowsConfig.properties");
            }
            Properties configProps = new Properties();
            configProps.load(configUrl.openStream());
            String sepChar = configProps.getProperty("delimchar");
            Iterator keysIter = ((Hashtable)configProps).keySet().iterator();
            while (keysIter.hasNext()) {
                String key = (String)keysIter.next();
                if (!key.startsWith("browser.")) continue;
                WindowsBrowser winBrowser = new WindowsBrowser(sepChar, configProps.getProperty(key));
                this.browsersToCheck.add(winBrowser);
            }
            String windowsConfigStr = configProps.getProperty(this.windowsKey, null);
            if (windowsConfigStr == null) {
                throw new BrowserLaunchingInitializingException(this.windowsKey + " is not a valid property");
            }
            String[] winConfigItems = windowsConfigStr.split(sepChar);
            this.commandsDefaultBrowser = winConfigItems[0];
            this.commandsTargettedBrowser = winConfigItems[1];
            this.browsersToCheck = Collections.unmodifiableList(this.browsersToCheck);
        }
        catch (IOException ioex) {
            throw new BrowserLaunchingInitializingException(ioex);
        }
    }

    public void openUrl(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        try {
            Map browserMap;
            WindowsBrowser winBrowser;
            this.logger.info(urlString);
            String protocol = this.getProtocol(urlString);
            this.logger.info(protocol);
            boolean successfullSystemPropLaunch = false;
            String browserName = System.getProperty("edu.stanford.ejalbert.preferred.browser", null);
            if (browserName != null && (winBrowser = (WindowsBrowser)(browserMap = this.getBrowserMap()).get(browserName)) != null) {
                this.logger.debug("using browser from system property");
                successfullSystemPropLaunch = this.openUrlWithBrowser(winBrowser, protocol, urlString);
            }
            if (!successfullSystemPropLaunch) {
                String[] args = this.getCommandArgs(protocol, urlString);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.getArrayAsString(args));
                }
                Process process = Runtime.getRuntime().exec(args);
                process.waitFor();
                process.exitValue();
            }
        }
        catch (Exception e) {
            this.logger.error("fatal exception", e);
            throw new BrowserLaunchingExecutionException(e);
        }
    }

    public void openUrl(String browser, String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        if ("Default".equals(browser) || browser == null) {
            this.logger.info("default or null browser target; falling through to non-targetted openUrl");
            this.openUrl(urlString);
        } else {
            Map browserMap = this.getBrowserMap();
            WindowsBrowser winBrowser = (WindowsBrowser)browserMap.get(browser);
            if (winBrowser == null) {
                this.logger.info("the available browsers list does not contain: " + browser);
                this.logger.info("falling through to non-targetted openUrl");
                this.openUrl(urlString);
            } else {
                String protocol = null;
                try {
                    protocol = this.getProtocol(urlString);
                }
                catch (MalformedURLException malrulex) {
                    throw new BrowserLaunchingExecutionException(malrulex);
                }
                boolean successfullLaunch = this.openUrlWithBrowser(winBrowser, protocol, urlString);
                if (!successfullLaunch) {
                    this.logger.debug("falling through to non-targetted openUrl");
                    this.openUrl(urlString);
                }
            }
        }
    }

    public void openUrl(List browsers, String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        if (browsers == null || browsers.isEmpty()) {
            this.logger.debug("falling through to non-targetted openUrl");
            this.openUrl(urlString);
        } else {
            String protocol = null;
            try {
                protocol = this.getProtocol(urlString);
            }
            catch (MalformedURLException malrulex) {
                throw new BrowserLaunchingExecutionException(malrulex);
            }
            Map browserMap = this.getBrowserMap();
            boolean success = false;
            Iterator iter = browsers.iterator();
            while (iter.hasNext() && !success) {
                WindowsBrowser winBrowser = (WindowsBrowser)browserMap.get(iter.next());
                if (winBrowser == null) continue;
                success = this.openUrlWithBrowser(winBrowser, protocol, urlString);
            }
            if (!success) {
                this.logger.debug("none of listed browsers succeeded; falling through to non-targetted openUrl");
                this.openUrl(urlString);
            }
        }
    }

    public List getBrowserList() {
        Map browserMap = this.getBrowserMap();
        ArrayList<String> browsers = new ArrayList<String>();
        browsers.add("Default");
        Iterator iter = browserMap.keySet().iterator();
        while (iter.hasNext()) {
            WindowsBrowser winBrowser;
            String key = (String)iter.next();
            if (!key.equals((winBrowser = (WindowsBrowser)browserMap.get(key)).getBrowserDisplayName())) continue;
            browsers.add(winBrowser.getBrowserDisplayName());
        }
        return browsers;
    }

    public boolean getNewWindowPolicy() {
        return this.forceNewWindow;
    }

    public void setNewWindowPolicy(boolean forceNewWindow) {
        this.forceNewWindow = forceNewWindow;
    }

    static {
        Arrays.sort(WIN_KEYS);
        regeditQueries = new String[]{"\"HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\""};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class DirFileFilter
    implements FileFilter {
        private DirFileFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

