/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.EnumSet;
import java.util.Iterator;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LinkStyle implements MpxjEnum
{
    NONE(0, "None"),
    END_TOP(1, "End Top"),
    END_START(2, "End Start");

    private static final LinkStyle[] TYPE_VALUES;
    private int m_value;
    private String m_name;

    private LinkStyle(int type, String name) {
        this.m_value = type;
        this.m_name = name;
    }

    public static LinkStyle getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = END_TOP.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static LinkStyle getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return LinkStyle.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    static {
        TYPE_VALUES = new LinkStyle[3];
        Iterator i$ = EnumSet.range(NONE, END_START).iterator();
        while (i$.hasNext()) {
            LinkStyle e;
            LinkStyle.TYPE_VALUES[e.getValue()] = e = (LinkStyle)i$.next();
        }
    }
}

