/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.mpxj.Duration;
import net.sf.mpxj.Filter;
import net.sf.mpxj.FilterCriteria;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TestOperator;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;

public class MppFilterTest
extends MPXJTestCase {
    public void testMpp9Filters() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9filter.mpp");
        this.testFilters(mpp);
        this.testFilterEvaluation(mpp);
        this.testLogicalOperatorEvaluation(mpp);
        this.testParameters(mpp);
    }

    public void testMpp12Filters() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12filter.mpp");
        this.testFilters(mpp);
        this.testFilterEvaluation(mpp);
        this.testLogicalOperatorEvaluation(mpp);
        this.testParameters(mpp);
    }

    private void testFilters(ProjectFile mpp) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        Filter filter = mpp.getFilterByName("Filter 1");
        FilterCriteria criteria = filter.getCriteria().get(0);
        MppFilterTest.assertEquals((Object)TaskField.DURATION1, (Object)criteria.getField());
        MppFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppFilterTest.assertEquals((int)45, (int)((int)((Duration)criteria.getValue(0)).getDuration()));
        MppFilterTest.assertEquals((Object)TimeUnit.DAYS, (Object)((Duration)criteria.getValue(0)).getUnits());
        filter = mpp.getFilterByName("Filter 2");
        criteria = filter.getCriteria().get(0);
        MppFilterTest.assertEquals((Object)TaskField.NUMBER1, (Object)criteria.getField());
        MppFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppFilterTest.assertEquals((int)99, (int)((Double)criteria.getValue(0)).intValue());
        filter = mpp.getFilterByName("Filter 3");
        criteria = filter.getCriteria().get(0);
        MppFilterTest.assertEquals((Object)TaskField.PERCENT_COMPLETE, (Object)criteria.getField());
        MppFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppFilterTest.assertEquals((int)10, (int)((Double)criteria.getValue(0)).intValue());
        filter = mpp.getFilterByName("Filter 4");
        criteria = filter.getCriteria().get(0);
        MppFilterTest.assertEquals((Object)TaskField.COST1, (Object)criteria.getField());
        MppFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppFilterTest.assertEquals((int)99, (int)((Double)criteria.getValue(0)).intValue());
        filter = mpp.getFilterByName("Filter 5");
        criteria = filter.getCriteria().get(0);
        MppFilterTest.assertEquals((Object)TaskField.TEXT1, (Object)criteria.getField());
        MppFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppFilterTest.assertEquals((String)"Hello", (String)((String)criteria.getValue(0)));
        filter = mpp.getFilterByName("Filter 6");
        criteria = filter.getCriteria().get(0);
        MppFilterTest.assertEquals((Object)TaskField.FLAG1, (Object)criteria.getField());
        MppFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppFilterTest.assertEquals((boolean)true, (boolean)((Boolean)criteria.getValue(0)));
        filter = mpp.getFilterByName("Filter 7");
        criteria = filter.getCriteria().get(0);
        MppFilterTest.assertEquals((Object)TaskField.DATE1, (Object)criteria.getField());
        MppFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        MppFilterTest.assertEquals((String)"18/07/2006", (String)df.format((Date)criteria.getValue(0)));
        filter = mpp.getFilterByName("Filter 8");
        criteria = filter.getCriteria().get(0);
        MppFilterTest.assertEquals((Object)TestOperator.EQUALS, (Object)criteria.getOperator());
        criteria = filter.getCriteria().get(1);
        MppFilterTest.assertEquals((Object)TestOperator.DOES_NOT_EQUAL, (Object)criteria.getOperator());
        criteria = filter.getCriteria().get(2);
        MppFilterTest.assertEquals((Object)TestOperator.IS_GREATER_THAN, (Object)criteria.getOperator());
        criteria = filter.getCriteria().get(3);
        MppFilterTest.assertEquals((Object)TestOperator.IS_GREATER_THAN_OR_EQUAL_TO, (Object)criteria.getOperator());
        criteria = filter.getCriteria().get(4);
        MppFilterTest.assertEquals((Object)TestOperator.IS_LESS_THAN, (Object)criteria.getOperator());
        criteria = filter.getCriteria().get(5);
        MppFilterTest.assertEquals((Object)TestOperator.IS_LESS_THAN_OR_EQUAL_TO, (Object)criteria.getOperator());
        criteria = filter.getCriteria().get(6);
        MppFilterTest.assertEquals((Object)TestOperator.IS_WITHIN, (Object)criteria.getOperator());
        criteria = filter.getCriteria().get(7);
        MppFilterTest.assertEquals((Object)TestOperator.IS_NOT_WITHIN, (Object)criteria.getOperator());
    }

    private void testFilterEvaluation(ProjectFile mpp) {
        Task task1 = mpp.getTaskByID(new Integer(1));
        Task task2 = mpp.getTaskByID(new Integer(2));
        Filter filter = mpp.getFilterByName("Filter 1");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2));
        filter = mpp.getFilterByName("Filter 2");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2));
        filter = mpp.getFilterByName("Filter 3");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2));
        filter = mpp.getFilterByName("Filter 4");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2));
        filter = mpp.getFilterByName("Filter 5");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2));
        filter = mpp.getFilterByName("Filter 6");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2));
        filter = mpp.getFilterByName("Filter 7");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2));
        Task task3 = mpp.getTaskByID(new Integer(3));
        Task task4 = mpp.getTaskByID(new Integer(4));
        Task task5 = mpp.getTaskByID(new Integer(5));
        Task task6 = mpp.getTaskByID(new Integer(6));
        Task task7 = mpp.getTaskByID(new Integer(7));
        filter = mpp.getFilterByName("Filter 9");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task3));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task4));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task5));
        filter = mpp.getFilterByName("Filter 10");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task3));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task4));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task5));
        filter = mpp.getFilterByName("Filter 11");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task3));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task4));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task5));
        filter = mpp.getFilterByName("Filter 12");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task3));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task4));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task5));
        filter = mpp.getFilterByName("Filter 13");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task3));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task4));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task5));
        filter = mpp.getFilterByName("Filter 14");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task3));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task4));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task5));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task6));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task7));
        filter = mpp.getFilterByName("Filter 15");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task3));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task4));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task5));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task6));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7));
        filter = mpp.getFilterByName("Filter 16");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task3));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task4));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task5));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task6));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task7));
        filter = mpp.getFilterByName("Filter 17");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task3));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task4));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task5));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task6));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7));
        filter = mpp.getFilterByName("Filter 18");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task3));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task4));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task5));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task6));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task7));
        filter = new Filter();
        FilterCriteria criteria = new FilterCriteria(mpp);
        filter.addCriteria(criteria);
        criteria.setField(TaskField.DEADLINE);
        criteria.setOperator(TestOperator.IS_ANY_VALUE);
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1));
        filter = new Filter();
        criteria = new FilterCriteria(mpp);
        filter.addCriteria(criteria);
        criteria.setField(TaskField.FLAG1);
        criteria.setOperator(TestOperator.EQUALS);
        criteria.setValue(0, Boolean.TRUE);
        MppFilterTest.assertTrue((boolean)filter.evaluate(task1));
        MppFilterTest.assertFalse((boolean)filter.evaluate(task2));
    }

    private void testLogicalOperatorEvaluation(ProjectFile mpp) {
        Task task6 = mpp.getTaskByID(new Integer(6));
        Task task7 = mpp.getTaskByID(new Integer(7));
        Filter filter = mpp.getFilterByName("Filter 19");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task6));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7));
        filter = mpp.getFilterByName("Filter 20");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task6));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7));
        filter = mpp.getFilterByName("Filter 21");
        MppFilterTest.assertFalse((boolean)filter.evaluate(task6));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7));
        filter = mpp.getFilterByName("Filter 22");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task6));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7));
        filter = mpp.getFilterByName("Filter 23");
        MppFilterTest.assertTrue((boolean)filter.evaluate(task6));
        MppFilterTest.assertTrue((boolean)filter.evaluate(task7));
    }

    private void testParameters(ProjectFile mpp) {
        Filter filter = mpp.getFilterByName("Filter 24");
        MppFilterTest.assertNotNull((Object)filter);
        FilterCriteria criteria = filter.getCriteria().get(0);
        MppFilterTest.assertNull((Object)criteria.getValue(0));
        MppFilterTest.assertEquals((String)"Duration1", (String)criteria.getPromptText(0));
        criteria = filter.getCriteria().get(1);
        MppFilterTest.assertNull((Object)criteria.getValue(0));
        MppFilterTest.assertEquals((String)"Number1", (String)criteria.getPromptText(0));
        criteria = filter.getCriteria().get(2);
        MppFilterTest.assertNull((Object)criteria.getValue(0));
        MppFilterTest.assertEquals((String)"%Complete", (String)criteria.getPromptText(0));
        criteria = filter.getCriteria().get(3);
        MppFilterTest.assertNull((Object)criteria.getValue(0));
        MppFilterTest.assertEquals((String)"Cost1", (String)criteria.getPromptText(0));
        criteria = filter.getCriteria().get(4);
        MppFilterTest.assertNull((Object)criteria.getValue(0));
        MppFilterTest.assertEquals((String)"Text1", (String)criteria.getPromptText(0));
        criteria = filter.getCriteria().get(5);
        MppFilterTest.assertNull((Object)criteria.getValue(0));
        MppFilterTest.assertEquals((String)"Flag1", (String)criteria.getPromptText(0));
        criteria = filter.getCriteria().get(6);
        MppFilterTest.assertNull((Object)criteria.getValue(0));
        MppFilterTest.assertEquals((String)"Date1", (String)criteria.getPromptText(0));
        criteria = filter.getCriteria().get(7);
        MppFilterTest.assertNull((Object)criteria.getValue(0));
        MppFilterTest.assertNull((Object)criteria.getValue(1));
        MppFilterTest.assertEquals((String)"LHS", (String)criteria.getPromptText(0));
        MppFilterTest.assertEquals((String)"RHS", (String)criteria.getPromptText(1));
        criteria = filter.getCriteria().get(8);
        MppFilterTest.assertNull((Object)criteria.getValue(0));
        MppFilterTest.assertNotNull((Object)criteria.getValue(1));
        MppFilterTest.assertEquals((String)"LHS", (String)criteria.getPromptText(0));
        MppFilterTest.assertNull((Object)criteria.getPromptText(1));
        criteria = filter.getCriteria().get(9);
        MppFilterTest.assertNotNull((Object)criteria.getValue(0));
        MppFilterTest.assertNull((Object)criteria.getValue(1));
        MppFilterTest.assertNull((Object)criteria.getPromptText(0));
        MppFilterTest.assertEquals((String)"RHS", (String)criteria.getPromptText(1));
    }

    public void testNullValueTestOperators() {
        TestOperator operator = TestOperator.CONTAINS;
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, null));
        MppFilterTest.assertFalse((boolean)operator.evaluate("", null));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, ""));
        operator = TestOperator.CONTAINS_EXACTLY;
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, null));
        MppFilterTest.assertFalse((boolean)operator.evaluate("", null));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, ""));
        operator = TestOperator.DOES_NOT_CONTAIN;
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, null));
        MppFilterTest.assertTrue((boolean)operator.evaluate("", null));
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, ""));
        operator = TestOperator.DOES_NOT_EQUAL;
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, null));
        MppFilterTest.assertTrue((boolean)operator.evaluate("", null));
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, ""));
        operator = TestOperator.EQUALS;
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, null));
        MppFilterTest.assertFalse((boolean)operator.evaluate("", null));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, ""));
        operator = TestOperator.IS_GREATER_THAN;
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, null));
        MppFilterTest.assertFalse((boolean)operator.evaluate("", null));
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, ""));
        operator = TestOperator.IS_GREATER_THAN_OR_EQUAL_TO;
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, null));
        MppFilterTest.assertFalse((boolean)operator.evaluate("", null));
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, ""));
        operator = TestOperator.IS_LESS_THAN;
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, null));
        MppFilterTest.assertTrue((boolean)operator.evaluate("", null));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, ""));
        operator = TestOperator.IS_LESS_THAN_OR_EQUAL_TO;
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, null));
        MppFilterTest.assertTrue((boolean)operator.evaluate("", null));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, ""));
        Object[] allNull = new Object[]{null, null};
        Object[] lhsNull = new Object[]{null, new Integer(10)};
        Object[] rhsNull = new Object[]{new Integer(1), null};
        operator = TestOperator.IS_NOT_WITHIN;
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, allNull));
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, lhsNull));
        MppFilterTest.assertTrue((boolean)operator.evaluate(null, rhsNull));
        MppFilterTest.assertTrue((boolean)operator.evaluate(new Integer(5), allNull));
        MppFilterTest.assertTrue((boolean)operator.evaluate(new Integer(5), lhsNull));
        MppFilterTest.assertTrue((boolean)operator.evaluate(new Integer(5), rhsNull));
        MppFilterTest.assertTrue((boolean)operator.evaluate(allNull, new Integer(5)));
        MppFilterTest.assertTrue((boolean)operator.evaluate(lhsNull, new Integer(5)));
        MppFilterTest.assertTrue((boolean)operator.evaluate(rhsNull, new Integer(5)));
        operator = TestOperator.IS_WITHIN;
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, allNull));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, lhsNull));
        MppFilterTest.assertFalse((boolean)operator.evaluate(null, rhsNull));
        MppFilterTest.assertFalse((boolean)operator.evaluate(new Integer(5), allNull));
        MppFilterTest.assertFalse((boolean)operator.evaluate(new Integer(5), lhsNull));
        MppFilterTest.assertFalse((boolean)operator.evaluate(new Integer(5), rhsNull));
        MppFilterTest.assertFalse((boolean)operator.evaluate(allNull, new Integer(5)));
        MppFilterTest.assertFalse((boolean)operator.evaluate(lhsNull, new Integer(5)));
        MppFilterTest.assertFalse((boolean)operator.evaluate(rhsNull, new Integer(5)));
    }
}

