SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ProductInformation]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ProductInformation](
	[ProductInformationData] [ntext] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ProductLicense]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ProductLicense](
	[LicenseData] [ntext] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Project]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[Project](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](255) NOT NULL CONSTRAINT [DF_Project_Name]  DEFAULT (''),
 CONSTRAINT [PK_Project] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ReportLayout]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ReportLayout](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](255) NOT NULL,
 CONSTRAINT [PK_ReportLayout] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ResourceLock]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ResourceLock](
	[UserID] [int] NOT NULL,
	[ResourceType] [int] NOT NULL,
	[ResourceID] [int] NOT NULL,
 CONSTRAINT [PK_ResourceLock] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ResourceType] ASC,
	[ResourceID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[ResourceLock]') AND name = N'IX_EntityID')
CREATE NONCLUSTERED INDEX [IX_EntityID] ON [dbo].[ResourceLock] 
(
	[UserID] ASC
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[ResourceLock]') AND name = N'IX_UserID')
CREATE NONCLUSTERED INDEX [IX_UserID] ON [dbo].[ResourceLock] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Task]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[Task](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](255) NOT NULL CONSTRAINT [DF_Task_Name]  DEFAULT (''),
 CONSTRAINT [PK_Task] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[UserGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[UserGroup](
	[UserID] [int] NOT NULL,
	[GroupID] [int] NOT NULL
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[UserGroup]') AND name = N'IX_Group')
CREATE NONCLUSTERED INDEX [IX_Group] ON [dbo].[UserGroup] 
(
	[GroupID] ASC
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[UserGroup]') AND name = N'IX_UserID')
CREATE NONCLUSTERED INDEX [IX_UserID] ON [dbo].[UserGroup] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[User]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[User](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Code] [nvarchar](8) NOT NULL CONSTRAINT [DF_User_Code]  DEFAULT (''),
	[Name] [nvarchar](255) NOT NULL CONSTRAINT [DF_User_Name]  DEFAULT (''),
	[Password] [nvarchar](255) NOT NULL,
	[EMail] [nvarchar](50) NOT NULL CONSTRAINT [DF_User_EMail]  DEFAULT (''),
	[FirstName] [nvarchar](128) NULL,
	[MiddleName] [nvarchar](128) NULL,
	[LastName] [nvarchar](128) NULL,
	[MemberIdentifier] [nvarchar](50) NULL,
	[Phone] [nvarchar](25) NULL,
	[PhoneExtension] [nvarchar](15) NULL,
	[Active] [bit] NOT NULL CONSTRAINT [DF_User_Active_1]  DEFAULT ((1)),
 CONSTRAINT [PK_User] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[User]') AND name = N'IX_Code')
CREATE NONCLUSTERED INDEX [IX_Code] ON [dbo].[User] 
(
	[Code] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ItemStatus]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ItemStatus](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[StartStatus] [bit] NOT NULL CONSTRAINT [DF_ItemStatus_StartStatus]  DEFAULT ((0)),
	[Name] [nvarchar](50) NOT NULL CONSTRAINT [DF_ItemStatus_Name]  DEFAULT (''),
 CONSTRAINT [PK_ItemStatus] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ItemType]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ItemType](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_ItemType] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[BinaryResourceType]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[BinaryResourceType](
	[ID] [int] NOT NULL,
	[Name] [nvarchar](255) NOT NULL,
 CONSTRAINT [PK_BinaryResourceType] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FilterType]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[FilterType](
	[ID] [int] NOT NULL,
	[Name] [varchar](225) NOT NULL,
 CONSTRAINT [PK_FilterType] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DeploymentResourceStatus]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[DeploymentResourceStatus](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[StartStatus] [bit] NOT NULL CONSTRAINT [DF_DeploymentResourceStatus_StartStatus]  DEFAULT ((0)),
	[Name] [nvarchar](50) NOT NULL CONSTRAINT [DF_DeploymentResourceStatus_Name]  DEFAULT (''),
 CONSTRAINT [PK_DeploymentResourceStatus] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ArchiveItem]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ArchiveItem](
	[ID] [int] NOT NULL,
	[ArchiveID] [int] NOT NULL,
	[ProjectID] [int] NOT NULL,
	[ProjectComponentID] [int] NOT NULL,
	[ComponentModuleID] [int] NOT NULL,
	[ItemStatusID] [int] NOT NULL,
	[ItemSeverityID] [int] NOT NULL,
	[ItemTypeID] [int] NOT NULL,
	[ReportedByUserID] [int] NOT NULL,
	[Version] [nvarchar](23) NOT NULL,
	[SolvedVersion] [nvarchar](23) NOT NULL CONSTRAINT [DF_ArchiveItem_SolvedVersion]  DEFAULT (''),
	[Created] [datetime] NOT NULL,
	[Modified] [datetime] NOT NULL,
	[Summary] [nvarchar](255) NOT NULL,
	[Keywords] [nvarchar](255) NOT NULL CONSTRAINT [DF_ArchiveItem_Keywords]  DEFAULT (''),
	[Description] [text] NOT NULL,
	[ItemPriorityID] [int] NULL,
	[AssignedToUserID] [int] NULL,
 CONSTRAINT [PK_ArchiveItem] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[ArchiveItem]') AND name = N'IX_ProjectID')
CREATE NONCLUSTERED INDEX [IX_ProjectID] ON [dbo].[ArchiveItem] 
(
	[ProjectID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Archive]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[Archive](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](255) NOT NULL,
 CONSTRAINT [PK_Archive] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DocumentResourceStatus]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[DocumentResourceStatus](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[StartStatus] [bit] NOT NULL CONSTRAINT [DF_DocumentStatus_StartStatus]  DEFAULT ((0)),
	[Name] [nvarchar](50) NOT NULL CONSTRAINT [DF_DocumentStatus_Name]  DEFAULT (''),
 CONSTRAINT [PK_DocumentStatus] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Group]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[Group](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](255) NOT NULL,
 CONSTRAINT [PK_Group] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ItemPriority]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ItemPriority](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_ItemPriority] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ItemSeverity]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ItemSeverity](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL CONSTRAINT [DF_ItemSeverity_Name]  DEFAULT (''),
 CONSTRAINT [PK_ItemSeverity] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Item]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[Item](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ProjectID] [int] NOT NULL,
	[ProjectComponentID] [int] NOT NULL CONSTRAINT [DF_Item_ProjectComponentID]  DEFAULT ((0)),
	[ComponentModuleID] [int] NOT NULL CONSTRAINT [DF_Item_ComponentModuleID]  DEFAULT ((0)),
	[ItemStatusID] [int] NOT NULL,
	[ItemSeverityID] [int] NOT NULL,
	[ItemTypeID] [int] NOT NULL,
	[ReportedByUserID] [int] NOT NULL,
	[Version] [nvarchar](23) NOT NULL CONSTRAINT [DF_Item_Version]  DEFAULT (''),
	[SolvedVersion] [nvarchar](23) NOT NULL CONSTRAINT [DF_Item_SolvedVersion]  DEFAULT (''),
	[Created] [datetime] NOT NULL,
	[Modified] [datetime] NOT NULL,
	[DueDate] [datetime] NULL,
	[DurationEstimate] [decimal](18, 2) NULL,
	[Summary] [nvarchar](255) NOT NULL CONSTRAINT [DF_ComponentItems_Title]  DEFAULT (''),
	[Keywords] [nvarchar](255) NOT NULL CONSTRAINT [DF_Item_Kwywords]  DEFAULT (''),
	[Description] [text] NOT NULL CONSTRAINT [DF_ComponentItems_Description]  DEFAULT (''),
	[ItemPriorityID] [int] NULL,
	[AssignedToUserID] [int] NULL CONSTRAINT [DF_Item_AssignToUserID]  DEFAULT ((0)),
 CONSTRAINT [PK_Item] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[Item]') AND name = N'IX_ProjectID')
CREATE NONCLUSTERED INDEX [IX_ProjectID] ON [dbo].[Item] 
(
	[ProjectID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ItemStatusTransition]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ItemStatusTransition](
	[FromItemStatusID] [int] NOT NULL,
	[ToItemStatusID] [int] NOT NULL
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[ItemStatusTransition]') AND name = N'IX_FromItemStatusID')
CREATE NONCLUSTERED INDEX [IX_FromItemStatusID] ON [dbo].[ItemStatusTransition] 
(
	[FromItemStatusID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ProjectComponent]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ProjectComponent](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ProjectID] [int] NOT NULL,
	[Name] [nvarchar](255) NOT NULL CONSTRAINT [DF_Components_Name]  DEFAULT (''),
 CONSTRAINT [PK_Components] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[ProjectComponent]') AND name = N'IX_ProjectID')
CREATE NONCLUSTERED INDEX [IX_ProjectID] ON [dbo].[ProjectComponent] 
(
	[ProjectID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ReportLayoutField]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ReportLayoutField](
	[ReportLayoutID] [int] NOT NULL,
	[FieldID] [int] NOT NULL
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[ReportLayoutField]') AND name = N'IX_ReportLayoutID')
CREATE NONCLUSTERED INDEX [IX_ReportLayoutID] ON [dbo].[ReportLayoutField] 
(
	[ReportLayoutID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[TaskItem]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[TaskItem](
	[TaskID] [int] NOT NULL,
	[ItemID] [int] NOT NULL
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[TaskItem]') AND name = N'IX_TaskID')
CREATE NONCLUSTERED INDEX [IX_TaskID] ON [dbo].[TaskItem] 
(
	[TaskID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ItemHistory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ItemHistory](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ItemID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Modified] [datetime] NOT NULL,
	[FieldName] [nvarchar](50) NOT NULL CONSTRAINT [DF_ItemHistory_FieldName]  DEFAULT (''),
	[PrevFieldValue] [ntext] NOT NULL CONSTRAINT [DF_ItemHistory_PrevFieldValue]  DEFAULT (''),
	[FieldValue] [ntext] NOT NULL CONSTRAINT [DF_ItemHistory_FieldValue]  DEFAULT (''),
 CONSTRAINT [PK_ItemHistory] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[ItemHistory]') AND name = N'IX_ItemID')
CREATE NONCLUSTERED INDEX [IX_ItemID] ON [dbo].[ItemHistory] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ItemNote]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ItemNote](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ItemID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Created] [datetime] NOT NULL,
	[Note] [text] NOT NULL,
 CONSTRAINT [PK_ItemNote] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[ItemNote]') AND name = N'IX_ItemID')
CREATE NONCLUSTERED INDEX [IX_ItemID] ON [dbo].[ItemNote] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Filter]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[Filter](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[FilterTypeID] [int] NULL,
	[Shared] [bit] NOT NULL CONSTRAINT [DF_Filter_Shared]  DEFAULT ((0)),
	[Name] [nvarchar](255) NOT NULL,
 CONSTRAINT [PK_Filter] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[UserRole]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[UserRole](
	[UserRoleID] [int] NOT NULL,
	[UserID] [int] NOT NULL
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[UserRole]') AND name = N'IX_UserRoleID')
CREATE NONCLUSTERED INDEX [IX_UserRoleID] ON [dbo].[UserRole] 
(
	[UserRoleID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DocumentResource]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[DocumentResource](
	[ID] [int] NOT NULL,
	[DocumentResourceStatusID] [int] NOT NULL,
	[AssignedToUserID] [int] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[UserSettings]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[UserSettings](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[ItemsPageSize] [int] NOT NULL CONSTRAINT [DF_UserSettings_ItemsPageSize]  DEFAULT ((10)),
	[SearchPageSize] [int] NOT NULL CONSTRAINT [DF_UserSettings_SearchPageSize]  DEFAULT ((5)),
	[ItemDisplayColumns] [int] NOT NULL CONSTRAINT [DF_UserSettings_ItemDisplayColumns]  DEFAULT ((0)),
	[DefaultItemStatusID] [int] NOT NULL CONSTRAINT [DF_UserSettings_DefaultItemStatusID]  DEFAULT ((-1)),
	[DefaultItemTypeID] [int] NOT NULL CONSTRAINT [DF_UserSettings_DefaultItemTypeID]  DEFAULT ((-1)),
	[DefaultItemSeverityID] [int] NOT NULL CONSTRAINT [DF_UserSettings_DefaultItemSeverityID]  DEFAULT ((-1)),
	[DefaultItemPriorityID] [int] NOT NULL CONSTRAINT [DF_UserSettings_DefaultItemPriorityID]  DEFAULT ((-1)),
	[DefaultItemAssignedToID] [int] NOT NULL CONSTRAINT [DF_UserSettings_DefaultItemAssigedToID]  DEFAULT ((-1)),
	[DefaultItemLocationID] [int] NOT NULL CONSTRAINT [DF_UserSettings_DefaultLocationID]  DEFAULT ((0)),
	[DefaultDocumentLocationID] [int] NOT NULL CONSTRAINT [DF_UserSettings_DefaultDocumentLocationID]  DEFAULT ((0)),
	[DefaultDeploymentLocationID] [int] NOT NULL CONSTRAINT [DF_UserSettings_DefaultDeploymnetLocationID]  DEFAULT ((0)),
	[DefaultProjectID] [int] NOT NULL CONSTRAINT [DF_UserSettings_DefaultProjectID]  DEFAULT ((-1)),
	[DefaultItemFilterID] [int] NOT NULL CONSTRAINT [DF_UserSettings_DefaultFilterID]  DEFAULT ((-1)),
	[DefaultItemTaskID] [int] NOT NULL CONSTRAINT [DF_UserSettings_DefaultTaskID]  DEFAULT ((-1)),
	[DefaultDocumentFilterID] [int] NOT NULL CONSTRAINT [DF_UserSettings_DefaultDocumentFilterID]  DEFAULT ((-1)),
	[DefaultDeploymentFilterID] [int] NOT NULL CONSTRAINT [DF_UserSettings_DefaultDeploymentFilterID]  DEFAULT ((-1)),
 CONSTRAINT [PK_UserSettings] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[UserSettings]') AND name = N'IX_UserSettings')
CREATE NONCLUSTERED INDEX [IX_UserSettings] ON [dbo].[UserSettings] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ComponentModule]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ComponentModule](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ProjectComponentID] [int] NOT NULL,
	[Name] [nvarchar](255) NOT NULL CONSTRAINT [DF_Modules_Name]  DEFAULT (''),
 CONSTRAINT [PK_ComponentModule] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[BinaryResource]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[BinaryResource](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[BinaryResourceTypeID] [int] NOT NULL,
	[ProjectID] [int] NOT NULL,
	[ProjectComponentID] [int] NOT NULL CONSTRAINT [DF_BinaryResource_ProjectComponentID]  DEFAULT ((0)),
	[ComponentModuleID] [int] NOT NULL CONSTRAINT [DF_BinaryResource_ComponentModuleID]  DEFAULT ((0)),
	[CreatedByUserID] [int] NOT NULL,
	[Created] [datetime] NOT NULL,
	[Modified] [datetime] NOT NULL,
	[Summary] [nvarchar](255) NOT NULL CONSTRAINT [DF_BinaryResource_Summary]  DEFAULT (''),
	[Keywords] [nvarchar](255) NOT NULL CONSTRAINT [DF_BinaryResource_Kwywords]  DEFAULT (''),
	[Description] [text] NOT NULL CONSTRAINT [DF_BinaryResource_Description]  DEFAULT (''),
 CONSTRAINT [PK_BinaryResource] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[BinaryResource]') AND name = N'IX_BinaryResourceTypeID')
CREATE NONCLUSTERED INDEX [IX_BinaryResourceTypeID] ON [dbo].[BinaryResource] 
(
	[BinaryResourceTypeID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[BinaryResourceAttachment]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[BinaryResourceAttachment](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[BinaryResourceID] [int] NOT NULL,
	[FileName] [nvarchar](255) NOT NULL,
	[FileCreationDate] [datetime] NOT NULL,
	[FileContent] [image] NULL,
 CONSTRAINT [PK_BinaryResourceAttachment] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[BinaryResourceHistory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[BinaryResourceHistory](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[BinaryResourceID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Modified] [datetime] NOT NULL,
	[FieldName] [nvarchar](50) NOT NULL CONSTRAINT [DF_BinaryResourceHistory_FieldName]  DEFAULT (''),
	[PrevFieldValue] [ntext] NOT NULL CONSTRAINT [DF_BinaryResourceHistory_PrevFieldValue]  DEFAULT (''),
	[FieldValue] [ntext] NOT NULL CONSTRAINT [DF_BinaryResourceHistory_FieldValue]  DEFAULT (''),
 CONSTRAINT [PK_BinaryResourceHistory] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[BinaryResourceNote]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[BinaryResourceNote](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[BinaryResourceID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Created] [datetime] NOT NULL,
	[Note] [text] NOT NULL,
 CONSTRAINT [PK_BinaryResourceNote] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DeploymentResource]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[DeploymentResource](
	[ID] [int] NOT NULL,
	[ProductVersion] [nvarchar](50) NOT NULL CONSTRAINT [DF_DeploymentResource_ProductVersion]  DEFAULT (''),
	[DeploymentResourceStatusID] [int] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FilterAtom]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[FilterAtom](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[FilterID] [int] NOT NULL,
	[FilterGroup] [int] NOT NULL,
	[DataName] [nvarchar](50) NOT NULL CONSTRAINT [DF_FilterItems_DataName]  DEFAULT (''),
	[OperationCode] [nvarchar](10) NOT NULL CONSTRAINT [DF_FilterItems_Operation]  DEFAULT (''),
	[StringValue] [nvarchar](50) NOT NULL CONSTRAINT [DF_FilterItems_StringValue]  DEFAULT (''),
	[ValueType] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_FilterAtom] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[FilterAtom]') AND name = N'IX_FilterID')
CREATE NONCLUSTERED INDEX [IX_FilterID] ON [dbo].[FilterAtom] 
(
	[FilterID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DeploymentResourceStatusTransition]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[DeploymentResourceStatusTransition](
	[FromDeploymentResourceStatusID] [int] NOT NULL,
	[ToDeploymentResourceStatusID] [int] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[UserItemColumnSettings]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[UserItemColumnSettings](
	[UserSettingsID] [int] NOT NULL,
	[ItemFieldID] [int] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ItemNotification]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ItemNotification](
	[Type] [int] NOT NULL,
	[ItemID] [int] NOT NULL
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[ItemNotification]') AND name = N'IX_ItemID')
CREATE NONCLUSTERED INDEX [IX_ItemID] ON [dbo].[ItemNotification] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[ItemNotification]') AND name = N'IX_ItemNotification')
CREATE NONCLUSTERED INDEX [IX_ItemNotification] ON [dbo].[ItemNotification] 
(
	[Type] ASC,
	[ItemID] ASC
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[ItemNotification]') AND name = N'IX_Type')
CREATE NONCLUSTERED INDEX [IX_Type] ON [dbo].[ItemNotification] 
(
	[Type] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[ItemAttachment]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[ItemAttachment](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ItemID] [int] NOT NULL,
	[FileName] [nvarchar](255) NOT NULL,
	[FileCreationDate] [datetime] NOT NULL,
	[FileContent] [image] NULL,
 CONSTRAINT [PK_ItemAttachements] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[ItemAttachment]') AND name = N'IX_ItemID')
CREATE NONCLUSTERED INDEX [IX_ItemID] ON [dbo].[ItemAttachment] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DocumentResourceStatusTransition]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[DocumentResourceStatusTransition](
	[FromDocumentResourceStatusID] [int] NOT NULL,
	[ToDocumentResourceStatusID] [int] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[GroupPermission]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[GroupPermission](
	[GroupID] [int] NOT NULL,
	[PermissionID] [int] NOT NULL
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[GroupPermission]') AND name = N'IX_GroupID')
CREATE NONCLUSTERED INDEX [IX_GroupID] ON [dbo].[GroupPermission] 
(
	[GroupID] ASC
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_Item_AssignedTo]') AND type = 'F')
ALTER TABLE [dbo].[Item]  WITH CHECK ADD  CONSTRAINT [FK_Item_AssignedTo] FOREIGN KEY([AssignedToUserID])
REFERENCES [dbo].[User] ([ID])
GO
ALTER TABLE [dbo].[Item] CHECK CONSTRAINT [FK_Item_AssignedTo]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_Item_ItemPriority]') AND type = 'F')
ALTER TABLE [dbo].[Item]  WITH CHECK ADD  CONSTRAINT [FK_Item_ItemPriority] FOREIGN KEY([ItemPriorityID])
REFERENCES [dbo].[ItemPriority] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[Item] CHECK CONSTRAINT [FK_Item_ItemPriority]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_Item_ItemSeverity]') AND type = 'F')
ALTER TABLE [dbo].[Item]  WITH CHECK ADD  CONSTRAINT [FK_Item_ItemSeverity] FOREIGN KEY([ItemSeverityID])
REFERENCES [dbo].[ItemSeverity] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[Item] CHECK CONSTRAINT [FK_Item_ItemSeverity]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_Item_ItemStatus]') AND type = 'F')
ALTER TABLE [dbo].[Item]  WITH CHECK ADD  CONSTRAINT [FK_Item_ItemStatus] FOREIGN KEY([ItemStatusID])
REFERENCES [dbo].[ItemStatus] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[Item] CHECK CONSTRAINT [FK_Item_ItemStatus]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_Item_ItemType]') AND type = 'F')
ALTER TABLE [dbo].[Item]  WITH CHECK ADD  CONSTRAINT [FK_Item_ItemType] FOREIGN KEY([ItemTypeID])
REFERENCES [dbo].[ItemType] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[Item] CHECK CONSTRAINT [FK_Item_ItemType]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_Item_Project]') AND type = 'F')
ALTER TABLE [dbo].[Item]  WITH CHECK ADD  CONSTRAINT [FK_Item_Project] FOREIGN KEY([ProjectID])
REFERENCES [dbo].[Project] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[Item] CHECK CONSTRAINT [FK_Item_Project]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_Item_ReportedBy]') AND type = 'F')
ALTER TABLE [dbo].[Item]  WITH CHECK ADD  CONSTRAINT [FK_Item_ReportedBy] FOREIGN KEY([ReportedByUserID])
REFERENCES [dbo].[User] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[Item] CHECK CONSTRAINT [FK_Item_ReportedBy]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_ItemStatusTransition_ItemStatus]') AND type = 'F')
ALTER TABLE [dbo].[ItemStatusTransition]  WITH CHECK ADD  CONSTRAINT [FK_ItemStatusTransition_ItemStatus] FOREIGN KEY([FromItemStatusID])
REFERENCES [dbo].[ItemStatus] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ItemStatusTransition] CHECK CONSTRAINT [FK_ItemStatusTransition_ItemStatus]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_ProjectComponent_Project]') AND type = 'F')
ALTER TABLE [dbo].[ProjectComponent]  WITH CHECK ADD  CONSTRAINT [FK_ProjectComponent_Project] FOREIGN KEY([ProjectID])
REFERENCES [dbo].[Project] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ProjectComponent] CHECK CONSTRAINT [FK_ProjectComponent_Project]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_ReportLayoutField_ReportLayout]') AND type = 'F')
ALTER TABLE [dbo].[ReportLayoutField]  WITH CHECK ADD  CONSTRAINT [FK_ReportLayoutField_ReportLayout] FOREIGN KEY([ReportLayoutID])
REFERENCES [dbo].[ReportLayout] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ReportLayoutField] CHECK CONSTRAINT [FK_ReportLayoutField_ReportLayout]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_TaskItem_Item]') AND type = 'F')
ALTER TABLE [dbo].[TaskItem]  WITH CHECK ADD  CONSTRAINT [FK_TaskItem_Item] FOREIGN KEY([ItemID])
REFERENCES [dbo].[Item] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[TaskItem] CHECK CONSTRAINT [FK_TaskItem_Item]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_TaskItem_Task]') AND type = 'F')
ALTER TABLE [dbo].[TaskItem]  WITH CHECK ADD  CONSTRAINT [FK_TaskItem_Task] FOREIGN KEY([TaskID])
REFERENCES [dbo].[Task] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[TaskItem] CHECK CONSTRAINT [FK_TaskItem_Task]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_ItemHistory_Item]') AND type = 'F')
ALTER TABLE [dbo].[ItemHistory]  WITH CHECK ADD  CONSTRAINT [FK_ItemHistory_Item] FOREIGN KEY([ItemID])
REFERENCES [dbo].[Item] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ItemHistory] CHECK CONSTRAINT [FK_ItemHistory_Item]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_ItemHistory_User]') AND type = 'F')
ALTER TABLE [dbo].[ItemHistory]  WITH CHECK ADD  CONSTRAINT [FK_ItemHistory_User] FOREIGN KEY([UserID])
REFERENCES [dbo].[User] ([ID])
GO
ALTER TABLE [dbo].[ItemHistory] CHECK CONSTRAINT [FK_ItemHistory_User]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_ItemNote_Item]') AND type = 'F')
ALTER TABLE [dbo].[ItemNote]  WITH CHECK ADD  CONSTRAINT [FK_ItemNote_Item] FOREIGN KEY([ItemID])
REFERENCES [dbo].[Item] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ItemNote] CHECK CONSTRAINT [FK_ItemNote_Item]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_ItemNote_User]') AND type = 'F')
ALTER TABLE [dbo].[ItemNote]  WITH CHECK ADD  CONSTRAINT [FK_ItemNote_User] FOREIGN KEY([UserID])
REFERENCES [dbo].[User] ([ID])
GO
ALTER TABLE [dbo].[ItemNote] CHECK CONSTRAINT [FK_ItemNote_User]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_Filter_FilterType]') AND type = 'F')
ALTER TABLE [dbo].[Filter]  WITH CHECK ADD  CONSTRAINT [FK_Filter_FilterType] FOREIGN KEY([FilterTypeID])
REFERENCES [dbo].[FilterType] ([ID])
GO
ALTER TABLE [dbo].[Filter] CHECK CONSTRAINT [FK_Filter_FilterType]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_Filter_User]') AND type = 'F')
ALTER TABLE [dbo].[Filter]  WITH CHECK ADD  CONSTRAINT [FK_Filter_User] FOREIGN KEY([UserID])
REFERENCES [dbo].[User] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[Filter] CHECK CONSTRAINT [FK_Filter_User]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_UserRole_User]') AND type = 'F')
ALTER TABLE [dbo].[UserRole]  WITH CHECK ADD  CONSTRAINT [FK_UserRole_User] FOREIGN KEY([UserID])
REFERENCES [dbo].[User] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[UserRole] CHECK CONSTRAINT [FK_UserRole_User]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_DocumentResource_BinaryResource]') AND type = 'F')
ALTER TABLE [dbo].[DocumentResource]  WITH CHECK ADD  CONSTRAINT [FK_DocumentResource_BinaryResource] FOREIGN KEY([ID])
REFERENCES [dbo].[BinaryResource] ([ID])
GO
ALTER TABLE [dbo].[DocumentResource] CHECK CONSTRAINT [FK_DocumentResource_BinaryResource]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_DocumentResource_DocumentResourceStatus]') AND type = 'F')
ALTER TABLE [dbo].[DocumentResource]  WITH CHECK ADD  CONSTRAINT [FK_DocumentResource_DocumentResourceStatus] FOREIGN KEY([DocumentResourceStatusID])
REFERENCES [dbo].[DocumentResourceStatus] ([ID])
GO
ALTER TABLE [dbo].[DocumentResource] CHECK CONSTRAINT [FK_DocumentResource_DocumentResourceStatus]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_DocumentResource_User]') AND type = 'F')
ALTER TABLE [dbo].[DocumentResource]  WITH CHECK ADD  CONSTRAINT [FK_DocumentResource_User] FOREIGN KEY([AssignedToUserID])
REFERENCES [dbo].[User] ([ID])
GO
ALTER TABLE [dbo].[DocumentResource] CHECK CONSTRAINT [FK_DocumentResource_User]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_UserSettings_User]') AND type = 'F')
ALTER TABLE [dbo].[UserSettings]  WITH CHECK ADD  CONSTRAINT [FK_UserSettings_User] FOREIGN KEY([UserID])
REFERENCES [dbo].[User] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[UserSettings] CHECK CONSTRAINT [FK_UserSettings_User]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_ProjectComponentModule_ProjectComponent]') AND type = 'F')
ALTER TABLE [dbo].[ComponentModule]  WITH CHECK ADD  CONSTRAINT [FK_ProjectComponentModule_ProjectComponent] FOREIGN KEY([ProjectComponentID])
REFERENCES [dbo].[ProjectComponent] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ComponentModule] CHECK CONSTRAINT [FK_ProjectComponentModule_ProjectComponent]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_BinaryResource_BinaryResourceType]') AND type = 'F')
ALTER TABLE [dbo].[BinaryResource]  WITH CHECK ADD  CONSTRAINT [FK_BinaryResource_BinaryResourceType] FOREIGN KEY([BinaryResourceTypeID])
REFERENCES [dbo].[BinaryResourceType] ([ID])
GO
ALTER TABLE [dbo].[BinaryResource] CHECK CONSTRAINT [FK_BinaryResource_BinaryResourceType]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_BinaryResourceAttachment_BinaryResource]') AND type = 'F')
ALTER TABLE [dbo].[BinaryResourceAttachment]  WITH CHECK ADD  CONSTRAINT [FK_BinaryResourceAttachment_BinaryResource] FOREIGN KEY([BinaryResourceID])
REFERENCES [dbo].[BinaryResource] ([ID])
GO
ALTER TABLE [dbo].[BinaryResourceAttachment] CHECK CONSTRAINT [FK_BinaryResourceAttachment_BinaryResource]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_BinaryResourceHistory_BinaryResource]') AND type = 'F')
ALTER TABLE [dbo].[BinaryResourceHistory]  WITH CHECK ADD  CONSTRAINT [FK_BinaryResourceHistory_BinaryResource] FOREIGN KEY([BinaryResourceID])
REFERENCES [dbo].[BinaryResource] ([ID])
GO
ALTER TABLE [dbo].[BinaryResourceHistory] CHECK CONSTRAINT [FK_BinaryResourceHistory_BinaryResource]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_BinaryResourceNote_BinaryResource]') AND type = 'F')
ALTER TABLE [dbo].[BinaryResourceNote]  WITH CHECK ADD  CONSTRAINT [FK_BinaryResourceNote_BinaryResource] FOREIGN KEY([BinaryResourceID])
REFERENCES [dbo].[BinaryResource] ([ID])
GO
ALTER TABLE [dbo].[BinaryResourceNote] CHECK CONSTRAINT [FK_BinaryResourceNote_BinaryResource]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_DeploymentResource_BinaryResource]') AND type = 'F')
ALTER TABLE [dbo].[DeploymentResource]  WITH CHECK ADD  CONSTRAINT [FK_DeploymentResource_BinaryResource] FOREIGN KEY([ID])
REFERENCES [dbo].[BinaryResource] ([ID])
GO
ALTER TABLE [dbo].[DeploymentResource] CHECK CONSTRAINT [FK_DeploymentResource_BinaryResource]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_DeploymentResource_DeploymentResourceStatus]') AND type = 'F')
ALTER TABLE [dbo].[DeploymentResource]  WITH CHECK ADD  CONSTRAINT [FK_DeploymentResource_DeploymentResourceStatus] FOREIGN KEY([DeploymentResourceStatusID])
REFERENCES [dbo].[DeploymentResourceStatus] ([ID])
GO
ALTER TABLE [dbo].[DeploymentResource] CHECK CONSTRAINT [FK_DeploymentResource_DeploymentResourceStatus]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_FilterItems_Filter]') AND type = 'F')
ALTER TABLE [dbo].[FilterAtom]  WITH CHECK ADD  CONSTRAINT [FK_FilterItems_Filter] FOREIGN KEY([FilterID])
REFERENCES [dbo].[Filter] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[FilterAtom] CHECK CONSTRAINT [FK_FilterItems_Filter]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_DeploymentResourceStatusTransition_DeploymentResourceStatus]') AND type = 'F')
ALTER TABLE [dbo].[DeploymentResourceStatusTransition]  WITH CHECK ADD  CONSTRAINT [FK_DeploymentResourceStatusTransition_DeploymentResourceStatus] FOREIGN KEY([FromDeploymentResourceStatusID])
REFERENCES [dbo].[DeploymentResourceStatus] ([ID])
GO
ALTER TABLE [dbo].[DeploymentResourceStatusTransition] CHECK CONSTRAINT [FK_DeploymentResourceStatusTransition_DeploymentResourceStatus]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_UserItemColumnSettings_UserSettings]') AND type = 'F')
ALTER TABLE [dbo].[UserItemColumnSettings]  WITH CHECK ADD  CONSTRAINT [FK_UserItemColumnSettings_UserSettings] FOREIGN KEY([UserSettingsID])
REFERENCES [dbo].[UserSettings] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[UserItemColumnSettings] CHECK CONSTRAINT [FK_UserItemColumnSettings_UserSettings]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_ItemNotification_Item]') AND type = 'F')
ALTER TABLE [dbo].[ItemNotification]  WITH CHECK ADD  CONSTRAINT [FK_ItemNotification_Item] FOREIGN KEY([ItemID])
REFERENCES [dbo].[Item] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ItemNotification] CHECK CONSTRAINT [FK_ItemNotification_Item]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_ItemAttachment_Item]') AND type = 'F')
ALTER TABLE [dbo].[ItemAttachment]  WITH CHECK ADD  CONSTRAINT [FK_ItemAttachment_Item] FOREIGN KEY([ItemID])
REFERENCES [dbo].[Item] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ItemAttachment] CHECK CONSTRAINT [FK_ItemAttachment_Item]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_DocumentResourceStatusTransition_DocumentResourceStatus]') AND type = 'F')
ALTER TABLE [dbo].[DocumentResourceStatusTransition]  WITH CHECK ADD  CONSTRAINT [FK_DocumentResourceStatusTransition_DocumentResourceStatus] FOREIGN KEY([FromDocumentResourceStatusID])
REFERENCES [dbo].[DocumentResourceStatus] ([ID])
GO
ALTER TABLE [dbo].[DocumentResourceStatusTransition] CHECK CONSTRAINT [FK_DocumentResourceStatusTransition_DocumentResourceStatus]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FK_UserGroupPermission_UserGroup]') AND type = 'F')
ALTER TABLE [dbo].[GroupPermission]  WITH CHECK ADD  CONSTRAINT [FK_UserGroupPermission_UserGroup] FOREIGN KEY([GroupID])
REFERENCES [dbo].[Group] ([ID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[GroupPermission] CHECK CONSTRAINT [FK_UserGroupPermission_UserGroup]
