////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Copyright 1999-2005, Hitek Software LLC
//http://www.sharewarejustice.com
//This source code is subject to change without any prior notice.  
//The source code is subject to a non-disclosure agreement. 
//No part of this source code may be reproduced, transmitted to other Shareware Developers or any other person, without the written permission of Hitek Software LLC.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.IO;

namespace Tracker
{
    public class PostData
    {
        public String status, dataLine;
        String postCgi = "http://www.sharewarejustice.com/cgi-bin/test.pl";
        //String postCgi = "http://www.sharewarejustice.com/cgi-bin/tracker.pl";

        //constructor
        public PostData() { }

        ///////////////////////////////////////////////	
        public int GetMethod(String parString)
        {
            try
            {
                postCgi = postCgi + "?" + parString;
                Uri uri = new Uri(postCgi);
                WebRequest request = WebRequest.Create(uri);
                // Get the response.
                HttpWebResponse response = (HttpWebResponse)request.GetResponse ();
                // Display the status.
                status = response.StatusDescription;
                // Get the stream containing content returned by the server.
                Stream dataStream = response.GetResponseStream ();
                // Open the stream using a StreamReader for easy access.
                StreamReader reader = new StreamReader (dataStream);
                // Read the content.
                dataLine = reader.ReadToEnd ();
                // Cleanup the streams and the response.
                reader.Close ();
                dataStream.Close ();
                response.Close ();
            }
            catch (Exception exp)
            {
                dataLine = exp.Message;
                return 1;
            }
            return 0;
        }
        ///////////////////////////////////////////////////
        public int PostMethod(String parString)
        {
            try
            {
                //?& hack needed or first parameter, i.e. authorid does not get passed
                postCgi = postCgi + "?&" + parString;
                Uri uri = new Uri(postCgi);
                WebRequest request = WebRequest.Create(postCgi);
                // Specify that you want to POST data
                request.Method = "POST";
                request.ContentType = "application/x-www-form-urlencoded";
                byte[] bytes = null;
                bytes = System.Text.Encoding.ASCII.GetBytes(postCgi);
                request.ContentLength = bytes.Length;
                //Get an output stream from the request object
                Stream outputStream = request.GetRequestStream();
                // Post the data out to the stream
                outputStream.Write(bytes, 0, bytes.Length);
                //Close the output stream and send the data out to the web server
                outputStream.Close();
                // read the response from the Web Server
                WebResponse response = request.GetResponse();
                //Get the Stream Object from the response
                Stream responseStream = response.GetResponseStream();
                //Create a stream reader and associate it with the stream object
                StreamReader reader = new StreamReader(responseStream);
                //read the entire stream 
                dataLine = reader.ReadToEnd();
                reader.Close();
                responseStream.Close();
                response.Close();
            }
            catch (Exception exp)
            {
                dataLine = exp.Message;
                return 1;
            }
            return 0;
        }
    }
}
