/*************************   CDEMO.CPP   *********************************
*                                                                        *
*                Simple Demo Program for                                 *
*                       C M A T H                                        *
*                                                                        *
*   Copyright 1996-2008 by OptiCode - Dr. Martin Sander Software Dev.    *
*                                                                        *
*       This sample program provides a very basic test                   *
*       for the correct installation of CMATH                            *
*       and for correct error handling.                                  *
*                                                                        *
**************************************************************************/
/*
Borland C++, 32-bit command-line compiler:
	1. Go to your CMATH or OptiVec directory.
	2. Be sure, your Borland C++ BIN directory is contained in the
           environment variable PATH and that you have a BCC32.CFG file
           pointing to your BC++ version's include and library paths.
	3. type
               BCC32 -Iinclude cdemo.cpp lib\cmathf4w.lib \lib\cmathfs.lib
           If you got CMATH as a part of OptiVec, type instead
               BCC32 -Iinclude cdemo.cpp lib\VCF4W.lib \VCFS.lib
	4. Run the program by typing:  cdemo

        Don't wonder about the math error message being displayed in
	a message box, rather than being printed to the console.
	This is because there is only one version of CMATH,
	simultaneously for GUI and console applications.
        You can get rid of the popup window by calling the routine
        V_setErrorEventFile, as indicated as a comment below.


Borland C++ Builder,  Borland (CodeGear) Dev. Studio, RAD Studio:

    Open the project CDEMOB6.BPR.
    This is a BC++ Builder 6 project. Later versions of BCB and
    Developer Studio will convert this project into their own format.
    When prompted, answer "YES" to allow this automatic conversion.

    Alternatively, follow this way:

    1. Create a project as a Win32 console application with static
       linking of the RTL and without inclusion of the VCL.

    2. Include the following files in this project:
       CDEMO.CPP
       CMATHF4W.LIB + CMATHS.LIB    or    VCF4W.LIB + VCFS.LIB

        Additionally, you have to link in the standard run-time libraries
        (normally done automatically by your compiler)

    3. Your include-file search path must contain:
       \YourCMATHDirectory\include;

    4. Your library search path must contain:
        \YourCMATHDirectory\lib;
        (in addition to the compiler's default settings).

Microsoft Visual C++, Visual Studio:
    If you got CMATH as a part of OptiVec, open the workspace VDEMO.DSW,
       which includes the project CDEMO.
    If you got CMATH separately, open the workspace CDEMO.DSW.

    Alternatively, follow this way:

  A. If you got CMATH as a part of OptiVec
    1. Create a new empty project as a "Win32 Console application".
    2. In the project settings, C/C++, Code Generation,
       verify that multi-thread debug is chosen.
    3. Add OptiVec\include to the include-file search path.
    4. Add the files CDEMOW.CPP, OVVC4.LIB and OVVCMTD.LIB to your project.
    5. Disable the use of precompiled headers
       (Project Settings /  C/C++   /  Preprocessor  /  Precompiled Headers)
    6. Compile and run.

  B. If you got CMATH separately
    1. Create a new empty project as a "Win32 Console application".
    2. In the project settings, C/C++, Code Generation,
       verify that multi-thread debug is chosen.
    3. Add CMATH\include to the include-file search path.
    4. Add the files CDEMOW.CPP, CMVC4.LIB and CMVCMTD.LIB to your project.
    5. Disable the use of precompiled headers
       (Project Settings /  C/C++   /  Preprocessor  /  Precompiled Headers)
    6. Compile and run.

*/

#include <newcplx.h>
#include <stdio.h>

int main( void )
{
    fComplex x, y;
    char     DataText[121];

  //  V_setErrorEventFile( "CDEMO.LOG", 0 );
         // activate the above line to receive all output and error
         // messages in a log-file instead of popup windows

    V_printErrorMsg( "Welcome to the CMATH installation check!\n\n"
                     "Do not wonder, the next window shows\n"
                     "a piece of error handling!\n");
    x = sin( fComplex( 3, 5));
    y = inv( fComplex(0,0));  // will produce an error message
    #if defined _MSC_VER && _MSC_VER >= 1400 
	    /* safe function of Visual Studio 2005 + */
        sprintf_s( DataText, 120,
                   "The sine of  { 3.0, 5.0 } is {%f, %f}\n"
                   "Complex 1/0 situations yield {%g, %g}\n",
                    x.Re, x.Im, y.Re, y.Im );
    #else
        sprintf( DataText, "The sine of  { 3.0, 5.0 } is {%f, %f}\n"
                           "Complex 1/0 situations yield {%g, %g}\n",
                           x.Re, x.Im, y.Re, y.Im );
    #endif
    V_printErrorMsg( DataText );
    V_printErrorMsg( "Thank you!\n"
                     "Enjoy using CMATH in your programs!" );
    return 0;
}
