using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;



using System.Runtime.InteropServices; //requirement class

namespace dlltest
{
	/// <summary>
	/// 
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{

		//load the Kernel.dll and declare the methods to use
		[DllImport("Kernel", EntryPoint="lstrcpy", CallingConvention=CallingConvention.StdCall)] 
		public static extern int lstrcpy (Object lpszString1,Object lpszString2); 
		//load the Kernel32.dll and declare the methods to use
		[DllImport("kernel32", EntryPoint="RtlMoveMemory", CallingConvention=CallingConvention.StdCall)] 
		public static extern void CopyMemory (Object Destination,Object Source, int Length); 

		//load the texttopdf.dll and declare the methods to use
		[DllImport("texttopdf", EntryPoint="apCreate", CallingConvention=CallingConvention.StdCall)] 
		public static extern int ApCreate (String lpFileName); 
 
		[DllImport("texttopdf", EntryPoint="apOpen", CallingConvention=CallingConvention.StdCall)] 
		public static extern int ApOpen (String lpFileName); 

		[DllImport("texttopdf", EntryPoint="apClose", CallingConvention=CallingConvention.StdCall)] 
		public static extern void ApClose (int id); 

		[DllImport("texttopdf", EntryPoint="apAddTextEx", CallingConvention=CallingConvention.StdCall)] 
		public static extern int ApAddTextEx (int id, int x, int y, String str, int color); 

		[DllImport("texttopdf", EntryPoint="apAddText", CallingConvention=CallingConvention.StdCall)] 
		public static extern int ApAddText (int id, int x, int y, int width, int height, String str, int color, int bkcolor, int lformat); 

		[DllImport("texttopdf", EntryPoint="apAddTxt", CallingConvention=CallingConvention.StdCall)] 
		public static extern int ApAddTxt (int id, String lpFileName, int color, int pagewidth, int pageheight, int AutoNewLine, int AutoWidthAdjust, int LeftMargin, int RightMargin, int TopMargin, int BottomMargin, int TabSize); 

		[DllImport("texttopdf", EntryPoint="apAddLine", CallingConvention=CallingConvention.StdCall)] 
		public static extern int ApAddLine (int id, int sx, int sy, int ex, int ey, int side_width, int side_color); 

		[DllImport("texttopdf", EntryPoint="apAddRect", CallingConvention=CallingConvention.StdCall)] 
		public static extern int ApAddRect (int id, int sx, int sy, int ex, int ey, int side_width, int side_color, int flagFill, int fill_color); 

		[DllImport("texttopdf", EntryPoint="apAddInfo", CallingConvention=CallingConvention.StdCall)] 
		public static extern int ApAddInfo (int id, String Title, String Subject, String Author, String Keywords, String Creator); 

		[DllImport("texttopdf", EntryPoint="apSetFunction", CallingConvention=CallingConvention.StdCall)] 
		public static extern int ApSetFunction (int id, int func_code, int Para1, int Para2, String szPara3, String szPara4); 

		[DllImport("texttopdf", EntryPoint="apGetFunction", CallingConvention=CallingConvention.StdCall)] 
		public static extern int ApGetFunction (int idg, int func_code, int Para1, int Para2, String szPara3, String szPara4); 
//**************************************************************************************
		//define for ApAddText
		const int Ap_DT_LEFT = 0x0;
		const int Ap_DT_CENTER = 0x1;
		const int Ap_DT_RIGHT = 0x2;
		const int Ap_DT_WORDBREAK = 0x10;
		const int Ap_DT_CALCRECT = 0x400;
		const int Ap_DT_CALCRECTEX = 0x800;

		//define for ApSetFunction
		const int Ap_Set_Encrypt = 105;
		const int Ap_Set_Font = 106;
		const int Ap_Set_NewOrClosePage = 109;
		const int Ap_Set_BookMark = 110;
		const int Ap_Set_ViewerPreferences = 121;
		const int Ap_Set_pageOrientation = 122;


		//define for ApGetFunction
		const int Ap_Get_PdfPageCount = 206;
		const int Ap_Get_PdfCurrentPageSize = 209;
		const int Ap_Get_StringWidth = 250;
		const int Ap_Get_StringHeight = 251;

		//set password and permission
		const int permission_Print = 1;
		const int permission_Copy  = 2;
		const int permission_Modify= 4;
//**************************************************************************************
		private int RGB(int r,int g,int b)
		{
			return ((int)(((r)|(((g))<<8))|(((b))<<16)));
			
		}

//**************************************************************************************
		private void Info()
		{
			int id;
			String strPDF = "Information.pdf";

			id = ApCreate(strPDF);
			if(id>0) 
			{
				//Note: set document info
				ApAddInfo( id, "Title", "Subject", "Author", "Keywords", "Creator");
				//add text file to pdf 
				String strFileName = "test.txt";
				ApSetFunction(id, Ap_Set_Font, 200, 16, "0", "0");
				ApAddTxt(id, strFileName, 0, 0, 0, 1, 1, 64, 64, 64, 64, 4);
				ApClose(id);
			}

		}
//**************************************************************************************
		private void Security()
		{
			int id;
			String strPDF = "Security.pdf";

			id = ApCreate(strPDF);
			if (id > 0) 
			{
				//Note: set encryption
				ApSetFunction(id, Ap_Set_Encrypt, 128, permission_Print + permission_Copy + permission_Modify, "owner", "user");
				//add text file to pdf 
				String strFileName = "test.txt";
				ApSetFunction(id, Ap_Set_Font, 200, 16, "0", "0");
				ApAddTxt(id, strFileName, 0, 0, 0, 1, 1, 64, 64, 64, 64, 4);
				ApClose(id);
			}
		}
//**************************************************************************************
		private void Bookmark()
		{
			int id;
			String strPDF = "Bookmark.pdf";

			id = ApCreate(strPDF);
			if (id > 0) {
				//create a page for A3
				ApSetFunction(id,Ap_Set_NewOrClosePage,1,1,"0","0");
				//add bookmark
				ApSetFunction(id,Ap_Set_BookMark,0,0,"bookmark one","0");
				//set system font and size
				ApSetFunction(id,Ap_Set_Font,1,48,"Arial","0");
				//add text
				ApAddTextEx(id,200,200,"this is a sample!",RGB(0,255,255));
				//close the page
				ApSetFunction(id,Ap_Set_NewOrClosePage,0,0,"0","0");
		

				//add bookmark
				ApSetFunction(id,Ap_Set_BookMark,0,0,"bookmark two","0");
				//add text file to pdf 
				String strFileName = "test.txt";
				ApSetFunction(id, Ap_Set_Font, 200, 16, "0", "0");
				ApAddTxt(id, strFileName, 0, 0, 0, 1, 1, 64, 64, 64, 64, 4);
				ApClose (id);
			}		
		}
//**************************************************************************************
		private void Append()
		{
			int id;
			String strPDF = "Append.pdf";

			if((id=ApOpen(strPDF)) > 0){				//Append PDF file
				//create a page for A4
				ApSetFunction(id,Ap_Set_NewOrClosePage,2,2,"0","0");
				//set system font and size
				ApSetFunction(id,Ap_Set_Font,1,32,"Arial","0");
				//add text
				ApAddTextEx(id,200,200,"Appended page",RGB(255,0,0));
				//close the page
				ApSetFunction(id,Ap_Set_NewOrClosePage,0,0,"0","0");

				ApClose(id);
			}else if((id=ApCreate(strPDF)) >0){			//Create new PDF file
				//create a page for A4
				ApSetFunction(id,Ap_Set_NewOrClosePage,2,2,"0","0");
				//set system font and size
				ApSetFunction(id,Ap_Set_Font,1,32,"Arial","0");
				//add text
				ApAddTextEx(id,200,200,"First page",RGB(255,0,0));
				//close the page
				ApSetFunction(id,Ap_Set_NewOrClosePage,0,0,"0","0");

				ApClose(id);
			}
		
		}

//**************************************************************************************
		private void  Composition()
		{			
			int id,width,height;
			String strPDF = "Composition.pdf";

			id = ApCreate(strPDF);
			if(id > 0)
			{
				String strTemp = "this is a sample! this is a sample! this is a sample! this is a sample!";

				//set document info
				ApAddInfo(id,"Title","Subject","Author","Keywords","Creator");
				//set encryption 
				ApSetFunction(id,Ap_Set_Encrypt,128,permission_Print + permission_Copy + permission_Modify,"owner",null);
				//set preferences for acrobat reader
				//thumbnail images visible.
				ApSetFunction(id,Ap_Set_ViewerPreferences,4,0,"0","0");

				//set page orientation
				ApSetFunction(id,Ap_Set_pageOrientation,90,0,"0","0");

				//create a page for A3
				ApSetFunction(id,Ap_Set_NewOrClosePage,1,1,"0","0");
				//add bookmark
				ApSetFunction(id,Ap_Set_BookMark,0,0,"bookmark one","0");
				//set system font and size
				ApSetFunction(id,Ap_Set_Font,1,48,"Helvetica","0");
				//add text
				ApAddTextEx(id,200,200,"this is a sample!",RGB(255,255,0));
				//close the page
				ApSetFunction(id,Ap_Set_NewOrClosePage,0,0,"0","0");

				//restore page orientation
				ApSetFunction(id,Ap_Set_pageOrientation,0,0,"0","0");
		
				//create a page for A4
				ApSetFunction(id,Ap_Set_NewOrClosePage,2,2,"0","0");
				//add bookmark
				ApSetFunction(id,Ap_Set_BookMark,0,0,"bookmark two","0");	
				//set font and size
				ApSetFunction(id,Ap_Set_Font,203,32,"0","0");
				//add text for rect
				width =400;
				height=200;
				ApAddText(id,100,100,width,height,strTemp,RGB(0,0,255),RGB(255,0,255),Ap_DT_WORDBREAK|Ap_DT_CENTER); 
				//close the page
				ApSetFunction(id,Ap_Set_NewOrClosePage,0,0,"0","0");
		
				//create a page for B5
				ApSetFunction(id,Ap_Set_NewOrClosePage,4,4,"0","0");
				//add bookmark
				ApSetFunction(id,Ap_Set_BookMark,0,0,"bookmark three","0");
				//add graphic
				ApAddLine(id,10,10,100,200,5,RGB(0,0,255));
				ApAddRect(id,20,210,300,400,3,RGB(0,255,0),1,RGB(255,0,255));
				//close the page
				ApSetFunction(id,Ap_Set_NewOrClosePage,0,0,"0","0");
				ApClose(id);
			}
		}
//**************************************************************************************
		private System.Windows.Forms.Button button1;
		/// <summary>
		/// 
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// 
			//
			InitializeComponent();

			//
			// TODO:  InitializeComponent
			//
		}

		/// <summary>
		/// 
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// ֧ķ - Ҫʹô༭޸
		/// ˷ݡ
		/// </summary>
		private void InitializeComponent()
		{
			this.button1 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(72, 112);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(136, 40);
			this.button1.TabIndex = 0;
			this.button1.Text = "button1";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 14);
			this.ClientSize = new System.Drawing.Size(292, 273);
			this.Controls.Add(this.button1);
			this.Name = "Form1";
			this.Text = "Form1";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// 
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
		
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			Info();    
			Security();
			Bookmark(); 
			Append();    
			Composition();
		}
	}
}
