unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  apCreate = function(pFileName:PChar  ): Longint	; stdcall	;
  apOpen = function(pFileName:PChar  ): Longint	; stdcall	;
  apClose = procedure(id:Longint ); stdcall ;

  apAddInfo = function(id:Longint;Title:PChar;Subject:PChar;Author:PChar;Keyword:PChar;Creator:PChar):Longint;stdcall;
  apSetFunction = function(id:Longint;func_code:Longint;
                             para1:Longint;para2:Longint;para3:PChar ;para4:PChar ): Longint	; stdcall	;
  apGetFunction = function(id:Longint;func_code:Longint;
                             para1:Longint;para2:Longint;para3:PChar ;para4:PChar ): Longint	; stdcall	;

  apAddText = function(id:Longint;x:Longint;y:Longint;width:Longint;height:Longint;
                      str:PChar;color:Longint;bkcolor:Longint;lFormat:Longint):Longint;stdcall;

  apAddTextEx= function(id:Longint;x:Longint;y:Longint;str:PChar;color:Longint):Longint;stdcall;

  apAddTxt = function (id:Longint;filename:PChar;color:Longint;
                        PageWidth:Longint;PageHeight:Longint;AutoNewLine:Longint;AutoWidthAdjust:Longint;
						            LeftMargin:Longint;RightMargin:Longint;TopMargin:Longint;BottomMargin:Longint;
						            TabSize:Longint):Longint;stdcall;

  apAddLine = function (id:Longint;sx:Longint;sy:Longint;ex:Longint;ey:Longint;width:Longint;color:Longint):Longint;stdcall;

  apAddRect = function(id:Longint;sx:Longint;sy:Longint;ex:Longint;ey:Longint;
							          side_width:Longint;side_color:Longint;
							          flagFill:Longint;fill_color:Longint):Longint;stdcall;

const
//define for ApSetFunction
Ap_Set_Encrypt 				  : Longint = 105 ;
Ap_Set_Font					    : Longint = 106 ;
Ap_Set_NewOrClosePage	  : Longint = 109 ;
Ap_Set_BookMark				  : Longint = 110 ;
Ap_Set_ViewerPreferences: Longint = 121 ;
Ap_Set_pageOrientation  : Longint = 122 ;


//define for ApGetFunction
Ap_Get_PdfPageCount			  : Longint = 206 ;
Ap_Get_PdfCurrentPageSize	: Longint = 209 ;
Ap_Get_StringWidth			  : Longint = 250 ;
Ap_Get_StringHeight			  : Longint = 251 ;

//define for ApAddText
Ap_DT_LEFT			: Longint = 0 ;
Ap_DT_CENTER		: Longint = 1 ;
Ap_DT_RIGHT			: Longint = 2 ;
Ap_DT_WORDBREAK	: Longint = 16;   //0x10 ;
Ap_DT_CALCRECT	: Longint = 1024; //0x400 ;
Ap_DT_CALCRECTEX: Longint = 2048; //0x800 ;

//set password and permission
permission_Print	: Longint = 1 ;
permission_Copy		: Longint = 2 ;
permission_Modify	: Longint = 4 ;


var
  Form1: TForm1;

  g_hapW : HMODULE	;
  pApCreate: apCreate;
  pApOpen: apOpen ;
  pApClose: apClose ;
  pApAddInfo: apAddInfo;
  pApSetFunction: apSetFunction ;
  pApGetFunction: apGetFunction ;
  pApAddText: apAddText ;
  pApAddTextEx: apAddTextEx;
  pApAddTxt: apAddTxt;
  pApAddLine: apAddLine ;
  pApAddRect: apAddRect;

implementation

{$R *.dfm}


//****************************************************************************

function FreeDll() : Boolean;
begin
	if(g_hapW = 0) then begin
		FreeDll:=False;
    Exit;
  end;
	FreeLibrary(g_hapW);
	g_hapW:=0;
  Result:=True;
end;
//****************************************************************************
function  LoadDll :Boolean ;
var
  path:PAnsiChar ;
  proc :FARPROC ;
label
  Failer;

begin
  path := 'texttopdf.dll';
  g_hapW :=LoadLibrary(path);
	if(g_hapW=0) then
		goto Failer;

	proc:=GetProcAddress(g_hapW,'apCreate');
	if(proc=nil)then
		goto Failer;
  pApCreate:=proc ;
	proc:=GetProcAddress(g_hapW,'apOpen');
	if(proc=nil)then
		goto Failer;
  pApOpen:=proc ;
  proc:=GetProcAddress(g_hapW,'apClose');
	if(proc=nil)then
		goto Failer;
  pApClose:=proc ;
  proc:=GetProcAddress(g_hapW,'apAddInfo');
	if(proc=nil)then
		goto Failer;
  pApAddInfo:=proc ;
  proc:=GetProcAddress(g_hapW,'apSetFunction');
	if(proc=nil)then
		goto Failer;
  pApSetFunction:=proc ;
  proc:=GetProcAddress(g_hapW,'apGetFunction');
	if(proc=nil)then
		goto Failer;
  pApGetFunction:=proc ;
  proc:=GetProcAddress(g_hapW,'apAddText');
	if(proc=nil)then
		goto Failer;
  pApAddText:=proc ;
  proc:=GetProcAddress(g_hapW,'apAddTextEx');
	if(proc=nil)then
		goto Failer;
  pApAddTextEx:=proc ;
  proc:=GetProcAddress(g_hapW,'apAddTxt');
	if(proc=nil)then
		goto Failer;
  pApAddTxt:=proc ;
  proc:=GetProcAddress(g_hapW,'apAddLine');
	if(proc=nil)then
		goto Failer;
  pApAddLine:=proc ;
  proc:=GetProcAddress(g_hapW,'apAddRect');
	if(proc=nil)then
		goto Failer;
  pApAddRect:=proc ;

  Result:=True;
  Exit;

  Failer:
    FreeDll();
    Result:=False;
end;
//**************************************************************************************
procedure Info();
var
	id:Longint;
  szPDFFile:PChar;
  szTxtFile:PChar;
begin
	szPDFFile:='Information.pdf';
  id:=pApCreate(szPDFFile);
	if( id >0 )then
	begin
    //Note: set document info
		pApAddInfo(id,'Title','Subject','Author','Keywords','Creator');

		//add text file to pdf
		szTxtFile := 'test.txt';
		pApSetFunction(id,Ap_Set_Font,200,16,0,0);
		pApAddTxt(id,szTxtFile,0,0,0,1,1,64,64,64,64,4);

		pApClose(id);
	end;
end;
//**************************************************************************************
procedure Security();
var
	id:Longint;
	szPDFFile:PChar;
	szTxtFile:PChar;
begin
	szPDFFile:='Security.pdf';
  id:=pApCreate(szPDFFile);
	if( id >0 ) then
	begin
    //Note: set encryption
		pApSetFunction(id,Ap_Set_Encrypt,128,permission_Print + permission_Copy + permission_Modify,'owner','user');
		//add text file to pdf
		szTxtFile := 'test.txt';
		pApSetFunction(id,Ap_Set_Font,200,16,0,0);
		pApAddTxt(id,szTxtFile,0,0,0,1,1,64,64,64,64,4);
		pApClose(id);
	end;
end;
//**************************************************************************************
procedure Bookmark();
var
	id:Longint;
	szPDFFile:PChar;
  szTxtFile:PChar;
begin
	szPDFFile:='Bookmark.pdf';
  id:=pApCreate(szPDFFile);
	if( id >0 )then
	begin
    //create a page for A3
		pApSetFunction(id,Ap_Set_NewOrClosePage,1,1,0,0);
		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,'bookmark one',0);
		//set system font and size
		pApSetFunction(id,Ap_Set_Font,1,48,'Arial',0);
		//add text
		pApAddTextEx(id,200,200,'this is a sample!',RGB(0,255,255));
		//close the page
		pApSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);


		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,'bookmark two',0);
		//add text file to pdf
		szTxtFile := 'test.txt';
		pApSetFunction(id,Ap_Set_Font,200,16,0,0);
		pApAddTxt(id,szTxtFile,0,0,0,1,1,64,64,64,64,4);

		pApClose(id);
	end;
end;
//**************************************************************************************
procedure Append() ;
var
	id:Longint;
	szPDFFile:PChar;
begin
	szPDFFile:='Append.pdf';
  id:=pApOpen(szPDFFile);
	if( id >0 ) then     	//Append PDF file
	  begin
		  //create a page for A4
		  pApSetFunction(id,Ap_Set_NewOrClosePage,2,2,0,0);
		  //set system font and size
		  pApSetFunction(id,Ap_Set_Font,1,32,'Arial',0);
		  //add text
		  pApAddTextEx(id,200,200,'Appended page',RGB(255,0,0));
		  //close the page
		  pApSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);

		  pApClose(id);
    end
	else
    begin         	    
      id:=pApCreate(szPDFFile);
	    if( id >0 ) then       //Create new PDF file
	    begin
		    //create a page for A4
		    pApSetFunction(id,Ap_Set_NewOrClosePage,2,2,0,0);
		    //set system font and size
		    pApSetFunction(id,Ap_Set_Font,1,32,'Arial',0);
		    //add text
		    pApAddTextEx(id,200,200,'First page',RGB(255,0,0));
		    //close the page
		    pApSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);

		    pApClose(id);
	    end;
  end;
end;
//**************************************************************************************  
procedure Composition() ;
var
	id:Longint;
  width:longint;
  height:longint;
	szPDFFile:pchar;
  SZTextFile:pchar;
begin
	szPDFFile :='Composition.pdf';
  id:=pApCreate(szPDFFile);
	if( id >0 ) then
	begin
    SZTextFile := 'this is a sample! this is a sample! this is a sample! this is a sample!';
    //set document info
		pApAddInfo(id,'Title','Subject','Author','Keywords','Creator');
		//set encryption
		pApSetFunction(id,Ap_Set_Encrypt,128,permission_Print + permission_Copy + permission_Modify,'owner',0);
		//set preferences for acrobat reader
		//thumbnail images visible.
		pApSetFunction(id,Ap_Set_ViewerPreferences,4,0,0,0);

		//set page orientation
		pApSetFunction(id,Ap_Set_pageOrientation,90,0,0,0);

		//create a page for A3
		pApSetFunction(id,Ap_Set_NewOrClosePage,1,1,0,0);
		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,'bookmark one',0);
		//set system font and size
		pApSetFunction(id,Ap_Set_Font,1,48,'Helvetica',0);
		//add text
		pApAddTextEx(id,200,200,'this is a sample!',RGB(255,255,0));
		//close the page
		pApSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);

		//restore page orientation
		pApSetFunction(id,Ap_Set_pageOrientation,0,0,0,0);

		//create a page for A4
		pApSetFunction(id,Ap_Set_NewOrClosePage,2,2,0,0);
		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,'bookmark two',0);
		//set font and size
		pApSetFunction(id,Ap_Set_Font,203,32,0,0);
		//add text for rect
		width :=400;
		height:=200;
		pApAddText(id,100,100,width,height,SZTextFile,RGB(0,0,255),RGB(255,0,255),Ap_DT_WORDBREAK or Ap_DT_CENTER);
		//close the page
		pApSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);

		//create a page for B5
		pApSetFunction(id,Ap_Set_NewOrClosePage,4,4,0,0);
		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,'bookmark three',0);
		//add graphic
		pApAddLine(id,10,10,100,200,5,RGB(0,0,255));
		pApAddRect(id,20,210,300,400,3,RGB(0,255,0),1,RGB(255,0,255));
		//close the page
		pApSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);

		pApClose(id);
	end;
end;
//**************************************************************************************
procedure TForm1.Button1Click(Sender: TObject);
var
  szImageFile : PChar ;
begin

  if( LoadDll() = True ) then
  begin


	  Info();

	  Security();

	  Bookmark();

    Append();

    Composition();

    FreeDll();
  end;

end;

end.
