//**************************************************************************************
#include <stdio.h>
#include <Windows.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <windowsx.h> 
//**************************************************************************************
//define for ApSetFunction
#define Ap_Set_Encrypt 				105
#define Ap_Set_Font					106
#define Ap_Set_NewOrClosePage		109
#define Ap_Set_BookMark				110
#define Ap_Set_ViewerPreferences	121
#define Ap_Set_pageOrientation		122


//define for ApGetFunction
#define Ap_Get_PdfPageCount			206
#define Ap_Get_PdfCurrentPageSize	209
#define Ap_Get_StringWidth			250
#define Ap_Get_StringHeight			251

//define for ApAddText
#define Ap_DT_LEFT			0
#define Ap_DT_CENTER		1
#define Ap_DT_RIGHT			2
#define Ap_DT_WORDBREAK		0x10
#define Ap_DT_CALCRECT		0x400
#define Ap_DT_CALCRECTEX    0X800

//set password and permission
#define permission_Print	1
#define permission_Copy		2
#define permission_Modify	4

//**************************************************************************************
typedef long	(__stdcall *apCreate)(char *);
typedef long	(__stdcall *apOpen)(char *);
typedef void	(__stdcall *apClose)(long);
typedef long	(__stdcall *apAddInfo)(long,char*,char*,char*,char*,char*);
typedef long	(__stdcall *apSetFunction)(long,long func_code,long para1,long para2,char *para3,char *para4);
typedef long	(__stdcall *apGetFunction)(long,long func_code,long para1,long para2,char *para3,char *para4);

typedef long	(__stdcall *apAddTextEx)(long,long,long,char *,long );
typedef long	(__stdcall *apAddText)(long,long,long,long,long,char *,long ,long,long);
typedef long	(__stdcall *apAddTxt)(long id,char *szTxtName,long color,
						   long width,long height,long AutoNewLine,long AutoWidthAdjust,
						   long LeftMargin,long RightMargin,long TopMargin,long BottomMargin,
						   long TabSize);

typedef long	(__stdcall *apAddLine)  (long ,long ,long ,long ,long ,long ,long );
typedef long	(__stdcall *apAddRect  )(long ,long ,long ,long ,long ,long ,long ,long ,long );

//**************************************************************************************
HMODULE				g_hApW=NULL;

apCreate			pApCreate;
apOpen			    pApOpen;
apClose			    pApClose;	
apAddInfo			pApAddInfo;	
apSetFunction		pApSetFunction;
apGetFunction		pApGetFunction;
apAddTextEx		    pApAddTextEx;
apAddText			pApAddText;
apAddTxt			pApAddTxt;
apAddLine			pApAddLine;
apAddRect			pApAddRect;

//**************************************************************************************
void	GetModulePath(char *out_path,char *in_name);
BOOL	LoadDll(void);
void	FreeDll();
//**************************************************************************************


void GetModulePath(char *out_path,char *in_name)
{
	char *p;
	GetModuleFileName(NULL,out_path,256);
	p =strrchr(out_path,'\\');
	p[1]=0;
	strcat(out_path,in_name);
}
//**************************************************************************************


BOOL LoadDll()
{
	char path[_MAX_PATH];
	GetModulePath(path,"texttopdf.dll");
	g_hApW=LoadLibrary(path);
	if(g_hApW==NULL)
		goto Failer;

	pApCreate=(apCreate)GetProcAddress(g_hApW,"apCreate");
	if(pApCreate==NULL)
		goto Failer;
	pApOpen=(apOpen)GetProcAddress(g_hApW,"apOpen");
	if(pApOpen==NULL)
		goto Failer;
	pApClose=(apClose)GetProcAddress(g_hApW,"apClose");
	if(pApClose==NULL)
		goto Failer;
	pApAddInfo=(apAddInfo)GetProcAddress(g_hApW,"apAddInfo");
	if(pApAddInfo==NULL)
		goto Failer;
	pApSetFunction=(apSetFunction)GetProcAddress(g_hApW,"apSetFunction");
	if(pApSetFunction==NULL)
		goto Failer;
	pApGetFunction=(apGetFunction)GetProcAddress(g_hApW,"apGetFunction");
	if(pApGetFunction==NULL)
		goto Failer;
	pApAddTextEx=(apAddTextEx)GetProcAddress(g_hApW,"apAddTextEx");
	if(pApAddTextEx==NULL)
		goto Failer;
	pApAddText=(apAddText)GetProcAddress(g_hApW,"apAddText");
	if(pApAddText==NULL)
		goto Failer;
	pApAddTxt=(apAddTxt)GetProcAddress(g_hApW,"apAddTxt");
	if(pApAddTxt==NULL)
		goto Failer;
	pApAddLine=(apAddLine)GetProcAddress(g_hApW,"apAddLine");
	if(pApAddLine==NULL)
		goto Failer;
	pApAddRect=(apAddRect)GetProcAddress(g_hApW,"apAddRect");
	if(pApAddRect==NULL)
		goto Failer;
	return TRUE;
Failer:
	FreeDll(); 
	return FALSE;

}
//**************************************************************************************

void FreeDll()
{
	if(g_hApW==NULL)
		return ;
	FreeLibrary(g_hApW);
	g_hApW=NULL;
}

//**************************************************************************************

void Info()
{
	long id;
	char szPDFFile[256];
	char szImageFile[256];
	memset(szPDFFile,0,256);
	memset(szImageFile,0,256);

	GetModulePath(szPDFFile,"Information.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		//Note: set document info
		pApAddInfo(id,"Title","Subject","Author","Keywords","Creator");
		//add text file to pdf 
		GetModulePath(szImageFile,"test.txt");
		pApSetFunction(id,Ap_Set_Font,200,16,0,0);
		pApAddTxt(id,szImageFile,0,0,0,1,1,64,64,64,64,4);

		pApClose(id);
	}
	
}
//**************************************************************************************

void Security()
{
	long id;
	char szPDFFile[256];
	char szImageFile[256];
	memset(szPDFFile,0,256);
	memset(szImageFile,0,256);

	GetModulePath(szPDFFile,"Security.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		//Note: set encryption
		pApSetFunction(id,Ap_Set_Encrypt,128,permission_Print + permission_Copy + permission_Modify,"owner","user");
		//add text file to pdf 
		GetModulePath(szImageFile,"test.txt");
		pApSetFunction(id,Ap_Set_Font,200,16,0,0);
		pApAddTxt(id,szImageFile,0,0,0,1,1,64,64,64,64,4);

		pApClose(id);
	}

}

//**************************************************************************************


void Bookmark()
{
	long id;
	char szPDFFile[256];
	char szImageFile[256];
	memset(szPDFFile,0,256);
	memset(szImageFile,0,256);

	GetModulePath(szPDFFile,"Bookmark.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		
		//create a page for A3
		pApSetFunction(id,Ap_Set_NewOrClosePage,1,1,0,0);
		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,"bookmark one",0);
		//set system font and size
		pApSetFunction(id,Ap_Set_Font,1,48,"Arial",0);
		//add text
		pApAddTextEx(id,200,200,"this is a sample!",RGB(0,255,255));
		//close the page
		pApSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);
		

		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,"bookmark two",0);
		//add text file to pdf 
		GetModulePath(szImageFile,"test.txt");
		pApSetFunction(id,Ap_Set_Font,200,16,0,0);
		pApAddTxt(id,szImageFile,0,0,0,1,1,64,64,64,64,4);

		pApClose(id);
	}

}

//**************************************************************************************
void Append()
{
	long id;
	char szPDFFile[256];
	memset(szPDFFile,0,256);

	GetModulePath(szPDFFile,"Append.pdf");
	
	if( (id=pApOpen(szPDFFile)) >0 )	//Append PDF file
	{
		//create a page for A4
		pApSetFunction(id,Ap_Set_NewOrClosePage,2,2,0,0);
		//set system font and size
		pApSetFunction(id,Ap_Set_Font,1,32,"Arial",0);
		//add text
		pApAddTextEx(id,200,200,"Appended page",RGB(255,0,0));
		//close the page
		pApSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);

		pApClose(id);
	}else
	if( (id=pApCreate(szPDFFile)) >0 )	//Create new PDF file
	{
		//create a page for A4
		pApSetFunction(id,Ap_Set_NewOrClosePage,2,2,0,0);
		//set system font and size
		pApSetFunction(id,Ap_Set_Font,1,32,"Arial",0);
		//add text
		pApAddTextEx(id,200,200,"First page",RGB(255,0,0));
		//close the page
		pApSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);

		pApClose(id);
	}
		
}

//**************************************************************************************


void Composition()
{

	long id,width,height;
	char szPDFFile[256];
	memset(szPDFFile,0,256);

	GetModulePath(szPDFFile,"Composition.pdf");
	if( (id=pApCreate(szPDFFile)) >0 )
	{
		char string[]="this is a sample! this is a sample! this is a sample! this is a sample!";

		//set document info
		pApAddInfo(id,"Title","Subject","Author","Keywords","Creator");
		//set encryption 
		pApSetFunction(id,Ap_Set_Encrypt,128,permission_Print + permission_Copy + permission_Modify,"owner",0);
		//set preferences for acrobat reader
		//thumbnail images visible.
		pApSetFunction(id,Ap_Set_ViewerPreferences,4,0,0,0);

		//set page orientation
		pApSetFunction(id,Ap_Set_pageOrientation,90,0,0,0);

		//create a page for A3
		pApSetFunction(id,Ap_Set_NewOrClosePage,1,1,0,0);
		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,"bookmark one",0);
		//set system font and size
		pApSetFunction(id,Ap_Set_Font,1,48,"Helvetica",0);
		//add text
		pApAddTextEx(id,200,200,"this is a sample!",RGB(255,255,0));
		//close the page
		pApSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);

		//restore page orientation
		pApSetFunction(id,Ap_Set_pageOrientation,0,0,0,0);
		
		//create a page for A4
		pApSetFunction(id,Ap_Set_NewOrClosePage,2,2,0,0);
		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,"bookmark two",0);	
		//set font and size
		pApSetFunction(id,Ap_Set_Font,203,32,0,0);
		//add text for rect
		width =400;
		height=200;
		pApAddText(id,100,100,width,height,string,RGB(0,0,255),RGB(255,0,255),Ap_DT_WORDBREAK|Ap_DT_CENTER); 
		//close the page
		pApSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);
		
		//create a page for B5
		pApSetFunction(id,Ap_Set_NewOrClosePage,4,4,0,0);
		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,"bookmark three",0);
		//add graphic
		pApAddLine(id,10,10,100,200,5,RGB(0,0,255));
		pApAddRect(id,20,210,300,400,3,RGB(0,255,0),1,RGB(255,0,255));
		//close the page
		pApSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);

		pApClose(id);

	}
}


//**************************************************************************************

void main()
{

	if(!LoadDll())
		return ;

	Info();

	Security();

	Bookmark();
	
	Append();

	Composition();

	FreeDll();

	return ;

}