unit ShockwaveFlashObjects_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ Shockwave Flash }
{ Version 1.0 }

{ Conversion log:
  Warning: 'label' is a reserved word. Parameter 'label' in IShockwaveFlash.TGotoLabel changed to 'label_'
  Warning: 'property' is a reserved word. Parameter 'property' in IShockwaveFlash.TSetProperty changed to 'property_'
  Warning: 'property' is a reserved word. Parameter 'property' in IShockwaveFlash.TGetProperty changed to 'property_'
  Warning: 'label' is a reserved word. Parameter 'label' in IShockwaveFlash.TCallLabel changed to 'label_'
  Warning: 'property' is a reserved word. Parameter 'property' in IShockwaveFlash.TSetPropertyNum changed to 'property_'
  Warning: 'property' is a reserved word. Parameter 'property' in IShockwaveFlash.TGetPropertyNum changed to 'property_'
  Warning: 'property' is a reserved word. Parameter 'property' in IShockwaveFlash.TGetPropertyAsNumber changed to 'property_'
 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_ShockwaveFlashObjects: TGUID = '{D27CDB6B-AE6D-11CF-96B8-444553540000}';

const

{ Component class GUIDs }
  Class_ShockwaveFlash: TGUID = '{D27CDB6E-AE6D-11CF-96B8-444553540000}';
  Class_FlashObjectInterface: TGUID = '{D27CDB71-AE6D-11CF-96B8-444553540000}';

type

{ Forward declarations: Interfaces }
  IShockwaveFlash = interface;
  IShockwaveFlashDisp = dispinterface;
  _IShockwaveFlashEvents = dispinterface;
  IFlashFactory = interface;
  IFlashObjectInterface = interface;
  IDispatchEx = interface;
  IServiceProvider = interface;

{ Forward declarations: CoClasses }
  ShockwaveFlash = IShockwaveFlash;
  FlashObjectInterface = IFlashObjectInterface;

{ Shockwave Flash }

  IShockwaveFlash = interface(IDispatch)
    ['{D27CDB6C-AE6D-11CF-96B8-444553540000}']
    function Get_ReadyState: Integer; safecall;
    function Get_TotalFrames: Integer; safecall;
    function Get_Playing: WordBool; safecall;
    procedure Set_Playing(Value: WordBool); safecall;
    function Get_Quality: SYSINT; safecall;
    procedure Set_Quality(Value: SYSINT); safecall;
    function Get_ScaleMode: SYSINT; safecall;
    procedure Set_ScaleMode(Value: SYSINT); safecall;
    function Get_AlignMode: SYSINT; safecall;
    procedure Set_AlignMode(Value: SYSINT); safecall;
    function Get_BackgroundColor: Integer; safecall;
    procedure Set_BackgroundColor(Value: Integer); safecall;
    function Get_Loop: WordBool; safecall;
    procedure Set_Loop(Value: WordBool); safecall;
    function Get_Movie: WideString; safecall;
    procedure Set_Movie(const Value: WideString); safecall;
    function Get_FrameNum: Integer; safecall;
    procedure Set_FrameNum(Value: Integer); safecall;
    procedure SetZoomRect(left, top, right, bottom: Integer); safecall;
    procedure Zoom(factor: SYSINT); safecall;
    procedure Pan(x, y: Integer; mode: SYSINT); safecall;
    procedure Play; safecall;
    procedure Stop; safecall;
    procedure Back; safecall;
    procedure Forward; safecall;
    procedure Rewind; safecall;
    procedure StopPlay; safecall;
    procedure GotoFrame(FrameNum: Integer); safecall;
    function CurrentFrame: Integer; safecall;
    function IsPlaying: WordBool; safecall;
    function PercentLoaded: Integer; safecall;
    function FrameLoaded(FrameNum: Integer): WordBool; safecall;
    function FlashVersion: Integer; safecall;
    function Get_WMode: WideString; safecall;
    procedure Set_WMode(const Value: WideString); safecall;
    function Get_SAlign: WideString; safecall;
    procedure Set_SAlign(const Value: WideString); safecall;
    function Get_Menu: WordBool; safecall;
    procedure Set_Menu(Value: WordBool); safecall;
    function Get_Base: WideString; safecall;
    procedure Set_Base(const Value: WideString); safecall;
    function Get_Scale: WideString; safecall;
    procedure Set_Scale(const Value: WideString); safecall;
    function Get_DeviceFont: WordBool; safecall;
    procedure Set_DeviceFont(Value: WordBool); safecall;
    function Get_EmbedMovie: WordBool; safecall;
    procedure Set_EmbedMovie(Value: WordBool); safecall;
    function Get_BGColor: WideString; safecall;
    procedure Set_BGColor(const Value: WideString); safecall;
    function Get_Quality2: WideString; safecall;
    procedure Set_Quality2(const Value: WideString); safecall;
    procedure LoadMovie(layer: SYSINT; const url: WideString); safecall;
    procedure TGotoFrame(const target: WideString; FrameNum: Integer); safecall;
    procedure TGotoLabel(const target, label_: WideString); safecall;
    function TCurrentFrame(const target: WideString): Integer; safecall;
    function TCurrentLabel(const target: WideString): WideString; safecall;
    procedure TPlay(const target: WideString); safecall;
    procedure TStopPlay(const target: WideString); safecall;
    procedure SetVariable(const name, value: WideString); safecall;
    function GetVariable(const name: WideString): WideString; safecall;
    procedure TSetProperty(const target: WideString; property_: SYSINT; const value: WideString); safecall;
    function TGetProperty(const target: WideString; property_: SYSINT): WideString; safecall;
    procedure TCallFrame(const target: WideString; FrameNum: SYSINT); safecall;
    procedure TCallLabel(const target, label_: WideString); safecall;
    procedure TSetPropertyNum(const target: WideString; property_: SYSINT; value: Double); safecall;
    function TGetPropertyNum(const target: WideString; property_: SYSINT): Double; safecall;
    function TGetPropertyAsNumber(const target: WideString; property_: SYSINT): Double; safecall;
    function Get_SWRemote: WideString; safecall;
    procedure Set_SWRemote(const Value: WideString); safecall;
    function Get_FlashVars: WideString; safecall;
    procedure Set_FlashVars(const Value: WideString); safecall;
    function Get_AllowScriptAccess: WideString; safecall;
    procedure Set_AllowScriptAccess(const Value: WideString); safecall;
    function Get_MovieData: WideString; safecall;
    procedure Set_MovieData(const Value: WideString); safecall;
    function Get_InlineData: IUnknown; safecall;
    procedure Set_InlineData(Value: IUnknown); safecall;
    function Get_SeamlessTabbing: WordBool; safecall;
    procedure Set_SeamlessTabbing(Value: WordBool); safecall;
    procedure EnforceLocalSecurity; safecall;
    function Get_Profile: WordBool; safecall;
    procedure Set_Profile(Value: WordBool); safecall;
    function Get_ProfileAddress: WideString; safecall;
    procedure Set_ProfileAddress(const Value: WideString); safecall;
    function Get_ProfilePort: Integer; safecall;
    procedure Set_ProfilePort(Value: Integer); safecall;
    function CallFunction(const request: WideString): WideString; safecall;
    procedure SetReturnValue(const returnValue: WideString); safecall;
    procedure DisableLocalSecurity; safecall;
    function Get_AllowNetworking: WideString; safecall;
    procedure Set_AllowNetworking(const Value: WideString); safecall;
    function Get_AllowFullScreen: WideString; safecall;
    procedure Set_AllowFullScreen(const Value: WideString); safecall;
    property ReadyState: Integer read Get_ReadyState;
    property TotalFrames: Integer read Get_TotalFrames;
    property Playing: WordBool read Get_Playing write Set_Playing;
    property Quality: SYSINT read Get_Quality write Set_Quality;
    property ScaleMode: SYSINT read Get_ScaleMode write Set_ScaleMode;
    property AlignMode: SYSINT read Get_AlignMode write Set_AlignMode;
    property BackgroundColor: Integer read Get_BackgroundColor write Set_BackgroundColor;
    property Loop: WordBool read Get_Loop write Set_Loop;
    property Movie: WideString read Get_Movie write Set_Movie;
    property FrameNum: Integer read Get_FrameNum write Set_FrameNum;
    property WMode: WideString read Get_WMode write Set_WMode;
    property SAlign: WideString read Get_SAlign write Set_SAlign;
    property Menu: WordBool read Get_Menu write Set_Menu;
    property Base: WideString read Get_Base write Set_Base;
    property Scale: WideString read Get_Scale write Set_Scale;
    property DeviceFont: WordBool read Get_DeviceFont write Set_DeviceFont;
    property EmbedMovie: WordBool read Get_EmbedMovie write Set_EmbedMovie;
    property BGColor: WideString read Get_BGColor write Set_BGColor;
    property Quality2: WideString read Get_Quality2 write Set_Quality2;
    property SWRemote: WideString read Get_SWRemote write Set_SWRemote;
    property FlashVars: WideString read Get_FlashVars write Set_FlashVars;
    property AllowScriptAccess: WideString read Get_AllowScriptAccess write Set_AllowScriptAccess;
    property MovieData: WideString read Get_MovieData write Set_MovieData;
    property InlineData: IUnknown read Get_InlineData write Set_InlineData;
    property SeamlessTabbing: WordBool read Get_SeamlessTabbing write Set_SeamlessTabbing;
    property Profile: WordBool read Get_Profile write Set_Profile;
    property ProfileAddress: WideString read Get_ProfileAddress write Set_ProfileAddress;
    property ProfilePort: Integer read Get_ProfilePort write Set_ProfilePort;
    property AllowNetworking: WideString read Get_AllowNetworking write Set_AllowNetworking;
    property AllowFullScreen: WideString read Get_AllowFullScreen write Set_AllowFullScreen;
  end;

{ DispInterface declaration for Dual Interface IShockwaveFlash }

  IShockwaveFlashDisp = dispinterface
    ['{D27CDB6C-AE6D-11CF-96B8-444553540000}']
    property ReadyState: Integer readonly dispid -525;
    property TotalFrames: Integer readonly dispid 124;
    property Playing: WordBool dispid 125;
    property Quality: SYSINT dispid 105;
    property ScaleMode: SYSINT dispid 120;
    property AlignMode: SYSINT dispid 121;
    property BackgroundColor: Integer dispid 123;
    property Loop: WordBool dispid 106;
    property Movie: WideString dispid 102;
    property FrameNum: Integer dispid 107;
    procedure SetZoomRect(left, top, right, bottom: Integer); dispid 109;
    procedure Zoom(factor: SYSINT); dispid 118;
    procedure Pan(x, y: Integer; mode: SYSINT); dispid 119;
    procedure Play; dispid 112;
    procedure Stop; dispid 113;
    procedure Back; dispid 114;
    procedure Forward; dispid 115;
    procedure Rewind; dispid 116;
    procedure StopPlay; dispid 126;
    procedure GotoFrame(FrameNum: Integer); dispid 127;
    function CurrentFrame: Integer; dispid 128;
    function IsPlaying: WordBool; dispid 129;
    function PercentLoaded: Integer; dispid 130;
    function FrameLoaded(FrameNum: Integer): WordBool; dispid 131;
    function FlashVersion: Integer; dispid 132;
    property WMode: WideString dispid 133;
    property SAlign: WideString dispid 134;
    property Menu: WordBool dispid 135;
    property Base: WideString dispid 136;
    property Scale: WideString dispid 137;
    property DeviceFont: WordBool dispid 138;
    property EmbedMovie: WordBool dispid 139;
    property BGColor: WideString dispid 140;
    property Quality2: WideString dispid 141;
    procedure LoadMovie(layer: SYSINT; const url: WideString); dispid 142;
    procedure TGotoFrame(const target: WideString; FrameNum: Integer); dispid 143;
    procedure TGotoLabel(const target, label_: WideString); dispid 144;
    function TCurrentFrame(const target: WideString): Integer; dispid 145;
    function TCurrentLabel(const target: WideString): WideString; dispid 146;
    procedure TPlay(const target: WideString); dispid 147;
    procedure TStopPlay(const target: WideString); dispid 148;
    procedure SetVariable(const name, value: WideString); dispid 151;
    function GetVariable(const name: WideString): WideString; dispid 152;
    procedure TSetProperty(const target: WideString; property_: SYSINT; const value: WideString); dispid 153;
    function TGetProperty(const target: WideString; property_: SYSINT): WideString; dispid 154;
    procedure TCallFrame(const target: WideString; FrameNum: SYSINT); dispid 155;
    procedure TCallLabel(const target, label_: WideString); dispid 156;
    procedure TSetPropertyNum(const target: WideString; property_: SYSINT; value: Double); dispid 157;
    function TGetPropertyNum(const target: WideString; property_: SYSINT): Double; dispid 158;
    function TGetPropertyAsNumber(const target: WideString; property_: SYSINT): Double; dispid 172;
    property SWRemote: WideString dispid 159;
    property FlashVars: WideString dispid 170;
    property AllowScriptAccess: WideString dispid 171;
    property MovieData: WideString dispid 190;
    property InlineData: IUnknown dispid 191;
    property SeamlessTabbing: WordBool dispid 192;
    procedure EnforceLocalSecurity; dispid 193;
    property Profile: WordBool dispid 194;
    property ProfileAddress: WideString dispid 195;
    property ProfilePort: Integer dispid 196;
    function CallFunction(const request: WideString): WideString; dispid 198;
    procedure SetReturnValue(const returnValue: WideString); dispid 199;
    procedure DisableLocalSecurity; dispid 200;
    property AllowNetworking: WideString dispid 201;
    property AllowFullScreen: WideString dispid 202;
  end;

{ Event interface for Shockwave Flash }

  _IShockwaveFlashEvents = dispinterface
    ['{D27CDB6D-AE6D-11CF-96B8-444553540000}']
    procedure OnReadyStateChange(newState: Integer); dispid -609;
    procedure OnProgress(percentDone: Integer); dispid 1958;
    procedure FSCommand(const command, args: WideString); dispid 150;
    procedure FlashCall(const request: WideString); dispid 197;
  end;

{ IFlashFactory Interface }

  IFlashFactory = interface(IUnknown)
    ['{D27CDB70-AE6D-11CF-96B8-444553540000}']
  end;

  IDispatchEx = interface(IDispatch)
    ['{A6EF9860-C720-11D0-9337-00A0C90DCAA9}']
    function GetDispID(const bstrName: WideString; grfdex: UINT; out pid: Integer): HResult; stdcall;
    function RemoteInvokeEx(id: Integer; lcid, dwFlags: UINT; var pdp: TDispParams; out pvarRes: OleVariant; out pei: TExcepInfo; const pspCaller: IServiceProvider; cvarRefArg: SYSUINT; var rgiRefArg: SYSUINT; var rgvarRefArg: OleVariant): HResult; stdcall;
    function DeleteMemberByName(const bstrName: WideString; grfdex: UINT): HResult; stdcall;
    function DeleteMemberByDispID(id: Integer): HResult; stdcall;
    function GetMemberProperties(id: Integer; grfdexFetch: UINT; out pgrfdex: UINT): HResult; stdcall;
    function GetMemberName(id: Integer; out pbstrName: WideString): HResult; stdcall;
    function GetNextDispID(grfdex: UINT; id: Integer; out pid: Integer): HResult; stdcall;
    function GetNameSpaceParent(out ppunk: IUnknown): HResult; stdcall;
  end;

{ IFlashObjectInterface Interface }

  IFlashObjectInterface = interface(IDispatchEx)
    ['{D27CDB72-AE6D-11CF-96B8-444553540000}']
  end;

  IServiceProvider = interface(IUnknown)
    ['{6D5140C1-7436-11CE-8034-00AA006009FA}']
    function RemoteQueryService(var guidService, riid: TGUID; out ppvObject: IUnknown): HResult; stdcall;
  end;

{ IFlashObjectInterface Interface }

  CoFlashObjectInterface = class
    class function Create: IFlashObjectInterface;
    class function CreateRemote(const MachineName: string): IFlashObjectInterface;
  end;

{ Shockwave Flash }

  TShockwaveFlashOnReadyStateChange = procedure(Sender: TObject; newState: Integer) of object;
  TShockwaveFlashOnProgress = procedure(Sender: TObject; percentDone: Integer) of object;
  TShockwaveFlashFSCommand = procedure(Sender: TObject; const command, args: WideString) of object;
  TShockwaveFlashFlashCall = procedure(Sender: TObject; const request: WideString) of object;

  TShockwaveFlash = class(TOleControl)
  private
    FOnReadyStateChange: TShockwaveFlashOnReadyStateChange;
    FOnProgress: TShockwaveFlashOnProgress;
    FOnFSCommand: TShockwaveFlashFSCommand;
    FOnFlashCall: TShockwaveFlashFlashCall;
    FIntf: IShockwaveFlash;
    function GetControlInterface: IShockwaveFlash;
  protected
    procedure CreateControl;
    procedure InitControlData; override;
    function GetTOleEnumProp(Index: Integer): TOleEnum;
    procedure SetTOleEnumProp(Index: Integer; Value: TOleEnum);
  public
    procedure SetZoomRect(left, top, right, bottom: Integer);
    procedure Zoom(factor: SYSINT);
    procedure Pan(x, y: Integer; mode: SYSINT);
    procedure Play;
    procedure Stop;
    procedure Back;
    procedure Forward;
    procedure Rewind;
    procedure StopPlay;
    procedure GotoFrame(FrameNum: Integer);
    function CurrentFrame: Integer;
    function IsPlaying: WordBool;
    function PercentLoaded: Integer;
    function FrameLoaded(FrameNum: Integer): WordBool;
    function FlashVersion: Integer;
    procedure LoadMovie(layer: SYSINT; const url: WideString);
    procedure TGotoFrame(const target: WideString; FrameNum: Integer);
    procedure TGotoLabel(const target, label_: WideString);
    function TCurrentFrame(const target: WideString): Integer;
    function TCurrentLabel(const target: WideString): WideString;
    procedure TPlay(const target: WideString);
    procedure TStopPlay(const target: WideString);
    procedure SetVariable(const name, value: WideString);
    function GetVariable(const name: WideString): WideString;
    procedure TSetProperty(const target: WideString; property_: SYSINT; const value: WideString);
    function TGetProperty(const target: WideString; property_: SYSINT): WideString;
    procedure TCallFrame(const target: WideString; FrameNum: SYSINT);
    procedure TCallLabel(const target, label_: WideString);
    procedure TSetPropertyNum(const target: WideString; property_: SYSINT; value: Double);
    function TGetPropertyNum(const target: WideString; property_: SYSINT): Double;
    function TGetPropertyAsNumber(const target: WideString; property_: SYSINT): Double;
    procedure EnforceLocalSecurity;
    function CallFunction(const request: WideString): WideString;
    procedure SetReturnValue(const returnValue: WideString);
    procedure DisableLocalSecurity;
    property ControlInterface: IShockwaveFlash read GetControlInterface;
    property ReadyState: Integer index -525 read GetIntegerProp;
    property TotalFrames: Integer index 124 read GetIntegerProp;
  published
    property TabStop;
    property Align;
    property DragCursor;
    property DragMode;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property Visible;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnStartDrag;
    property Playing: WordBool index 125 read GetWordBoolProp write SetWordBoolProp stored False;
    property Quality: SYSINT index 105 read GetIntegerProp write SetIntegerProp stored False;
    property ScaleMode: SYSINT index 120 read GetIntegerProp write SetIntegerProp stored False;
    property AlignMode: SYSINT index 121 read GetIntegerProp write SetIntegerProp stored False;
    property BackgroundColor: Integer index 123 read GetIntegerProp write SetIntegerProp stored False;
    property Loop: WordBool index 106 read GetWordBoolProp write SetWordBoolProp stored False;
    property Movie: WideString index 102 read GetWideStringProp write SetWideStringProp stored False;
    property FrameNum: Integer index 107 read GetIntegerProp write SetIntegerProp stored False;
    property WMode: WideString index 133 read GetWideStringProp write SetWideStringProp stored False;
    property SAlign: WideString index 134 read GetWideStringProp write SetWideStringProp stored False;
    property Menu: WordBool index 135 read GetWordBoolProp write SetWordBoolProp stored False;
    property Base: WideString index 136 read GetWideStringProp write SetWideStringProp stored False;
    property Scale: WideString index 137 read GetWideStringProp write SetWideStringProp stored False;
    property DeviceFont: WordBool index 138 read GetWordBoolProp write SetWordBoolProp stored False;
    property EmbedMovie: WordBool index 139 read GetWordBoolProp write SetWordBoolProp stored False;
    property BGColor: WideString index 140 read GetWideStringProp write SetWideStringProp stored False;
    property Quality2: WideString index 141 read GetWideStringProp write SetWideStringProp stored False;
    property SWRemote: WideString index 159 read GetWideStringProp write SetWideStringProp stored False;
    property FlashVars: WideString index 170 read GetWideStringProp write SetWideStringProp stored False;
    property AllowScriptAccess: WideString index 171 read GetWideStringProp write SetWideStringProp stored False;
    property MovieData: WideString index 190 read GetWideStringProp write SetWideStringProp stored False;
    property InlineData: IUnknown index 191 read GetIUnknownProp write SetIUnknownProp stored False;
    property SeamlessTabbing: WordBool index 192 read GetWordBoolProp write SetWordBoolProp stored False;
    property Profile: WordBool index 194 read GetWordBoolProp write SetWordBoolProp stored False;
    property ProfileAddress: WideString index 195 read GetWideStringProp write SetWideStringProp stored False;
    property ProfilePort: Integer index 196 read GetIntegerProp write SetIntegerProp stored False;
    property AllowNetworking: WideString index 201 read GetWideStringProp write SetWideStringProp stored False;
    property AllowFullScreen: WideString index 202 read GetWideStringProp write SetWideStringProp stored False;
    property OnReadyStateChange: TShockwaveFlashOnReadyStateChange read FOnReadyStateChange write FOnReadyStateChange;
    property OnProgress: TShockwaveFlashOnProgress read FOnProgress write FOnProgress;
    property OnFSCommand: TShockwaveFlashFSCommand read FOnFSCommand write FOnFSCommand;
    property OnFlashCall: TShockwaveFlashFlashCall read FOnFlashCall write FOnFlashCall;
  end;

procedure Register;

implementation

uses ComObj;

class function CoFlashObjectInterface.Create: IFlashObjectInterface;
begin
  Result := CreateComObject(Class_FlashObjectInterface) as IFlashObjectInterface;
end;

class function CoFlashObjectInterface.CreateRemote(const MachineName: string): IFlashObjectInterface;
begin
  Result := CreateRemoteComObject(MachineName, Class_FlashObjectInterface) as IFlashObjectInterface;
end;

procedure TShockwaveFlash.InitControlData;
const
  CEventDispIDs: array[0..3] of Integer = (
    $FFFFFD9F, $000007A6, $00000096, $000000C5);
  CControlData: TControlData = (
    ClassID: '{D27CDB6E-AE6D-11CF-96B8-444553540000}';
    EventIID: '{D27CDB6D-AE6D-11CF-96B8-444553540000}';
    EventCount: 4;
    EventDispIDs: @CEventDispIDs;
    LicenseKey: nil;
    Flags: $00000000;
    Version: 300);
begin
  ControlData := @CControlData;
end;

procedure TShockwaveFlash.CreateControl;

  procedure DoCreate;
  begin
    FIntf := IUnknown(OleObject) as IShockwaveFlash;
  end;

begin
  if FIntf = nil then DoCreate;
end;

function TShockwaveFlash.GetControlInterface: IShockwaveFlash;
begin
  CreateControl;
  Result := FIntf;
end;

function TShockwaveFlash.GetTOleEnumProp(Index: Integer): TOleEnum;
begin
  Result := GetIntegerProp(Index);
end;

procedure TShockwaveFlash.SetTOleEnumProp(Index: Integer; Value: TOleEnum);
begin
  SetIntegerProp(Index, Value);
end;

procedure TShockwaveFlash.SetZoomRect(left, top, right, bottom: Integer);
begin
  CreateControl;
  FIntf.SetZoomRect(left, top, right, bottom);
end;

procedure TShockwaveFlash.Zoom(factor: SYSINT);
begin
  CreateControl;
  FIntf.Zoom(factor);
end;

procedure TShockwaveFlash.Pan(x, y: Integer; mode: SYSINT);
begin
  CreateControl;
  FIntf.Pan(x, y, mode);
end;

procedure TShockwaveFlash.Play;
begin
  CreateControl;
  FIntf.Play;
end;

procedure TShockwaveFlash.Stop;
begin
  CreateControl;
  FIntf.Stop;
end;

procedure TShockwaveFlash.Back;
begin
  CreateControl;
  FIntf.Back;
end;

procedure TShockwaveFlash.Forward;
begin
  CreateControl;
  FIntf.Forward;
end;

procedure TShockwaveFlash.Rewind;
begin
  CreateControl;
  FIntf.Rewind;
end;

procedure TShockwaveFlash.StopPlay;
begin
  CreateControl;
  FIntf.StopPlay;
end;

procedure TShockwaveFlash.GotoFrame(FrameNum: Integer);
begin
  CreateControl;
  FIntf.GotoFrame(FrameNum);
end;

function TShockwaveFlash.CurrentFrame: Integer;
begin
  CreateControl;
  Result := FIntf.CurrentFrame;
end;

function TShockwaveFlash.IsPlaying: WordBool;
begin
  CreateControl;
  Result := FIntf.IsPlaying;
end;

function TShockwaveFlash.PercentLoaded: Integer;
begin
  CreateControl;
  Result := FIntf.PercentLoaded;
end;

function TShockwaveFlash.FrameLoaded(FrameNum: Integer): WordBool;
begin
  CreateControl;
  Result := FIntf.FrameLoaded(FrameNum);
end;

function TShockwaveFlash.FlashVersion: Integer;
begin
  CreateControl;
  Result := FIntf.FlashVersion;
end;

procedure TShockwaveFlash.LoadMovie(layer: SYSINT; const url: WideString);
begin
  CreateControl;
  FIntf.LoadMovie(layer, url);
end;

procedure TShockwaveFlash.TGotoFrame(const target: WideString; FrameNum: Integer);
begin
  CreateControl;
  FIntf.TGotoFrame(target, FrameNum);
end;

procedure TShockwaveFlash.TGotoLabel(const target, label_: WideString);
begin
  CreateControl;
  FIntf.TGotoLabel(target, label_);
end;

function TShockwaveFlash.TCurrentFrame(const target: WideString): Integer;
begin
  CreateControl;
  Result := FIntf.TCurrentFrame(target);
end;

function TShockwaveFlash.TCurrentLabel(const target: WideString): WideString;
begin
  CreateControl;
  Result := FIntf.TCurrentLabel(target);
end;

procedure TShockwaveFlash.TPlay(const target: WideString);
begin
  CreateControl;
  FIntf.TPlay(target);
end;

procedure TShockwaveFlash.TStopPlay(const target: WideString);
begin
  CreateControl;
  FIntf.TStopPlay(target);
end;

procedure TShockwaveFlash.SetVariable(const name, value: WideString);
begin
  CreateControl;
  FIntf.SetVariable(name, value);
end;

function TShockwaveFlash.GetVariable(const name: WideString): WideString;
begin
  CreateControl;
  Result := FIntf.GetVariable(name);
end;

procedure TShockwaveFlash.TSetProperty(const target: WideString; property_: SYSINT; const value: WideString);
begin
  CreateControl;
  FIntf.TSetProperty(target, property_, value);
end;

function TShockwaveFlash.TGetProperty(const target: WideString; property_: SYSINT): WideString;
begin
  CreateControl;
  Result := FIntf.TGetProperty(target, property_);
end;

procedure TShockwaveFlash.TCallFrame(const target: WideString; FrameNum: SYSINT);
begin
  CreateControl;
  FIntf.TCallFrame(target, FrameNum);
end;

procedure TShockwaveFlash.TCallLabel(const target, label_: WideString);
begin
  CreateControl;
  FIntf.TCallLabel(target, label_);
end;

procedure TShockwaveFlash.TSetPropertyNum(const target: WideString; property_: SYSINT; value: Double);
begin
  CreateControl;
  FIntf.TSetPropertyNum(target, property_, value);
end;

function TShockwaveFlash.TGetPropertyNum(const target: WideString; property_: SYSINT): Double;
begin
  CreateControl;
  Result := FIntf.TGetPropertyNum(target, property_);
end;

function TShockwaveFlash.TGetPropertyAsNumber(const target: WideString; property_: SYSINT): Double;
begin
  CreateControl;
  Result := FIntf.TGetPropertyAsNumber(target, property_);
end;

procedure TShockwaveFlash.EnforceLocalSecurity;
begin
  CreateControl;
  FIntf.EnforceLocalSecurity;
end;

function TShockwaveFlash.CallFunction(const request: WideString): WideString;
begin
  CreateControl;
  Result := FIntf.CallFunction(request);
end;

procedure TShockwaveFlash.SetReturnValue(const returnValue: WideString);
begin
  CreateControl;
  FIntf.SetReturnValue(returnValue);
end;

procedure TShockwaveFlash.DisableLocalSecurity;
begin
  CreateControl;
  FIntf.DisableLocalSecurity;
end;


procedure Register;
begin
  RegisterComponents('ActiveX', [TShockwaveFlash]);
end;

end.
