unit WMPLib_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ Windows Media Player }
{ Version 1.0 }

{ Conversion log:
  Warning: 'type' is a reserved word. IWMPDownloadItem.type changed to type_
  Warning: 'type' is a reserved word. Parameter 'type' in IWMPCDDVDWizardExternal.WriteNamesEx changed to 'type_'
 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_WMPLib: TGUID = '{6BF52A50-394A-11D3-B153-00C04F79FAA6}';

const

{ WMP Playlist Change Event Type }

{ WMPPlaylistChangeEventType }

  wmplcUnknown = 0;
  wmplcClear = 1;
  wmplcInfoChange = 2;
  wmplcMove = 3;
  wmplcDelete = 4;
  wmplcInsert = 5;
  wmplcAppend = 6;
  wmplcPrivate = 7;
  wmplcNameChange = 8;
  wmplcMorph = 9;
  wmplcSort = 10;
  wmplcLast = 11;

{ State of opening process }

{ WMPOpenState }

  wmposUndefined = 0;
  wmposPlaylistChanging = 1;
  wmposPlaylistLocating = 2;
  wmposPlaylistConnecting = 3;
  wmposPlaylistLoading = 4;
  wmposPlaylistOpening = 5;
  wmposPlaylistOpenNoMedia = 6;
  wmposPlaylistChanged = 7;
  wmposMediaChanging = 8;
  wmposMediaLocating = 9;
  wmposMediaConnecting = 10;
  wmposMediaLoading = 11;
  wmposMediaOpening = 12;
  wmposMediaOpen = 13;
  wmposBeginCodecAcquisition = 14;
  wmposEndCodecAcquisition = 15;
  wmposBeginLicenseAcquisition = 16;
  wmposEndLicenseAcquisition = 17;
  wmposBeginIndividualization = 18;
  wmposEndIndividualization = 19;
  wmposMediaWaiting = 20;
  wmposOpeningUnknownURL = 21;

{ State of playback }

{ WMPPlayState }

  wmppsUndefined = 0;
  wmppsStopped = 1;
  wmppsPaused = 2;
  wmppsPlaying = 3;
  wmppsScanForward = 4;
  wmppsScanReverse = 5;
  wmppsBuffering = 6;
  wmppsWaiting = 7;
  wmppsMediaEnded = 8;
  wmppsTransitioning = 9;
  wmppsReady = 10;
  wmppsReconnecting = 11;
  wmppsLast = 12;

{ State of a download }

{ WMPSubscriptionDownloadState }

  wmpsdlsDownloading = 0;
  wmpsdlsPaused = 1;
  wmpsdlsProcessing = 2;
  wmpsdlsCompleted = 3;
  wmpsdlsCancelled = 4;

{ WMP_WRITENAMESEX_TYPE }

  WMP_WRITENAMES_TYPE_CD_BY_TOC = 0;
  WMP_WRITENAMES_TYPE_CD_BY_CONTENT_ID = 1;
  WMP_WRITENAMES_TYPE_CD_BY_MDQCD = 2;
  WMP_WRITENAMES_TYPE_DVD_BY_DVDID = 3;

const

{ Component class GUIDs }
  Class_WindowsMediaPlayer: TGUID = '{6BF52A52-394A-11D3-B153-00C04F79FAA6}';
  Class_WMPButtonCtrl: TGUID = '{87291B51-0C8E-11D3-BB2A-00A0C93CA73A}';
  Class_WMPListBoxCtrl: TGUID = '{FC1880CF-83B9-43A7-A066-C44CE8C82583}';
  Class_WMPSliderCtrl: TGUID = '{F2BF2C90-405F-11D3-BB39-00A0C93CA73A}';
  Class_WMPVideoCtrl: TGUID = '{61CECF11-FC3A-11D2-A1CD-005004602752}';
  Class_WMPEffects: TGUID = '{47DEA830-D619-4154-B8D8-6B74845D6A2D}';
  Class_WMPEqualizerSettingsCtrl: TGUID = '{93EB32F5-87B1-45AD-ACC6-0F2483DB83BB}';
  Class_WMPVideoSettingsCtrl: TGUID = '{AE7BFAFE-DCC8-4A73-92C8-CC300CA88859}';
  Class_WMPLibraryTreeCtrl: TGUID = '{D9DE732A-AEE9-4503-9D11-5605589977A8}';
  Class_WMPEditCtrl: TGUID = '{6342FCED-25EA-4033-BDDB-D049A14382D3}';
  Class_WMPMenuCtrl: TGUID = '{BAB3768B-8883-4AEC-9F9B-E14C947913EF}';
  Class_WMPAutoMenuCtrl: TGUID = '{6B28F900-8D64-4B80-9963-CC52DDD1FBB4}';
  Class_WMPRegionalButtonCtrl: TGUID = '{AE3B6831-25A9-11D3-BD41-00C04F6EA5AE}';
  Class_WMPRegionalButton: TGUID = '{09AEFF11-69EF-11D3-BD4D-00C04F6EA5AE}';
  Class_WMPCustomSliderCtrl: TGUID = '{95F45AA3-ED0A-11D2-BA67-0000F80855E6}';
  Class_WMPTextCtrl: TGUID = '{DDDA102E-0E17-11D3-A2E2-00C04F79F88E}';
  Class_WMPPlaylistCtrl: TGUID = '{5F9CFD93-8CAD-11D3-9A7E-00C04F8EFB70}';
  Class_WMPCore: TGUID = '{09428D37-E0B9-11D2-B147-00C04F79FAA6}';

type

{ Forward declarations: Interfaces }
  IWMPEvents = interface;
  _WMPOCXEvents = dispinterface;
  IWMPPlayer4 = interface;
  IWMPPlayer4Disp = dispinterface;
  IWMPCore3 = interface;
  IWMPCore3Disp = dispinterface;
  IWMPCore2 = interface;
  IWMPCore2Disp = dispinterface;
  IWMPCore = interface;
  IWMPCoreDisp = dispinterface;
  IWMPControls = interface;
  IWMPControlsDisp = dispinterface;
  IWMPMedia = interface;
  IWMPMediaDisp = dispinterface;
  IWMPPlaylist = interface;
  IWMPPlaylistDisp = dispinterface;
  IWMPSettings = interface;
  IWMPSettingsDisp = dispinterface;
  IWMPMediaCollection = interface;
  IWMPMediaCollectionDisp = dispinterface;
  IWMPStringCollection = interface;
  IWMPStringCollectionDisp = dispinterface;
  IWMPPlaylistCollection = interface;
  IWMPPlaylistCollectionDisp = dispinterface;
  IWMPPlaylistArray = interface;
  IWMPPlaylistArrayDisp = dispinterface;
  IWMPNetwork = interface;
  IWMPNetworkDisp = dispinterface;
  IWMPCdromCollection = interface;
  IWMPCdromCollectionDisp = dispinterface;
  IWMPCdrom = interface;
  IWMPCdromDisp = dispinterface;
  IWMPClosedCaption = interface;
  IWMPClosedCaptionDisp = dispinterface;
  IWMPError = interface;
  IWMPErrorDisp = dispinterface;
  IWMPErrorItem = interface;
  IWMPErrorItemDisp = dispinterface;
  IWMPDVD = interface;
  IWMPDVDDisp = dispinterface;
  IWMPPlayerApplication = interface;
  IWMPPlayerApplicationDisp = dispinterface;
  IWMPPlayer3 = interface;
  IWMPPlayer3Disp = dispinterface;
  IWMPPlayer2 = interface;
  IWMPPlayer2Disp = dispinterface;
  IWMPPlayer = interface;
  IWMPPlayerDisp = dispinterface;
  IWMPErrorItem2 = interface;
  IWMPErrorItem2Disp = dispinterface;
  IWMPControls2 = interface;
  IWMPControls2Disp = dispinterface;
  IWMPMedia2 = interface;
  IWMPMedia2Disp = dispinterface;
  IWMPMedia3 = interface;
  IWMPMedia3Disp = dispinterface;
  IWMPMetadataPicture = interface;
  IWMPMetadataPictureDisp = dispinterface;
  IWMPMetadataText = interface;
  IWMPMetadataTextDisp = dispinterface;
  IWMPSettings2 = interface;
  IWMPSettings2Disp = dispinterface;
  IWMPControls3 = interface;
  IWMPControls3Disp = dispinterface;
  IWMPClosedCaption2 = interface;
  IWMPClosedCaption2Disp = dispinterface;
  IWMPPlaylistCtrl = interface;
  IWMPPlaylistCtrlDisp = dispinterface;
  IAppDispatch = interface;
  IAppDispatchDisp = dispinterface;
  IWMPSafeBrowser = interface;
  IWMPSafeBrowserDisp = dispinterface;
  IWMPObjectExtendedProps = interface;
  IWMPObjectExtendedPropsDisp = dispinterface;
  IWMPLayoutSubView = interface;
  IWMPLayoutSubViewDisp = dispinterface;
  IWMPLayoutView = interface;
  IWMPLayoutViewDisp = dispinterface;
  IWMPEventObject = interface;
  IWMPEventObjectDisp = dispinterface;
  IWMPTheme = interface;
  IWMPThemeDisp = dispinterface;
  IWMPLayoutSettingsDispatch = interface;
  IWMPLayoutSettingsDispatchDisp = dispinterface;
  IWMPNowPlayingHelperDispatch = interface;
  IWMPNowPlayingHelperDispatchDisp = dispinterface;
  IWMPButtonCtrlEvents = dispinterface;
  IWMPButtonCtrl = interface;
  IWMPButtonCtrlDisp = dispinterface;
  IWMPListBoxCtrl = interface;
  IWMPListBoxCtrlDisp = dispinterface;
  IWMPListBoxItem = interface;
  IWMPListBoxItemDisp = dispinterface;
  IWMPPlaylistCtrlColumn = interface;
  IWMPPlaylistCtrlColumnDisp = dispinterface;
  IWMPSliderCtrlEvents = dispinterface;
  IWMPSliderCtrl = interface;
  IWMPSliderCtrlDisp = dispinterface;
  IWMPVideoCtrlEvents = dispinterface;
  IWMPVideoCtrl = interface;
  IWMPVideoCtrlDisp = dispinterface;
  IWMPEffectsCtrl = interface;
  IWMPEffectsCtrlDisp = dispinterface;
  IWMPEqualizerSettingsCtrl = interface;
  IWMPEqualizerSettingsCtrlDisp = dispinterface;
  IWMPVideoSettingsCtrl = interface;
  IWMPVideoSettingsCtrlDisp = dispinterface;
  IWMPLibraryTreeCtrl = interface;
  IWMPLibraryTreeCtrlDisp = dispinterface;
  IWMPEditCtrl = interface;
  IWMPEditCtrlDisp = dispinterface;
  IWMPPluginUIHost = interface;
  IWMPPluginUIHostDisp = dispinterface;
  IWMPMenuCtrl = interface;
  IWMPMenuCtrlDisp = dispinterface;
  IWMPAutoMenuCtrl = interface;
  IWMPAutoMenuCtrlDisp = dispinterface;
  IWMPRegionalButtonCtrl = interface;
  IWMPRegionalButtonCtrlDisp = dispinterface;
  IWMPRegionalButtonEvents = dispinterface;
  IWMPRegionalButton = interface;
  IWMPRegionalButtonDisp = dispinterface;
  IWMPCustomSliderCtrlEvents = dispinterface;
  IWMPCustomSlider = interface;
  IWMPCustomSliderDisp = dispinterface;
  IWMPTextCtrl = interface;
  IWMPTextCtrlDisp = dispinterface;
  ITaskCntrCtrl = interface;
  ITaskCntrCtrlDisp = dispinterface;
  _WMPCoreEvents = dispinterface;
  IWMPGraphEventHandler = interface;
  IWMPGraphEventHandlerDisp = dispinterface;
  IAssaultVis = interface;
  IAssaultVisDisp = dispinterface;
  IBattery = interface;
  IBatteryDisp = dispinterface;
  IBatteryPreset = interface;
  IBatteryPresetDisp = dispinterface;
  IBatteryRandomPreset = interface;
  IBatteryRandomPresetDisp = dispinterface;
  IBatterySavedPreset = interface;
  IBatterySavedPresetDisp = dispinterface;
  IBarsEffect = interface;
  IBarsEffectDisp = dispinterface;
  ISpikesEffect = interface;
  ISpikesEffectDisp = dispinterface;
  IDotPlaneEffect = interface;
  IDotPlaneEffectDisp = dispinterface;
  IPlenoptic = interface;
  IPlenopticDisp = dispinterface;
  IWMPExternal = interface;
  IWMPExternalDisp = dispinterface;
  IWMPExternalColors = interface;
  IWMPExternalColorsDisp = dispinterface;
  IWMPTemplatesExternal = interface;
  IWMPTemplatesExternalDisp = dispinterface;
  IWMPSubscriptionServiceExternal = interface;
  IWMPSubscriptionServiceExternalDisp = dispinterface;
  IWMPDownloadManager = interface;
  IWMPDownloadManagerDisp = dispinterface;
  IWMPDownloadCollection = interface;
  IWMPDownloadCollectionDisp = dispinterface;
  IWMPDownloadItem = interface;
  IWMPDownloadItemDisp = dispinterface;
  IWMPCDDVDWizardExternal = interface;
  IWMPCDDVDWizardExternalDisp = dispinterface;
  IWMPBaseExternal = interface;
  IWMPBaseExternalDisp = dispinterface;
  IWMPOfflineExternal = interface;
  IWMPOfflineExternalDisp = dispinterface;

{ Forward declarations: CoClasses }
  WindowsMediaPlayer = IWMPPlayer4;
  WMPButtonCtrl = IWMPButtonCtrl;
  WMPListBoxCtrl = IWMPListBoxCtrl;
  WMPSliderCtrl = IWMPSliderCtrl;
  WMPVideoCtrl = IWMPVideoCtrl;
  WMPEffects = IWMPEffectsCtrl;
  WMPEqualizerSettingsCtrl = IWMPEqualizerSettingsCtrl;
  WMPVideoSettingsCtrl = IWMPVideoSettingsCtrl;
  WMPLibraryTreeCtrl = IWMPLibraryTreeCtrl;
  WMPEditCtrl = IWMPEditCtrl;
  WMPMenuCtrl = IWMPMenuCtrl;
  WMPAutoMenuCtrl = IWMPAutoMenuCtrl;
  WMPRegionalButtonCtrl = IWMPRegionalButtonCtrl;
  WMPRegionalButton = IWMPRegionalButton;
  WMPCustomSliderCtrl = IWMPCustomSlider;
  WMPTextCtrl = IWMPTextCtrl;
  WMPPlaylistCtrl = IWMPPlaylistCtrl;
  WMPCore = IWMPCore3;

{ Forward declarations: Enums }
  WMPPlaylistChangeEventType = TOleEnum;
  WMPOpenState = TOleEnum;
  WMPPlayState = TOleEnum;
  WMPSubscriptionDownloadState = TOleEnum;
  WMP_WRITENAMESEX_TYPE = TOleEnum;

  ULONG_PTR = UINT;

{ IWMPEvents: Public interface. }

  IWMPEvents = interface(IUnknown)
    ['{19A6627B-DA9E-47C1-BB23-00B5E668236A}']
    procedure OpenStateChange(NewState: Integer); stdcall;
    procedure PlayStateChange(NewState: Integer); stdcall;
    procedure AudioLanguageChange(LangID: Integer); stdcall;
    procedure StatusChange; stdcall;
    procedure ScriptCommand(const scType, Param: WideString); stdcall;
    procedure NewStream; stdcall;
    procedure Disconnect(Result: Integer); stdcall;
    procedure Buffering(Start: WordBool); stdcall;
    procedure Error; stdcall;
    procedure Warning(WarningType, Param: Integer; const Description: WideString); stdcall;
    procedure EndOfStream(Result: Integer); stdcall;
    procedure PositionChange(oldPosition, newPosition: Double); stdcall;
    procedure MarkerHit(MarkerNum: Integer); stdcall;
    procedure DurationUnitChange(NewDurationUnit: Integer); stdcall;
    procedure CdromMediaChange(CdromNum: Integer); stdcall;
    procedure PlaylistChange(Playlist: IDispatch; change: WMPPlaylistChangeEventType); stdcall;
    procedure CurrentPlaylistChange(change: WMPPlaylistChangeEventType); stdcall;
    procedure CurrentPlaylistItemAvailable(const bstrItemName: WideString); stdcall;
    procedure MediaChange(Item: IDispatch); stdcall;
    procedure CurrentMediaItemAvailable(const bstrItemName: WideString); stdcall;
    procedure CurrentItemChange(pdispMedia: IDispatch); stdcall;
    procedure MediaCollectionChange; stdcall;
    procedure MediaCollectionAttributeStringAdded(const bstrAttribName, bstrAttribVal: WideString); stdcall;
    procedure MediaCollectionAttributeStringRemoved(const bstrAttribName, bstrAttribVal: WideString); stdcall;
    procedure MediaCollectionAttributeStringChanged(const bstrAttribName, bstrOldAttribVal, bstrNewAttribVal: WideString); stdcall;
    procedure PlaylistCollectionChange; stdcall;
    procedure PlaylistCollectionPlaylistAdded(const bstrPlaylistName: WideString); stdcall;
    procedure PlaylistCollectionPlaylistRemoved(const bstrPlaylistName: WideString); stdcall;
    procedure PlaylistCollectionPlaylistSetAsDeleted(const bstrPlaylistName: WideString; varfIsDeleted: WordBool); stdcall;
    procedure ModeChange(const ModeName: WideString; NewValue: WordBool); stdcall;
    procedure MediaError(pMediaObject: IDispatch); stdcall;
    procedure OpenPlaylistSwitch(pItem: IDispatch); stdcall;
    procedure DomainChange(const strDomain: WideString); stdcall;
    procedure SwitchedToPlayerApplication; stdcall;
    procedure SwitchedToControl; stdcall;
    procedure PlayerDockedStateChange; stdcall;
    procedure PlayerReconnect; stdcall;
    procedure Click(nButton, nShiftState: Smallint; fX, fY: Integer); stdcall;
    procedure DoubleClick(nButton, nShiftState: Smallint; fX, fY: Integer); stdcall;
    procedure KeyDown(nKeyCode, nShiftState: Smallint); stdcall;
    procedure KeyPress(nKeyAscii: Smallint); stdcall;
    procedure KeyUp(nKeyCode, nShiftState: Smallint); stdcall;
    procedure MouseDown(nButton, nShiftState: Smallint; fX, fY: Integer); stdcall;
    procedure MouseMove(nButton, nShiftState: Smallint; fX, fY: Integer); stdcall;
    procedure MouseUp(nButton, nShiftState: Smallint; fX, fY: Integer); stdcall;
  end;

{ _WMPOCXEvents: Public interface. }

  _WMPOCXEvents = dispinterface
    ['{6BF52A51-394A-11D3-B153-00C04F79FAA6}']
    procedure OpenStateChange(NewState: Integer); dispid 5001;
    procedure PlayStateChange(NewState: Integer); dispid 5101;
    procedure AudioLanguageChange(LangID: Integer); dispid 5102;
    procedure StatusChange; dispid 5002;
    procedure ScriptCommand(const scType, Param: WideString); dispid 5301;
    procedure NewStream; dispid 5403;
    procedure Disconnect(Result: Integer); dispid 5401;
    procedure Buffering(Start: WordBool); dispid 5402;
    procedure Error; dispid 5501;
    procedure Warning(WarningType, Param: Integer; const Description: WideString); dispid 5601;
    procedure EndOfStream(Result: Integer); dispid 5201;
    procedure PositionChange(oldPosition, newPosition: Double); dispid 5202;
    procedure MarkerHit(MarkerNum: Integer); dispid 5203;
    procedure DurationUnitChange(NewDurationUnit: Integer); dispid 5204;
    procedure CdromMediaChange(CdromNum: Integer); dispid 5701;
    procedure PlaylistChange(Playlist: IDispatch; change: WMPPlaylistChangeEventType); dispid 5801;
    procedure CurrentPlaylistChange(change: WMPPlaylistChangeEventType); dispid 5804;
    procedure CurrentPlaylistItemAvailable(const bstrItemName: WideString); dispid 5805;
    procedure MediaChange(Item: IDispatch); dispid 5802;
    procedure CurrentMediaItemAvailable(const bstrItemName: WideString); dispid 5803;
    procedure CurrentItemChange(pdispMedia: IDispatch); dispid 5806;
    procedure MediaCollectionChange; dispid 5807;
    procedure MediaCollectionAttributeStringAdded(const bstrAttribName, bstrAttribVal: WideString); dispid 5808;
    procedure MediaCollectionAttributeStringRemoved(const bstrAttribName, bstrAttribVal: WideString); dispid 5809;
    procedure MediaCollectionAttributeStringChanged(const bstrAttribName, bstrOldAttribVal, bstrNewAttribVal: WideString); dispid 5820;
    procedure PlaylistCollectionChange; dispid 5810;
    procedure PlaylistCollectionPlaylistAdded(const bstrPlaylistName: WideString); dispid 5811;
    procedure PlaylistCollectionPlaylistRemoved(const bstrPlaylistName: WideString); dispid 5812;
    procedure PlaylistCollectionPlaylistSetAsDeleted(const bstrPlaylistName: WideString; varfIsDeleted: WordBool); dispid 5818;
    procedure ModeChange(const ModeName: WideString; NewValue: WordBool); dispid 5819;
    procedure MediaError(pMediaObject: IDispatch); dispid 5821;
    procedure OpenPlaylistSwitch(pItem: IDispatch); dispid 5823;
    procedure DomainChange(const strDomain: WideString); dispid 5822;
    procedure SwitchedToPlayerApplication; dispid 6501;
    procedure SwitchedToControl; dispid 6502;
    procedure PlayerDockedStateChange; dispid 6503;
    procedure PlayerReconnect; dispid 6504;
    procedure Click(nButton, nShiftState: Smallint; fX, fY: Integer); dispid 6505;
    procedure DoubleClick(nButton, nShiftState: Smallint; fX, fY: Integer); dispid 6506;
    procedure KeyDown(nKeyCode, nShiftState: Smallint); dispid 6507;
    procedure KeyPress(nKeyAscii: Smallint); dispid 6508;
    procedure KeyUp(nKeyCode, nShiftState: Smallint); dispid 6509;
    procedure MouseDown(nButton, nShiftState: Smallint; fX, fY: Integer); dispid 6510;
    procedure MouseMove(nButton, nShiftState: Smallint; fX, fY: Integer); dispid 6511;
    procedure MouseUp(nButton, nShiftState: Smallint; fX, fY: Integer); dispid 6512;
  end;

{ IWMPCore: Public interface. }

  IWMPCore = interface(IDispatch)
    ['{D84CCA99-CCE2-11D2-9ECC-0000F8085981}']
    procedure close; safecall;
    function Get_URL: WideString; safecall;
    procedure Set_URL(const Value: WideString); safecall;
    function Get_openState: WMPOpenState; safecall;
    function Get_playState: WMPPlayState; safecall;
    function Get_controls: IWMPControls; safecall;
    function Get_settings: IWMPSettings; safecall;
    function Get_currentMedia: IWMPMedia; safecall;
    procedure Set_currentMedia(const Value: IWMPMedia); safecall;
    function Get_mediaCollection: IWMPMediaCollection; safecall;
    function Get_playlistCollection: IWMPPlaylistCollection; safecall;
    function Get_versionInfo: WideString; safecall;
    procedure launchURL(const bstrURL: WideString); safecall;
    function Get_network: IWMPNetwork; safecall;
    function Get_currentPlaylist: IWMPPlaylist; safecall;
    procedure Set_currentPlaylist(const Value: IWMPPlaylist); safecall;
    function Get_cdromCollection: IWMPCdromCollection; safecall;
    function Get_closedCaption: IWMPClosedCaption; safecall;
    function Get_isOnline: WordBool; safecall;
    function Get_Error: IWMPError; safecall;
    function Get_status: WideString; safecall;
    property URL: WideString read Get_URL write Set_URL;
    property openState: WMPOpenState read Get_openState;
    property playState: WMPPlayState read Get_playState;
    property controls: IWMPControls read Get_controls;
    property settings: IWMPSettings read Get_settings;
    property currentMedia: IWMPMedia read Get_currentMedia write Set_currentMedia;
    property mediaCollection: IWMPMediaCollection read Get_mediaCollection;
    property playlistCollection: IWMPPlaylistCollection read Get_playlistCollection;
    property versionInfo: WideString read Get_versionInfo;
    property network: IWMPNetwork read Get_network;
    property currentPlaylist: IWMPPlaylist read Get_currentPlaylist write Set_currentPlaylist;
    property cdromCollection: IWMPCdromCollection read Get_cdromCollection;
    property closedCaption: IWMPClosedCaption read Get_closedCaption;
    property isOnline: WordBool read Get_isOnline;
    property Error: IWMPError read Get_Error;
    property status: WideString read Get_status;
  end;

{ DispInterface declaration for Dual Interface IWMPCore }

  IWMPCoreDisp = dispinterface
    ['{D84CCA99-CCE2-11D2-9ECC-0000F8085981}']
    procedure close; dispid 3;
    property URL: WideString dispid 1;
    property openState: WMPOpenState readonly dispid 2;
    property playState: WMPPlayState readonly dispid 10;
    property controls: IWMPControls readonly dispid 4;
    property settings: IWMPSettings readonly dispid 5;
    property currentMedia: IWMPMedia dispid 6;
    property mediaCollection: IWMPMediaCollection readonly dispid 8;
    property playlistCollection: IWMPPlaylistCollection readonly dispid 9;
    property versionInfo: WideString readonly dispid 11;
    procedure launchURL(const bstrURL: WideString); dispid 12;
    property network: IWMPNetwork readonly dispid 7;
    property currentPlaylist: IWMPPlaylist dispid 13;
    property cdromCollection: IWMPCdromCollection readonly dispid 14;
    property closedCaption: IWMPClosedCaption readonly dispid 15;
    property isOnline: WordBool readonly dispid 16;
    property Error: IWMPError readonly dispid 17;
    property status: WideString readonly dispid 18;
  end;

{ IWMPCore2: Public interface. }

  IWMPCore2 = interface(IWMPCore)
    ['{BC17E5B7-7561-4C18-BB90-17D485775659}']
    function Get_dvd: IWMPDVD; safecall;
    property dvd: IWMPDVD read Get_dvd;
  end;

{ DispInterface declaration for Dual Interface IWMPCore2 }

  IWMPCore2Disp = dispinterface
    ['{BC17E5B7-7561-4C18-BB90-17D485775659}']
    procedure close; dispid 3;
    property URL: WideString dispid 1;
    property openState: WMPOpenState readonly dispid 2;
    property playState: WMPPlayState readonly dispid 10;
    property controls: IWMPControls readonly dispid 4;
    property settings: IWMPSettings readonly dispid 5;
    property currentMedia: IWMPMedia dispid 6;
    property mediaCollection: IWMPMediaCollection readonly dispid 8;
    property playlistCollection: IWMPPlaylistCollection readonly dispid 9;
    property versionInfo: WideString readonly dispid 11;
    procedure launchURL(const bstrURL: WideString); dispid 12;
    property network: IWMPNetwork readonly dispid 7;
    property currentPlaylist: IWMPPlaylist dispid 13;
    property cdromCollection: IWMPCdromCollection readonly dispid 14;
    property closedCaption: IWMPClosedCaption readonly dispid 15;
    property isOnline: WordBool readonly dispid 16;
    property Error: IWMPError readonly dispid 17;
    property status: WideString readonly dispid 18;
    property dvd: IWMPDVD readonly dispid 40;
  end;

{ IWMPCore3: Public interface. }

  IWMPCore3 = interface(IWMPCore2)
    ['{7587C667-628F-499F-88E7-6A6F4E888464}']
    function newPlaylist(const bstrName, bstrURL: WideString): IWMPPlaylist; safecall;
    function newMedia(const bstrURL: WideString): IWMPMedia; safecall;
  end;

{ DispInterface declaration for Dual Interface IWMPCore3 }

  IWMPCore3Disp = dispinterface
    ['{7587C667-628F-499F-88E7-6A6F4E888464}']
    procedure close; dispid 3;
    property URL: WideString dispid 1;
    property openState: WMPOpenState readonly dispid 2;
    property playState: WMPPlayState readonly dispid 10;
    property controls: IWMPControls readonly dispid 4;
    property settings: IWMPSettings readonly dispid 5;
    property currentMedia: IWMPMedia dispid 6;
    property mediaCollection: IWMPMediaCollection readonly dispid 8;
    property playlistCollection: IWMPPlaylistCollection readonly dispid 9;
    property versionInfo: WideString readonly dispid 11;
    procedure launchURL(const bstrURL: WideString); dispid 12;
    property network: IWMPNetwork readonly dispid 7;
    property currentPlaylist: IWMPPlaylist dispid 13;
    property cdromCollection: IWMPCdromCollection readonly dispid 14;
    property closedCaption: IWMPClosedCaption readonly dispid 15;
    property isOnline: WordBool readonly dispid 16;
    property Error: IWMPError readonly dispid 17;
    property status: WideString readonly dispid 18;
    property dvd: IWMPDVD readonly dispid 40;
    function newPlaylist(const bstrName, bstrURL: WideString): IWMPPlaylist; dispid 41;
    function newMedia(const bstrURL: WideString): IWMPMedia; dispid 42;
  end;

{ IWMPPlayer4: Public interface. }

  IWMPPlayer4 = interface(IWMPCore3)
    ['{6C497D62-8919-413C-82DB-E935FB3EC584}']
    function Get_enabled: WordBool; safecall;
    procedure Set_enabled(Value: WordBool); safecall;
    function Get_fullScreen: WordBool; safecall;
    procedure Set_fullScreen(Value: WordBool); safecall;
    function Get_enableContextMenu: WordBool; safecall;
    procedure Set_enableContextMenu(Value: WordBool); safecall;
    procedure Set_uiMode(const Value: WideString); safecall;
    function Get_uiMode: WideString; safecall;
    function Get_stretchToFit: WordBool; safecall;
    procedure Set_stretchToFit(Value: WordBool); safecall;
    function Get_windowlessVideo: WordBool; safecall;
    procedure Set_windowlessVideo(Value: WordBool); safecall;
    function Get_isRemote: WordBool; safecall;
    function Get_playerApplication: IWMPPlayerApplication; safecall;
    procedure openPlayer(const bstrURL: WideString); safecall;
    property enabled: WordBool read Get_enabled write Set_enabled;
    property fullScreen: WordBool read Get_fullScreen write Set_fullScreen;
    property enableContextMenu: WordBool read Get_enableContextMenu write Set_enableContextMenu;
    property uiMode: WideString read Get_uiMode write Set_uiMode;
    property stretchToFit: WordBool read Get_stretchToFit write Set_stretchToFit;
    property windowlessVideo: WordBool read Get_windowlessVideo write Set_windowlessVideo;
    property isRemote: WordBool read Get_isRemote;
    property playerApplication: IWMPPlayerApplication read Get_playerApplication;
  end;

{ DispInterface declaration for Dual Interface IWMPPlayer4 }

  IWMPPlayer4Disp = dispinterface
    ['{6C497D62-8919-413C-82DB-E935FB3EC584}']
    procedure close; dispid 3;
    property URL: WideString dispid 1;
    property openState: WMPOpenState readonly dispid 2;
    property playState: WMPPlayState readonly dispid 10;
    property controls: IWMPControls readonly dispid 4;
    property settings: IWMPSettings readonly dispid 5;
    property currentMedia: IWMPMedia dispid 6;
    property mediaCollection: IWMPMediaCollection readonly dispid 8;
    property playlistCollection: IWMPPlaylistCollection readonly dispid 9;
    property versionInfo: WideString readonly dispid 11;
    procedure launchURL(const bstrURL: WideString); dispid 12;
    property network: IWMPNetwork readonly dispid 7;
    property currentPlaylist: IWMPPlaylist dispid 13;
    property cdromCollection: IWMPCdromCollection readonly dispid 14;
    property closedCaption: IWMPClosedCaption readonly dispid 15;
    property isOnline: WordBool readonly dispid 16;
    property Error: IWMPError readonly dispid 17;
    property status: WideString readonly dispid 18;
    property dvd: IWMPDVD readonly dispid 40;
    function newPlaylist(const bstrName, bstrURL: WideString): IWMPPlaylist; dispid 41;
    function newMedia(const bstrURL: WideString): IWMPMedia; dispid 42;
    property enabled: WordBool dispid 19;
    property fullScreen: WordBool dispid 21;
    property enableContextMenu: WordBool dispid 22;
    property uiMode: WideString dispid 23;
    property stretchToFit: WordBool dispid 24;
    property windowlessVideo: WordBool dispid 25;
    property isRemote: WordBool readonly dispid 26;
    property playerApplication: IWMPPlayerApplication readonly dispid 27;
    procedure openPlayer(const bstrURL: WideString); dispid 28;
  end;

{ IWMPControls: Public interface. }

  IWMPControls = interface(IDispatch)
    ['{74C09E02-F828-11D2-A74B-00A0C905F36E}']
    function Get_isAvailable(const bstrItem: WideString): WordBool; safecall;
    procedure play; safecall;
    procedure stop; safecall;
    procedure pause; safecall;
    procedure fastForward; safecall;
    procedure fastReverse; safecall;
    function Get_currentPosition: Double; safecall;
    procedure Set_currentPosition(Value: Double); safecall;
    function Get_currentPositionString: WideString; safecall;
    procedure next; safecall;
    procedure previous; safecall;
    function Get_currentItem: IWMPMedia; safecall;
    procedure Set_currentItem(const Value: IWMPMedia); safecall;
    function Get_currentMarker: Integer; safecall;
    procedure Set_currentMarker(Value: Integer); safecall;
    procedure playItem(const pIWMPMedia: IWMPMedia); safecall;
    property isAvailable[const bstrItem: WideString]: WordBool read Get_isAvailable;
    property currentPosition: Double read Get_currentPosition write Set_currentPosition;
    property currentPositionString: WideString read Get_currentPositionString;
    property currentItem: IWMPMedia read Get_currentItem write Set_currentItem;
    property currentMarker: Integer read Get_currentMarker write Set_currentMarker;
  end;

{ DispInterface declaration for Dual Interface IWMPControls }

  IWMPControlsDisp = dispinterface
    ['{74C09E02-F828-11D2-A74B-00A0C905F36E}']
    property isAvailable[const bstrItem: WideString]: WordBool readonly dispid 62;
    procedure play; dispid 51;
    procedure stop; dispid 52;
    procedure pause; dispid 53;
    procedure fastForward; dispid 54;
    procedure fastReverse; dispid 55;
    property currentPosition: Double dispid 56;
    property currentPositionString: WideString readonly dispid 57;
    procedure next; dispid 58;
    procedure previous; dispid 59;
    property currentItem: IWMPMedia dispid 60;
    property currentMarker: Integer dispid 61;
    procedure playItem(const pIWMPMedia: IWMPMedia); dispid 63;
  end;

{ IWMPMedia: Public interface. }

  IWMPMedia = interface(IDispatch)
    ['{94D55E95-3FAC-11D3-B155-00C04F79FAA6}']
    function Get_isIdentical(const pIWMPMedia: IWMPMedia): WordBool; safecall;
    function Get_sourceURL: WideString; safecall;
    function Get_name: WideString; safecall;
    procedure Set_name(const Value: WideString); safecall;
    function Get_imageSourceWidth: Integer; safecall;
    function Get_imageSourceHeight: Integer; safecall;
    function Get_markerCount: Integer; safecall;
    function getMarkerTime(MarkerNum: Integer): Double; safecall;
    function getMarkerName(MarkerNum: Integer): WideString; safecall;
    function Get_duration: Double; safecall;
    function Get_durationString: WideString; safecall;
    function Get_attributeCount: Integer; safecall;
    function getAttributeName(lIndex: Integer): WideString; safecall;
    function getItemInfo(const bstrItemName: WideString): WideString; safecall;
    procedure setItemInfo(const bstrItemName, bstrVal: WideString); safecall;
    function getItemInfoByAtom(lAtom: Integer): WideString; safecall;
    function isMemberOf(const pPlaylist: IWMPPlaylist): WordBool; safecall;
    function isReadOnlyItem(const bstrItemName: WideString): WordBool; safecall;
    property isIdentical[const pIWMPMedia: IWMPMedia]: WordBool read Get_isIdentical;
    property sourceURL: WideString read Get_sourceURL;
    property name: WideString read Get_name write Set_name;
    property imageSourceWidth: Integer read Get_imageSourceWidth;
    property imageSourceHeight: Integer read Get_imageSourceHeight;
    property markerCount: Integer read Get_markerCount;
    property duration: Double read Get_duration;
    property durationString: WideString read Get_durationString;
    property attributeCount: Integer read Get_attributeCount;
  end;

{ DispInterface declaration for Dual Interface IWMPMedia }

  IWMPMediaDisp = dispinterface
    ['{94D55E95-3FAC-11D3-B155-00C04F79FAA6}']
    property isIdentical[const pIWMPMedia: IWMPMedia]: WordBool readonly dispid 763;
    property sourceURL: WideString readonly dispid 751;
    property name: WideString dispid 764;
    property imageSourceWidth: Integer readonly dispid 752;
    property imageSourceHeight: Integer readonly dispid 753;
    property markerCount: Integer readonly dispid 754;
    function getMarkerTime(MarkerNum: Integer): Double; dispid 755;
    function getMarkerName(MarkerNum: Integer): WideString; dispid 756;
    property duration: Double readonly dispid 757;
    property durationString: WideString readonly dispid 758;
    property attributeCount: Integer readonly dispid 759;
    function getAttributeName(lIndex: Integer): WideString; dispid 760;
    function getItemInfo(const bstrItemName: WideString): WideString; dispid 761;
    procedure setItemInfo(const bstrItemName, bstrVal: WideString); dispid 762;
    function getItemInfoByAtom(lAtom: Integer): WideString; dispid 765;
    function isMemberOf(const pPlaylist: IWMPPlaylist): WordBool; dispid 766;
    function isReadOnlyItem(const bstrItemName: WideString): WordBool; dispid 767;
  end;

{ IWMPPlaylist: Public interface. }

  IWMPPlaylist = interface(IDispatch)
    ['{D5F0F4F1-130C-11D3-B14E-00C04F79FAA6}']
    function Get_count: Integer; safecall;
    function Get_name: WideString; safecall;
    procedure Set_name(const Value: WideString); safecall;
    function Get_attributeCount: Integer; safecall;
    function Get_attributeName(lIndex: Integer): WideString; safecall;
    function Get_Item(lIndex: Integer): IWMPMedia; safecall;
    function getItemInfo(const bstrName: WideString): WideString; safecall;
    procedure setItemInfo(const bstrName, bstrValue: WideString); safecall;
    function Get_isIdentical(const pIWMPPlaylist: IWMPPlaylist): WordBool; safecall;
    procedure clear; safecall;
    procedure insertItem(lIndex: Integer; const pIWMPMedia: IWMPMedia); safecall;
    procedure appendItem(const pIWMPMedia: IWMPMedia); safecall;
    procedure removeItem(const pIWMPMedia: IWMPMedia); safecall;
    procedure moveItem(lIndexOld, lIndexNew: Integer); safecall;
    property count: Integer read Get_count;
    property name: WideString read Get_name write Set_name;
    property attributeCount: Integer read Get_attributeCount;
    property attributeName[lIndex: Integer]: WideString read Get_attributeName;
    property Item[lIndex: Integer]: IWMPMedia read Get_Item;
    property isIdentical[const pIWMPPlaylist: IWMPPlaylist]: WordBool read Get_isIdentical;
  end;

{ DispInterface declaration for Dual Interface IWMPPlaylist }

  IWMPPlaylistDisp = dispinterface
    ['{D5F0F4F1-130C-11D3-B14E-00C04F79FAA6}']
    property count: Integer readonly dispid 201;
    property name: WideString dispid 202;
    property attributeCount: Integer readonly dispid 210;
    property attributeName[lIndex: Integer]: WideString readonly dispid 211;
    property Item[lIndex: Integer]: IWMPMedia readonly dispid 212;
    function getItemInfo(const bstrName: WideString): WideString; dispid 203;
    procedure setItemInfo(const bstrName, bstrValue: WideString); dispid 204;
    property isIdentical[const pIWMPPlaylist: IWMPPlaylist]: WordBool readonly dispid 213;
    procedure clear; dispid 205;
    procedure insertItem(lIndex: Integer; const pIWMPMedia: IWMPMedia); dispid 206;
    procedure appendItem(const pIWMPMedia: IWMPMedia); dispid 207;
    procedure removeItem(const pIWMPMedia: IWMPMedia); dispid 208;
    procedure moveItem(lIndexOld, lIndexNew: Integer); dispid 209;
  end;

{ IWMPSettings: Public interface. }

  IWMPSettings = interface(IDispatch)
    ['{9104D1AB-80C9-4FED-ABF0-2E6417A6DF14}']
    function Get_isAvailable(const bstrItem: WideString): WordBool; safecall;
    function Get_autoStart: WordBool; safecall;
    procedure Set_autoStart(Value: WordBool); safecall;
    function Get_baseURL: WideString; safecall;
    procedure Set_baseURL(const Value: WideString); safecall;
    function Get_defaultFrame: WideString; safecall;
    procedure Set_defaultFrame(const Value: WideString); safecall;
    function Get_invokeURLs: WordBool; safecall;
    procedure Set_invokeURLs(Value: WordBool); safecall;
    function Get_mute: WordBool; safecall;
    procedure Set_mute(Value: WordBool); safecall;
    function Get_playCount: Integer; safecall;
    procedure Set_playCount(Value: Integer); safecall;
    function Get_rate: Double; safecall;
    procedure Set_rate(Value: Double); safecall;
    function Get_balance: Integer; safecall;
    procedure Set_balance(Value: Integer); safecall;
    function Get_volume: Integer; safecall;
    procedure Set_volume(Value: Integer); safecall;
    function getMode(const bstrMode: WideString): WordBool; safecall;
    procedure setMode(const bstrMode: WideString; varfMode: WordBool); safecall;
    function Get_enableErrorDialogs: WordBool; safecall;
    procedure Set_enableErrorDialogs(Value: WordBool); safecall;
    property isAvailable[const bstrItem: WideString]: WordBool read Get_isAvailable;
    property autoStart: WordBool read Get_autoStart write Set_autoStart;
    property baseURL: WideString read Get_baseURL write Set_baseURL;
    property defaultFrame: WideString read Get_defaultFrame write Set_defaultFrame;
    property invokeURLs: WordBool read Get_invokeURLs write Set_invokeURLs;
    property mute: WordBool read Get_mute write Set_mute;
    property playCount: Integer read Get_playCount write Set_playCount;
    property rate: Double read Get_rate write Set_rate;
    property balance: Integer read Get_balance write Set_balance;
    property volume: Integer read Get_volume write Set_volume;
    property enableErrorDialogs: WordBool read Get_enableErrorDialogs write Set_enableErrorDialogs;
  end;

{ DispInterface declaration for Dual Interface IWMPSettings }

  IWMPSettingsDisp = dispinterface
    ['{9104D1AB-80C9-4FED-ABF0-2E6417A6DF14}']
    property isAvailable[const bstrItem: WideString]: WordBool readonly dispid 113;
    property autoStart: WordBool dispid 101;
    property baseURL: WideString dispid 108;
    property defaultFrame: WideString dispid 109;
    property invokeURLs: WordBool dispid 103;
    property mute: WordBool dispid 104;
    property playCount: Integer dispid 105;
    property rate: Double dispid 106;
    property balance: Integer dispid 102;
    property volume: Integer dispid 107;
    function getMode(const bstrMode: WideString): WordBool; dispid 110;
    procedure setMode(const bstrMode: WideString; varfMode: WordBool); dispid 111;
    property enableErrorDialogs: WordBool dispid 112;
  end;

{ IWMPMediaCollection: Public interface. }

  IWMPMediaCollection = interface(IDispatch)
    ['{8363BC22-B4B4-4B19-989D-1CD765749DD1}']
    function add(const bstrURL: WideString): IWMPMedia; safecall;
    function getAll: IWMPPlaylist; safecall;
    function getByName(const bstrName: WideString): IWMPPlaylist; safecall;
    function getByGenre(const bstrGenre: WideString): IWMPPlaylist; safecall;
    function getByAuthor(const bstrAuthor: WideString): IWMPPlaylist; safecall;
    function getByAlbum(const bstrAlbum: WideString): IWMPPlaylist; safecall;
    function getByAttribute(const bstrAttribute, bstrValue: WideString): IWMPPlaylist; safecall;
    procedure remove(const pItem: IWMPMedia; varfDeleteFile: WordBool); safecall;
    function getAttributeStringCollection(const bstrAttribute, bstrMediaType: WideString): IWMPStringCollection; safecall;
    function getMediaAtom(const bstrItemName: WideString): Integer; safecall;
    procedure setDeleted(const pItem: IWMPMedia; varfIsDeleted: WordBool); safecall;
    function isDeleted(const pItem: IWMPMedia): WordBool; safecall;
  end;

{ DispInterface declaration for Dual Interface IWMPMediaCollection }

  IWMPMediaCollectionDisp = dispinterface
    ['{8363BC22-B4B4-4B19-989D-1CD765749DD1}']
    function add(const bstrURL: WideString): IWMPMedia; dispid 452;
    function getAll: IWMPPlaylist; dispid 453;
    function getByName(const bstrName: WideString): IWMPPlaylist; dispid 454;
    function getByGenre(const bstrGenre: WideString): IWMPPlaylist; dispid 455;
    function getByAuthor(const bstrAuthor: WideString): IWMPPlaylist; dispid 456;
    function getByAlbum(const bstrAlbum: WideString): IWMPPlaylist; dispid 457;
    function getByAttribute(const bstrAttribute, bstrValue: WideString): IWMPPlaylist; dispid 458;
    procedure remove(const pItem: IWMPMedia; varfDeleteFile: WordBool); dispid 459;
    function getAttributeStringCollection(const bstrAttribute, bstrMediaType: WideString): IWMPStringCollection; dispid 461;
    function getMediaAtom(const bstrItemName: WideString): Integer; dispid 470;
    procedure setDeleted(const pItem: IWMPMedia; varfIsDeleted: WordBool); dispid 471;
    function isDeleted(const pItem: IWMPMedia): WordBool; dispid 472;
  end;

{ IWMPStringCollection: Public interface. }

  IWMPStringCollection = interface(IDispatch)
    ['{4A976298-8C0D-11D3-B389-00C04F68574B}']
    function Get_count: Integer; safecall;
    function Item(lIndex: Integer): WideString; safecall;
    property count: Integer read Get_count;
  end;

{ DispInterface declaration for Dual Interface IWMPStringCollection }

  IWMPStringCollectionDisp = dispinterface
    ['{4A976298-8C0D-11D3-B389-00C04F68574B}']
    property count: Integer readonly dispid 401;
    function Item(lIndex: Integer): WideString; dispid 402;
  end;

{ IWMPPlaylistCollection: Public interface. }

  IWMPPlaylistCollection = interface(IDispatch)
    ['{10A13217-23A7-439B-B1C0-D847C79B7774}']
    function newPlaylist(const bstrName: WideString): IWMPPlaylist; safecall;
    function getAll: IWMPPlaylistArray; safecall;
    function getByName(const bstrName: WideString): IWMPPlaylistArray; safecall;
    procedure remove(const pItem: IWMPPlaylist); safecall;
    procedure setDeleted(const pItem: IWMPPlaylist; varfIsDeleted: WordBool); safecall;
    function isDeleted(const pItem: IWMPPlaylist): WordBool; safecall;
    function importPlaylist(const pItem: IWMPPlaylist): IWMPPlaylist; safecall;
  end;

{ DispInterface declaration for Dual Interface IWMPPlaylistCollection }

  IWMPPlaylistCollectionDisp = dispinterface
    ['{10A13217-23A7-439B-B1C0-D847C79B7774}']
    function newPlaylist(const bstrName: WideString): IWMPPlaylist; dispid 552;
    function getAll: IWMPPlaylistArray; dispid 553;
    function getByName(const bstrName: WideString): IWMPPlaylistArray; dispid 554;
    procedure remove(const pItem: IWMPPlaylist); dispid 556;
    procedure setDeleted(const pItem: IWMPPlaylist; varfIsDeleted: WordBool); dispid 560;
    function isDeleted(const pItem: IWMPPlaylist): WordBool; dispid 561;
    function importPlaylist(const pItem: IWMPPlaylist): IWMPPlaylist; dispid 562;
  end;

{ IWMPPlaylistArray: Public interface. }

  IWMPPlaylistArray = interface(IDispatch)
    ['{679409C0-99F7-11D3-9FB7-00105AA620BB}']
    function Get_count: Integer; safecall;
    function Item(lIndex: Integer): IWMPPlaylist; safecall;
    property count: Integer read Get_count;
  end;

{ DispInterface declaration for Dual Interface IWMPPlaylistArray }

  IWMPPlaylistArrayDisp = dispinterface
    ['{679409C0-99F7-11D3-9FB7-00105AA620BB}']
    property count: Integer readonly dispid 501;
    function Item(lIndex: Integer): IWMPPlaylist; dispid 502;
  end;

{ IWMPNetwork: Public interface. }

  IWMPNetwork = interface(IDispatch)
    ['{EC21B779-EDEF-462D-BBA4-AD9DDE2B29A7}']
    function Get_bandWidth: Integer; safecall;
    function Get_recoveredPackets: Integer; safecall;
    function Get_sourceProtocol: WideString; safecall;
    function Get_receivedPackets: Integer; safecall;
    function Get_lostPackets: Integer; safecall;
    function Get_receptionQuality: Integer; safecall;
    function Get_bufferingCount: Integer; safecall;
    function Get_bufferingProgress: Integer; safecall;
    function Get_bufferingTime: Integer; safecall;
    procedure Set_bufferingTime(Value: Integer); safecall;
    function Get_frameRate: Integer; safecall;
    function Get_maxBitRate: Integer; safecall;
    function Get_bitRate: Integer; safecall;
    function getProxySettings(const bstrProtocol: WideString): Integer; safecall;
    procedure setProxySettings(const bstrProtocol: WideString; lProxySetting: Integer); safecall;
    function getProxyName(const bstrProtocol: WideString): WideString; safecall;
    procedure setProxyName(const bstrProtocol, bstrProxyName: WideString); safecall;
    function getProxyPort(const bstrProtocol: WideString): Integer; safecall;
    procedure setProxyPort(const bstrProtocol: WideString; lProxyPort: Integer); safecall;
    function getProxyExceptionList(const bstrProtocol: WideString): WideString; safecall;
    procedure setProxyExceptionList(const bstrProtocol, pbstrExceptionList: WideString); safecall;
    function getProxyBypassForLocal(const bstrProtocol: WideString): WordBool; safecall;
    procedure setProxyBypassForLocal(const bstrProtocol: WideString; fBypassForLocal: WordBool); safecall;
    function Get_maxBandwidth: Integer; safecall;
    procedure Set_maxBandwidth(Value: Integer); safecall;
    function Get_downloadProgress: Integer; safecall;
    function Get_encodedFrameRate: Integer; safecall;
    function Get_framesSkipped: Integer; safecall;
    property bandWidth: Integer read Get_bandWidth;
    property recoveredPackets: Integer read Get_recoveredPackets;
    property sourceProtocol: WideString read Get_sourceProtocol;
    property receivedPackets: Integer read Get_receivedPackets;
    property lostPackets: Integer read Get_lostPackets;
    property receptionQuality: Integer read Get_receptionQuality;
    property bufferingCount: Integer read Get_bufferingCount;
    property bufferingProgress: Integer read Get_bufferingProgress;
    property bufferingTime: Integer read Get_bufferingTime write Set_bufferingTime;
    property frameRate: Integer read Get_frameRate;
    property maxBitRate: Integer read Get_maxBitRate;
    property bitRate: Integer read Get_bitRate;
    property maxBandwidth: Integer read Get_maxBandwidth write Set_maxBandwidth;
    property downloadProgress: Integer read Get_downloadProgress;
    property encodedFrameRate: Integer read Get_encodedFrameRate;
    property framesSkipped: Integer read Get_framesSkipped;
  end;

{ DispInterface declaration for Dual Interface IWMPNetwork }

  IWMPNetworkDisp = dispinterface
    ['{EC21B779-EDEF-462D-BBA4-AD9DDE2B29A7}']
    property bandWidth: Integer readonly dispid 801;
    property recoveredPackets: Integer readonly dispid 802;
    property sourceProtocol: WideString readonly dispid 803;
    property receivedPackets: Integer readonly dispid 804;
    property lostPackets: Integer readonly dispid 805;
    property receptionQuality: Integer readonly dispid 806;
    property bufferingCount: Integer readonly dispid 807;
    property bufferingProgress: Integer readonly dispid 808;
    property bufferingTime: Integer dispid 809;
    property frameRate: Integer readonly dispid 810;
    property maxBitRate: Integer readonly dispid 811;
    property bitRate: Integer readonly dispid 812;
    function getProxySettings(const bstrProtocol: WideString): Integer; dispid 813;
    procedure setProxySettings(const bstrProtocol: WideString; lProxySetting: Integer); dispid 814;
    function getProxyName(const bstrProtocol: WideString): WideString; dispid 815;
    procedure setProxyName(const bstrProtocol, bstrProxyName: WideString); dispid 816;
    function getProxyPort(const bstrProtocol: WideString): Integer; dispid 817;
    procedure setProxyPort(const bstrProtocol: WideString; lProxyPort: Integer); dispid 818;
    function getProxyExceptionList(const bstrProtocol: WideString): WideString; dispid 819;
    procedure setProxyExceptionList(const bstrProtocol, pbstrExceptionList: WideString); dispid 820;
    function getProxyBypassForLocal(const bstrProtocol: WideString): WordBool; dispid 821;
    procedure setProxyBypassForLocal(const bstrProtocol: WideString; fBypassForLocal: WordBool); dispid 822;
    property maxBandwidth: Integer dispid 823;
    property downloadProgress: Integer readonly dispid 824;
    property encodedFrameRate: Integer readonly dispid 825;
    property framesSkipped: Integer readonly dispid 826;
  end;

{ IWMPCdromCollection: Public interface. }

  IWMPCdromCollection = interface(IDispatch)
    ['{EE4C8FE2-34B2-11D3-A3BF-006097C9B344}']
    function Get_count: Integer; safecall;
    function Item(lIndex: Integer): IWMPCdrom; safecall;
    function getByDriveSpecifier(const bstrDriveSpecifier: WideString): IWMPCdrom; safecall;
    property count: Integer read Get_count;
  end;

{ DispInterface declaration for Dual Interface IWMPCdromCollection }

  IWMPCdromCollectionDisp = dispinterface
    ['{EE4C8FE2-34B2-11D3-A3BF-006097C9B344}']
    property count: Integer readonly dispid 301;
    function Item(lIndex: Integer): IWMPCdrom; dispid 302;
    function getByDriveSpecifier(const bstrDriveSpecifier: WideString): IWMPCdrom; dispid 303;
  end;

{ IWMPCdrom: Public interface. }

  IWMPCdrom = interface(IDispatch)
    ['{CFAB6E98-8730-11D3-B388-00C04F68574B}']
    function Get_driveSpecifier: WideString; safecall;
    function Get_Playlist: IWMPPlaylist; safecall;
    procedure eject; safecall;
    property driveSpecifier: WideString read Get_driveSpecifier;
    property Playlist: IWMPPlaylist read Get_Playlist;
  end;

{ DispInterface declaration for Dual Interface IWMPCdrom }

  IWMPCdromDisp = dispinterface
    ['{CFAB6E98-8730-11D3-B388-00C04F68574B}']
    property driveSpecifier: WideString readonly dispid 251;
    property Playlist: IWMPPlaylist readonly dispid 252;
    procedure eject; dispid 253;
  end;

{ IWMPClosedCaption: Public interface. }

  IWMPClosedCaption = interface(IDispatch)
    ['{4F2DF574-C588-11D3-9ED0-00C04FB6E937}']
    function Get_SAMIStyle: WideString; safecall;
    procedure Set_SAMIStyle(const Value: WideString); safecall;
    function Get_SAMILang: WideString; safecall;
    procedure Set_SAMILang(const Value: WideString); safecall;
    function Get_SAMIFileName: WideString; safecall;
    procedure Set_SAMIFileName(const Value: WideString); safecall;
    function Get_captioningId: WideString; safecall;
    procedure Set_captioningId(const Value: WideString); safecall;
    property SAMIStyle: WideString read Get_SAMIStyle write Set_SAMIStyle;
    property SAMILang: WideString read Get_SAMILang write Set_SAMILang;
    property SAMIFileName: WideString read Get_SAMIFileName write Set_SAMIFileName;
    property captioningId: WideString read Get_captioningId write Set_captioningId;
  end;

{ DispInterface declaration for Dual Interface IWMPClosedCaption }

  IWMPClosedCaptionDisp = dispinterface
    ['{4F2DF574-C588-11D3-9ED0-00C04FB6E937}']
    property SAMIStyle: WideString dispid 951;
    property SAMILang: WideString dispid 952;
    property SAMIFileName: WideString dispid 953;
    property captioningId: WideString dispid 954;
  end;

{ IWMPError: Public interface. }

  IWMPError = interface(IDispatch)
    ['{A12DCF7D-14AB-4C1B-A8CD-63909F06025B}']
    procedure clearErrorQueue; safecall;
    function Get_errorCount: Integer; safecall;
    function Get_Item(dwIndex: Integer): IWMPErrorItem; safecall;
    procedure webHelp; safecall;
    property errorCount: Integer read Get_errorCount;
    property Item[dwIndex: Integer]: IWMPErrorItem read Get_Item;
  end;

{ DispInterface declaration for Dual Interface IWMPError }

  IWMPErrorDisp = dispinterface
    ['{A12DCF7D-14AB-4C1B-A8CD-63909F06025B}']
    procedure clearErrorQueue; dispid 851;
    property errorCount: Integer readonly dispid 852;
    property Item[dwIndex: Integer]: IWMPErrorItem readonly dispid 853;
    procedure webHelp; dispid 854;
  end;

{ IWMPErrorItem: Public interface. }

  IWMPErrorItem = interface(IDispatch)
    ['{3614C646-3B3B-4DE7-A81E-930E3F2127B3}']
    function Get_errorCode: Integer; safecall;
    function Get_errorDescription: WideString; safecall;
    function Get_errorContext: OleVariant; safecall;
    function Get_remedy: Integer; safecall;
    function Get_customUrl: WideString; safecall;
    property errorCode: Integer read Get_errorCode;
    property errorDescription: WideString read Get_errorDescription;
    property errorContext: OleVariant read Get_errorContext;
    property remedy: Integer read Get_remedy;
    property customUrl: WideString read Get_customUrl;
  end;

{ DispInterface declaration for Dual Interface IWMPErrorItem }

  IWMPErrorItemDisp = dispinterface
    ['{3614C646-3B3B-4DE7-A81E-930E3F2127B3}']
    property errorCode: Integer readonly dispid 901;
    property errorDescription: WideString readonly dispid 902;
    property errorContext: OleVariant readonly dispid 903;
    property remedy: Integer readonly dispid 904;
    property customUrl: WideString readonly dispid 905;
  end;

{ IWMPDVD: Public interface. }

  IWMPDVD = interface(IDispatch)
    ['{8DA61686-4668-4A5C-AE5D-803193293DBE}']
    function Get_isAvailable(const bstrItem: WideString): WordBool; safecall;
    function Get_domain: WideString; safecall;
    procedure topMenu; safecall;
    procedure titleMenu; safecall;
    procedure back; safecall;
    procedure resume; safecall;
    property isAvailable[const bstrItem: WideString]: WordBool read Get_isAvailable;
    property domain: WideString read Get_domain;
  end;

{ DispInterface declaration for Dual Interface IWMPDVD }

  IWMPDVDDisp = dispinterface
    ['{8DA61686-4668-4A5C-AE5D-803193293DBE}']
    property isAvailable[const bstrItem: WideString]: WordBool readonly dispid 1001;
    property domain: WideString readonly dispid 1002;
    procedure topMenu; dispid 1003;
    procedure titleMenu; dispid 1004;
    procedure back; dispid 1005;
    procedure resume; dispid 1006;
  end;

{ IWMPPlayerApplication: Public interface. }

  IWMPPlayerApplication = interface(IDispatch)
    ['{40897764-CEAB-47BE-AD4A-8E28537F9BBF}']
    procedure switchToPlayerApplication; safecall;
    procedure switchToControl; safecall;
    function Get_playerDocked: WordBool; safecall;
    function Get_hasDisplay: WordBool; safecall;
    property playerDocked: WordBool read Get_playerDocked;
    property hasDisplay: WordBool read Get_hasDisplay;
  end;

{ DispInterface declaration for Dual Interface IWMPPlayerApplication }

  IWMPPlayerApplicationDisp = dispinterface
    ['{40897764-CEAB-47BE-AD4A-8E28537F9BBF}']
    procedure switchToPlayerApplication; dispid 1101;
    procedure switchToControl; dispid 1102;
    property playerDocked: WordBool readonly dispid 1103;
    property hasDisplay: WordBool readonly dispid 1104;
  end;

{ IWMPPlayer3: Public interface. }

  IWMPPlayer3 = interface(IWMPCore2)
    ['{54062B68-052A-4C25-A39F-8B63346511D4}']
    function Get_enabled: WordBool; safecall;
    procedure Set_enabled(Value: WordBool); safecall;
    function Get_fullScreen: WordBool; safecall;
    procedure Set_fullScreen(Value: WordBool); safecall;
    function Get_enableContextMenu: WordBool; safecall;
    procedure Set_enableContextMenu(Value: WordBool); safecall;
    procedure Set_uiMode(const Value: WideString); safecall;
    function Get_uiMode: WideString; safecall;
    function Get_stretchToFit: WordBool; safecall;
    procedure Set_stretchToFit(Value: WordBool); safecall;
    function Get_windowlessVideo: WordBool; safecall;
    procedure Set_windowlessVideo(Value: WordBool); safecall;
    property enabled: WordBool read Get_enabled write Set_enabled;
    property fullScreen: WordBool read Get_fullScreen write Set_fullScreen;
    property enableContextMenu: WordBool read Get_enableContextMenu write Set_enableContextMenu;
    property uiMode: WideString read Get_uiMode write Set_uiMode;
    property stretchToFit: WordBool read Get_stretchToFit write Set_stretchToFit;
    property windowlessVideo: WordBool read Get_windowlessVideo write Set_windowlessVideo;
  end;

{ DispInterface declaration for Dual Interface IWMPPlayer3 }

  IWMPPlayer3Disp = dispinterface
    ['{54062B68-052A-4C25-A39F-8B63346511D4}']
    procedure close; dispid 3;
    property URL: WideString dispid 1;
    property openState: WMPOpenState readonly dispid 2;
    property playState: WMPPlayState readonly dispid 10;
    property controls: IWMPControls readonly dispid 4;
    property settings: IWMPSettings readonly dispid 5;
    property currentMedia: IWMPMedia dispid 6;
    property mediaCollection: IWMPMediaCollection readonly dispid 8;
    property playlistCollection: IWMPPlaylistCollection readonly dispid 9;
    property versionInfo: WideString readonly dispid 11;
    procedure launchURL(const bstrURL: WideString); dispid 12;
    property network: IWMPNetwork readonly dispid 7;
    property currentPlaylist: IWMPPlaylist dispid 13;
    property cdromCollection: IWMPCdromCollection readonly dispid 14;
    property closedCaption: IWMPClosedCaption readonly dispid 15;
    property isOnline: WordBool readonly dispid 16;
    property Error: IWMPError readonly dispid 17;
    property status: WideString readonly dispid 18;
    property dvd: IWMPDVD readonly dispid 40;
    property enabled: WordBool dispid 19;
    property fullScreen: WordBool dispid 21;
    property enableContextMenu: WordBool dispid 22;
    property uiMode: WideString dispid 23;
    property stretchToFit: WordBool dispid 24;
    property windowlessVideo: WordBool dispid 25;
  end;

{ IWMPPlayer2: Public interface. }

  IWMPPlayer2 = interface(IWMPCore)
    ['{0E6B01D1-D407-4C85-BF5F-1C01F6150280}']
    function Get_enabled: WordBool; safecall;
    procedure Set_enabled(Value: WordBool); safecall;
    function Get_fullScreen: WordBool; safecall;
    procedure Set_fullScreen(Value: WordBool); safecall;
    function Get_enableContextMenu: WordBool; safecall;
    procedure Set_enableContextMenu(Value: WordBool); safecall;
    procedure Set_uiMode(const Value: WideString); safecall;
    function Get_uiMode: WideString; safecall;
    function Get_stretchToFit: WordBool; safecall;
    procedure Set_stretchToFit(Value: WordBool); safecall;
    function Get_windowlessVideo: WordBool; safecall;
    procedure Set_windowlessVideo(Value: WordBool); safecall;
    property enabled: WordBool read Get_enabled write Set_enabled;
    property fullScreen: WordBool read Get_fullScreen write Set_fullScreen;
    property enableContextMenu: WordBool read Get_enableContextMenu write Set_enableContextMenu;
    property uiMode: WideString read Get_uiMode write Set_uiMode;
    property stretchToFit: WordBool read Get_stretchToFit write Set_stretchToFit;
    property windowlessVideo: WordBool read Get_windowlessVideo write Set_windowlessVideo;
  end;

{ DispInterface declaration for Dual Interface IWMPPlayer2 }

  IWMPPlayer2Disp = dispinterface
    ['{0E6B01D1-D407-4C85-BF5F-1C01F6150280}']
    procedure close; dispid 3;
    property URL: WideString dispid 1;
    property openState: WMPOpenState readonly dispid 2;
    property playState: WMPPlayState readonly dispid 10;
    property controls: IWMPControls readonly dispid 4;
    property settings: IWMPSettings readonly dispid 5;
    property currentMedia: IWMPMedia dispid 6;
    property mediaCollection: IWMPMediaCollection readonly dispid 8;
    property playlistCollection: IWMPPlaylistCollection readonly dispid 9;
    property versionInfo: WideString readonly dispid 11;
    procedure launchURL(const bstrURL: WideString); dispid 12;
    property network: IWMPNetwork readonly dispid 7;
    property currentPlaylist: IWMPPlaylist dispid 13;
    property cdromCollection: IWMPCdromCollection readonly dispid 14;
    property closedCaption: IWMPClosedCaption readonly dispid 15;
    property isOnline: WordBool readonly dispid 16;
    property Error: IWMPError readonly dispid 17;
    property status: WideString readonly dispid 18;
    property enabled: WordBool dispid 19;
    property fullScreen: WordBool dispid 21;
    property enableContextMenu: WordBool dispid 22;
    property uiMode: WideString dispid 23;
    property stretchToFit: WordBool dispid 24;
    property windowlessVideo: WordBool dispid 25;
  end;

{ IWMPPlayer: Public interface. }

  IWMPPlayer = interface(IWMPCore)
    ['{6BF52A4F-394A-11D3-B153-00C04F79FAA6}']
    function Get_enabled: WordBool; safecall;
    procedure Set_enabled(Value: WordBool); safecall;
    function Get_fullScreen: WordBool; safecall;
    procedure Set_fullScreen(Value: WordBool); safecall;
    function Get_enableContextMenu: WordBool; safecall;
    procedure Set_enableContextMenu(Value: WordBool); safecall;
    procedure Set_uiMode(const Value: WideString); safecall;
    function Get_uiMode: WideString; safecall;
    property enabled: WordBool read Get_enabled write Set_enabled;
    property fullScreen: WordBool read Get_fullScreen write Set_fullScreen;
    property enableContextMenu: WordBool read Get_enableContextMenu write Set_enableContextMenu;
    property uiMode: WideString read Get_uiMode write Set_uiMode;
  end;

{ DispInterface declaration for Dual Interface IWMPPlayer }

  IWMPPlayerDisp = dispinterface
    ['{6BF52A4F-394A-11D3-B153-00C04F79FAA6}']
    procedure close; dispid 3;
    property URL: WideString dispid 1;
    property openState: WMPOpenState readonly dispid 2;
    property playState: WMPPlayState readonly dispid 10;
    property controls: IWMPControls readonly dispid 4;
    property settings: IWMPSettings readonly dispid 5;
    property currentMedia: IWMPMedia dispid 6;
    property mediaCollection: IWMPMediaCollection readonly dispid 8;
    property playlistCollection: IWMPPlaylistCollection readonly dispid 9;
    property versionInfo: WideString readonly dispid 11;
    procedure launchURL(const bstrURL: WideString); dispid 12;
    property network: IWMPNetwork readonly dispid 7;
    property currentPlaylist: IWMPPlaylist dispid 13;
    property cdromCollection: IWMPCdromCollection readonly dispid 14;
    property closedCaption: IWMPClosedCaption readonly dispid 15;
    property isOnline: WordBool readonly dispid 16;
    property Error: IWMPError readonly dispid 17;
    property status: WideString readonly dispid 18;
    property enabled: WordBool dispid 19;
    property fullScreen: WordBool dispid 21;
    property enableContextMenu: WordBool dispid 22;
    property uiMode: WideString dispid 23;
  end;

{ IWMPErrorItem2: Public interface. }

  IWMPErrorItem2 = interface(IWMPErrorItem)
    ['{F75CCEC0-C67C-475C-931E-8719870BEE7D}']
    function Get_condition: Integer; safecall;
    property condition: Integer read Get_condition;
  end;

{ DispInterface declaration for Dual Interface IWMPErrorItem2 }

  IWMPErrorItem2Disp = dispinterface
    ['{F75CCEC0-C67C-475C-931E-8719870BEE7D}']
    property errorCode: Integer readonly dispid 901;
    property errorDescription: WideString readonly dispid 902;
    property errorContext: OleVariant readonly dispid 903;
    property remedy: Integer readonly dispid 904;
    property customUrl: WideString readonly dispid 905;
    property condition: Integer readonly dispid 906;
  end;

{ IWMPControls2: Public interface. }

  IWMPControls2 = interface(IWMPControls)
    ['{6F030D25-0890-480F-9775-1F7E40AB5B8E}']
    procedure step(lStep: Integer); safecall;
  end;

{ DispInterface declaration for Dual Interface IWMPControls2 }

  IWMPControls2Disp = dispinterface
    ['{6F030D25-0890-480F-9775-1F7E40AB5B8E}']
    property isAvailable[const bstrItem: WideString]: WordBool readonly dispid 62;
    procedure play; dispid 51;
    procedure stop; dispid 52;
    procedure pause; dispid 53;
    procedure fastForward; dispid 54;
    procedure fastReverse; dispid 55;
    property currentPosition: Double dispid 56;
    property currentPositionString: WideString readonly dispid 57;
    procedure next; dispid 58;
    procedure previous; dispid 59;
    property currentItem: IWMPMedia dispid 60;
    property currentMarker: Integer dispid 61;
    procedure playItem(const pIWMPMedia: IWMPMedia); dispid 63;
    procedure step(lStep: Integer); dispid 64;
  end;

{ IWMPMedia2: Public interface. }

  IWMPMedia2 = interface(IWMPMedia)
    ['{AB7C88BB-143E-4EA4-ACC3-E4350B2106C3}']
    function Get_Error: IWMPErrorItem; safecall;
    property Error: IWMPErrorItem read Get_Error;
  end;

{ DispInterface declaration for Dual Interface IWMPMedia2 }

  IWMPMedia2Disp = dispinterface
    ['{AB7C88BB-143E-4EA4-ACC3-E4350B2106C3}']
    property isIdentical[const pIWMPMedia: IWMPMedia]: WordBool readonly dispid 763;
    property sourceURL: WideString readonly dispid 751;
    property name: WideString dispid 764;
    property imageSourceWidth: Integer readonly dispid 752;
    property imageSourceHeight: Integer readonly dispid 753;
    property markerCount: Integer readonly dispid 754;
    function getMarkerTime(MarkerNum: Integer): Double; dispid 755;
    function getMarkerName(MarkerNum: Integer): WideString; dispid 756;
    property duration: Double readonly dispid 757;
    property durationString: WideString readonly dispid 758;
    property attributeCount: Integer readonly dispid 759;
    function getAttributeName(lIndex: Integer): WideString; dispid 760;
    function getItemInfo(const bstrItemName: WideString): WideString; dispid 761;
    procedure setItemInfo(const bstrItemName, bstrVal: WideString); dispid 762;
    function getItemInfoByAtom(lAtom: Integer): WideString; dispid 765;
    function isMemberOf(const pPlaylist: IWMPPlaylist): WordBool; dispid 766;
    function isReadOnlyItem(const bstrItemName: WideString): WordBool; dispid 767;
    property Error: IWMPErrorItem readonly dispid 768;
  end;

{ IWMPMedia3: Public interface. }

  IWMPMedia3 = interface(IWMPMedia2)
    ['{F118EFC7-F03A-4FB4-99C9-1C02A5C1065B}']
    function getAttributeCountByType(const bstrType, bstrLanguage: WideString): Integer; safecall;
    function getItemInfoByType(const bstrType, bstrLanguage: WideString; lIndex: Integer): OleVariant; safecall;
  end;

{ DispInterface declaration for Dual Interface IWMPMedia3 }

  IWMPMedia3Disp = dispinterface
    ['{F118EFC7-F03A-4FB4-99C9-1C02A5C1065B}']
    property isIdentical[const pIWMPMedia: IWMPMedia]: WordBool readonly dispid 763;
    property sourceURL: WideString readonly dispid 751;
    property name: WideString dispid 764;
    property imageSourceWidth: Integer readonly dispid 752;
    property imageSourceHeight: Integer readonly dispid 753;
    property markerCount: Integer readonly dispid 754;
    function getMarkerTime(MarkerNum: Integer): Double; dispid 755;
    function getMarkerName(MarkerNum: Integer): WideString; dispid 756;
    property duration: Double readonly dispid 757;
    property durationString: WideString readonly dispid 758;
    property attributeCount: Integer readonly dispid 759;
    function getAttributeName(lIndex: Integer): WideString; dispid 760;
    function getItemInfo(const bstrItemName: WideString): WideString; dispid 761;
    procedure setItemInfo(const bstrItemName, bstrVal: WideString); dispid 762;
    function getItemInfoByAtom(lAtom: Integer): WideString; dispid 765;
    function isMemberOf(const pPlaylist: IWMPPlaylist): WordBool; dispid 766;
    function isReadOnlyItem(const bstrItemName: WideString): WordBool; dispid 767;
    property Error: IWMPErrorItem readonly dispid 768;
    function getAttributeCountByType(const bstrType, bstrLanguage: WideString): Integer; dispid 769;
    function getItemInfoByType(const bstrType, bstrLanguage: WideString; lIndex: Integer): OleVariant; dispid 770;
  end;

{ IWMPMetadataPicture: Not Public.  Internal interface used by Windows Media Player. }

  IWMPMetadataPicture = interface(IDispatch)
    ['{5C29BBE0-F87D-4C45-AA28-A70F0230FFA9}']
    function Get_mimeType: WideString; safecall;
    function Get_pictureType: WideString; safecall;
    function Get_Description: WideString; safecall;
    function Get_URL: WideString; safecall;
    property mimeType: WideString read Get_mimeType;
    property pictureType: WideString read Get_pictureType;
    property Description: WideString read Get_Description;
    property URL: WideString read Get_URL;
  end;

{ DispInterface declaration for Dual Interface IWMPMetadataPicture }

  IWMPMetadataPictureDisp = dispinterface
    ['{5C29BBE0-F87D-4C45-AA28-A70F0230FFA9}']
    property mimeType: WideString readonly dispid 1051;
    property pictureType: WideString readonly dispid 1052;
    property Description: WideString readonly dispid 1053;
    property URL: WideString readonly dispid 1054;
  end;

{ IWMPMetadataText: Not Public.  Internal interface used by Windows Media Player. }

  IWMPMetadataText = interface(IDispatch)
    ['{769A72DB-13D2-45E2-9C48-53CA9D5B7450}']
    function Get_Description: WideString; safecall;
    function Get_text: WideString; safecall;
    property Description: WideString read Get_Description;
    property text: WideString read Get_text;
  end;

{ DispInterface declaration for Dual Interface IWMPMetadataText }

  IWMPMetadataTextDisp = dispinterface
    ['{769A72DB-13D2-45E2-9C48-53CA9D5B7450}']
    property Description: WideString readonly dispid 1056;
    property text: WideString readonly dispid 1055;
  end;

{ IWMPSettings2: Public interface. }

  IWMPSettings2 = interface(IWMPSettings)
    ['{FDA937A4-EECE-4DA5-A0B6-39BF89ADE2C2}']
    function Get_defaultAudioLanguage: Integer; safecall;
    function Get_mediaAccessRights: WideString; safecall;
    function requestMediaAccessRights(const bstrDesiredAccess: WideString): WordBool; safecall;
    property defaultAudioLanguage: Integer read Get_defaultAudioLanguage;
    property mediaAccessRights: WideString read Get_mediaAccessRights;
  end;

{ DispInterface declaration for Dual Interface IWMPSettings2 }

  IWMPSettings2Disp = dispinterface
    ['{FDA937A4-EECE-4DA5-A0B6-39BF89ADE2C2}']
    property isAvailable[const bstrItem: WideString]: WordBool readonly dispid 113;
    property autoStart: WordBool dispid 101;
    property baseURL: WideString dispid 108;
    property defaultFrame: WideString dispid 109;
    property invokeURLs: WordBool dispid 103;
    property mute: WordBool dispid 104;
    property playCount: Integer dispid 105;
    property rate: Double dispid 106;
    property balance: Integer dispid 102;
    property volume: Integer dispid 107;
    function getMode(const bstrMode: WideString): WordBool; dispid 110;
    procedure setMode(const bstrMode: WideString; varfMode: WordBool); dispid 111;
    property enableErrorDialogs: WordBool dispid 112;
    property defaultAudioLanguage: Integer readonly dispid 114;
    property mediaAccessRights: WideString readonly dispid 115;
    function requestMediaAccessRights(const bstrDesiredAccess: WideString): WordBool; dispid 116;
  end;

{ IWMPControls3: Public interface. }

  IWMPControls3 = interface(IWMPControls2)
    ['{A1D1110E-D545-476A-9A78-AC3E4CB1E6BD}']
    function Get_audioLanguageCount: Integer; safecall;
    function getAudioLanguageID(lIndex: Integer): Integer; safecall;
    function getAudioLanguageDescription(lIndex: Integer): WideString; safecall;
    function Get_currentAudioLanguage: Integer; safecall;
    procedure Set_currentAudioLanguage(Value: Integer); safecall;
    function Get_currentAudioLanguageIndex: Integer; safecall;
    procedure Set_currentAudioLanguageIndex(Value: Integer); safecall;
    function getLanguageName(lLangID: Integer): WideString; safecall;
    function Get_currentPositionTimecode: WideString; safecall;
    procedure Set_currentPositionTimecode(const Value: WideString); safecall;
    property audioLanguageCount: Integer read Get_audioLanguageCount;
    property currentAudioLanguage: Integer read Get_currentAudioLanguage write Set_currentAudioLanguage;
    property currentAudioLanguageIndex: Integer read Get_currentAudioLanguageIndex write Set_currentAudioLanguageIndex;
    property currentPositionTimecode: WideString read Get_currentPositionTimecode write Set_currentPositionTimecode;
  end;

{ DispInterface declaration for Dual Interface IWMPControls3 }

  IWMPControls3Disp = dispinterface
    ['{A1D1110E-D545-476A-9A78-AC3E4CB1E6BD}']
    property isAvailable[const bstrItem: WideString]: WordBool readonly dispid 62;
    procedure play; dispid 51;
    procedure stop; dispid 52;
    procedure pause; dispid 53;
    procedure fastForward; dispid 54;
    procedure fastReverse; dispid 55;
    property currentPosition: Double dispid 56;
    property currentPositionString: WideString readonly dispid 57;
    procedure next; dispid 58;
    procedure previous; dispid 59;
    property currentItem: IWMPMedia dispid 60;
    property currentMarker: Integer dispid 61;
    procedure playItem(const pIWMPMedia: IWMPMedia); dispid 63;
    procedure step(lStep: Integer); dispid 64;
    property audioLanguageCount: Integer readonly dispid 65;
    function getAudioLanguageID(lIndex: Integer): Integer; dispid 66;
    function getAudioLanguageDescription(lIndex: Integer): WideString; dispid 67;
    property currentAudioLanguage: Integer dispid 68;
    property currentAudioLanguageIndex: Integer dispid 69;
    function getLanguageName(lLangID: Integer): WideString; dispid 70;
    property currentPositionTimecode: WideString dispid 71;
  end;

{ IWMPClosedCaption2: Public interface. }

  IWMPClosedCaption2 = interface(IWMPClosedCaption)
    ['{350BA78B-6BC8-4113-A5F5-312056934EB6}']
    function Get_SAMILangCount: Integer; safecall;
    function getSAMILangName(nIndex: Integer): WideString; safecall;
    function getSAMILangID(nIndex: Integer): Integer; safecall;
    function Get_SAMIStyleCount: Integer; safecall;
    function getSAMIStyleName(nIndex: Integer): WideString; safecall;
    property SAMILangCount: Integer read Get_SAMILangCount;
    property SAMIStyleCount: Integer read Get_SAMIStyleCount;
  end;

{ DispInterface declaration for Dual Interface IWMPClosedCaption2 }

  IWMPClosedCaption2Disp = dispinterface
    ['{350BA78B-6BC8-4113-A5F5-312056934EB6}']
    property SAMIStyle: WideString dispid 951;
    property SAMILang: WideString dispid 952;
    property SAMIFileName: WideString dispid 953;
    property captioningId: WideString dispid 954;
    property SAMILangCount: Integer readonly dispid 955;
    function getSAMILangName(nIndex: Integer): WideString; dispid 956;
    function getSAMILangID(nIndex: Integer): Integer; dispid 957;
    property SAMIStyleCount: Integer readonly dispid 958;
    function getSAMIStyleName(nIndex: Integer): WideString; dispid 959;
  end;

{ IWMPPlaylistCtrl: Public interface for skin object model. }

  IWMPPlaylistCtrl = interface(IDispatch)
    ['{5F9CFD92-8CAD-11D3-9A7E-00C04F8EFB70}']
    function Get_Playlist: IWMPPlaylist; safecall;
    procedure Set_Playlist(const Value: IWMPPlaylist); safecall;
    function Get_columns: WideString; safecall;
    procedure Set_columns(const Value: WideString); safecall;
    function Get_columnCount: Integer; safecall;
    function Get_columnOrder: WideString; safecall;
    procedure Set_columnOrder(const Value: WideString); safecall;
    function Get_columnsVisible: WordBool; safecall;
    procedure Set_columnsVisible(Value: WordBool); safecall;
    function Get_dropDownVisible: WordBool; safecall;
    procedure Set_dropDownVisible(Value: WordBool); safecall;
    function Get_playlistItemsVisible: WordBool; safecall;
    procedure Set_playlistItemsVisible(Value: WordBool); safecall;
    function Get_checkboxesVisible: WordBool; safecall;
    procedure Set_checkboxesVisible(Value: WordBool); safecall;
    function Get_backgroundColor: WideString; safecall;
    procedure Set_backgroundColor(const Value: WideString); safecall;
    function Get_foregroundColor: WideString; safecall;
    procedure Set_foregroundColor(const Value: WideString); safecall;
    function Get_disabledItemColor: WideString; safecall;
    procedure Set_disabledItemColor(const Value: WideString); safecall;
    function Get_itemPlayingColor: WideString; safecall;
    procedure Set_itemPlayingColor(const Value: WideString); safecall;
    function Get_itemPlayingBackgroundColor: WideString; safecall;
    procedure Set_itemPlayingBackgroundColor(const Value: WideString); safecall;
    function Get_backgroundImage: WideString; safecall;
    procedure Set_backgroundImage(const Value: WideString); safecall;
    function Get_allowItemEditing: WordBool; safecall;
    procedure Set_allowItemEditing(Value: WordBool); safecall;
    function Get_allowColumnSorting: WordBool; safecall;
    procedure Set_allowColumnSorting(Value: WordBool); safecall;
    function Get_dropDownList: WideString; safecall;
    procedure Set_dropDownList(const Value: WideString); safecall;
    function Get_dropDownToolTip: WideString; safecall;
    procedure Set_dropDownToolTip(const Value: WideString); safecall;
    function Get_copying: WordBool; safecall;
    procedure copy; safecall;
    procedure abortCopy; safecall;
    procedure deleteSelected; safecall;
    procedure deleteSelectedFromLibrary; safecall;
    procedure moveSelectedUp; safecall;
    procedure moveSelectedDown; safecall;
    procedure addSelectedToPlaylist(const pdispPlaylist: IWMPPlaylist); safecall;
    function getNextSelectedItem(nStartIndex: Integer): Integer; safecall;
    function getNextCheckedItem(nStartIndex: Integer): Integer; safecall;
    procedure setSelectedState(nIndex: Integer; vbSelected: WordBool); safecall;
    procedure setCheckedState(nIndex: Integer; vbChecked: WordBool); safecall;
    procedure sortColumn(nIndex: Integer); safecall;
    procedure setColumnResizeMode(nIndex: Integer; const newMode: WideString); safecall;
    procedure setColumnWidth(nIndex, nWidth: Integer); safecall;
    function Get_itemErrorColor: WideString; safecall;
    procedure Set_itemErrorColor(const Value: WideString); safecall;
    function Get_itemCount: Integer; safecall;
    function Get_itemMedia(nIndex: Integer): IWMPMedia; safecall;
    function Get_itemPlaylist(nIndex: Integer): IWMPPlaylist; safecall;
    function getNextSelectedItem2(nStartIndex: Integer): Integer; safecall;
    function getNextCheckedItem2(nStartIndex: Integer): Integer; safecall;
    procedure setSelectedState2(nIndex: Integer; vbSelected: WordBool); safecall;
    procedure setCheckedState2(nIndex: Integer; vbChecked: WordBool); safecall;
    function Get_leftStatus: WideString; safecall;
    procedure Set_leftStatus(const Value: WideString); safecall;
    function Get_rightStatus: WideString; safecall;
    procedure Set_rightStatus(const Value: WideString); safecall;
    function Get_editButtonVisible: WordBool; safecall;
    procedure Set_editButtonVisible(Value: WordBool); safecall;
    function Get_dropDownImage: WideString; safecall;
    procedure Set_dropDownImage(const Value: WideString); safecall;
    function Get_dropDownBackgroundImage: WideString; safecall;
    procedure Set_dropDownBackgroundImage(const Value: WideString); safecall;
    function Get_hueShift: Single; safecall;
    procedure Set_hueShift(Value: Single); safecall;
    function Get_saturation: Single; safecall;
    procedure Set_saturation(Value: Single); safecall;
    function Get_statusColor: WideString; safecall;
    procedure Set_statusColor(const Value: WideString); safecall;
    property Playlist: IWMPPlaylist read Get_Playlist write Set_Playlist;
    property columns: WideString read Get_columns write Set_columns;
    property columnCount: Integer read Get_columnCount;
    property columnOrder: WideString read Get_columnOrder write Set_columnOrder;
    property columnsVisible: WordBool read Get_columnsVisible write Set_columnsVisible;
    property dropDownVisible: WordBool read Get_dropDownVisible write Set_dropDownVisible;
    property playlistItemsVisible: WordBool read Get_playlistItemsVisible write Set_playlistItemsVisible;
    property checkboxesVisible: WordBool read Get_checkboxesVisible write Set_checkboxesVisible;
    property backgroundColor: WideString read Get_backgroundColor write Set_backgroundColor;
    property foregroundColor: WideString read Get_foregroundColor write Set_foregroundColor;
    property disabledItemColor: WideString read Get_disabledItemColor write Set_disabledItemColor;
    property itemPlayingColor: WideString read Get_itemPlayingColor write Set_itemPlayingColor;
    property itemPlayingBackgroundColor: WideString read Get_itemPlayingBackgroundColor write Set_itemPlayingBackgroundColor;
    property backgroundImage: WideString read Get_backgroundImage write Set_backgroundImage;
    property allowItemEditing: WordBool read Get_allowItemEditing write Set_allowItemEditing;
    property allowColumnSorting: WordBool read Get_allowColumnSorting write Set_allowColumnSorting;
    property dropDownList: WideString read Get_dropDownList write Set_dropDownList;
    property dropDownToolTip: WideString read Get_dropDownToolTip write Set_dropDownToolTip;
    property copying: WordBool read Get_copying;
    property itemErrorColor: WideString read Get_itemErrorColor write Set_itemErrorColor;
    property itemCount: Integer read Get_itemCount;
    property itemMedia[nIndex: Integer]: IWMPMedia read Get_itemMedia;
    property itemPlaylist[nIndex: Integer]: IWMPPlaylist read Get_itemPlaylist;
    property leftStatus: WideString read Get_leftStatus write Set_leftStatus;
    property rightStatus: WideString read Get_rightStatus write Set_rightStatus;
    property editButtonVisible: WordBool read Get_editButtonVisible write Set_editButtonVisible;
    property dropDownImage: WideString read Get_dropDownImage write Set_dropDownImage;
    property dropDownBackgroundImage: WideString read Get_dropDownBackgroundImage write Set_dropDownBackgroundImage;
    property hueShift: Single read Get_hueShift write Set_hueShift;
    property saturation: Single read Get_saturation write Set_saturation;
    property statusColor: WideString read Get_statusColor write Set_statusColor;
  end;

{ DispInterface declaration for Dual Interface IWMPPlaylistCtrl }

  IWMPPlaylistCtrlDisp = dispinterface
    ['{5F9CFD92-8CAD-11D3-9A7E-00C04F8EFB70}']
    property Playlist: IWMPPlaylist dispid 5601;
    property columns: WideString dispid 5602;
    property columnCount: Integer readonly dispid 5603;
    property columnOrder: WideString dispid 5604;
    property columnsVisible: WordBool dispid 5605;
    property dropDownVisible: WordBool dispid 5607;
    property playlistItemsVisible: WordBool dispid 5608;
    property checkboxesVisible: WordBool dispid 5609;
    property backgroundColor: WideString dispid 5612;
    property foregroundColor: WideString dispid 5613;
    property disabledItemColor: WideString dispid 5614;
    property itemPlayingColor: WideString dispid 5615;
    property itemPlayingBackgroundColor: WideString dispid 5616;
    property backgroundImage: WideString dispid 5617;
    property allowItemEditing: WordBool dispid 5618;
    property allowColumnSorting: WordBool dispid 5619;
    property dropDownList: WideString dispid 5620;
    property dropDownToolTip: WideString dispid 5621;
    property copying: WordBool readonly dispid 5622;
    procedure copy; dispid 5623;
    procedure abortCopy; dispid 5624;
    procedure deleteSelected; dispid 5625;
    procedure deleteSelectedFromLibrary; dispid 5626;
    procedure moveSelectedUp; dispid 5628;
    procedure moveSelectedDown; dispid 5629;
    procedure addSelectedToPlaylist(const pdispPlaylist: IWMPPlaylist); dispid 5630;
    function getNextSelectedItem(nStartIndex: Integer): Integer; dispid 5631;
    function getNextCheckedItem(nStartIndex: Integer): Integer; dispid 5632;
    procedure setSelectedState(nIndex: Integer; vbSelected: WordBool); dispid 5633;
    procedure setCheckedState(nIndex: Integer; vbChecked: WordBool); dispid 5634;
    procedure sortColumn(nIndex: Integer); dispid 5635;
    procedure setColumnResizeMode(nIndex: Integer; const newMode: WideString); dispid 5636;
    procedure setColumnWidth(nIndex, nWidth: Integer); dispid 5637;
    property itemErrorColor: WideString dispid 5642;
    property itemCount: Integer readonly dispid 5643;
    property itemMedia[nIndex: Integer]: IWMPMedia readonly dispid 5644;
    property itemPlaylist[nIndex: Integer]: IWMPPlaylist readonly dispid 5645;
    function getNextSelectedItem2(nStartIndex: Integer): Integer; dispid 5646;
    function getNextCheckedItem2(nStartIndex: Integer): Integer; dispid 5647;
    procedure setSelectedState2(nIndex: Integer; vbSelected: WordBool); dispid 5648;
    procedure setCheckedState2(nIndex: Integer; vbChecked: WordBool); dispid 5649;
    property leftStatus: WideString dispid 5650;
    property rightStatus: WideString dispid 5651;
    property editButtonVisible: WordBool dispid 5652;
    property dropDownImage: WideString dispid 5653;
    property dropDownBackgroundImage: WideString dispid 5654;
    property hueShift: Single dispid 5655;
    property saturation: Single dispid 5656;
    property statusColor: WideString dispid 5658;
  end;

{ IAppDispatch: Not Public.  Internal interface used by Windows Media Player. }

  IAppDispatch = interface(IDispatch)
    ['{E41C88DD-2364-4FF7-A0F5-CA9859AF783F}']
    function Get_titlebarVisible: WordBool; safecall;
    procedure Set_titlebarVisible(Value: WordBool); safecall;
    function Get_titlebarAutoHide: WordBool; safecall;
    procedure Set_titlebarAutoHide(Value: WordBool); safecall;
    function Get_currentTask: WideString; safecall;
    procedure Set_currentTask(const Value: WideString); safecall;
    function Get_settingsVisible: WordBool; safecall;
    procedure Set_settingsVisible(Value: WordBool); safecall;
    function Get_playlistVisible: WordBool; safecall;
    procedure Set_playlistVisible(Value: WordBool); safecall;
    procedure gotoSkinMode; safecall;
    procedure adjustLeft(nDistance: Integer); safecall;
    function Get_taskbarVisible: WordBool; safecall;
    procedure Set_taskbarVisible(Value: WordBool); safecall;
    function Get_titlebarCurrentlyVisible: WordBool; safecall;
    function Get_bgPluginRunning: WordBool; safecall;
    procedure configurePlugins(nType: Integer); safecall;
    function getTimeString(dTime: Double): WideString; safecall;
    function Get_isXPOrBetter: WordBool; safecall;
    function Get_maximized: WordBool; safecall;
    property titlebarVisible: WordBool read Get_titlebarVisible write Set_titlebarVisible;
    property titlebarAutoHide: WordBool read Get_titlebarAutoHide write Set_titlebarAutoHide;
    property currentTask: WideString read Get_currentTask write Set_currentTask;
    property settingsVisible: WordBool read Get_settingsVisible write Set_settingsVisible;
    property playlistVisible: WordBool read Get_playlistVisible write Set_playlistVisible;
    property taskbarVisible: WordBool read Get_taskbarVisible write Set_taskbarVisible;
    property titlebarCurrentlyVisible: WordBool read Get_titlebarCurrentlyVisible;
    property bgPluginRunning: WordBool read Get_bgPluginRunning;
    property isXPOrBetter: WordBool read Get_isXPOrBetter;
    property maximized: WordBool read Get_maximized;
  end;

{ DispInterface declaration for Dual Interface IAppDispatch }

  IAppDispatchDisp = dispinterface
    ['{E41C88DD-2364-4FF7-A0F5-CA9859AF783F}']
    property titlebarVisible: WordBool dispid 100;
    property titlebarAutoHide: WordBool dispid 101;
    property currentTask: WideString dispid 102;
    property settingsVisible: WordBool dispid 103;
    property playlistVisible: WordBool dispid 104;
    procedure gotoSkinMode; dispid 105;
    procedure adjustLeft(nDistance: Integer); dispid 106;
    property taskbarVisible: WordBool dispid 107;
    property titlebarCurrentlyVisible: WordBool readonly dispid 108;
    property bgPluginRunning: WordBool readonly dispid 109;
    procedure configurePlugins(nType: Integer); dispid 110;
    function getTimeString(dTime: Double): WideString; dispid 111;
    property isXPOrBetter: WordBool readonly dispid 112;
    property maximized: WordBool readonly dispid 113;
  end;

{ IWMPSafeBrowser: Not Public.  Internal interface used by Windows Media Player. }

  IWMPSafeBrowser = interface(IDispatch)
    ['{EF870383-83AB-4EA9-BE48-56FA4251AF10}']
    function Get_URL: WideString; safecall;
    procedure Set_URL(const Value: WideString); safecall;
    function Get_status: Integer; safecall;
    function Get_pendingDownloads: Integer; safecall;
    procedure showSAMIText(const samiText: WideString); safecall;
    procedure showLyrics(const lyrics: WideString); safecall;
    procedure loadSpecialPage(const pageName: WideString); safecall;
    procedure goBack; safecall;
    procedure goForward; safecall;
    procedure stop; safecall;
    procedure refresh; safecall;
    property URL: WideString read Get_URL write Set_URL;
    property status: Integer read Get_status;
    property pendingDownloads: Integer read Get_pendingDownloads;
  end;

{ DispInterface declaration for Dual Interface IWMPSafeBrowser }

  IWMPSafeBrowserDisp = dispinterface
    ['{EF870383-83AB-4EA9-BE48-56FA4251AF10}']
    property URL: WideString dispid 8400;
    property status: Integer readonly dispid 8401;
    property pendingDownloads: Integer readonly dispid 8402;
    procedure showSAMIText(const samiText: WideString); dispid 8403;
    procedure showLyrics(const lyrics: WideString); dispid 8404;
    procedure loadSpecialPage(const pageName: WideString); dispid 8405;
    procedure goBack; dispid 8406;
    procedure goForward; dispid 8407;
    procedure stop; dispid 8408;
    procedure refresh; dispid 8409;
  end;

{ IWMPObjectExtendedProps: Public interface for skin object model. }

  IWMPObjectExtendedProps = interface(IDispatch)
    ['{21D077C1-4BAA-11D3-BD45-00C04F6EA5AE}']
    function Get_id: WideString; safecall;
    function Get_elementType: WideString; safecall;
    function Get_left: Integer; safecall;
    procedure Set_left(Value: Integer); safecall;
    function Get_top: Integer; safecall;
    procedure Set_top(Value: Integer); safecall;
    function Get_width: Integer; safecall;
    procedure Set_width(Value: Integer); safecall;
    function Get_height: Integer; safecall;
    procedure Set_height(Value: Integer); safecall;
    function Get_zIndex: Integer; safecall;
    procedure Set_zIndex(Value: Integer); safecall;
    function Get_clippingImage: WideString; safecall;
    procedure Set_clippingImage(const Value: WideString); safecall;
    function Get_clippingColor: WideString; safecall;
    procedure Set_clippingColor(const Value: WideString); safecall;
    function Get_visible: WordBool; safecall;
    procedure Set_visible(Value: WordBool); safecall;
    function Get_enabled: WordBool; safecall;
    procedure Set_enabled(Value: WordBool); safecall;
    function Get_tabStop: WordBool; safecall;
    procedure Set_tabStop(Value: WordBool); safecall;
    function Get_passThrough: WordBool; safecall;
    procedure Set_passThrough(Value: WordBool); safecall;
    function Get_horizontalAlignment: WideString; safecall;
    procedure Set_horizontalAlignment(const Value: WideString); safecall;
    function Get_verticalAlignment: WideString; safecall;
    procedure Set_verticalAlignment(const Value: WideString); safecall;
    procedure moveTo(newX, newY, moveTime: Integer); safecall;
    function Get_alphaBlend: Integer; safecall;
    procedure Set_alphaBlend(Value: Integer); safecall;
    procedure alphaBlendTo(newVal, alphaTime: Integer); safecall;
    function Get_accName: WideString; safecall;
    procedure Set_accName(const Value: WideString); safecall;
    function Get_accDescription: WideString; safecall;
    procedure Set_accDescription(const Value: WideString); safecall;
    function Get_accKeyboardShortcut: WideString; safecall;
    procedure Set_accKeyboardShortcut(const Value: WideString); safecall;
    property id: WideString read Get_id;
    property elementType: WideString read Get_elementType;
    property left: Integer read Get_left write Set_left;
    property top: Integer read Get_top write Set_top;
    property width: Integer read Get_width write Set_width;
    property height: Integer read Get_height write Set_height;
    property zIndex: Integer read Get_zIndex write Set_zIndex;
    property clippingImage: WideString read Get_clippingImage write Set_clippingImage;
    property clippingColor: WideString read Get_clippingColor write Set_clippingColor;
    property visible: WordBool read Get_visible write Set_visible;
    property enabled: WordBool read Get_enabled write Set_enabled;
    property tabStop: WordBool read Get_tabStop write Set_tabStop;
    property passThrough: WordBool read Get_passThrough write Set_passThrough;
    property horizontalAlignment: WideString read Get_horizontalAlignment write Set_horizontalAlignment;
    property verticalAlignment: WideString read Get_verticalAlignment write Set_verticalAlignment;
    property alphaBlend: Integer read Get_alphaBlend write Set_alphaBlend;
    property accName: WideString read Get_accName write Set_accName;
    property accDescription: WideString read Get_accDescription write Set_accDescription;
    property accKeyboardShortcut: WideString read Get_accKeyboardShortcut write Set_accKeyboardShortcut;
  end;

{ DispInterface declaration for Dual Interface IWMPObjectExtendedProps }

  IWMPObjectExtendedPropsDisp = dispinterface
    ['{21D077C1-4BAA-11D3-BD45-00C04F6EA5AE}']
    property id: WideString readonly dispid 2000;
    property elementType: WideString readonly dispid 2001;
    property left: Integer dispid 2002;
    property top: Integer dispid 2003;
    property width: Integer dispid 2004;
    property height: Integer dispid 2005;
    property zIndex: Integer dispid 2006;
    property clippingImage: WideString dispid 2007;
    property clippingColor: WideString dispid 2008;
    property visible: WordBool dispid 2009;
    property enabled: WordBool dispid 2010;
    property tabStop: WordBool dispid 2011;
    property passThrough: WordBool dispid 2012;
    property horizontalAlignment: WideString dispid 2013;
    property verticalAlignment: WideString dispid 2014;
    procedure moveTo(newX, newY, moveTime: Integer); dispid 2015;
    property alphaBlend: Integer dispid 2016;
    procedure alphaBlendTo(newVal, alphaTime: Integer); dispid 2017;
    property accName: WideString dispid 2018;
    property accDescription: WideString dispid 2019;
    property accKeyboardShortcut: WideString dispid 2020;
  end;

{ IWMPLayoutSubView: Public interface for skin object model. }

  IWMPLayoutSubView = interface(IWMPObjectExtendedProps)
    ['{72F486B1-0D43-11D3-BD3F-00C04F6EA5AE}']
    function Get_transparencyColor: WideString; safecall;
    procedure Set_transparencyColor(const Value: WideString); safecall;
    function Get_backgroundColor: WideString; safecall;
    procedure Set_backgroundColor(const Value: WideString); safecall;
    function Get_backgroundImage: WideString; safecall;
    procedure Set_backgroundImage(const Value: WideString); safecall;
    function Get_backgroundTiled: WordBool; safecall;
    procedure Set_backgroundTiled(Value: WordBool); safecall;
    function Get_backgroundImageHueShift: Single; safecall;
    procedure Set_backgroundImageHueShift(Value: Single); safecall;
    function Get_backgroundImageSaturation: Single; safecall;
    procedure Set_backgroundImageSaturation(Value: Single); safecall;
    function Get_resizeBackgroundImage: WordBool; safecall;
    procedure Set_resizeBackgroundImage(Value: WordBool); safecall;
    property transparencyColor: WideString read Get_transparencyColor write Set_transparencyColor;
    property backgroundColor: WideString read Get_backgroundColor write Set_backgroundColor;
    property backgroundImage: WideString read Get_backgroundImage write Set_backgroundImage;
    property backgroundTiled: WordBool read Get_backgroundTiled write Set_backgroundTiled;
    property backgroundImageHueShift: Single read Get_backgroundImageHueShift write Set_backgroundImageHueShift;
    property backgroundImageSaturation: Single read Get_backgroundImageSaturation write Set_backgroundImageSaturation;
    property resizeBackgroundImage: WordBool read Get_resizeBackgroundImage write Set_resizeBackgroundImage;
  end;

{ DispInterface declaration for Dual Interface IWMPLayoutSubView }

  IWMPLayoutSubViewDisp = dispinterface
    ['{72F486B1-0D43-11D3-BD3F-00C04F6EA5AE}']
    property id: WideString readonly dispid 2000;
    property elementType: WideString readonly dispid 2001;
    property left: Integer dispid 2002;
    property top: Integer dispid 2003;
    property width: Integer dispid 2004;
    property height: Integer dispid 2005;
    property zIndex: Integer dispid 2006;
    property clippingImage: WideString dispid 2007;
    property clippingColor: WideString dispid 2008;
    property visible: WordBool dispid 2009;
    property enabled: WordBool dispid 2010;
    property tabStop: WordBool dispid 2011;
    property passThrough: WordBool dispid 2012;
    property horizontalAlignment: WideString dispid 2013;
    property verticalAlignment: WideString dispid 2014;
    procedure moveTo(newX, newY, moveTime: Integer); dispid 2015;
    property alphaBlend: Integer dispid 2016;
    procedure alphaBlendTo(newVal, alphaTime: Integer); dispid 2017;
    property accName: WideString dispid 2018;
    property accDescription: WideString dispid 2019;
    property accKeyboardShortcut: WideString dispid 2020;
    property transparencyColor: WideString dispid 2300;
    property backgroundColor: WideString dispid 2301;
    property backgroundImage: WideString dispid 2302;
    property backgroundTiled: WordBool dispid 2303;
    property backgroundImageHueShift: Single dispid 2304;
    property backgroundImageSaturation: Single dispid 2305;
    property resizeBackgroundImage: WordBool dispid 2306;
  end;

{ IWMPLayoutView: Public interface for skin object model. }

  IWMPLayoutView = interface(IWMPLayoutSubView)
    ['{172E905D-80D9-4C2F-B7CE-2CCB771787A2}']
    function Get_title: WideString; safecall;
    procedure Set_title(const Value: WideString); safecall;
    function Get_category: WideString; safecall;
    procedure Set_category(const Value: WideString); safecall;
    function Get_focusObjectID: WideString; safecall;
    procedure Set_focusObjectID(const Value: WideString); safecall;
    function Get_titleBar: WordBool; safecall;
    function Get_resizable: WordBool; safecall;
    function Get_timerInterval: Integer; safecall;
    procedure Set_timerInterval(Value: Integer); safecall;
    function Get_minWidth: Integer; safecall;
    procedure Set_minWidth(Value: Integer); safecall;
    function Get_maxWidth: Integer; safecall;
    procedure Set_maxWidth(Value: Integer); safecall;
    function Get_minHeight: Integer; safecall;
    procedure Set_minHeight(Value: Integer); safecall;
    function Get_maxHeight: Integer; safecall;
    procedure Set_maxHeight(Value: Integer); safecall;
    procedure close; safecall;
    procedure minimize; safecall;
    procedure maximize; safecall;
    procedure restore; safecall;
    procedure size(const bstrDirection: WideString); safecall;
    procedure returnToMediaCenter; safecall;
    procedure updateWindow; safecall;
    property title: WideString read Get_title write Set_title;
    property category: WideString read Get_category write Set_category;
    property focusObjectID: WideString read Get_focusObjectID write Set_focusObjectID;
    property titleBar: WordBool read Get_titleBar;
    property resizable: WordBool read Get_resizable;
    property timerInterval: Integer read Get_timerInterval write Set_timerInterval;
    property minWidth: Integer read Get_minWidth write Set_minWidth;
    property maxWidth: Integer read Get_maxWidth write Set_maxWidth;
    property minHeight: Integer read Get_minHeight write Set_minHeight;
    property maxHeight: Integer read Get_maxHeight write Set_maxHeight;
  end;

{ DispInterface declaration for Dual Interface IWMPLayoutView }

  IWMPLayoutViewDisp = dispinterface
    ['{172E905D-80D9-4C2F-B7CE-2CCB771787A2}']
    property id: WideString readonly dispid 2000;
    property elementType: WideString readonly dispid 2001;
    property left: Integer dispid 2002;
    property top: Integer dispid 2003;
    property width: Integer dispid 2004;
    property height: Integer dispid 2005;
    property zIndex: Integer dispid 2006;
    property clippingImage: WideString dispid 2007;
    property clippingColor: WideString dispid 2008;
    property visible: WordBool dispid 2009;
    property enabled: WordBool dispid 2010;
    property tabStop: WordBool dispid 2011;
    property passThrough: WordBool dispid 2012;
    property horizontalAlignment: WideString dispid 2013;
    property verticalAlignment: WideString dispid 2014;
    procedure moveTo(newX, newY, moveTime: Integer); dispid 2015;
    property alphaBlend: Integer dispid 2016;
    procedure alphaBlendTo(newVal, alphaTime: Integer); dispid 2017;
    property accName: WideString dispid 2018;
    property accDescription: WideString dispid 2019;
    property accKeyboardShortcut: WideString dispid 2020;
    property transparencyColor: WideString dispid 2300;
    property backgroundColor: WideString dispid 2301;
    property backgroundImage: WideString dispid 2302;
    property backgroundTiled: WordBool dispid 2303;
    property backgroundImageHueShift: Single dispid 2304;
    property backgroundImageSaturation: Single dispid 2305;
    property resizeBackgroundImage: WordBool dispid 2306;
    property title: WideString dispid 2307;
    property category: WideString dispid 2308;
    property focusObjectID: WideString dispid 2309;
    property titleBar: WordBool readonly dispid 2311;
    property resizable: WordBool readonly dispid 2312;
    property timerInterval: Integer dispid 2313;
    property minWidth: Integer dispid 2314;
    property maxWidth: Integer dispid 2315;
    property minHeight: Integer dispid 2316;
    property maxHeight: Integer dispid 2317;
    procedure close; dispid 2318;
    procedure minimize; dispid 2319;
    procedure maximize; dispid 2320;
    procedure restore; dispid 2321;
    procedure size(const bstrDirection: WideString); dispid 2322;
    procedure returnToMediaCenter; dispid 2323;
    procedure updateWindow; dispid 2324;
  end;

{ IWMPEventObject: Not Public.  Internal interface used by Windows Media Player. }

  IWMPEventObject = interface(IDispatch)
    ['{5AF0BEC1-46AA-11D3-BD45-00C04F6EA5AE}']
    function Get_srcElement: IDispatch; safecall;
    function Get_altKey: WordBool; safecall;
    function Get_ctrlKey: WordBool; safecall;
    function Get_shiftKey: WordBool; safecall;
    function Get_fromElement: IDispatch; safecall;
    function Get_toElement: IDispatch; safecall;
    procedure Set_keyCode(Value: Integer); safecall;
    function Get_keyCode: Integer; safecall;
    function Get_button: Integer; safecall;
    function Get_x: Integer; safecall;
    function Get_y: Integer; safecall;
    function Get_clientX: Integer; safecall;
    function Get_clientY: Integer; safecall;
    function Get_offsetX: Integer; safecall;
    function Get_offsetY: Integer; safecall;
    function Get_screenX: Integer; safecall;
    function Get_screenY: Integer; safecall;
    function Get_screenWidth: Integer; safecall;
    function Get_screenHeight: Integer; safecall;
    property srcElement: IDispatch read Get_srcElement;
    property altKey: WordBool read Get_altKey;
    property ctrlKey: WordBool read Get_ctrlKey;
    property shiftKey: WordBool read Get_shiftKey;
    property fromElement: IDispatch read Get_fromElement;
    property toElement: IDispatch read Get_toElement;
    property keyCode: Integer read Get_keyCode write Set_keyCode;
    property button: Integer read Get_button;
    property x: Integer read Get_x;
    property y: Integer read Get_y;
    property clientX: Integer read Get_clientX;
    property clientY: Integer read Get_clientY;
    property offsetX: Integer read Get_offsetX;
    property offsetY: Integer read Get_offsetY;
    property screenX: Integer read Get_screenX;
    property screenY: Integer read Get_screenY;
    property screenWidth: Integer read Get_screenWidth;
    property screenHeight: Integer read Get_screenHeight;
  end;

{ DispInterface declaration for Dual Interface IWMPEventObject }

  IWMPEventObjectDisp = dispinterface
    ['{5AF0BEC1-46AA-11D3-BD45-00C04F6EA5AE}']
    property srcElement: IDispatch readonly dispid 2200;
    property altKey: WordBool readonly dispid 2201;
    property ctrlKey: WordBool readonly dispid 2202;
    property shiftKey: WordBool readonly dispid 2203;
    property fromElement: IDispatch readonly dispid 2204;
    property toElement: IDispatch readonly dispid 2205;
    property keyCode: Integer dispid 2206;
    property button: Integer readonly dispid 2207;
    property x: Integer readonly dispid 2208;
    property y: Integer readonly dispid 2209;
    property clientX: Integer readonly dispid 2210;
    property clientY: Integer readonly dispid 2211;
    property offsetX: Integer readonly dispid 2212;
    property offsetY: Integer readonly dispid 2213;
    property screenX: Integer readonly dispid 2214;
    property screenY: Integer readonly dispid 2215;
    property screenWidth: Integer readonly dispid 2216;
    property screenHeight: Integer readonly dispid 2217;
  end;

{ IWMPTheme: Public interface for skin object model. }

  IWMPTheme = interface(IDispatch)
    ['{6FCAE13D-E492-4584-9C21-D2C052A2A33A}']
    function Get_title: WideString; safecall;
    function Get_version: Single; safecall;
    function Get_authorVersion: WideString; safecall;
    function Get_author: WideString; safecall;
    function Get_copyright: WideString; safecall;
    function Get_currentViewID: WideString; safecall;
    procedure Set_currentViewID(const Value: WideString); safecall;
    procedure showErrorDialog; safecall;
    procedure logString(const stringVal: WideString); safecall;
    procedure openView(const viewID: WideString); safecall;
    procedure openViewRelative(const viewID: WideString; x, y: Integer); safecall;
    procedure closeView(const viewID: WideString); safecall;
    function openDialog(const dialogType, parameters: WideString): WideString; safecall;
    function loadString(const bstrString: WideString): WideString; safecall;
    function loadPreference(const bstrName: WideString): WideString; safecall;
    procedure savePreference(const bstrName, bstrValue: WideString); safecall;
    procedure playSound(const bstrFilename: WideString); safecall;
    property title: WideString read Get_title;
    property version: Single read Get_version;
    property authorVersion: WideString read Get_authorVersion;
    property author: WideString read Get_author;
    property copyright: WideString read Get_copyright;
    property currentViewID: WideString read Get_currentViewID write Set_currentViewID;
  end;

{ DispInterface declaration for Dual Interface IWMPTheme }

  IWMPThemeDisp = dispinterface
    ['{6FCAE13D-E492-4584-9C21-D2C052A2A33A}']
    property title: WideString readonly dispid 2500;
    property version: Single readonly dispid 2501;
    property authorVersion: WideString readonly dispid 2502;
    property author: WideString readonly dispid 2503;
    property copyright: WideString readonly dispid 2504;
    property currentViewID: WideString dispid 2505;
    procedure showErrorDialog; dispid 2506;
    procedure logString(const stringVal: WideString); dispid 2507;
    procedure openView(const viewID: WideString); dispid 2508;
    procedure openViewRelative(const viewID: WideString; x, y: Integer); dispid 2515;
    procedure closeView(const viewID: WideString); dispid 2509;
    function openDialog(const dialogType, parameters: WideString): WideString; dispid 2510;
    function loadString(const bstrString: WideString): WideString; dispid 2511;
    function loadPreference(const bstrName: WideString): WideString; dispid 2512;
    procedure savePreference(const bstrName, bstrValue: WideString); dispid 2513;
    procedure playSound(const bstrFilename: WideString); dispid 2514;
  end;

{ IWMPLayoutSettingsDispatch: Not Public.  Internal interface used by Windows Media Player. }

  IWMPLayoutSettingsDispatch = interface(IDispatch)
    ['{B2C2D18E-97AF-4B6A-A56B-2FFFF470FB81}']
    function Get_effectType: WideString; safecall;
    procedure Set_effectType(const Value: WideString); safecall;
    function Get_effectPreset: Integer; safecall;
    procedure Set_effectPreset(Value: Integer); safecall;
    function Get_settingsView: WideString; safecall;
    procedure Set_settingsView(const Value: WideString); safecall;
    function Get_videoZoom: Integer; safecall;
    procedure Set_videoZoom(Value: Integer); safecall;
    function Get_videoShrinkToFit: WordBool; safecall;
    procedure Set_videoShrinkToFit(Value: WordBool); safecall;
    function Get_videoStretchToFit: WordBool; safecall;
    procedure Set_videoStretchToFit(Value: WordBool); safecall;
    function Get_userVideoStretchToFit: WordBool; safecall;
    procedure Set_userVideoStretchToFit(Value: WordBool); safecall;
    function Get_showCaptions: WordBool; safecall;
    procedure Set_showCaptions(Value: WordBool); safecall;
    function Get_showTitles: WordBool; safecall;
    procedure Set_showTitles(Value: WordBool); safecall;
    function Get_showEffects: WordBool; safecall;
    procedure Set_showEffects(Value: WordBool); safecall;
    function Get_showFullScreenPlaylist: WordBool; safecall;
    procedure Set_showFullScreenPlaylist(Value: WordBool); safecall;
    function Get_contrastMode: WideString; safecall;
    function getNamedString(const bstrName: WideString): WideString; safecall;
    function getDurationStringFromSeconds(lDurationVal: Integer): WideString; safecall;
    function Get_displayView: WideString; safecall;
    procedure Set_displayView(const Value: WideString); safecall;
    function Get_metadataView: WideString; safecall;
    procedure Set_metadataView(const Value: WideString); safecall;
    function Get_showSettings: WordBool; safecall;
    procedure Set_showSettings(Value: WordBool); safecall;
    function Get_showResizeBars: WordBool; safecall;
    procedure Set_showResizeBars(Value: WordBool); safecall;
    function Get_showPlaylist: WordBool; safecall;
    procedure Set_showPlaylist(Value: WordBool); safecall;
    function Get_showMetadata: WordBool; safecall;
    procedure Set_showMetadata(Value: WordBool); safecall;
    function Get_settingsWidth: Integer; safecall;
    procedure Set_settingsWidth(Value: Integer); safecall;
    function Get_settingsHeight: Integer; safecall;
    procedure Set_settingsHeight(Value: Integer); safecall;
    function Get_playlistWidth: Integer; safecall;
    procedure Set_playlistWidth(Value: Integer); safecall;
    function Get_playlistHeight: Integer; safecall;
    procedure Set_playlistHeight(Value: Integer); safecall;
    function Get_metadataWidth: Integer; safecall;
    procedure Set_metadataWidth(Value: Integer); safecall;
    function Get_metadataHeight: Integer; safecall;
    procedure Set_metadataHeight(Value: Integer); safecall;
    function Get_fullScreenAvailable: WordBool; safecall;
    procedure Set_fullScreenAvailable(Value: WordBool); safecall;
    function Get_fullScreenRequest: WordBool; safecall;
    procedure Set_fullScreenRequest(Value: WordBool); safecall;
    function Get_quickHide: WordBool; safecall;
    procedure Set_quickHide(Value: WordBool); safecall;
    function Get_displayPreset: Integer; safecall;
    procedure Set_displayPreset(Value: Integer); safecall;
    function Get_settingsPreset: Integer; safecall;
    procedure Set_settingsPreset(Value: Integer); safecall;
    function Get_metadataPreset: Integer; safecall;
    procedure Set_metadataPreset(Value: Integer); safecall;
    function Get_userDisplayView: WideString; safecall;
    function Get_userWMPDisplayView: WideString; safecall;
    function Get_userDisplayPreset: Integer; safecall;
    function Get_userWMPDisplayPreset: Integer; safecall;
    function Get_dynamicRangeControl: Integer; safecall;
    procedure Set_dynamicRangeControl(Value: Integer); safecall;
    function Get_slowRate: Single; safecall;
    procedure Set_slowRate(Value: Single); safecall;
    function Get_fastRate: Single; safecall;
    procedure Set_fastRate(Value: Single); safecall;
    function Get_buttonHueShift: Single; safecall;
    procedure Set_buttonHueShift(Value: Single); safecall;
    function Get_buttonSaturation: Single; safecall;
    procedure Set_buttonSaturation(Value: Single); safecall;
    function Get_backHueShift: Single; safecall;
    procedure Set_backHueShift(Value: Single); safecall;
    function Get_backSaturation: Single; safecall;
    procedure Set_backSaturation(Value: Single); safecall;
    function Get_vizRequest: Integer; safecall;
    procedure Set_vizRequest(Value: Integer); safecall;
    function Get_vizAutoSelect: WordBool; safecall;
    procedure Set_vizAutoSelect(Value: WordBool); safecall;
    function Get_appColorLight: WideString; safecall;
    function Get_appColorMedium: WideString; safecall;
    function Get_appColorDark: WideString; safecall;
    function Get_toolbarButtonHighlight: WideString; safecall;
    function Get_toolbarButtonShadow: WideString; safecall;
    function Get_toolbarButtonFace: WideString; safecall;
    function Get_itemPlayingColor: WideString; safecall;
    function Get_itemPlayingBackgroundColor: WideString; safecall;
    function Get_itemErrorColor: WideString; safecall;
    function Get_appColorLimited: WordBool; safecall;
    function Get_appColorBlackBackground: WordBool; safecall;
    procedure Set_appColorBlackBackground(Value: WordBool); safecall;
    function Get_userWMPSettingsView: WideString; safecall;
    function Get_userWMPSettingsPreset: Integer; safecall;
    function Get_userWMPShowSettings: WordBool; safecall;
    function Get_userWMPMetadataView: WideString; safecall;
    function Get_userWMPMetadataPreset: Integer; safecall;
    function Get_userWMPShowMetadata: WordBool; safecall;
    function Get_captionsHeight: Integer; safecall;
    procedure Set_captionsHeight(Value: Integer); safecall;
    function Get_snapToVideo: WordBool; safecall;
    procedure Set_snapToVideo(Value: WordBool); safecall;
    function Get_pinFullScreenControls: WordBool; safecall;
    procedure Set_pinFullScreenControls(Value: WordBool); safecall;
    property effectType: WideString read Get_effectType write Set_effectType;
    property effectPreset: Integer read Get_effectPreset write Set_effectPreset;
    property settingsView: WideString read Get_settingsView write Set_settingsView;
    property videoZoom: Integer read Get_videoZoom write Set_videoZoom;
    property videoShrinkToFit: WordBool read Get_videoShrinkToFit write Set_videoShrinkToFit;
    property videoStretchToFit: WordBool read Get_videoStretchToFit write Set_videoStretchToFit;
    property userVideoStretchToFit: WordBool read Get_userVideoStretchToFit write Set_userVideoStretchToFit;
    property showCaptions: WordBool read Get_showCaptions write Set_showCaptions;
    property showTitles: WordBool read Get_showTitles write Set_showTitles;
    property showEffects: WordBool read Get_showEffects write Set_showEffects;
    property showFullScreenPlaylist: WordBool read Get_showFullScreenPlaylist write Set_showFullScreenPlaylist;
    property contrastMode: WideString read Get_contrastMode;
    property displayView: WideString read Get_displayView write Set_displayView;
    property metadataView: WideString read Get_metadataView write Set_metadataView;
    property showSettings: WordBool read Get_showSettings write Set_showSettings;
    property showResizeBars: WordBool read Get_showResizeBars write Set_showResizeBars;
    property showPlaylist: WordBool read Get_showPlaylist write Set_showPlaylist;
    property showMetadata: WordBool read Get_showMetadata write Set_showMetadata;
    property settingsWidth: Integer read Get_settingsWidth write Set_settingsWidth;
    property settingsHeight: Integer read Get_settingsHeight write Set_settingsHeight;
    property playlistWidth: Integer read Get_playlistWidth write Set_playlistWidth;
    property playlistHeight: Integer read Get_playlistHeight write Set_playlistHeight;
    property metadataWidth: Integer read Get_metadataWidth write Set_metadataWidth;
    property metadataHeight: Integer read Get_metadataHeight write Set_metadataHeight;
    property fullScreenAvailable: WordBool read Get_fullScreenAvailable write Set_fullScreenAvailable;
    property fullScreenRequest: WordBool read Get_fullScreenRequest write Set_fullScreenRequest;
    property quickHide: WordBool read Get_quickHide write Set_quickHide;
    property displayPreset: Integer read Get_displayPreset write Set_displayPreset;
    property settingsPreset: Integer read Get_settingsPreset write Set_settingsPreset;
    property metadataPreset: Integer read Get_metadataPreset write Set_metadataPreset;
    property userDisplayView: WideString read Get_userDisplayView;
    property userWMPDisplayView: WideString read Get_userWMPDisplayView;
    property userDisplayPreset: Integer read Get_userDisplayPreset;
    property userWMPDisplayPreset: Integer read Get_userWMPDisplayPreset;
    property dynamicRangeControl: Integer read Get_dynamicRangeControl write Set_dynamicRangeControl;
    property slowRate: Single read Get_slowRate write Set_slowRate;
    property fastRate: Single read Get_fastRate write Set_fastRate;
    property buttonHueShift: Single read Get_buttonHueShift write Set_buttonHueShift;
    property buttonSaturation: Single read Get_buttonSaturation write Set_buttonSaturation;
    property backHueShift: Single read Get_backHueShift write Set_backHueShift;
    property backSaturation: Single read Get_backSaturation write Set_backSaturation;
    property vizRequest: Integer read Get_vizRequest write Set_vizRequest;
    property vizAutoSelect: WordBool read Get_vizAutoSelect write Set_vizAutoSelect;
    property appColorLight: WideString read Get_appColorLight;
    property appColorMedium: WideString read Get_appColorMedium;
    property appColorDark: WideString read Get_appColorDark;
    property toolbarButtonHighlight: WideString read Get_toolbarButtonHighlight;
    property toolbarButtonShadow: WideString read Get_toolbarButtonShadow;
    property toolbarButtonFace: WideString read Get_toolbarButtonFace;
    property itemPlayingColor: WideString read Get_itemPlayingColor;
    property itemPlayingBackgroundColor: WideString read Get_itemPlayingBackgroundColor;
    property itemErrorColor: WideString read Get_itemErrorColor;
    property appColorLimited: WordBool read Get_appColorLimited;
    property appColorBlackBackground: WordBool read Get_appColorBlackBackground write Set_appColorBlackBackground;
    property userWMPSettingsView: WideString read Get_userWMPSettingsView;
    property userWMPSettingsPreset: Integer read Get_userWMPSettingsPreset;
    property userWMPShowSettings: WordBool read Get_userWMPShowSettings;
    property userWMPMetadataView: WideString read Get_userWMPMetadataView;
    property userWMPMetadataPreset: Integer read Get_userWMPMetadataPreset;
    property userWMPShowMetadata: WordBool read Get_userWMPShowMetadata;
    property captionsHeight: Integer read Get_captionsHeight write Set_captionsHeight;
    property snapToVideo: WordBool read Get_snapToVideo write Set_snapToVideo;
    property pinFullScreenControls: WordBool read Get_pinFullScreenControls write Set_pinFullScreenControls;
  end;

{ DispInterface declaration for Dual Interface IWMPLayoutSettingsDispatch }

  IWMPLayoutSettingsDispatchDisp = dispinterface
    ['{B2C2D18E-97AF-4B6A-A56B-2FFFF470FB81}']
    property effectType: WideString dispid 2800;
    property effectPreset: Integer dispid 2801;
    property settingsView: WideString dispid 2802;
    property videoZoom: Integer dispid 2803;
    property videoShrinkToFit: WordBool dispid 2804;
    property videoStretchToFit: WordBool dispid 2805;
    property userVideoStretchToFit: WordBool dispid 2867;
    property showCaptions: WordBool dispid 2807;
    property showTitles: WordBool dispid 2808;
    property showEffects: WordBool dispid 2809;
    property showFullScreenPlaylist: WordBool dispid 2811;
    property contrastMode: WideString readonly dispid 2813;
    function getNamedString(const bstrName: WideString): WideString; dispid 2810;
    function getDurationStringFromSeconds(lDurationVal: Integer): WideString; dispid 2815;
    property displayView: WideString dispid 2816;
    property metadataView: WideString dispid 2817;
    property showSettings: WordBool dispid 2818;
    property showResizeBars: WordBool dispid 2819;
    property showPlaylist: WordBool dispid 2820;
    property showMetadata: WordBool dispid 2821;
    property settingsWidth: Integer dispid 2822;
    property settingsHeight: Integer dispid 2823;
    property playlistWidth: Integer dispid 2824;
    property playlistHeight: Integer dispid 2825;
    property metadataWidth: Integer dispid 2826;
    property metadataHeight: Integer dispid 2827;
    property fullScreenAvailable: WordBool dispid 2828;
    property fullScreenRequest: WordBool dispid 2829;
    property quickHide: WordBool dispid 2830;
    property displayPreset: Integer dispid 2831;
    property settingsPreset: Integer dispid 2832;
    property metadataPreset: Integer dispid 2833;
    property userDisplayView: WideString readonly dispid 2834;
    property userWMPDisplayView: WideString readonly dispid 2835;
    property userDisplayPreset: Integer readonly dispid 2836;
    property userWMPDisplayPreset: Integer readonly dispid 2837;
    property dynamicRangeControl: Integer dispid 2838;
    property slowRate: Single dispid 2839;
    property fastRate: Single dispid 2840;
    property buttonHueShift: Single dispid 2841;
    property buttonSaturation: Single dispid 2842;
    property backHueShift: Single dispid 2843;
    property backSaturation: Single dispid 2844;
    property vizRequest: Integer dispid 2845;
    property vizAutoSelect: WordBool dispid 2846;
    property appColorLight: WideString readonly dispid 2847;
    property appColorMedium: WideString readonly dispid 2848;
    property appColorDark: WideString readonly dispid 2849;
    property toolbarButtonHighlight: WideString readonly dispid 2855;
    property toolbarButtonShadow: WideString readonly dispid 2856;
    property toolbarButtonFace: WideString readonly dispid 2857;
    property itemPlayingColor: WideString readonly dispid 2850;
    property itemPlayingBackgroundColor: WideString readonly dispid 2851;
    property itemErrorColor: WideString readonly dispid 2852;
    property appColorLimited: WordBool readonly dispid 2853;
    property appColorBlackBackground: WordBool dispid 2854;
    property userWMPSettingsView: WideString readonly dispid 2858;
    property userWMPSettingsPreset: Integer readonly dispid 2859;
    property userWMPShowSettings: WordBool readonly dispid 2860;
    property userWMPMetadataView: WideString readonly dispid 2861;
    property userWMPMetadataPreset: Integer readonly dispid 2862;
    property userWMPShowMetadata: WordBool readonly dispid 2863;
    property captionsHeight: Integer dispid 2864;
    property snapToVideo: WordBool dispid 2865;
    property pinFullScreenControls: WordBool dispid 2866;
  end;

{ IWMPNowPlayingHelperDispatch: Not Public.  Internal interface used by Windows Media Player. }

  IWMPNowPlayingHelperDispatch = interface(IDispatch)
    ['{504F112E-77CC-4E3C-A073-5371B31D9B36}']
    function Get_viewFriendlyName(const bstrView: WideString): WideString; safecall;
    function Get_viewPresetCount(const bstrView: WideString): Integer; safecall;
    function Get_viewPresetName(const bstrView: WideString; nPresetIndex: Integer): WideString; safecall;
    function Get_effectFriendlyName(const bstrEffect: WideString): WideString; safecall;
    function Get_effectPresetName(const bstrEffect: WideString; nPresetIndex: Integer): WideString; safecall;
    function resolveDisplayView(fSafe: WordBool): WideString; safecall;
    function isValidDisplayView(const bstrView: WideString): WordBool; safecall;
    function getSkinFile: WideString; safecall;
    function Get_captionsAvailable: WordBool; safecall;
    function Get_linkAvailable: Integer; safecall;
    function Get_linkRequest: Integer; safecall;
    procedure Set_linkRequest(Value: Integer); safecall;
    function Get_linkRequestParams: WideString; safecall;
    procedure Set_linkRequestParams(const Value: WideString); safecall;
    function Get_isXPOrBetter: WordBool; safecall;
    function getCurrentArtID(fLargeArt: WordBool): Integer; safecall;
    function getTimeString(dTime: Double): WideString; safecall;
    function getCurrentScriptCommand(const bstrType: WideString): WideString; safecall;
    procedure calcLayout(lWidth, lHeight: Integer; vbCaptions, vbBanner: WordBool); safecall;
    function getLayoutSize(nProp: Integer): Integer; safecall;
    function getRootPlaylist(pPlaylist: IDispatch): IDispatch; safecall;
    function getHTMLViewURL: WideString; safecall;
    function Get_canSendLink: WordBool; safecall;
    procedure sendLink(dblStartTime, dblEndTime: Double); safecall;
    function Get_editObj: IUnknown; safecall;
    procedure Set_editObj(Value: IUnknown); safecall;
    property viewFriendlyName[const bstrView: WideString]: WideString read Get_viewFriendlyName;
    property viewPresetCount[const bstrView: WideString]: Integer read Get_viewPresetCount;
    property viewPresetName[const bstrView: WideString; nPresetIndex: Integer]: WideString read Get_viewPresetName;
    property effectFriendlyName[const bstrEffect: WideString]: WideString read Get_effectFriendlyName;
    property effectPresetName[const bstrEffect: WideString; nPresetIndex: Integer]: WideString read Get_effectPresetName;
    property captionsAvailable: WordBool read Get_captionsAvailable;
    property linkAvailable: Integer read Get_linkAvailable;
    property linkRequest: Integer read Get_linkRequest write Set_linkRequest;
    property linkRequestParams: WideString read Get_linkRequestParams write Set_linkRequestParams;
    property isXPOrBetter: WordBool read Get_isXPOrBetter;
    property canSendLink: WordBool read Get_canSendLink;
    property editObj: IUnknown read Get_editObj write Set_editObj;
  end;

{ DispInterface declaration for Dual Interface IWMPNowPlayingHelperDispatch }

  IWMPNowPlayingHelperDispatchDisp = dispinterface
    ['{504F112E-77CC-4E3C-A073-5371B31D9B36}']
    property viewFriendlyName[const bstrView: WideString]: WideString readonly dispid 2901;
    property viewPresetCount[const bstrView: WideString]: Integer readonly dispid 2902;
    property viewPresetName[const bstrView: WideString; nPresetIndex: Integer]: WideString readonly dispid 2903;
    property effectFriendlyName[const bstrEffect: WideString]: WideString readonly dispid 2904;
    property effectPresetName[const bstrEffect: WideString; nPresetIndex: Integer]: WideString readonly dispid 2905;
    function resolveDisplayView(fSafe: WordBool): WideString; dispid 2909;
    function isValidDisplayView(const bstrView: WideString): WordBool; dispid 2910;
    function getSkinFile: WideString; dispid 2911;
    property captionsAvailable: WordBool readonly dispid 2912;
    property linkAvailable: Integer readonly dispid 2913;
    property linkRequest: Integer dispid 2914;
    property linkRequestParams: WideString dispid 2915;
    property isXPOrBetter: WordBool readonly dispid 2916;
    function getCurrentArtID(fLargeArt: WordBool): Integer; dispid 2917;
    function getTimeString(dTime: Double): WideString; dispid 2918;
    function getCurrentScriptCommand(const bstrType: WideString): WideString; dispid 2919;
    procedure calcLayout(lWidth, lHeight: Integer; vbCaptions, vbBanner: WordBool); dispid 2920;
    function getLayoutSize(nProp: Integer): Integer; dispid 2921;
    function getRootPlaylist(pPlaylist: IDispatch): IDispatch; dispid 2922;
    function getHTMLViewURL: WideString; dispid 2923;
    property canSendLink: WordBool readonly dispid 2924;
    procedure sendLink(dblStartTime, dblEndTime: Double); dispid 2925;
    property editObj: IUnknown dispid 2926;
  end;

{ IWMPButtonCtrlEvents: Public interface for skin object model. }

  IWMPButtonCtrlEvents = dispinterface
    ['{BB17FFF7-1692-4555-918A-6AF7BFACEDD2}']
    procedure onclick; dispid 5120;
  end;

{ IWMPButtonCtrl: Public interface for skin object model. }

  IWMPButtonCtrl = interface(IDispatch)
    ['{87291B50-0C8E-11D3-BB2A-00A0C93CA73A}']
    function Get_image: WideString; safecall;
    procedure Set_image(const Value: WideString); safecall;
    function Get_hoverImage: WideString; safecall;
    procedure Set_hoverImage(const Value: WideString); safecall;
    function Get_downImage: WideString; safecall;
    procedure Set_downImage(const Value: WideString); safecall;
    function Get_disabledImage: WideString; safecall;
    procedure Set_disabledImage(const Value: WideString); safecall;
    function Get_hoverDownImage: WideString; safecall;
    procedure Set_hoverDownImage(const Value: WideString); safecall;
    function Get_tiled: WordBool; safecall;
    procedure Set_tiled(Value: WordBool); safecall;
    function Get_transparencyColor: WideString; safecall;
    procedure Set_transparencyColor(const Value: WideString); safecall;
    function Get_down: WordBool; safecall;
    procedure Set_down(Value: WordBool); safecall;
    function Get_sticky: WordBool; safecall;
    procedure Set_sticky(Value: WordBool); safecall;
    function Get_upToolTip: WideString; safecall;
    procedure Set_upToolTip(const Value: WideString); safecall;
    function Get_downToolTip: WideString; safecall;
    procedure Set_downToolTip(const Value: WideString); safecall;
    function Get_cursor: WideString; safecall;
    procedure Set_cursor(const Value: WideString); safecall;
    property image: WideString read Get_image write Set_image;
    property hoverImage: WideString read Get_hoverImage write Set_hoverImage;
    property downImage: WideString read Get_downImage write Set_downImage;
    property disabledImage: WideString read Get_disabledImage write Set_disabledImage;
    property hoverDownImage: WideString read Get_hoverDownImage write Set_hoverDownImage;
    property tiled: WordBool read Get_tiled write Set_tiled;
    property transparencyColor: WideString read Get_transparencyColor write Set_transparencyColor;
    property down: WordBool read Get_down write Set_down;
    property sticky: WordBool read Get_sticky write Set_sticky;
    property upToolTip: WideString read Get_upToolTip write Set_upToolTip;
    property downToolTip: WideString read Get_downToolTip write Set_downToolTip;
    property cursor: WideString read Get_cursor write Set_cursor;
  end;

{ DispInterface declaration for Dual Interface IWMPButtonCtrl }

  IWMPButtonCtrlDisp = dispinterface
    ['{87291B50-0C8E-11D3-BB2A-00A0C93CA73A}']
    property image: WideString dispid 5102;
    property hoverImage: WideString dispid 5103;
    property downImage: WideString dispid 5104;
    property disabledImage: WideString dispid 5105;
    property hoverDownImage: WideString dispid 5106;
    property tiled: WordBool dispid 5107;
    property transparencyColor: WideString dispid 5108;
    property down: WordBool dispid 5109;
    property sticky: WordBool dispid 5110;
    property upToolTip: WideString dispid 5112;
    property downToolTip: WideString dispid 5113;
    property cursor: WideString dispid 5114;
  end;

{ IWMPListBoxCtrl: Public interface for skin object model. }

  IWMPListBoxCtrl = interface(IDispatch)
    ['{FC1880CE-83B9-43A7-A066-C44CE8C82583}']
    function Get_selectedItem: Integer; safecall;
    procedure Set_selectedItem(Value: Integer); safecall;
    function Get_sorted: WordBool; safecall;
    procedure Set_sorted(Value: WordBool); safecall;
    function Get_multiselect: WordBool; safecall;
    procedure Set_multiselect(Value: WordBool); safecall;
    function Get_readOnly: WordBool; safecall;
    procedure Set_readOnly(Value: WordBool); safecall;
    function Get_foregroundColor: WideString; safecall;
    procedure Set_foregroundColor(const Value: WideString); safecall;
    function Get_backgroundColor: WideString; safecall;
    procedure Set_backgroundColor(const Value: WideString); safecall;
    function Get_fontSize: Integer; safecall;
    procedure Set_fontSize(Value: Integer); safecall;
    function Get_fontStyle: WideString; safecall;
    procedure Set_fontStyle(const Value: WideString); safecall;
    function Get_fontFace: WideString; safecall;
    procedure Set_fontFace(const Value: WideString); safecall;
    function Get_itemCount: Integer; safecall;
    function Get_firstVisibleItem: Integer; safecall;
    procedure Set_firstVisibleItem(Value: Integer); safecall;
    procedure Set_popUp(Value: WordBool); safecall;
    function Get_focusItem: Integer; safecall;
    procedure Set_focusItem(Value: Integer); safecall;
    function Get_border: WordBool; safecall;
    procedure Set_border(Value: WordBool); safecall;
    function getItem(nPos: Integer): WideString; safecall;
    procedure insertItem(nPos: Integer; const newVal: WideString); safecall;
    procedure appendItem(const newVal: WideString); safecall;
    procedure replaceItem(nPos: Integer; const newVal: WideString); safecall;
    procedure deleteItem(nPos: Integer); safecall;
    procedure deleteAll; safecall;
    function findItem(nStartIndex: Integer; const newVal: WideString): Integer; safecall;
    function getNextSelectedItem(nStartIndex: Integer): Integer; safecall;
    procedure setSelectedState(nPos: Integer; vbSelected: WordBool); safecall;
    procedure show; safecall;
    procedure dismiss; safecall;
    property selectedItem: Integer read Get_selectedItem write Set_selectedItem;
    property sorted: WordBool read Get_sorted write Set_sorted;
    property multiselect: WordBool read Get_multiselect write Set_multiselect;
    property readOnly: WordBool read Get_readOnly write Set_readOnly;
    property foregroundColor: WideString read Get_foregroundColor write Set_foregroundColor;
    property backgroundColor: WideString read Get_backgroundColor write Set_backgroundColor;
    property fontSize: Integer read Get_fontSize write Set_fontSize;
    property fontStyle: WideString read Get_fontStyle write Set_fontStyle;
    property fontFace: WideString read Get_fontFace write Set_fontFace;
    property itemCount: Integer read Get_itemCount;
    property firstVisibleItem: Integer read Get_firstVisibleItem write Set_firstVisibleItem;
    property popUp: WordBool write Set_popUp;
    property focusItem: Integer read Get_focusItem write Set_focusItem;
    property border: WordBool read Get_border write Set_border;
  end;

{ DispInterface declaration for Dual Interface IWMPListBoxCtrl }

  IWMPListBoxCtrlDisp = dispinterface
    ['{FC1880CE-83B9-43A7-A066-C44CE8C82583}']
    property selectedItem: Integer dispid 6108;
    property sorted: WordBool dispid 6100;
    property multiselect: WordBool dispid 6101;
    property readOnly: WordBool dispid 6102;
    property foregroundColor: WideString dispid 6103;
    property backgroundColor: WideString dispid 6104;
    property fontSize: Integer dispid 6105;
    property fontStyle: WideString dispid 6106;
    property fontFace: WideString dispid 6107;
    property itemCount: Integer readonly dispid 6109;
    property firstVisibleItem: Integer dispid 6110;
    property popUp: WordBool writeonly dispid 6120;
    property focusItem: Integer dispid 6121;
    property border: WordBool dispid 6125;
    function getItem(nPos: Integer): WideString; dispid 6111;
    procedure insertItem(nPos: Integer; const newVal: WideString); dispid 6112;
    procedure appendItem(const newVal: WideString); dispid 6113;
    procedure replaceItem(nPos: Integer; const newVal: WideString); dispid 6114;
    procedure deleteItem(nPos: Integer); dispid 6115;
    procedure deleteAll; dispid 6116;
    function findItem(nStartIndex: Integer; const newVal: WideString): Integer; dispid 6117;
    function getNextSelectedItem(nStartIndex: Integer): Integer; dispid 6118;
    procedure setSelectedState(nPos: Integer; vbSelected: WordBool); dispid 6122;
    procedure show; dispid 6123;
    procedure dismiss; dispid 6124;
  end;

{ IWMPListBoxItem: Public interface for skin object model. }

  IWMPListBoxItem = interface(IDispatch)
    ['{D255DFB8-C22A-42CF-B8B7-F15D7BCF65D6}']
    procedure Set_value(const Value: WideString); safecall;
    property value: WideString write Set_value;
  end;

{ DispInterface declaration for Dual Interface IWMPListBoxItem }

  IWMPListBoxItemDisp = dispinterface
    ['{D255DFB8-C22A-42CF-B8B7-F15D7BCF65D6}']
    property value: WideString writeonly dispid 6119;
  end;

{ IWMPPlaylistCtrlColumn: Public interface for skin object model. }

  IWMPPlaylistCtrlColumn = interface(IDispatch)
    ['{63D9D30F-AE4C-4678-8CA8-5720F4FE4419}']
    function Get_columnName: WideString; safecall;
    procedure Set_columnName(const Value: WideString); safecall;
    function Get_columnID: WideString; safecall;
    procedure Set_columnID(const Value: WideString); safecall;
    function Get_columnResizeMode: WideString; safecall;
    procedure Set_columnResizeMode(const Value: WideString); safecall;
    function Get_columnWidth: Integer; safecall;
    procedure Set_columnWidth(Value: Integer); safecall;
    property columnName: WideString read Get_columnName write Set_columnName;
    property columnID: WideString read Get_columnID write Set_columnID;
    property columnResizeMode: WideString read Get_columnResizeMode write Set_columnResizeMode;
    property columnWidth: Integer read Get_columnWidth write Set_columnWidth;
  end;

{ DispInterface declaration for Dual Interface IWMPPlaylistCtrlColumn }

  IWMPPlaylistCtrlColumnDisp = dispinterface
    ['{63D9D30F-AE4C-4678-8CA8-5720F4FE4419}']
    property columnName: WideString dispid 5670;
    property columnID: WideString dispid 5671;
    property columnResizeMode: WideString dispid 5672;
    property columnWidth: Integer dispid 5673;
  end;

{ IWMPSliderCtrlEvents: Public interface for skin object model. }

  IWMPSliderCtrlEvents = dispinterface
    ['{CDAC14D2-8BE4-11D3-BB48-00A0C93CA73A}']
    procedure ondragbegin; dispid 5430;
    procedure ondragend; dispid 5431;
    procedure onpositionchange; dispid 5432;
  end;

{ IWMPSliderCtrl: Public interface for skin object model. }

  IWMPSliderCtrl = interface(IDispatch)
    ['{F2BF2C8F-405F-11D3-BB39-00A0C93CA73A}']
    function Get_direction: WideString; safecall;
    procedure Set_direction(const Value: WideString); safecall;
    function Get_slide: WordBool; safecall;
    procedure Set_slide(Value: WordBool); safecall;
    function Get_tiled: WordBool; safecall;
    procedure Set_tiled(Value: WordBool); safecall;
    function Get_foregroundColor: WideString; safecall;
    procedure Set_foregroundColor(const Value: WideString); safecall;
    function Get_foregroundEndColor: WideString; safecall;
    procedure Set_foregroundEndColor(const Value: WideString); safecall;
    function Get_backgroundColor: WideString; safecall;
    procedure Set_backgroundColor(const Value: WideString); safecall;
    function Get_backgroundEndColor: WideString; safecall;
    procedure Set_backgroundEndColor(const Value: WideString); safecall;
    function Get_disabledColor: WideString; safecall;
    procedure Set_disabledColor(const Value: WideString); safecall;
    function Get_transparencyColor: WideString; safecall;
    procedure Set_transparencyColor(const Value: WideString); safecall;
    function Get_foregroundImage: WideString; safecall;
    procedure Set_foregroundImage(const Value: WideString); safecall;
    function Get_backgroundImage: WideString; safecall;
    procedure Set_backgroundImage(const Value: WideString); safecall;
    function Get_backgroundHoverImage: WideString; safecall;
    procedure Set_backgroundHoverImage(const Value: WideString); safecall;
    function Get_disabledImage: WideString; safecall;
    procedure Set_disabledImage(const Value: WideString); safecall;
    function Get_thumbImage: WideString; safecall;
    procedure Set_thumbImage(const Value: WideString); safecall;
    function Get_thumbHoverImage: WideString; safecall;
    procedure Set_thumbHoverImage(const Value: WideString); safecall;
    function Get_thumbDownImage: WideString; safecall;
    procedure Set_thumbDownImage(const Value: WideString); safecall;
    function Get_thumbDisabledImage: WideString; safecall;
    procedure Set_thumbDisabledImage(const Value: WideString); safecall;
    function Get_min: Single; safecall;
    procedure Set_min(Value: Single); safecall;
    function Get_max: Single; safecall;
    procedure Set_max(Value: Single); safecall;
    function Get_value: Single; safecall;
    procedure Set_value(Value: Single); safecall;
    function Get_toolTip: WideString; safecall;
    procedure Set_toolTip(const Value: WideString); safecall;
    function Get_cursor: WideString; safecall;
    procedure Set_cursor(const Value: WideString); safecall;
    function Get_borderSize: SYSINT; safecall;
    procedure Set_borderSize(Value: SYSINT); safecall;
    function Get_foregroundHoverImage: WideString; safecall;
    procedure Set_foregroundHoverImage(const Value: WideString); safecall;
    function Get_foregroundProgress: Single; safecall;
    procedure Set_foregroundProgress(Value: Single); safecall;
    function Get_useForegroundProgress: WordBool; safecall;
    procedure Set_useForegroundProgress(Value: WordBool); safecall;
    property direction: WideString read Get_direction write Set_direction;
    property slide: WordBool read Get_slide write Set_slide;
    property tiled: WordBool read Get_tiled write Set_tiled;
    property foregroundColor: WideString read Get_foregroundColor write Set_foregroundColor;
    property foregroundEndColor: WideString read Get_foregroundEndColor write Set_foregroundEndColor;
    property backgroundColor: WideString read Get_backgroundColor write Set_backgroundColor;
    property backgroundEndColor: WideString read Get_backgroundEndColor write Set_backgroundEndColor;
    property disabledColor: WideString read Get_disabledColor write Set_disabledColor;
    property transparencyColor: WideString read Get_transparencyColor write Set_transparencyColor;
    property foregroundImage: WideString read Get_foregroundImage write Set_foregroundImage;
    property backgroundImage: WideString read Get_backgroundImage write Set_backgroundImage;
    property backgroundHoverImage: WideString read Get_backgroundHoverImage write Set_backgroundHoverImage;
    property disabledImage: WideString read Get_disabledImage write Set_disabledImage;
    property thumbImage: WideString read Get_thumbImage write Set_thumbImage;
    property thumbHoverImage: WideString read Get_thumbHoverImage write Set_thumbHoverImage;
    property thumbDownImage: WideString read Get_thumbDownImage write Set_thumbDownImage;
    property thumbDisabledImage: WideString read Get_thumbDisabledImage write Set_thumbDisabledImage;
    property min: Single read Get_min write Set_min;
    property max: Single read Get_max write Set_max;
    property value: Single read Get_value write Set_value;
    property toolTip: WideString read Get_toolTip write Set_toolTip;
    property cursor: WideString read Get_cursor write Set_cursor;
    property borderSize: SYSINT read Get_borderSize write Set_borderSize;
    property foregroundHoverImage: WideString read Get_foregroundHoverImage write Set_foregroundHoverImage;
    property foregroundProgress: Single read Get_foregroundProgress write Set_foregroundProgress;
    property useForegroundProgress: WordBool read Get_useForegroundProgress write Set_useForegroundProgress;
  end;

{ DispInterface declaration for Dual Interface IWMPSliderCtrl }

  IWMPSliderCtrlDisp = dispinterface
    ['{F2BF2C8F-405F-11D3-BB39-00A0C93CA73A}']
    property direction: WideString dispid 5400;
    property slide: WordBool dispid 5402;
    property tiled: WordBool dispid 5403;
    property foregroundColor: WideString dispid 5404;
    property foregroundEndColor: WideString dispid 5405;
    property backgroundColor: WideString dispid 5406;
    property backgroundEndColor: WideString dispid 5407;
    property disabledColor: WideString dispid 5408;
    property transparencyColor: WideString dispid 5409;
    property foregroundImage: WideString dispid 5410;
    property backgroundImage: WideString dispid 5411;
    property backgroundHoverImage: WideString dispid 5412;
    property disabledImage: WideString dispid 5413;
    property thumbImage: WideString dispid 5414;
    property thumbHoverImage: WideString dispid 5415;
    property thumbDownImage: WideString dispid 5416;
    property thumbDisabledImage: WideString dispid 5417;
    property min: Single dispid 5418;
    property max: Single dispid 5419;
    property value: Single dispid 5420;
    property toolTip: WideString dispid 5421;
    property cursor: WideString dispid 5422;
    property borderSize: SYSINT dispid 5423;
    property foregroundHoverImage: WideString dispid 5424;
    property foregroundProgress: Single dispid 5425;
    property useForegroundProgress: WordBool dispid 5426;
  end;

{ IWMPVideoCtrlEvents: Public interface for skin object model. }

  IWMPVideoCtrlEvents = dispinterface
    ['{A85C0477-714C-4A06-B9F6-7C8CA38B45DC}']
    procedure onvideostart; dispid 5720;
    procedure onvideoend; dispid 5721;
  end;

{ IWMPVideoCtrl: Public interface for skin object model. }

  IWMPVideoCtrl = interface(IDispatch)
    ['{61CECF10-FC3A-11D2-A1CD-005004602752}']
    procedure Set_windowless(Value: WordBool); safecall;
    function Get_windowless: WordBool; safecall;
    procedure Set_cursor(const Value: WideString); safecall;
    function Get_cursor: WideString; safecall;
    procedure Set_backgroundColor(const Value: WideString); safecall;
    function Get_backgroundColor: WideString; safecall;
    procedure Set_maintainAspectRatio(Value: WordBool); safecall;
    function Get_maintainAspectRatio: WordBool; safecall;
    procedure Set_toolTip(const Value: WideString); safecall;
    function Get_toolTip: WideString; safecall;
    function Get_fullScreen: WordBool; safecall;
    procedure Set_fullScreen(Value: WordBool); safecall;
    procedure Set_shrinkToFit(Value: WordBool); safecall;
    function Get_shrinkToFit: WordBool; safecall;
    procedure Set_stretchToFit(Value: WordBool); safecall;
    function Get_stretchToFit: WordBool; safecall;
    procedure Set_zoom(Value: Integer); safecall;
    function Get_zoom: Integer; safecall;
    property windowless: WordBool read Get_windowless write Set_windowless;
    property cursor: WideString read Get_cursor write Set_cursor;
    property backgroundColor: WideString read Get_backgroundColor write Set_backgroundColor;
    property maintainAspectRatio: WordBool read Get_maintainAspectRatio write Set_maintainAspectRatio;
    property toolTip: WideString read Get_toolTip write Set_toolTip;
    property fullScreen: WordBool read Get_fullScreen write Set_fullScreen;
    property shrinkToFit: WordBool read Get_shrinkToFit write Set_shrinkToFit;
    property stretchToFit: WordBool read Get_stretchToFit write Set_stretchToFit;
    property zoom: Integer read Get_zoom write Set_zoom;
  end;

{ DispInterface declaration for Dual Interface IWMPVideoCtrl }

  IWMPVideoCtrlDisp = dispinterface
    ['{61CECF10-FC3A-11D2-A1CD-005004602752}']
    property windowless: WordBool dispid 5700;
    property cursor: WideString dispid 5701;
    property backgroundColor: WideString dispid 5702;
    property maintainAspectRatio: WordBool dispid 5704;
    property toolTip: WideString dispid 5706;
    property fullScreen: WordBool dispid 5707;
    property shrinkToFit: WordBool dispid 5703;
    property stretchToFit: WordBool dispid 5708;
    property zoom: Integer dispid 5709;
  end;

{ IWMPEffectsCtrl: Public interface for skin object model. }

  IWMPEffectsCtrl = interface(IDispatch)
    ['{A9EFAB80-0A60-4C3F-BBD1-4558DD2A9769}']
    function Get_windowed: WordBool; safecall;
    procedure Set_windowed(Value: WordBool); safecall;
    function Get_allowAll: WordBool; safecall;
    procedure Set_allowAll(Value: WordBool); safecall;
    procedure Set_currentEffectType(const Value: WideString); safecall;
    function Get_currentEffectType: WideString; safecall;
    function Get_currentEffectTitle: WideString; safecall;
    procedure next; safecall;
    procedure previous; safecall;
    procedure settings; safecall;
    function Get_currentEffect: IDispatch; safecall;
    procedure Set_currentEffect(Value: IDispatch); safecall;
    procedure nextEffect; safecall;
    procedure previousEffect; safecall;
    procedure nextPreset; safecall;
    procedure previousPreset; safecall;
    function Get_currentPreset: Integer; safecall;
    procedure Set_currentPreset(Value: Integer); safecall;
    function Get_currentPresetTitle: WideString; safecall;
    function Get_currentEffectPresetCount: Integer; safecall;
    function Get_fullScreen: WordBool; safecall;
    procedure Set_fullScreen(Value: WordBool); safecall;
    function Get_effectCanGoFullScreen: WordBool; safecall;
    function Get_effectHasPropertyPage: WordBool; safecall;
    function Get_effectCount: Integer; safecall;
    function Get_effectTitle(index: Integer): WideString; safecall;
    function Get_effectType(index: Integer): WideString; safecall;
    property windowed: WordBool read Get_windowed write Set_windowed;
    property allowAll: WordBool read Get_allowAll write Set_allowAll;
    property currentEffectType: WideString read Get_currentEffectType write Set_currentEffectType;
    property currentEffectTitle: WideString read Get_currentEffectTitle;
    property currentEffect: IDispatch read Get_currentEffect write Set_currentEffect;
    property currentPreset: Integer read Get_currentPreset write Set_currentPreset;
    property currentPresetTitle: WideString read Get_currentPresetTitle;
    property currentEffectPresetCount: Integer read Get_currentEffectPresetCount;
    property fullScreen: WordBool read Get_fullScreen write Set_fullScreen;
    property effectCanGoFullScreen: WordBool read Get_effectCanGoFullScreen;
    property effectHasPropertyPage: WordBool read Get_effectHasPropertyPage;
    property effectCount: Integer read Get_effectCount;
    property effectTitle[index: Integer]: WideString read Get_effectTitle;
    property effectType[index: Integer]: WideString read Get_effectType;
  end;

{ DispInterface declaration for Dual Interface IWMPEffectsCtrl }

  IWMPEffectsCtrlDisp = dispinterface
    ['{A9EFAB80-0A60-4C3F-BBD1-4558DD2A9769}']
    property windowed: WordBool dispid 5500;
    property allowAll: WordBool dispid 5501;
    property currentEffectType: WideString dispid 5507;
    property currentEffectTitle: WideString readonly dispid 5506;
    procedure next; dispid 5502;
    procedure previous; dispid 5503;
    procedure settings; dispid 5504;
    property currentEffect: IDispatch dispid 5505;
    procedure nextEffect; dispid 5509;
    procedure previousEffect; dispid 5510;
    procedure nextPreset; dispid 5511;
    procedure previousPreset; dispid 5512;
    property currentPreset: Integer dispid 5513;
    property currentPresetTitle: WideString readonly dispid 5514;
    property currentEffectPresetCount: Integer readonly dispid 5515;
    property fullScreen: WordBool dispid 5516;
    property effectCanGoFullScreen: WordBool readonly dispid 5517;
    property effectHasPropertyPage: WordBool readonly dispid 5518;
    property effectCount: Integer readonly dispid 5520;
    property effectTitle[index: Integer]: WideString readonly dispid 5521;
    property effectType[index: Integer]: WideString readonly dispid 5522;
  end;

{ IWMPEqualizerSettingsCtrl: Public interface for skin object model. }

  IWMPEqualizerSettingsCtrl = interface(IDispatch)
    ['{2BD3716F-A914-49FB-8655-996D5F495498}']
    function Get_bypass: WordBool; safecall;
    procedure Set_bypass(Value: WordBool); safecall;
    function Get_gainLevel1: Single; safecall;
    procedure Set_gainLevel1(Value: Single); safecall;
    function Get_gainLevel2: Single; safecall;
    procedure Set_gainLevel2(Value: Single); safecall;
    function Get_gainLevel3: Single; safecall;
    procedure Set_gainLevel3(Value: Single); safecall;
    function Get_gainLevel4: Single; safecall;
    procedure Set_gainLevel4(Value: Single); safecall;
    function Get_gainLevel5: Single; safecall;
    procedure Set_gainLevel5(Value: Single); safecall;
    function Get_gainLevel6: Single; safecall;
    procedure Set_gainLevel6(Value: Single); safecall;
    function Get_gainLevel7: Single; safecall;
    procedure Set_gainLevel7(Value: Single); safecall;
    function Get_gainLevel8: Single; safecall;
    procedure Set_gainLevel8(Value: Single); safecall;
    function Get_gainLevel9: Single; safecall;
    procedure Set_gainLevel9(Value: Single); safecall;
    function Get_gainLevel10: Single; safecall;
    procedure Set_gainLevel10(Value: Single); safecall;
    function Get_gainLevels(iIndex: Integer): Single; safecall;
    procedure Set_gainLevels(iIndex: Integer; Value: Single); safecall;
    procedure reset; safecall;
    function Get_bands: Integer; safecall;
    procedure nextPreset; safecall;
    procedure previousPreset; safecall;
    function Get_currentPreset: Integer; safecall;
    procedure Set_currentPreset(Value: Integer); safecall;
    function Get_currentPresetTitle: WideString; safecall;
    function Get_presetCount: Integer; safecall;
    function Get_enhancedAudio: WordBool; safecall;
    procedure Set_enhancedAudio(Value: WordBool); safecall;
    function Get_speakerSize: Integer; safecall;
    procedure Set_speakerSize(Value: Integer); safecall;
    function Get_currentSpeakerName: WideString; safecall;
    function Get_truBassLevel: Integer; safecall;
    procedure Set_truBassLevel(Value: Integer); safecall;
    function Get_wowLevel: Integer; safecall;
    procedure Set_wowLevel(Value: Integer); safecall;
    function Get_splineTension: Single; safecall;
    procedure Set_splineTension(Value: Single); safecall;
    function Get_enableSplineTension: WordBool; safecall;
    procedure Set_enableSplineTension(Value: WordBool); safecall;
    function Get_presetTitle(iIndex: Integer): WideString; safecall;
    function Get_normalization: WordBool; safecall;
    procedure Set_normalization(Value: WordBool); safecall;
    function Get_normalizationAverage: Single; safecall;
    function Get_normalizationPeak: Single; safecall;
    function Get_crossFade: WordBool; safecall;
    procedure Set_crossFade(Value: WordBool); safecall;
    function Get_crossFadeWindow: Integer; safecall;
    procedure Set_crossFadeWindow(Value: Integer); safecall;
    property bypass: WordBool read Get_bypass write Set_bypass;
    property gainLevel1: Single read Get_gainLevel1 write Set_gainLevel1;
    property gainLevel2: Single read Get_gainLevel2 write Set_gainLevel2;
    property gainLevel3: Single read Get_gainLevel3 write Set_gainLevel3;
    property gainLevel4: Single read Get_gainLevel4 write Set_gainLevel4;
    property gainLevel5: Single read Get_gainLevel5 write Set_gainLevel5;
    property gainLevel6: Single read Get_gainLevel6 write Set_gainLevel6;
    property gainLevel7: Single read Get_gainLevel7 write Set_gainLevel7;
    property gainLevel8: Single read Get_gainLevel8 write Set_gainLevel8;
    property gainLevel9: Single read Get_gainLevel9 write Set_gainLevel9;
    property gainLevel10: Single read Get_gainLevel10 write Set_gainLevel10;
    property gainLevels[iIndex: Integer]: Single read Get_gainLevels write Set_gainLevels;
    property bands: Integer read Get_bands;
    property currentPreset: Integer read Get_currentPreset write Set_currentPreset;
    property currentPresetTitle: WideString read Get_currentPresetTitle;
    property presetCount: Integer read Get_presetCount;
    property enhancedAudio: WordBool read Get_enhancedAudio write Set_enhancedAudio;
    property speakerSize: Integer read Get_speakerSize write Set_speakerSize;
    property currentSpeakerName: WideString read Get_currentSpeakerName;
    property truBassLevel: Integer read Get_truBassLevel write Set_truBassLevel;
    property wowLevel: Integer read Get_wowLevel write Set_wowLevel;
    property splineTension: Single read Get_splineTension write Set_splineTension;
    property enableSplineTension: WordBool read Get_enableSplineTension write Set_enableSplineTension;
    property presetTitle[iIndex: Integer]: WideString read Get_presetTitle;
    property normalization: WordBool read Get_normalization write Set_normalization;
    property normalizationAverage: Single read Get_normalizationAverage;
    property normalizationPeak: Single read Get_normalizationPeak;
    property crossFade: WordBool read Get_crossFade write Set_crossFade;
    property crossFadeWindow: Integer read Get_crossFadeWindow write Set_crossFadeWindow;
  end;

{ DispInterface declaration for Dual Interface IWMPEqualizerSettingsCtrl }

  IWMPEqualizerSettingsCtrlDisp = dispinterface
    ['{2BD3716F-A914-49FB-8655-996D5F495498}']
    property bypass: WordBool dispid 5800;
    property gainLevel1: Single dispid 5804;
    property gainLevel2: Single dispid 5805;
    property gainLevel3: Single dispid 5806;
    property gainLevel4: Single dispid 5807;
    property gainLevel5: Single dispid 5808;
    property gainLevel6: Single dispid 5809;
    property gainLevel7: Single dispid 5810;
    property gainLevel8: Single dispid 5811;
    property gainLevel9: Single dispid 5812;
    property gainLevel10: Single dispid 5813;
    property gainLevels[iIndex: Integer]: Single dispid 5815;
    procedure reset; dispid 5814;
    property bands: Integer readonly dispid 5801;
    procedure nextPreset; dispid 5816;
    procedure previousPreset; dispid 5817;
    property currentPreset: Integer dispid 5818;
    property currentPresetTitle: WideString readonly dispid 5819;
    property presetCount: Integer readonly dispid 5820;
    property enhancedAudio: WordBool dispid 5821;
    property speakerSize: Integer dispid 5822;
    property currentSpeakerName: WideString readonly dispid 5823;
    property truBassLevel: Integer dispid 5824;
    property wowLevel: Integer dispid 5825;
    property splineTension: Single dispid 5827;
    property enableSplineTension: WordBool dispid 5826;
    property presetTitle[iIndex: Integer]: WideString readonly dispid 5828;
    property normalization: WordBool dispid 5829;
    property normalizationAverage: Single readonly dispid 5830;
    property normalizationPeak: Single readonly dispid 5831;
    property crossFade: WordBool dispid 5832;
    property crossFadeWindow: Integer dispid 5833;
  end;

{ IWMPVideoSettingsCtrl: Public interface for skin object model. }

  IWMPVideoSettingsCtrl = interface(IDispatch)
    ['{07EC23DA-EF73-4BDE-A40F-F269E0B7AFD6}']
    function Get_brightness: Integer; safecall;
    procedure Set_brightness(Value: Integer); safecall;
    function Get_contrast: Integer; safecall;
    procedure Set_contrast(Value: Integer); safecall;
    function Get_hue: Integer; safecall;
    procedure Set_hue(Value: Integer); safecall;
    function Get_saturation: Integer; safecall;
    procedure Set_saturation(Value: Integer); safecall;
    procedure reset; safecall;
    property brightness: Integer read Get_brightness write Set_brightness;
    property contrast: Integer read Get_contrast write Set_contrast;
    property hue: Integer read Get_hue write Set_hue;
    property saturation: Integer read Get_saturation write Set_saturation;
  end;

{ DispInterface declaration for Dual Interface IWMPVideoSettingsCtrl }

  IWMPVideoSettingsCtrlDisp = dispinterface
    ['{07EC23DA-EF73-4BDE-A40F-F269E0B7AFD6}']
    property brightness: Integer dispid 5900;
    property contrast: Integer dispid 5901;
    property hue: Integer dispid 5902;
    property saturation: Integer dispid 5903;
    procedure reset; dispid 5904;
  end;

{ IWMPLibraryTreeCtrl: Not Public.  Internal interface used by Windows Media Player. }

  IWMPLibraryTreeCtrl = interface(IDispatch)
    ['{B738FCAE-F089-45DF-AED6-034B9E7DB632}']
    function Get_dropDownVisible: WordBool; safecall;
    procedure Set_dropDownVisible(Value: WordBool); safecall;
    function Get_foregroundColor: WideString; safecall;
    procedure Set_foregroundColor(const Value: WideString); safecall;
    function Get_backgroundColor: WideString; safecall;
    procedure Set_backgroundColor(const Value: WideString); safecall;
    function Get_fontSize: Integer; safecall;
    procedure Set_fontSize(Value: Integer); safecall;
    function Get_fontStyle: WideString; safecall;
    procedure Set_fontStyle(const Value: WideString); safecall;
    function Get_fontFace: WideString; safecall;
    procedure Set_fontFace(const Value: WideString); safecall;
    function Get_filter: WideString; safecall;
    procedure Set_filter(const Value: WideString); safecall;
    function Get_expandState: WideString; safecall;
    procedure Set_expandState(const Value: WideString); safecall;
    function Get_Playlist: IWMPPlaylist; safecall;
    procedure Set_Playlist(const Value: IWMPPlaylist); safecall;
    function Get_selectedPlaylist: IWMPPlaylist; safecall;
    function Get_selectedMedia: IWMPMedia; safecall;
    property dropDownVisible: WordBool read Get_dropDownVisible write Set_dropDownVisible;
    property foregroundColor: WideString read Get_foregroundColor write Set_foregroundColor;
    property backgroundColor: WideString read Get_backgroundColor write Set_backgroundColor;
    property fontSize: Integer read Get_fontSize write Set_fontSize;
    property fontStyle: WideString read Get_fontStyle write Set_fontStyle;
    property fontFace: WideString read Get_fontFace write Set_fontFace;
    property filter: WideString read Get_filter write Set_filter;
    property expandState: WideString read Get_expandState write Set_expandState;
    property Playlist: IWMPPlaylist read Get_Playlist write Set_Playlist;
    property selectedPlaylist: IWMPPlaylist read Get_selectedPlaylist;
    property selectedMedia: IWMPMedia read Get_selectedMedia;
  end;

{ DispInterface declaration for Dual Interface IWMPLibraryTreeCtrl }

  IWMPLibraryTreeCtrlDisp = dispinterface
    ['{B738FCAE-F089-45DF-AED6-034B9E7DB632}']
    property dropDownVisible: WordBool dispid 6401;
    property foregroundColor: WideString dispid 6402;
    property backgroundColor: WideString dispid 6403;
    property fontSize: Integer dispid 6404;
    property fontStyle: WideString dispid 6405;
    property fontFace: WideString dispid 6406;
    property filter: WideString dispid 6407;
    property expandState: WideString dispid 6408;
    property Playlist: IWMPPlaylist dispid 6409;
    property selectedPlaylist: IWMPPlaylist readonly dispid 6410;
    property selectedMedia: IWMPMedia readonly dispid 6411;
  end;

{ IWMPEditCtrl: Public interface for skin object model. }

  IWMPEditCtrl = interface(IDispatch)
    ['{70E1217C-C617-4CFD-BD8A-69CA2043E70B}']
    function Get_value: WideString; safecall;
    procedure Set_value(const Value: WideString); safecall;
    function Get_border: WordBool; safecall;
    procedure Set_border(Value: WordBool); safecall;
    function Get_justification: WideString; safecall;
    procedure Set_justification(const Value: WideString); safecall;
    function Get_editStyle: WideString; safecall;
    procedure Set_editStyle(const Value: WideString); safecall;
    function Get_wordWrap: WordBool; safecall;
    procedure Set_wordWrap(Value: WordBool); safecall;
    function Get_readOnly: WordBool; safecall;
    procedure Set_readOnly(Value: WordBool); safecall;
    function Get_foregroundColor: WideString; safecall;
    procedure Set_foregroundColor(const Value: WideString); safecall;
    function Get_backgroundColor: WideString; safecall;
    procedure Set_backgroundColor(const Value: WideString); safecall;
    function Get_fontSize: Integer; safecall;
    procedure Set_fontSize(Value: Integer); safecall;
    function Get_fontStyle: WideString; safecall;
    procedure Set_fontStyle(const Value: WideString); safecall;
    function Get_fontFace: WideString; safecall;
    procedure Set_fontFace(const Value: WideString); safecall;
    function Get_textLimit: Integer; safecall;
    procedure Set_textLimit(Value: Integer); safecall;
    function Get_lineCount: Integer; safecall;
    function getLine(nIndex: Integer): WideString; safecall;
    function getSelectionStart: Integer; safecall;
    function getSelectionEnd: Integer; safecall;
    procedure setSelection(nStart, nEnd: Integer); safecall;
    procedure replaceSelection(const newVal: WideString); safecall;
    function getLineIndex(nIndex: Integer): Integer; safecall;
    function getLineFromChar(nPosition: Integer): Integer; safecall;
    property value: WideString read Get_value write Set_value;
    property border: WordBool read Get_border write Set_border;
    property justification: WideString read Get_justification write Set_justification;
    property editStyle: WideString read Get_editStyle write Set_editStyle;
    property wordWrap: WordBool read Get_wordWrap write Set_wordWrap;
    property readOnly: WordBool read Get_readOnly write Set_readOnly;
    property foregroundColor: WideString read Get_foregroundColor write Set_foregroundColor;
    property backgroundColor: WideString read Get_backgroundColor write Set_backgroundColor;
    property fontSize: Integer read Get_fontSize write Set_fontSize;
    property fontStyle: WideString read Get_fontStyle write Set_fontStyle;
    property fontFace: WideString read Get_fontFace write Set_fontFace;
    property textLimit: Integer read Get_textLimit write Set_textLimit;
    property lineCount: Integer read Get_lineCount;
  end;

{ DispInterface declaration for Dual Interface IWMPEditCtrl }

  IWMPEditCtrlDisp = dispinterface
    ['{70E1217C-C617-4CFD-BD8A-69CA2043E70B}']
    property value: WideString dispid 0;
    property border: WordBool dispid 6000;
    property justification: WideString dispid 6001;
    property editStyle: WideString dispid 6002;
    property wordWrap: WordBool dispid 6003;
    property readOnly: WordBool dispid 6004;
    property foregroundColor: WideString dispid 6005;
    property backgroundColor: WideString dispid 6006;
    property fontSize: Integer dispid 6007;
    property fontStyle: WideString dispid 6008;
    property fontFace: WideString dispid 6009;
    property textLimit: Integer dispid 6010;
    property lineCount: Integer readonly dispid 6011;
    function getLine(nIndex: Integer): WideString; dispid 6012;
    function getSelectionStart: Integer; dispid 6013;
    function getSelectionEnd: Integer; dispid 6014;
    procedure setSelection(nStart, nEnd: Integer); dispid 6015;
    procedure replaceSelection(const newVal: WideString); dispid 6016;
    function getLineIndex(nIndex: Integer): Integer; dispid 6017;
    function getLineFromChar(nPosition: Integer): Integer; dispid 6018;
  end;

{ IWMPPluginUIHost: Not Public.  Internal interface used by Windows Media Player. }

  IWMPPluginUIHost = interface(IDispatch)
    ['{5D0AD945-289E-45C5-A9C6-F301F0152108}']
    function Get_backgroundColor: WideString; safecall;
    procedure Set_backgroundColor(const Value: WideString); safecall;
    function Get_objectID: WideString; safecall;
    procedure Set_objectID(const Value: WideString); safecall;
    function getProperty(const bstrName: WideString): OleVariant; safecall;
    procedure setProperty(const bstrName: WideString; newVal: OleVariant); safecall;
    property backgroundColor: WideString read Get_backgroundColor write Set_backgroundColor;
    property objectID: WideString read Get_objectID write Set_objectID;
  end;

{ DispInterface declaration for Dual Interface IWMPPluginUIHost }

  IWMPPluginUIHostDisp = dispinterface
    ['{5D0AD945-289E-45C5-A9C6-F301F0152108}']
    property backgroundColor: WideString dispid 6201;
    property objectID: WideString dispid 6202;
    function getProperty(const bstrName: WideString): OleVariant; dispid 6203;
    procedure setProperty(const bstrName: WideString; newVal: OleVariant); dispid 6204;
  end;

{ IWMPMenuCtrl: Not Public.  Internal interface used by Windows Media Player. }

  IWMPMenuCtrl = interface(IDispatch)
    ['{158A7ADC-33DA-4039-A553-BDDBBE389F5C}']
    procedure deleteAllItems; safecall;
    procedure appendItem(nID: Integer; const bstrItem: WideString); safecall;
    procedure appendSeparator; safecall;
    procedure enableItem(nID: Integer; newVal: WordBool); safecall;
    procedure checkItem(nID: Integer; newVal: WordBool); safecall;
    procedure checkRadioItem(nID: Integer; newVal: WordBool); safecall;
    function Get_showFlags: Integer; safecall;
    procedure Set_showFlags(Value: Integer); safecall;
    function show: Integer; safecall;
    procedure showEx(nID: Integer); safecall;
    property showFlags: Integer read Get_showFlags write Set_showFlags;
  end;

{ DispInterface declaration for Dual Interface IWMPMenuCtrl }

  IWMPMenuCtrlDisp = dispinterface
    ['{158A7ADC-33DA-4039-A553-BDDBBE389F5C}']
    procedure deleteAllItems; dispid 6301;
    procedure appendItem(nID: Integer; const bstrItem: WideString); dispid 6302;
    procedure appendSeparator; dispid 6303;
    procedure enableItem(nID: Integer; newVal: WordBool); dispid 6304;
    procedure checkItem(nID: Integer; newVal: WordBool); dispid 6305;
    procedure checkRadioItem(nID: Integer; newVal: WordBool); dispid 6306;
    property showFlags: Integer dispid 6307;
    function show: Integer; dispid 6308;
    procedure showEx(nID: Integer); dispid 6309;
  end;

{ IWMPAutoMenuCtrl: Not Public.  Internal interface used by Windows Media Player. }

  IWMPAutoMenuCtrl = interface(IDispatch)
    ['{1AD13E0B-4F3A-41DF-9BE2-F9E6FE0A7875}']
    procedure show(const newVal: WideString); safecall;
  end;

{ DispInterface declaration for Dual Interface IWMPAutoMenuCtrl }

  IWMPAutoMenuCtrlDisp = dispinterface
    ['{1AD13E0B-4F3A-41DF-9BE2-F9E6FE0A7875}']
    procedure show(const newVal: WideString); dispid 6501;
  end;

{ IWMPRegionalButtonCtrl: Public interface for skin object model. }

  IWMPRegionalButtonCtrl = interface(IDispatch)
    ['{58D507B1-2354-11D3-BD41-00C04F6EA5AE}']
    function Get_image: WideString; safecall;
    procedure Set_image(const Value: WideString); safecall;
    function Get_hoverImage: WideString; safecall;
    procedure Set_hoverImage(const Value: WideString); safecall;
    function Get_downImage: WideString; safecall;
    procedure Set_downImage(const Value: WideString); safecall;
    function Get_hoverDownImage: WideString; safecall;
    procedure Set_hoverDownImage(const Value: WideString); safecall;
    function Get_disabledImage: WideString; safecall;
    procedure Set_disabledImage(const Value: WideString); safecall;
    function Get_mappingImage: WideString; safecall;
    procedure Set_mappingImage(const Value: WideString); safecall;
    function Get_transparencyColor: WideString; safecall;
    procedure Set_transparencyColor(const Value: WideString); safecall;
    function Get_cursor: WideString; safecall;
    procedure Set_cursor(const Value: WideString); safecall;
    function Get_showBackground: WordBool; safecall;
    procedure Set_showBackground(Value: WordBool); safecall;
    function Get_radio: WordBool; safecall;
    procedure Set_radio(Value: WordBool); safecall;
    function Get_buttonCount: Integer; safecall;
    function createButton: IDispatch; safecall;
    function getButton(nButton: Integer): IDispatch; safecall;
    procedure Click(nButton: Integer); safecall;
    function Get_hueShift: Single; safecall;
    procedure Set_hueShift(Value: Single); safecall;
    function Get_saturation: Single; safecall;
    procedure Set_saturation(Value: Single); safecall;
    property image: WideString read Get_image write Set_image;
    property hoverImage: WideString read Get_hoverImage write Set_hoverImage;
    property downImage: WideString read Get_downImage write Set_downImage;
    property hoverDownImage: WideString read Get_hoverDownImage write Set_hoverDownImage;
    property disabledImage: WideString read Get_disabledImage write Set_disabledImage;
    property mappingImage: WideString read Get_mappingImage write Set_mappingImage;
    property transparencyColor: WideString read Get_transparencyColor write Set_transparencyColor;
    property cursor: WideString read Get_cursor write Set_cursor;
    property showBackground: WordBool read Get_showBackground write Set_showBackground;
    property radio: WordBool read Get_radio write Set_radio;
    property buttonCount: Integer read Get_buttonCount;
    property hueShift: Single read Get_hueShift write Set_hueShift;
    property saturation: Single read Get_saturation write Set_saturation;
  end;

{ DispInterface declaration for Dual Interface IWMPRegionalButtonCtrl }

  IWMPRegionalButtonCtrlDisp = dispinterface
    ['{58D507B1-2354-11D3-BD41-00C04F6EA5AE}']
    property image: WideString dispid 5300;
    property hoverImage: WideString dispid 5301;
    property downImage: WideString dispid 5302;
    property hoverDownImage: WideString dispid 5303;
    property disabledImage: WideString dispid 5304;
    property mappingImage: WideString dispid 5305;
    property transparencyColor: WideString dispid 5306;
    property cursor: WideString dispid 5308;
    property showBackground: WordBool dispid 5309;
    property radio: WordBool dispid 5310;
    property buttonCount: Integer readonly dispid 5311;
    function createButton: IDispatch; dispid 5312;
    function getButton(nButton: Integer): IDispatch; dispid 5313;
    procedure Click(nButton: Integer); dispid 5314;
    property hueShift: Single dispid 5315;
    property saturation: Single dispid 5316;
  end;

{ IWMPRegionalButtonEvents: Public interface for skin object model. }

  IWMPRegionalButtonEvents = dispinterface
    ['{50FC8D31-67AC-11D3-BD4C-00C04F6EA5AE}']
    procedure onblur; dispid 5360;
    procedure onfocus; dispid 5361;
    procedure onclick; dispid 5362;
    procedure ondblclick; dispid 5363;
    procedure onmousedown; dispid 5364;
    procedure onmouseup; dispid 5365;
    procedure onmousemove; dispid 5366;
    procedure onmouseover; dispid 5367;
    procedure onmouseout; dispid 5368;
    procedure onkeypress; dispid 5369;
    procedure onkeydown; dispid 5370;
    procedure onkeyup; dispid 5371;
  end;

{ IWMPRegionalButton: Public interface for skin object model. }

  IWMPRegionalButton = interface(IDispatch)
    ['{58D507B2-2354-11D3-BD41-00C04F6EA5AE}']
    function Get_upToolTip: WideString; safecall;
    procedure Set_upToolTip(const Value: WideString); safecall;
    function Get_downToolTip: WideString; safecall;
    procedure Set_downToolTip(const Value: WideString); safecall;
    function Get_mappingColor: WideString; safecall;
    procedure Set_mappingColor(const Value: WideString); safecall;
    function Get_enabled: WordBool; safecall;
    procedure Set_enabled(Value: WordBool); safecall;
    function Get_sticky: WordBool; safecall;
    procedure Set_sticky(Value: WordBool); safecall;
    function Get_down: WordBool; safecall;
    procedure Set_down(Value: WordBool); safecall;
    function Get_index: Integer; safecall;
    function Get_tabStop: WordBool; safecall;
    procedure Set_tabStop(Value: WordBool); safecall;
    function Get_cursor: WideString; safecall;
    procedure Set_cursor(const Value: WideString); safecall;
    procedure Click; safecall;
    function Get_accName: WideString; safecall;
    procedure Set_accName(const Value: WideString); safecall;
    function Get_accDescription: WideString; safecall;
    procedure Set_accDescription(const Value: WideString); safecall;
    function Get_accKeyboardShortcut: WideString; safecall;
    procedure Set_accKeyboardShortcut(const Value: WideString); safecall;
    property upToolTip: WideString read Get_upToolTip write Set_upToolTip;
    property downToolTip: WideString read Get_downToolTip write Set_downToolTip;
    property mappingColor: WideString read Get_mappingColor write Set_mappingColor;
    property enabled: WordBool read Get_enabled write Set_enabled;
    property sticky: WordBool read Get_sticky write Set_sticky;
    property down: WordBool read Get_down write Set_down;
    property index: Integer read Get_index;
    property tabStop: WordBool read Get_tabStop write Set_tabStop;
    property cursor: WideString read Get_cursor write Set_cursor;
    property accName: WideString read Get_accName write Set_accName;
    property accDescription: WideString read Get_accDescription write Set_accDescription;
    property accKeyboardShortcut: WideString read Get_accKeyboardShortcut write Set_accKeyboardShortcut;
  end;

{ DispInterface declaration for Dual Interface IWMPRegionalButton }

  IWMPRegionalButtonDisp = dispinterface
    ['{58D507B2-2354-11D3-BD41-00C04F6EA5AE}']
    property upToolTip: WideString dispid 5330;
    property downToolTip: WideString dispid 5331;
    property mappingColor: WideString dispid 5332;
    property enabled: WordBool dispid 5333;
    property sticky: WordBool dispid 5339;
    property down: WordBool dispid 5340;
    property index: Integer readonly dispid 5341;
    property tabStop: WordBool dispid 5342;
    property cursor: WideString dispid 5343;
    procedure Click; dispid 5344;
    property accName: WideString dispid 5345;
    property accDescription: WideString dispid 5346;
    property accKeyboardShortcut: WideString dispid 5347;
  end;

{ IWMPCustomSliderCtrlEvents: Public interface for skin object model. }

  IWMPCustomSliderCtrlEvents = dispinterface
    ['{95F45AA4-ED0A-11D2-BA67-0000F80855E6}']
    procedure ondragbegin; dispid 5020;
    procedure ondragend; dispid 5021;
    procedure onpositionchange; dispid 5022;
  end;

{ IWMPCustomSlider: Public interface for skin object model. }

  IWMPCustomSlider = interface(IDispatch)
    ['{95F45AA2-ED0A-11D2-BA67-0000F80855E6}']
    function Get_cursor: WideString; safecall;
    procedure Set_cursor(const Value: WideString); safecall;
    function Get_min: Single; safecall;
    procedure Set_min(Value: Single); safecall;
    function Get_max: Single; safecall;
    procedure Set_max(Value: Single); safecall;
    function Get_value: Single; safecall;
    procedure Set_value(Value: Single); safecall;
    function Get_toolTip: WideString; safecall;
    procedure Set_toolTip(const Value: WideString); safecall;
    function Get_positionImage: WideString; safecall;
    procedure Set_positionImage(const Value: WideString); safecall;
    function Get_image: WideString; safecall;
    procedure Set_image(const Value: WideString); safecall;
    function Get_hoverImage: WideString; safecall;
    procedure Set_hoverImage(const Value: WideString); safecall;
    function Get_disabledImage: WideString; safecall;
    procedure Set_disabledImage(const Value: WideString); safecall;
    function Get_downImage: WideString; safecall;
    procedure Set_downImage(const Value: WideString); safecall;
    function Get_transparencyColor: WideString; safecall;
    procedure Set_transparencyColor(const Value: WideString); safecall;
    property cursor: WideString read Get_cursor write Set_cursor;
    property min: Single read Get_min write Set_min;
    property max: Single read Get_max write Set_max;
    property value: Single read Get_value write Set_value;
    property toolTip: WideString read Get_toolTip write Set_toolTip;
    property positionImage: WideString read Get_positionImage write Set_positionImage;
    property image: WideString read Get_image write Set_image;
    property hoverImage: WideString read Get_hoverImage write Set_hoverImage;
    property disabledImage: WideString read Get_disabledImage write Set_disabledImage;
    property downImage: WideString read Get_downImage write Set_downImage;
    property transparencyColor: WideString read Get_transparencyColor write Set_transparencyColor;
  end;

{ DispInterface declaration for Dual Interface IWMPCustomSlider }

  IWMPCustomSliderDisp = dispinterface
    ['{95F45AA2-ED0A-11D2-BA67-0000F80855E6}']
    property cursor: WideString dispid 5009;
    property min: Single dispid 5005;
    property max: Single dispid 5006;
    property value: Single dispid 5010;
    property toolTip: WideString dispid 5011;
    property positionImage: WideString dispid 5002;
    property image: WideString dispid 5001;
    property hoverImage: WideString dispid 5003;
    property disabledImage: WideString dispid 5004;
    property downImage: WideString dispid 5012;
    property transparencyColor: WideString dispid 5008;
  end;

{ IWMPTextCtrl: Public interface for skin object model. }

  IWMPTextCtrl = interface(IDispatch)
    ['{237DAC8E-0E32-11D3-A2E2-00C04F79F88E}']
    function Get_backgroundColor: WideString; safecall;
    procedure Set_backgroundColor(const Value: WideString); safecall;
    function Get_fontFace: WideString; safecall;
    procedure Set_fontFace(const Value: WideString); safecall;
    function Get_fontStyle: WideString; safecall;
    procedure Set_fontStyle(const Value: WideString); safecall;
    function Get_fontSize: Integer; safecall;
    procedure Set_fontSize(Value: Integer); safecall;
    function Get_foregroundColor: WideString; safecall;
    procedure Set_foregroundColor(const Value: WideString); safecall;
    function Get_hoverBackgroundColor: WideString; safecall;
    procedure Set_hoverBackgroundColor(const Value: WideString); safecall;
    function Get_hoverForegroundColor: WideString; safecall;
    procedure Set_hoverForegroundColor(const Value: WideString); safecall;
    function Get_hoverFontStyle: WideString; safecall;
    procedure Set_hoverFontStyle(const Value: WideString); safecall;
    function Get_value: WideString; safecall;
    procedure Set_value(const Value: WideString); safecall;
    function Get_toolTip: WideString; safecall;
    procedure Set_toolTip(const Value: WideString); safecall;
    function Get_disabledFontStyle: WideString; safecall;
    procedure Set_disabledFontStyle(const Value: WideString); safecall;
    function Get_disabledForegroundColor: WideString; safecall;
    procedure Set_disabledForegroundColor(const Value: WideString); safecall;
    function Get_disabledBackgroundColor: WideString; safecall;
    procedure Set_disabledBackgroundColor(const Value: WideString); safecall;
    function Get_fontSmoothing: WordBool; safecall;
    procedure Set_fontSmoothing(Value: WordBool); safecall;
    function Get_justification: WideString; safecall;
    procedure Set_justification(const Value: WideString); safecall;
    function Get_wordWrap: WordBool; safecall;
    procedure Set_wordWrap(Value: WordBool); safecall;
    function Get_cursor: WideString; safecall;
    procedure Set_cursor(const Value: WideString); safecall;
    function Get_scrolling: WordBool; safecall;
    procedure Set_scrolling(Value: WordBool); safecall;
    function Get_scrollingDirection: WideString; safecall;
    procedure Set_scrollingDirection(const Value: WideString); safecall;
    function Get_scrollingDelay: SYSINT; safecall;
    procedure Set_scrollingDelay(Value: SYSINT); safecall;
    function Get_scrollingAmount: SYSINT; safecall;
    procedure Set_scrollingAmount(Value: SYSINT); safecall;
    function Get_textWidth: SYSINT; safecall;
    property backgroundColor: WideString read Get_backgroundColor write Set_backgroundColor;
    property fontFace: WideString read Get_fontFace write Set_fontFace;
    property fontStyle: WideString read Get_fontStyle write Set_fontStyle;
    property fontSize: Integer read Get_fontSize write Set_fontSize;
    property foregroundColor: WideString read Get_foregroundColor write Set_foregroundColor;
    property hoverBackgroundColor: WideString read Get_hoverBackgroundColor write Set_hoverBackgroundColor;
    property hoverForegroundColor: WideString read Get_hoverForegroundColor write Set_hoverForegroundColor;
    property hoverFontStyle: WideString read Get_hoverFontStyle write Set_hoverFontStyle;
    property value: WideString read Get_value write Set_value;
    property toolTip: WideString read Get_toolTip write Set_toolTip;
    property disabledFontStyle: WideString read Get_disabledFontStyle write Set_disabledFontStyle;
    property disabledForegroundColor: WideString read Get_disabledForegroundColor write Set_disabledForegroundColor;
    property disabledBackgroundColor: WideString read Get_disabledBackgroundColor write Set_disabledBackgroundColor;
    property fontSmoothing: WordBool read Get_fontSmoothing write Set_fontSmoothing;
    property justification: WideString read Get_justification write Set_justification;
    property wordWrap: WordBool read Get_wordWrap write Set_wordWrap;
    property cursor: WideString read Get_cursor write Set_cursor;
    property scrolling: WordBool read Get_scrolling write Set_scrolling;
    property scrollingDirection: WideString read Get_scrollingDirection write Set_scrollingDirection;
    property scrollingDelay: SYSINT read Get_scrollingDelay write Set_scrollingDelay;
    property scrollingAmount: SYSINT read Get_scrollingAmount write Set_scrollingAmount;
    property textWidth: SYSINT read Get_textWidth;
  end;

{ DispInterface declaration for Dual Interface IWMPTextCtrl }

  IWMPTextCtrlDisp = dispinterface
    ['{237DAC8E-0E32-11D3-A2E2-00C04F79F88E}']
    property backgroundColor: WideString dispid 5201;
    property fontFace: WideString dispid 5206;
    property fontStyle: WideString dispid 5207;
    property fontSize: Integer dispid 5208;
    property foregroundColor: WideString dispid 5209;
    property hoverBackgroundColor: WideString dispid 5210;
    property hoverForegroundColor: WideString dispid 5211;
    property hoverFontStyle: WideString dispid 5212;
    property value: WideString dispid 5213;
    property toolTip: WideString dispid 5214;
    property disabledFontStyle: WideString dispid 5215;
    property disabledForegroundColor: WideString dispid 5216;
    property disabledBackgroundColor: WideString dispid 5217;
    property fontSmoothing: WordBool dispid 5221;
    property justification: WideString dispid 5222;
    property wordWrap: WordBool dispid 5223;
    property cursor: WideString dispid 5224;
    property scrolling: WordBool dispid 5225;
    property scrollingDirection: WideString dispid 5226;
    property scrollingDelay: SYSINT dispid 5227;
    property scrollingAmount: SYSINT dispid 5228;
    property textWidth: SYSINT readonly dispid 5229;
  end;

{ ITaskCntrCtrl: Not Public.  Internal interface used by Windows Media Player. }

  ITaskCntrCtrl = interface(IDispatch)
    ['{891EADB1-1C45-48B0-B704-49A888DA98C4}']
    function Get_CurrentContainer: IUnknown; safecall;
    procedure Set_CurrentContainer(Value: IUnknown); safecall;
    procedure Activate; safecall;
    property CurrentContainer: IUnknown read Get_CurrentContainer write Set_CurrentContainer;
  end;

{ DispInterface declaration for Dual Interface ITaskCntrCtrl }

  ITaskCntrCtrlDisp = dispinterface
    ['{891EADB1-1C45-48B0-B704-49A888DA98C4}']
    property CurrentContainer: IUnknown dispid 1610743808;
    procedure Activate; dispid 1610743810;
  end;

{ _WMPCoreEvents: Public interface. }

  _WMPCoreEvents = dispinterface
    ['{D84CCA96-CCE2-11D2-9ECC-0000F8085981}']
    procedure OpenStateChange(NewState: Integer); dispid 5001;
    procedure PlayStateChange(NewState: Integer); dispid 5101;
    procedure AudioLanguageChange(LangID: Integer); dispid 5102;
    procedure StatusChange; dispid 5002;
    procedure ScriptCommand(const scType, Param: WideString); dispid 5301;
    procedure NewStream; dispid 5403;
    procedure Disconnect(Result: Integer); dispid 5401;
    procedure Buffering(Start: WordBool); dispid 5402;
    procedure Error; dispid 5501;
    procedure Warning(WarningType, Param: Integer; const Description: WideString); dispid 5601;
    procedure EndOfStream(Result: Integer); dispid 5201;
    procedure PositionChange(oldPosition, newPosition: Double); dispid 5202;
    procedure MarkerHit(MarkerNum: Integer); dispid 5203;
    procedure DurationUnitChange(NewDurationUnit: Integer); dispid 5204;
    procedure CdromMediaChange(CdromNum: Integer); dispid 5701;
    procedure PlaylistChange(Playlist: IDispatch; change: WMPPlaylistChangeEventType); dispid 5801;
    procedure CurrentPlaylistChange(change: WMPPlaylistChangeEventType); dispid 5804;
    procedure CurrentPlaylistItemAvailable(const bstrItemName: WideString); dispid 5805;
    procedure MediaChange(Item: IDispatch); dispid 5802;
    procedure CurrentMediaItemAvailable(const bstrItemName: WideString); dispid 5803;
    procedure CurrentItemChange(pdispMedia: IDispatch); dispid 5806;
    procedure MediaCollectionChange; dispid 5807;
    procedure MediaCollectionAttributeStringAdded(const bstrAttribName, bstrAttribVal: WideString); dispid 5808;
    procedure MediaCollectionAttributeStringRemoved(const bstrAttribName, bstrAttribVal: WideString); dispid 5809;
    procedure MediaCollectionAttributeStringChanged(const bstrAttribName, bstrOldAttribVal, bstrNewAttribVal: WideString); dispid 5820;
    procedure PlaylistCollectionChange; dispid 5810;
    procedure PlaylistCollectionPlaylistAdded(const bstrPlaylistName: WideString); dispid 5811;
    procedure PlaylistCollectionPlaylistRemoved(const bstrPlaylistName: WideString); dispid 5812;
    procedure PlaylistCollectionPlaylistSetAsDeleted(const bstrPlaylistName: WideString; varfIsDeleted: WordBool); dispid 5818;
    procedure ModeChange(const ModeName: WideString; NewValue: WordBool); dispid 5819;
    procedure MediaError(pMediaObject: IDispatch); dispid 5821;
    procedure OpenPlaylistSwitch(pItem: IDispatch); dispid 5823;
    procedure DomainChange(const strDomain: WideString); dispid 5822;
  end;

{ IWMPGraphEventHandler: Not Public.  Internal interface used by Windows Media Player. }

  IWMPGraphEventHandler = interface(IDispatch)
    ['{6B550945-018F-11D3-B14A-00C04F79FAA6}']
    procedure NotifyGraphStateChange(punkGraph: ULONG_PTR; lGraphState: Integer); safecall;
    procedure AsyncNotifyGraphStateChange(punkGraph: ULONG_PTR; lGraphState: Integer); safecall;
    procedure NotifyRateChange(punkGraph: ULONG_PTR; dRate: Double); safecall;
    procedure NotifyPlaybackEnd(punkGraph: ULONG_PTR; const bstrQueuedUrl: WideString; dwCurrentContext: UINT); safecall;
    procedure NotifyStreamEnd(punkGraph: ULONG_PTR); safecall;
    procedure NotifyScriptCommand(punkGraph: ULONG_PTR; const bstrCommand, bstrParam: WideString); safecall;
    procedure NotifyEarlyScriptCommand(punkGraph: ULONG_PTR; const bstrCommand, bstrParam: WideString; dTime: Double); safecall;
    procedure NotifyMarkerHit(punkGraph: ULONG_PTR; lMarker: Integer); safecall;
    procedure NotifyGraphError(punkGraph: ULONG_PTR; lErrMajor, lErrMinor, lCondition: Integer; const bstrInfo: WideString); safecall;
    procedure NotifyAcquireCredentials(punkGraph: ULONG_PTR; const bstrRealm, bstrSite, bstrUser, bstrPassword: WideString; var pdwFlags: UINT; out pfCancel: WordBool); safecall;
    procedure NotifyUntrustedLicense(punkGraph: ULONG_PTR; const bstrURL: WideString; out pfCancel: WordBool); safecall;
    procedure NotifyLicenseDialog(punkGraph: ULONG_PTR; const bstrURL: WideString; var pPostData: Byte; dwPostDataSize: UINT; lResult: Integer); safecall;
    procedure NotifyNeedsIndividualization(punkGraph: ULONG_PTR; out pfResult: WordBool); safecall;
    procedure NotifyNewMetadata(punkGraph: ULONG_PTR); safecall;
    procedure NotifyNewMediaCaps(punkGraph: ULONG_PTR); safecall;
    procedure NotifyDisconnect(punkGraph: ULONG_PTR; lResult: Integer); safecall;
    procedure NotifySave(punkGraph: ULONG_PTR; fStarted, lResult: Integer); safecall;
    procedure NotifyDelayClose(punkGraph: ULONG_PTR; fDelay: WordBool); safecall;
    procedure NotifyDVD(punkGraph: ULONG_PTR; lEventCode, lParam1, lParam2: Integer); safecall;
    procedure NotifyRequestAppThreadAction(punkGraph: ULONG_PTR; dwAction: UINT); safecall;
    procedure NotifyPrerollReady(punkGraph: ULONG_PTR); safecall;
    procedure NotifyNewIcons(punkGraph: ULONG_PTR); safecall;
    procedure NotifyStepComplete(punkGraph: ULONG_PTR); safecall;
    procedure NotifyNewBitrate(punkGraph: ULONG_PTR; dwBitrate: UINT); safecall;
  end;

{ DispInterface declaration for Dual Interface IWMPGraphEventHandler }

  IWMPGraphEventHandlerDisp = dispinterface
    ['{6B550945-018F-11D3-B14A-00C04F79FAA6}']
    procedure NotifyGraphStateChange(punkGraph: ULONG_PTR; lGraphState: Integer); dispid 8151;
    procedure AsyncNotifyGraphStateChange(punkGraph: ULONG_PTR; lGraphState: Integer); dispid 8173;
    procedure NotifyRateChange(punkGraph: ULONG_PTR; dRate: Double); dispid 8153;
    procedure NotifyPlaybackEnd(punkGraph: ULONG_PTR; const bstrQueuedUrl: WideString; dwCurrentContext: UINT); dispid 8157;
    procedure NotifyStreamEnd(punkGraph: ULONG_PTR); dispid 8156;
    procedure NotifyScriptCommand(punkGraph: ULONG_PTR; const bstrCommand, bstrParam: WideString); dispid 8158;
    procedure NotifyEarlyScriptCommand(punkGraph: ULONG_PTR; const bstrCommand, bstrParam: WideString; dTime: Double); dispid 8172;
    procedure NotifyMarkerHit(punkGraph: ULONG_PTR; lMarker: Integer); dispid 8159;
    procedure NotifyGraphError(punkGraph: ULONG_PTR; lErrMajor, lErrMinor, lCondition: Integer; const bstrInfo: WideString); dispid 8160;
    procedure NotifyAcquireCredentials(punkGraph: ULONG_PTR; const bstrRealm, bstrSite, bstrUser, bstrPassword: WideString; var pdwFlags: UINT; out pfCancel: WordBool); dispid 8161;
    procedure NotifyUntrustedLicense(punkGraph: ULONG_PTR; const bstrURL: WideString; out pfCancel: WordBool); dispid 8178;
    procedure NotifyLicenseDialog(punkGraph: ULONG_PTR; const bstrURL: WideString; var pPostData: Byte; dwPostDataSize: UINT; lResult: Integer); dispid 8162;
    procedure NotifyNeedsIndividualization(punkGraph: ULONG_PTR; out pfResult: WordBool); dispid 8163;
    procedure NotifyNewMetadata(punkGraph: ULONG_PTR); dispid 8165;
    procedure NotifyNewMediaCaps(punkGraph: ULONG_PTR); dispid 8166;
    procedure NotifyDisconnect(punkGraph: ULONG_PTR; lResult: Integer); dispid 8167;
    procedure NotifySave(punkGraph: ULONG_PTR; fStarted, lResult: Integer); dispid 8168;
    procedure NotifyDelayClose(punkGraph: ULONG_PTR; fDelay: WordBool); dispid 8169;
    procedure NotifyDVD(punkGraph: ULONG_PTR; lEventCode, lParam1, lParam2: Integer); dispid 8170;
    procedure NotifyRequestAppThreadAction(punkGraph: ULONG_PTR; dwAction: UINT); dispid 8171;
    procedure NotifyPrerollReady(punkGraph: ULONG_PTR); dispid 8174;
    procedure NotifyNewIcons(punkGraph: ULONG_PTR); dispid 8177;
    procedure NotifyStepComplete(punkGraph: ULONG_PTR); dispid 8179;
    procedure NotifyNewBitrate(punkGraph: ULONG_PTR; dwBitrate: UINT); dispid 8180;
  end;

{ IAssaultVis: Not Public.  Internal interface used by Windows Media Player. }

  IAssaultVis = interface(IDispatch)
    ['{28682B8E-9055-47A9-A179-8E0BAB1164D1}']
  end;

{ DispInterface declaration for Dual Interface IAssaultVis }

  IAssaultVisDisp = dispinterface
    ['{28682B8E-9055-47A9-A179-8E0BAB1164D1}']
  end;

{ IBattery: Not Public.  Internal interface used by Windows Media Player. }

  IBattery = interface(IDispatch)
    ['{F8578BFA-CD8F-4CE1-A684-5B7E85FCA7DC}']
    function Get_presetCount: Integer; safecall;
    function Get_preset(nIndex: Integer): IDispatch; safecall;
    property presetCount: Integer read Get_presetCount;
    property preset[nIndex: Integer]: IDispatch read Get_preset;
  end;

{ DispInterface declaration for Dual Interface IBattery }

  IBatteryDisp = dispinterface
    ['{F8578BFA-CD8F-4CE1-A684-5B7E85FCA7DC}']
    property presetCount: Integer readonly dispid 1;
    property preset[nIndex: Integer]: IDispatch readonly dispid 2;
  end;

{ IBatteryPreset: Not Public.  Internal interface used by Windows Media Player. }

  IBatteryPreset = interface(IDispatch)
    ['{40C6BDE7-9C90-49D4-AD20-BEF81A6C5F22}']
    function Get_title: WideString; safecall;
    procedure Set_title(const Value: WideString); safecall;
    property title: WideString read Get_title write Set_title;
  end;

{ DispInterface declaration for Dual Interface IBatteryPreset }

  IBatteryPresetDisp = dispinterface
    ['{40C6BDE7-9C90-49D4-AD20-BEF81A6C5F22}']
    property title: WideString dispid 1;
  end;

{ IBatteryRandomPreset: Not Public.  Internal interface used by Windows Media Player. }

  IBatteryRandomPreset = interface(IBatteryPreset)
    ['{F85E2D65-207D-48DB-84B1-915E1735DB17}']
  end;

{ DispInterface declaration for Dual Interface IBatteryRandomPreset }

  IBatteryRandomPresetDisp = dispinterface
    ['{F85E2D65-207D-48DB-84B1-915E1735DB17}']
    property title: WideString dispid 1;
  end;

{ IBatterySavedPreset: Not Public.  Internal interface used by Windows Media Player. }

  IBatterySavedPreset = interface(IBatteryPreset)
    ['{876E7208-0172-4EBB-B08B-2E1D30DFE44C}']
  end;

{ DispInterface declaration for Dual Interface IBatterySavedPreset }

  IBatterySavedPresetDisp = dispinterface
    ['{876E7208-0172-4EBB-B08B-2E1D30DFE44C}']
    property title: WideString dispid 1;
  end;

{ IBarsEffect: Not Public.  Internal interface used by Windows Media Player. }

  IBarsEffect = interface(IDispatch)
    ['{33E9291A-F6A9-11D2-9435-00A0C92A2F2D}']
    function Get_displayMode: Integer; safecall;
    procedure Set_displayMode(Value: Integer); safecall;
    function Get_showPeaks: WordBool; safecall;
    procedure Set_showPeaks(Value: WordBool); safecall;
    function Get_peakHangTime: Integer; safecall;
    procedure Set_peakHangTime(Value: Integer); safecall;
    function Get_peakFallbackAcceleration: Single; safecall;
    procedure Set_peakFallbackAcceleration(Value: Single); safecall;
    function Get_peakFallbackSpeed: Single; safecall;
    procedure Set_peakFallbackSpeed(Value: Single); safecall;
    function Get_levelFallbackAcceleration: Single; safecall;
    procedure Set_levelFallbackAcceleration(Value: Single); safecall;
    function Get_levelFallbackSpeed: Single; safecall;
    procedure Set_levelFallbackSpeed(Value: Single); safecall;
    function Get_backgroundColor: WideString; safecall;
    procedure Set_backgroundColor(const Value: WideString); safecall;
    function Get_levelColor: WideString; safecall;
    procedure Set_levelColor(const Value: WideString); safecall;
    function Get_peakColor: WideString; safecall;
    procedure Set_peakColor(const Value: WideString); safecall;
    function Get_horizontalSpacing: Integer; safecall;
    procedure Set_horizontalSpacing(Value: Integer); safecall;
    function Get_levelWidth: Integer; safecall;
    procedure Set_levelWidth(Value: Integer); safecall;
    function Get_levelScale: Single; safecall;
    procedure Set_levelScale(Value: Single); safecall;
    function Get_fadeRate: Integer; safecall;
    procedure Set_fadeRate(Value: Integer); safecall;
    function Get_fadeMode: Integer; safecall;
    procedure Set_fadeMode(Value: Integer); safecall;
    function Get_transparent: WordBool; safecall;
    procedure Set_transparent(Value: WordBool); safecall;
    property displayMode: Integer read Get_displayMode write Set_displayMode;
    property showPeaks: WordBool read Get_showPeaks write Set_showPeaks;
    property peakHangTime: Integer read Get_peakHangTime write Set_peakHangTime;
    property peakFallbackAcceleration: Single read Get_peakFallbackAcceleration write Set_peakFallbackAcceleration;
    property peakFallbackSpeed: Single read Get_peakFallbackSpeed write Set_peakFallbackSpeed;
    property levelFallbackAcceleration: Single read Get_levelFallbackAcceleration write Set_levelFallbackAcceleration;
    property levelFallbackSpeed: Single read Get_levelFallbackSpeed write Set_levelFallbackSpeed;
    property backgroundColor: WideString read Get_backgroundColor write Set_backgroundColor;
    property levelColor: WideString read Get_levelColor write Set_levelColor;
    property peakColor: WideString read Get_peakColor write Set_peakColor;
    property horizontalSpacing: Integer read Get_horizontalSpacing write Set_horizontalSpacing;
    property levelWidth: Integer read Get_levelWidth write Set_levelWidth;
    property levelScale: Single read Get_levelScale write Set_levelScale;
    property fadeRate: Integer read Get_fadeRate write Set_fadeRate;
    property fadeMode: Integer read Get_fadeMode write Set_fadeMode;
    property transparent: WordBool read Get_transparent write Set_transparent;
  end;

{ DispInterface declaration for Dual Interface IBarsEffect }

  IBarsEffectDisp = dispinterface
    ['{33E9291A-F6A9-11D2-9435-00A0C92A2F2D}']
    property displayMode: Integer dispid 8000;
    property showPeaks: WordBool dispid 8001;
    property peakHangTime: Integer dispid 8002;
    property peakFallbackAcceleration: Single dispid 8003;
    property peakFallbackSpeed: Single dispid 8004;
    property levelFallbackAcceleration: Single dispid 8005;
    property levelFallbackSpeed: Single dispid 8006;
    property backgroundColor: WideString dispid 8007;
    property levelColor: WideString dispid 8008;
    property peakColor: WideString dispid 8009;
    property horizontalSpacing: Integer dispid 8010;
    property levelWidth: Integer dispid 8012;
    property levelScale: Single dispid 8013;
    property fadeRate: Integer dispid 8014;
    property fadeMode: Integer dispid 8015;
    property transparent: WordBool dispid 8016;
  end;

{ ISpikesEffect: Not Public.  Internal interface used by Windows Media Player. }

  ISpikesEffect = interface(IDispatch)
    ['{3984E7EB-08EF-11D3-9447-00A0C92A2F2D}']
    function Get_backgroundColor: WideString; safecall;
    procedure Set_backgroundColor(const Value: WideString); safecall;
    function Get_foregroundColor: WideString; safecall;
    procedure Set_foregroundColor(const Value: WideString); safecall;
    function Get_displayMode: Integer; safecall;
    procedure Set_displayMode(Value: Integer); safecall;
    function Get_fallbackSpeed: Single; safecall;
    procedure Set_fallbackSpeed(Value: Single); safecall;
    function Get_transparent: WordBool; safecall;
    procedure Set_transparent(Value: WordBool); safecall;
    property backgroundColor: WideString read Get_backgroundColor write Set_backgroundColor;
    property foregroundColor: WideString read Get_foregroundColor write Set_foregroundColor;
    property displayMode: Integer read Get_displayMode write Set_displayMode;
    property fallbackSpeed: Single read Get_fallbackSpeed write Set_fallbackSpeed;
    property transparent: WordBool read Get_transparent write Set_transparent;
  end;

{ DispInterface declaration for Dual Interface ISpikesEffect }

  ISpikesEffectDisp = dispinterface
    ['{3984E7EB-08EF-11D3-9447-00A0C92A2F2D}']
    property backgroundColor: WideString dispid 8201;
    property foregroundColor: WideString dispid 8202;
    property displayMode: Integer dispid 8203;
    property fallbackSpeed: Single dispid 8204;
    property transparent: WordBool dispid 8205;
  end;

{ IDotPlaneEffect: Not Public.  Internal interface used by Windows Media Player. }

  IDotPlaneEffect = interface(IDispatch)
    ['{37327700-EF20-11D2-9431-00A0C92A2F2D}']
    function Get_cameraDistance: Single; safecall;
    procedure Set_cameraDistance(Value: Single); safecall;
    function Get_fallbackAcceleration: Single; safecall;
    procedure Set_fallbackAcceleration(Value: Single); safecall;
    function Get_fallbackSpeed: Single; safecall;
    procedure Set_fallbackSpeed(Value: Single); safecall;
    function Get_spinZ: WordBool; safecall;
    procedure Set_spinZ(Value: WordBool); safecall;
    function Get_spinX: WordBool; safecall;
    procedure Set_spinX(Value: WordBool); safecall;
    function Get_spinY: WordBool; safecall;
    procedure Set_spinY(Value: WordBool); safecall;
    procedure reset; safecall;
    procedure stopSpin; safecall;
    function Get_backgroundColor: WideString; safecall;
    procedure Set_backgroundColor(const Value: WideString); safecall;
    function Get_fadeColor1: WideString; safecall;
    procedure Set_fadeColor1(const Value: WideString); safecall;
    function Get_fadeColor2: WideString; safecall;
    procedure Set_fadeColor2(const Value: WideString); safecall;
    function Get_fadeColor3: WideString; safecall;
    procedure Set_fadeColor3(const Value: WideString); safecall;
    function Get_fadeColor4: WideString; safecall;
    procedure Set_fadeColor4(const Value: WideString); safecall;
    function Get_fadeColor5: WideString; safecall;
    procedure Set_fadeColor5(const Value: WideString); safecall;
    function Get_transparent: WordBool; safecall;
    procedure Set_transparent(Value: WordBool); safecall;
    property cameraDistance: Single read Get_cameraDistance write Set_cameraDistance;
    property fallbackAcceleration: Single read Get_fallbackAcceleration write Set_fallbackAcceleration;
    property fallbackSpeed: Single read Get_fallbackSpeed write Set_fallbackSpeed;
    property spinZ: WordBool read Get_spinZ write Set_spinZ;
    property spinX: WordBool read Get_spinX write Set_spinX;
    property spinY: WordBool read Get_spinY write Set_spinY;
    property backgroundColor: WideString read Get_backgroundColor write Set_backgroundColor;
    property fadeColor1: WideString read Get_fadeColor1 write Set_fadeColor1;
    property fadeColor2: WideString read Get_fadeColor2 write Set_fadeColor2;
    property fadeColor3: WideString read Get_fadeColor3 write Set_fadeColor3;
    property fadeColor4: WideString read Get_fadeColor4 write Set_fadeColor4;
    property fadeColor5: WideString read Get_fadeColor5 write Set_fadeColor5;
    property transparent: WordBool read Get_transparent write Set_transparent;
  end;

{ DispInterface declaration for Dual Interface IDotPlaneEffect }

  IDotPlaneEffectDisp = dispinterface
    ['{37327700-EF20-11D2-9431-00A0C92A2F2D}']
    property cameraDistance: Single dispid 8300;
    property fallbackAcceleration: Single dispid 8301;
    property fallbackSpeed: Single dispid 8302;
    property spinZ: WordBool dispid 8303;
    property spinX: WordBool dispid 8304;
    property spinY: WordBool dispid 8305;
    procedure reset; dispid 8313;
    procedure stopSpin; dispid 8314;
    property backgroundColor: WideString dispid 8307;
    property fadeColor1: WideString dispid 8308;
    property fadeColor2: WideString dispid 8309;
    property fadeColor3: WideString dispid 8310;
    property fadeColor4: WideString dispid 8311;
    property fadeColor5: WideString dispid 8312;
    property transparent: WordBool dispid 8315;
  end;

{ IPlenoptic: Not Public.  Internal interface used by Windows Media Player. }

  IPlenoptic = interface(IDispatch)
    ['{E31E7583-32D5-491C-B611-825D032B02CF}']
  end;

{ DispInterface declaration for Dual Interface IPlenoptic }

  IPlenopticDisp = dispinterface
    ['{E31E7583-32D5-491C-B611-825D032B02CF}']
  end;

{ IWMPExternal: Public interface for scripting object model. }

  IWMPExternal = interface(IDispatch)
    ['{E2CC638C-FD2C-409B-A1EA-5DDB72DC8E84}']
    function Get_version: WideString; safecall;
    function Get_appColorLight: WideString; safecall;
    procedure Set_OnColorChange(Value: IDispatch); safecall;
    property version: WideString read Get_version;
    property appColorLight: WideString read Get_appColorLight;
    property OnColorChange: IDispatch write Set_OnColorChange;
  end;

{ DispInterface declaration for Dual Interface IWMPExternal }

  IWMPExternalDisp = dispinterface
    ['{E2CC638C-FD2C-409B-A1EA-5DDB72DC8E84}']
    property version: WideString readonly dispid 10005;
    property appColorLight: WideString readonly dispid 10012;
    property OnColorChange: IDispatch writeonly dispid 10018;
  end;

{ IWMPExternalColors: Public interface for scripting object model. }

  IWMPExternalColors = interface(IWMPExternal)
    ['{D10CCDFF-472D-498C-B5FE-3630E5405E0A}']
    function Get_appColorMedium: WideString; safecall;
    function Get_appColorDark: WideString; safecall;
    function Get_appColorButtonHighlight: WideString; safecall;
    function Get_appColorButtonShadow: WideString; safecall;
    function Get_appColorButtonHoverFace: WideString; safecall;
    property appColorMedium: WideString read Get_appColorMedium;
    property appColorDark: WideString read Get_appColorDark;
    property appColorButtonHighlight: WideString read Get_appColorButtonHighlight;
    property appColorButtonShadow: WideString read Get_appColorButtonShadow;
    property appColorButtonHoverFace: WideString read Get_appColorButtonHoverFace;
  end;

{ DispInterface declaration for Dual Interface IWMPExternalColors }

  IWMPExternalColorsDisp = dispinterface
    ['{D10CCDFF-472D-498C-B5FE-3630E5405E0A}']
    property version: WideString readonly dispid 10005;
    property appColorLight: WideString readonly dispid 10012;
    property OnColorChange: IDispatch writeonly dispid 10018;
    property appColorMedium: WideString readonly dispid 10013;
    property appColorDark: WideString readonly dispid 10014;
    property appColorButtonHighlight: WideString readonly dispid 10015;
    property appColorButtonShadow: WideString readonly dispid 10016;
    property appColorButtonHoverFace: WideString readonly dispid 10017;
  end;

{ IWMPTemplatesExternal: Not Public.  Internal interface used by Windows Media Player. }

  IWMPTemplatesExternal = interface(IWMPExternalColors)
    ['{FFFB0104-CCBB-4513-8B6B-46F5098FAB43}']
    procedure EditMetadata; safecall;
    function IsMetadataAvailableForEdit: WordBool; safecall;
    function IsAutoMetadataDownloadAllowed: WordBool; safecall;
    procedure AdvancedEditDialog; safecall;
    function IsAdvancedEditDialogAvailable: WordBool; safecall;
    function Get_HueShiftedBitmapURL(resID: Integer): WideString; safecall;
    procedure FindMedia(const bstrURLParams: WideString); safecall;
    procedure BuyCD(const bstrURLParams: WideString); safecall;
    function Get_State: WideString; safecall;
    procedure Set_State(const Value: WideString); safecall;
    property HueShiftedBitmapURL[resID: Integer]: WideString read Get_HueShiftedBitmapURL;
    property State: WideString read Get_State write Set_State;
  end;

{ DispInterface declaration for Dual Interface IWMPTemplatesExternal }

  IWMPTemplatesExternalDisp = dispinterface
    ['{FFFB0104-CCBB-4513-8B6B-46F5098FAB43}']
    property version: WideString readonly dispid 10005;
    property appColorLight: WideString readonly dispid 10012;
    property OnColorChange: IDispatch writeonly dispid 10018;
    property appColorMedium: WideString readonly dispid 10013;
    property appColorDark: WideString readonly dispid 10014;
    property appColorButtonHighlight: WideString readonly dispid 10015;
    property appColorButtonShadow: WideString readonly dispid 10016;
    property appColorButtonHoverFace: WideString readonly dispid 10017;
    procedure EditMetadata; dispid 10011;
    function IsMetadataAvailableForEdit: WordBool; dispid 10010;
    function IsAutoMetadataDownloadAllowed: WordBool; dispid 10019;
    procedure AdvancedEditDialog; dispid 10006;
    function IsAdvancedEditDialogAvailable: WordBool; dispid 10021;
    property HueShiftedBitmapURL[resID: Integer]: WideString readonly dispid 10020;
    procedure FindMedia(const bstrURLParams: WideString); dispid 10022;
    procedure BuyCD(const bstrURLParams: WideString); dispid 10023;
    property State: WideString dispid 10024;
  end;

{ IWMPSubscriptionServiceExternal: Public interface for scripting object model. }

  IWMPSubscriptionServiceExternal = interface(IWMPExternal)
    ['{2E922378-EE70-4CEB-BBAB-CE7CE4A04816}']
    function Get_DownloadManager: IWMPDownloadManager; safecall;
    property DownloadManager: IWMPDownloadManager read Get_DownloadManager;
  end;

{ DispInterface declaration for Dual Interface IWMPSubscriptionServiceExternal }

  IWMPSubscriptionServiceExternalDisp = dispinterface
    ['{2E922378-EE70-4CEB-BBAB-CE7CE4A04816}']
    property version: WideString readonly dispid 10005;
    property appColorLight: WideString readonly dispid 10012;
    property OnColorChange: IDispatch writeonly dispid 10018;
    property DownloadManager: IWMPDownloadManager readonly dispid 10009;
  end;

{ IWMPDownloadManager: Public interface for Windows Media Player Subscription Service SDK. }

  IWMPDownloadManager = interface(IDispatch)
    ['{E15E9AD1-8F20-4CC4-9EC7-1A328CA86A0D}']
    function getDownloadCollection(lCollectionId: Integer): IWMPDownloadCollection; safecall;
    function createDownloadCollection: IWMPDownloadCollection; safecall;
  end;

{ DispInterface declaration for Dual Interface IWMPDownloadManager }

  IWMPDownloadManagerDisp = dispinterface
    ['{E15E9AD1-8F20-4CC4-9EC7-1A328CA86A0D}']
    function getDownloadCollection(lCollectionId: Integer): IWMPDownloadCollection; dispid 1151;
    function createDownloadCollection: IWMPDownloadCollection; dispid 1152;
  end;

{ IWMPDownloadCollection: Public interface for Windows Media Player Subscription Service SDK. }

  IWMPDownloadCollection = interface(IDispatch)
    ['{7AAA2D24-B37A-4E11-82C1-E071246463A4}']
    function Get_id: Integer; safecall;
    function Get_count: Integer; safecall;
    function Item(lItem: Integer): IWMPDownloadItem; safecall;
    function startDownload(const bstrSourceURL, bstrType: WideString): IWMPDownloadItem; safecall;
    procedure removeItem(lItem: Integer); safecall;
    procedure clear; safecall;
    property id: Integer read Get_id;
    property count: Integer read Get_count;
  end;

{ DispInterface declaration for Dual Interface IWMPDownloadCollection }

  IWMPDownloadCollectionDisp = dispinterface
    ['{7AAA2D24-B37A-4E11-82C1-E071246463A4}']
    property id: Integer readonly dispid 1201;
    property count: Integer readonly dispid 1202;
    function Item(lItem: Integer): IWMPDownloadItem; dispid 1203;
    function startDownload(const bstrSourceURL, bstrType: WideString): IWMPDownloadItem; dispid 1204;
    procedure removeItem(lItem: Integer); dispid 1205;
    procedure clear; dispid 1206;
  end;

{ IWMPDownloadItem: Public interface for Windows Media Player Subscription Service SDK. }

  IWMPDownloadItem = interface(IDispatch)
    ['{C9470E8E-3F6B-46A9-A0A9-452815C34297}']
    function Get_sourceURL: WideString; safecall;
    function Get_size: Integer; safecall;
    function Get_type_: WideString; safecall;
    function Get_progress: Integer; safecall;
    function Get_downloadState: WMPSubscriptionDownloadState; safecall;
    procedure pause; safecall;
    procedure resume; safecall;
    procedure cancel; safecall;
    property sourceURL: WideString read Get_sourceURL;
    property size: Integer read Get_size;
    property type_: WideString read Get_type_;
    property progress: Integer read Get_progress;
    property downloadState: WMPSubscriptionDownloadState read Get_downloadState;
  end;

{ DispInterface declaration for Dual Interface IWMPDownloadItem }

  IWMPDownloadItemDisp = dispinterface
    ['{C9470E8E-3F6B-46A9-A0A9-452815C34297}']
    property sourceURL: WideString readonly dispid 1251;
    property size: Integer readonly dispid 1252;
    property type_: WideString readonly dispid 1253;
    property progress: Integer readonly dispid 1254;
    property downloadState: WMPSubscriptionDownloadState readonly dispid 1255;
    procedure pause; dispid 1256;
    procedure resume; dispid 1257;
    procedure cancel; dispid 1258;
  end;

{ IWMPCDDVDWizardExternal: Not Public.  Internal interface used by Windows Media Player. }

  IWMPCDDVDWizardExternal = interface(IWMPExternalColors)
    ['{2D7EF888-1D3C-484A-A906-9F49D99BB344}']
    procedure WriteNames(const bstrTOC, bstrMetadata: WideString); safecall;
    procedure ReturnToMainTask; safecall;
    procedure WriteNamesEx(type_: WMP_WRITENAMESEX_TYPE; const bstrTypeId, bstrMetadata: WideString; fRenameRegroupFiles: WordBool); safecall;
    function GetMDQByRequestID(const bstrRequestID: WideString): WideString; safecall;
    procedure EditMetadata; safecall;
    function IsMetadataAvailableForEdit: WordBool; safecall;
  end;

{ DispInterface declaration for Dual Interface IWMPCDDVDWizardExternal }

  IWMPCDDVDWizardExternalDisp = dispinterface
    ['{2D7EF888-1D3C-484A-A906-9F49D99BB344}']
    property version: WideString readonly dispid 10005;
    property appColorLight: WideString readonly dispid 10012;
    property OnColorChange: IDispatch writeonly dispid 10018;
    property appColorMedium: WideString readonly dispid 10013;
    property appColorDark: WideString readonly dispid 10014;
    property appColorButtonHighlight: WideString readonly dispid 10015;
    property appColorButtonShadow: WideString readonly dispid 10016;
    property appColorButtonHoverFace: WideString readonly dispid 10017;
    procedure WriteNames(const bstrTOC, bstrMetadata: WideString); dispid 10001;
    procedure ReturnToMainTask; dispid 10002;
    procedure WriteNamesEx(type_: WMP_WRITENAMESEX_TYPE; const bstrTypeId, bstrMetadata: WideString; fRenameRegroupFiles: WordBool); dispid 10007;
    function GetMDQByRequestID(const bstrRequestID: WideString): WideString; dispid 10008;
    procedure EditMetadata; dispid 10011;
    function IsMetadataAvailableForEdit: WordBool; dispid 10010;
  end;

{ IWMPBaseExternal: Public interface for scripting object model. }

  IWMPBaseExternal = interface(IWMPExternal)
    ['{F81B2A59-02BC-4003-8B2F-C124AF66FC66}']
  end;

{ DispInterface declaration for Dual Interface IWMPBaseExternal }

  IWMPBaseExternalDisp = dispinterface
    ['{F81B2A59-02BC-4003-8B2F-C124AF66FC66}']
    property version: WideString readonly dispid 10005;
    property appColorLight: WideString readonly dispid 10012;
    property OnColorChange: IDispatch writeonly dispid 10018;
  end;

{ IWMPOfflineExternal: Not Public.  Internal interface used by Windows Media Player.. }

  IWMPOfflineExternal = interface(IWMPExternal)
    ['{3148E685-B243-423D-8341-8480D6EFF674}']
    procedure forceOnline; safecall;
  end;

{ DispInterface declaration for Dual Interface IWMPOfflineExternal }

  IWMPOfflineExternalDisp = dispinterface
    ['{3148E685-B243-423D-8341-8480D6EFF674}']
    property version: WideString readonly dispid 10005;
    property appColorLight: WideString readonly dispid 10012;
    property OnColorChange: IDispatch writeonly dispid 10018;
    procedure forceOnline; dispid 10025;
  end;

{ Windows Media Player ActiveX Control }

  TWindowsMediaPlayerOpenStateChange = procedure(Sender: TObject; NewState: Integer) of object;
  TWindowsMediaPlayerPlayStateChange = procedure(Sender: TObject; NewState: Integer) of object;
  TWindowsMediaPlayerAudioLanguageChange = procedure(Sender: TObject; LangID: Integer) of object;
  TWindowsMediaPlayerScriptCommand = procedure(Sender: TObject; const scType, Param: WideString) of object;
  TWindowsMediaPlayerDisconnect = procedure(Sender: TObject; Result: Integer) of object;
  TWindowsMediaPlayerBuffering = procedure(Sender: TObject; Start: WordBool) of object;
  TWindowsMediaPlayerWarning = procedure(Sender: TObject; WarningType, Param: Integer; const Description: WideString) of object;
  TWindowsMediaPlayerEndOfStream = procedure(Sender: TObject; Result: Integer) of object;
  TWindowsMediaPlayerPositionChange = procedure(Sender: TObject; oldPosition, newPosition: Double) of object;
  TWindowsMediaPlayerMarkerHit = procedure(Sender: TObject; MarkerNum: Integer) of object;
  TWindowsMediaPlayerDurationUnitChange = procedure(Sender: TObject; NewDurationUnit: Integer) of object;
  TWindowsMediaPlayerCdromMediaChange = procedure(Sender: TObject; CdromNum: Integer) of object;
  TWindowsMediaPlayerPlaylistChange = procedure(Sender: TObject; Playlist: IDispatch; change: WMPPlaylistChangeEventType) of object;
  TWindowsMediaPlayerCurrentPlaylistChange = procedure(Sender: TObject; change: WMPPlaylistChangeEventType) of object;
  TWindowsMediaPlayerCurrentPlaylistItemAvailable = procedure(Sender: TObject; const bstrItemName: WideString) of object;
  TWindowsMediaPlayerMediaChange = procedure(Sender: TObject; Item: IDispatch) of object;
  TWindowsMediaPlayerCurrentMediaItemAvailable = procedure(Sender: TObject; const bstrItemName: WideString) of object;
  TWindowsMediaPlayerCurrentItemChange = procedure(Sender: TObject; pdispMedia: IDispatch) of object;
  TWindowsMediaPlayerMediaCollectionAttributeStringAdded = procedure(Sender: TObject; const bstrAttribName, bstrAttribVal: WideString) of object;
  TWindowsMediaPlayerMediaCollectionAttributeStringRemoved = procedure(Sender: TObject; const bstrAttribName, bstrAttribVal: WideString) of object;
  TWindowsMediaPlayerMediaCollectionAttributeStringChanged = procedure(Sender: TObject; const bstrAttribName, bstrOldAttribVal, bstrNewAttribVal: WideString) of object;
  TWindowsMediaPlayerPlaylistCollectionPlaylistAdded = procedure(Sender: TObject; const bstrPlaylistName: WideString) of object;
  TWindowsMediaPlayerPlaylistCollectionPlaylistRemoved = procedure(Sender: TObject; const bstrPlaylistName: WideString) of object;
  TWindowsMediaPlayerPlaylistCollectionPlaylistSetAsDeleted = procedure(Sender: TObject; const bstrPlaylistName: WideString; varfIsDeleted: WordBool) of object;
  TWindowsMediaPlayerModeChange = procedure(Sender: TObject; const ModeName: WideString; NewValue: WordBool) of object;
  TWindowsMediaPlayerMediaError = procedure(Sender: TObject; pMediaObject: IDispatch) of object;
  TWindowsMediaPlayerOpenPlaylistSwitch = procedure(Sender: TObject; pItem: IDispatch) of object;
  TWindowsMediaPlayerDomainChange = procedure(Sender: TObject; const strDomain: WideString) of object;
  TWindowsMediaPlayerClick = procedure(Sender: TObject; nButton, nShiftState: Smallint; fX, fY: Integer) of object;
  TWindowsMediaPlayerDoubleClick = procedure(Sender: TObject; nButton, nShiftState: Smallint; fX, fY: Integer) of object;
  TWindowsMediaPlayerKeyDown = procedure(Sender: TObject; nKeyCode, nShiftState: Smallint) of object;
  TWindowsMediaPlayerKeyPress = procedure(Sender: TObject; nKeyAscii: Smallint) of object;
  TWindowsMediaPlayerKeyUp = procedure(Sender: TObject; nKeyCode, nShiftState: Smallint) of object;
  TWindowsMediaPlayerMouseDown = procedure(Sender: TObject; nButton, nShiftState: Smallint; fX, fY: Integer) of object;
  TWindowsMediaPlayerMouseMove = procedure(Sender: TObject; nButton, nShiftState: Smallint; fX, fY: Integer) of object;
  TWindowsMediaPlayerMouseUp = procedure(Sender: TObject; nButton, nShiftState: Smallint; fX, fY: Integer) of object;

  TWindowsMediaPlayer = class(TOleControl)
  private
    FOnOpenStateChange: TWindowsMediaPlayerOpenStateChange;
    FOnPlayStateChange: TWindowsMediaPlayerPlayStateChange;
    FOnAudioLanguageChange: TWindowsMediaPlayerAudioLanguageChange;
    FOnStatusChange: TNotifyEvent;
    FOnScriptCommand: TWindowsMediaPlayerScriptCommand;
    FOnNewStream: TNotifyEvent;
    FOnDisconnect: TWindowsMediaPlayerDisconnect;
    FOnBuffering: TWindowsMediaPlayerBuffering;
    FOnError: TNotifyEvent;
    FOnWarning: TWindowsMediaPlayerWarning;
    FOnEndOfStream: TWindowsMediaPlayerEndOfStream;
    FOnPositionChange: TWindowsMediaPlayerPositionChange;
    FOnMarkerHit: TWindowsMediaPlayerMarkerHit;
    FOnDurationUnitChange: TWindowsMediaPlayerDurationUnitChange;
    FOnCdromMediaChange: TWindowsMediaPlayerCdromMediaChange;
    FOnPlaylistChange: TWindowsMediaPlayerPlaylistChange;
    FOnCurrentPlaylistChange: TWindowsMediaPlayerCurrentPlaylistChange;
    FOnCurrentPlaylistItemAvailable: TWindowsMediaPlayerCurrentPlaylistItemAvailable;
    FOnMediaChange: TWindowsMediaPlayerMediaChange;
    FOnCurrentMediaItemAvailable: TWindowsMediaPlayerCurrentMediaItemAvailable;
    FOnCurrentItemChange: TWindowsMediaPlayerCurrentItemChange;
    FOnMediaCollectionChange: TNotifyEvent;
    FOnMediaCollectionAttributeStringAdded: TWindowsMediaPlayerMediaCollectionAttributeStringAdded;
    FOnMediaCollectionAttributeStringRemoved: TWindowsMediaPlayerMediaCollectionAttributeStringRemoved;
    FOnMediaCollectionAttributeStringChanged: TWindowsMediaPlayerMediaCollectionAttributeStringChanged;
    FOnPlaylistCollectionChange: TNotifyEvent;
    FOnPlaylistCollectionPlaylistAdded: TWindowsMediaPlayerPlaylistCollectionPlaylistAdded;
    FOnPlaylistCollectionPlaylistRemoved: TWindowsMediaPlayerPlaylistCollectionPlaylistRemoved;
    FOnPlaylistCollectionPlaylistSetAsDeleted: TWindowsMediaPlayerPlaylistCollectionPlaylistSetAsDeleted;
    FOnModeChange: TWindowsMediaPlayerModeChange;
    FOnMediaError: TWindowsMediaPlayerMediaError;
    FOnOpenPlaylistSwitch: TWindowsMediaPlayerOpenPlaylistSwitch;
    FOnDomainChange: TWindowsMediaPlayerDomainChange;
    FOnSwitchedToPlayerApplication: TNotifyEvent;
    FOnSwitchedToControl: TNotifyEvent;
    FOnPlayerDockedStateChange: TNotifyEvent;
    FOnPlayerReconnect: TNotifyEvent;
    FOnClick: TWindowsMediaPlayerClick;
    FOnDoubleClick: TWindowsMediaPlayerDoubleClick;
    FOnKeyDown: TWindowsMediaPlayerKeyDown;
    FOnKeyPress: TWindowsMediaPlayerKeyPress;
    FOnKeyUp: TWindowsMediaPlayerKeyUp;
    FOnMouseDown: TWindowsMediaPlayerMouseDown;
    FOnMouseMove: TWindowsMediaPlayerMouseMove;
    FOnMouseUp: TWindowsMediaPlayerMouseUp;
    FIntf: IWMPPlayer4;
    function GetControlInterface: IWMPPlayer4;
    function Get_controls: IWMPControls;
    function Get_settings: IWMPSettings;
    function Get_currentMedia: IWMPMedia;
    procedure Set_currentMedia(const Value: IWMPMedia);
    function Get_mediaCollection: IWMPMediaCollection;
    function Get_playlistCollection: IWMPPlaylistCollection;
    function Get_network: IWMPNetwork;
    function Get_currentPlaylist: IWMPPlaylist;
    procedure Set_currentPlaylist(const Value: IWMPPlaylist);
    function Get_cdromCollection: IWMPCdromCollection;
    function Get_closedCaption: IWMPClosedCaption;
    function Get_Error: IWMPError;
    function Get_dvd: IWMPDVD;
    function Get_playerApplication: IWMPPlayerApplication;
  protected
    procedure CreateControl;
    procedure InitControlData; override;
    function GetTOleEnumProp(Index: Integer): TOleEnum;
    procedure SetTOleEnumProp(Index: Integer; Value: TOleEnum);
  public
    procedure close;
    procedure launchURL(const bstrURL: WideString);
    function newPlaylist(const bstrName, bstrURL: WideString): IWMPPlaylist;
    function newMedia(const bstrURL: WideString): IWMPMedia;
    procedure openPlayer(const bstrURL: WideString);
    property ControlInterface: IWMPPlayer4 read GetControlInterface;
    property openState: WMPOpenState index 2 read GetTOleEnumProp;
    property playState: WMPPlayState index 10 read GetTOleEnumProp;
    property controls: IWMPControls read Get_controls;
    property settings: IWMPSettings read Get_settings;
    property mediaCollection: IWMPMediaCollection read Get_mediaCollection;
    property playlistCollection: IWMPPlaylistCollection read Get_playlistCollection;
    property versionInfo: WideString index 11 read GetWideStringProp;
    property network: IWMPNetwork read Get_network;
    property cdromCollection: IWMPCdromCollection read Get_cdromCollection;
    property closedCaption: IWMPClosedCaption read Get_closedCaption;
    property isOnline: WordBool index 16 read GetWordBoolProp;
    property IWMPCore_Error: IWMPError read Get_Error;
    property status: WideString index 18 read GetWideStringProp;
    property dvd: IWMPDVD read Get_dvd;
    property isRemote: WordBool index 26 read GetWordBoolProp;
    property playerApplication: IWMPPlayerApplication read Get_playerApplication;
  published
    property TabStop;
    property Align;
    property DragCursor;
    property DragMode;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property Visible;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnStartDrag;
    property URL: WideString index 1 read GetWideStringProp write SetWideStringProp stored False;
    property currentMedia: IWMPMedia read Get_currentMedia write Set_currentMedia stored False;
    property currentPlaylist: IWMPPlaylist read Get_currentPlaylist write Set_currentPlaylist stored False;
    property enabled: WordBool index 19 read GetWordBoolProp write SetWordBoolProp stored False;
    property fullScreen: WordBool index 21 read GetWordBoolProp write SetWordBoolProp stored False;
    property enableContextMenu: WordBool index 22 read GetWordBoolProp write SetWordBoolProp stored False;
    property uiMode: WideString index 23 read GetWideStringProp write SetWideStringProp stored False;
    property stretchToFit: WordBool index 24 read GetWordBoolProp write SetWordBoolProp stored False;
    property windowlessVideo: WordBool index 25 read GetWordBoolProp write SetWordBoolProp stored False;
    property OnOpenStateChange: TWindowsMediaPlayerOpenStateChange read FOnOpenStateChange write FOnOpenStateChange;
    property OnPlayStateChange: TWindowsMediaPlayerPlayStateChange read FOnPlayStateChange write FOnPlayStateChange;
    property OnAudioLanguageChange: TWindowsMediaPlayerAudioLanguageChange read FOnAudioLanguageChange write FOnAudioLanguageChange;
    property OnStatusChange: TNotifyEvent read FOnStatusChange write FOnStatusChange;
    property OnScriptCommand: TWindowsMediaPlayerScriptCommand read FOnScriptCommand write FOnScriptCommand;
    property OnNewStream: TNotifyEvent read FOnNewStream write FOnNewStream;
    property OnDisconnect: TWindowsMediaPlayerDisconnect read FOnDisconnect write FOnDisconnect;
    property OnBuffering: TWindowsMediaPlayerBuffering read FOnBuffering write FOnBuffering;
    property OnError: TNotifyEvent read FOnError write FOnError;
    property OnWarning: TWindowsMediaPlayerWarning read FOnWarning write FOnWarning;
    property OnEndOfStream: TWindowsMediaPlayerEndOfStream read FOnEndOfStream write FOnEndOfStream;
    property OnPositionChange: TWindowsMediaPlayerPositionChange read FOnPositionChange write FOnPositionChange;
    property OnMarkerHit: TWindowsMediaPlayerMarkerHit read FOnMarkerHit write FOnMarkerHit;
    property OnDurationUnitChange: TWindowsMediaPlayerDurationUnitChange read FOnDurationUnitChange write FOnDurationUnitChange;
    property OnCdromMediaChange: TWindowsMediaPlayerCdromMediaChange read FOnCdromMediaChange write FOnCdromMediaChange;
    property OnPlaylistChange: TWindowsMediaPlayerPlaylistChange read FOnPlaylistChange write FOnPlaylistChange;
    property OnCurrentPlaylistChange: TWindowsMediaPlayerCurrentPlaylistChange read FOnCurrentPlaylistChange write FOnCurrentPlaylistChange;
    property OnCurrentPlaylistItemAvailable: TWindowsMediaPlayerCurrentPlaylistItemAvailable read FOnCurrentPlaylistItemAvailable write FOnCurrentPlaylistItemAvailable;
    property OnMediaChange: TWindowsMediaPlayerMediaChange read FOnMediaChange write FOnMediaChange;
    property OnCurrentMediaItemAvailable: TWindowsMediaPlayerCurrentMediaItemAvailable read FOnCurrentMediaItemAvailable write FOnCurrentMediaItemAvailable;
    property OnCurrentItemChange: TWindowsMediaPlayerCurrentItemChange read FOnCurrentItemChange write FOnCurrentItemChange;
    property OnMediaCollectionChange: TNotifyEvent read FOnMediaCollectionChange write FOnMediaCollectionChange;
    property OnMediaCollectionAttributeStringAdded: TWindowsMediaPlayerMediaCollectionAttributeStringAdded read FOnMediaCollectionAttributeStringAdded write FOnMediaCollectionAttributeStringAdded;
    property OnMediaCollectionAttributeStringRemoved: TWindowsMediaPlayerMediaCollectionAttributeStringRemoved read FOnMediaCollectionAttributeStringRemoved write FOnMediaCollectionAttributeStringRemoved;
    property OnMediaCollectionAttributeStringChanged: TWindowsMediaPlayerMediaCollectionAttributeStringChanged read FOnMediaCollectionAttributeStringChanged write FOnMediaCollectionAttributeStringChanged;
    property OnPlaylistCollectionChange: TNotifyEvent read FOnPlaylistCollectionChange write FOnPlaylistCollectionChange;
    property OnPlaylistCollectionPlaylistAdded: TWindowsMediaPlayerPlaylistCollectionPlaylistAdded read FOnPlaylistCollectionPlaylistAdded write FOnPlaylistCollectionPlaylistAdded;
    property OnPlaylistCollectionPlaylistRemoved: TWindowsMediaPlayerPlaylistCollectionPlaylistRemoved read FOnPlaylistCollectionPlaylistRemoved write FOnPlaylistCollectionPlaylistRemoved;
    property OnPlaylistCollectionPlaylistSetAsDeleted: TWindowsMediaPlayerPlaylistCollectionPlaylistSetAsDeleted read FOnPlaylistCollectionPlaylistSetAsDeleted write FOnPlaylistCollectionPlaylistSetAsDeleted;
    property OnModeChange: TWindowsMediaPlayerModeChange read FOnModeChange write FOnModeChange;
    property OnMediaError: TWindowsMediaPlayerMediaError read FOnMediaError write FOnMediaError;
    property OnOpenPlaylistSwitch: TWindowsMediaPlayerOpenPlaylistSwitch read FOnOpenPlaylistSwitch write FOnOpenPlaylistSwitch;
    property OnDomainChange: TWindowsMediaPlayerDomainChange read FOnDomainChange write FOnDomainChange;
    property OnSwitchedToPlayerApplication: TNotifyEvent read FOnSwitchedToPlayerApplication write FOnSwitchedToPlayerApplication;
    property OnSwitchedToControl: TNotifyEvent read FOnSwitchedToControl write FOnSwitchedToControl;
    property OnPlayerDockedStateChange: TNotifyEvent read FOnPlayerDockedStateChange write FOnPlayerDockedStateChange;
    property OnPlayerReconnect: TNotifyEvent read FOnPlayerReconnect write FOnPlayerReconnect;
    property OnClick: TWindowsMediaPlayerClick read FOnClick write FOnClick;
    property OnDoubleClick: TWindowsMediaPlayerDoubleClick read FOnDoubleClick write FOnDoubleClick;
    property OnKeyDown: TWindowsMediaPlayerKeyDown read FOnKeyDown write FOnKeyDown;
    property OnKeyPress: TWindowsMediaPlayerKeyPress read FOnKeyPress write FOnKeyPress;
    property OnKeyUp: TWindowsMediaPlayerKeyUp read FOnKeyUp write FOnKeyUp;
    property OnMouseDown: TWindowsMediaPlayerMouseDown read FOnMouseDown write FOnMouseDown;
    property OnMouseMove: TWindowsMediaPlayerMouseMove read FOnMouseMove write FOnMouseMove;
    property OnMouseUp: TWindowsMediaPlayerMouseUp read FOnMouseUp write FOnMouseUp;
  end;

procedure Register;

implementation

uses ComObj;

procedure TWindowsMediaPlayer.InitControlData;
const
  CEventDispIDs: array[0..44] of Integer = (
    $00001389, $000013ED, $000013EE, $0000138A, $000014B5, $0000151B,
    $00001519, $0000151A, $0000157D, $000015E1, $00001451, $00001452,
    $00001453, $00001454, $00001645, $000016A9, $000016AC, $000016AD,
    $000016AA, $000016AB, $000016AE, $000016AF, $000016B0, $000016B1,
    $000016BC, $000016B2, $000016B3, $000016B4, $000016BA, $000016BB,
    $000016BD, $000016BF, $000016BE, $00001965, $00001966, $00001967,
    $00001968, $00001969, $0000196A, $0000196B, $0000196C, $0000196D,
    $0000196E, $0000196F, $00001970);
  CControlData: TControlData = (
    ClassID: '{6BF52A52-394A-11D3-B153-00C04F79FAA6}';
    EventIID: '{6BF52A51-394A-11D3-B153-00C04F79FAA6}';
    EventCount: 45;
    EventDispIDs: @CEventDispIDs;
    LicenseKey: nil;
    Flags: $00000000;
    Version: 300);
begin
  ControlData := @CControlData;
end;

procedure TWindowsMediaPlayer.CreateControl;

  procedure DoCreate;
  begin
    FIntf := IUnknown(OleObject) as IWMPPlayer4;
  end;

begin
  if FIntf = nil then DoCreate;
end;

function TWindowsMediaPlayer.GetControlInterface: IWMPPlayer4;
begin
  CreateControl;
  Result := FIntf;
end;

function TWindowsMediaPlayer.GetTOleEnumProp(Index: Integer): TOleEnum;
begin
  Result := GetIntegerProp(Index);
end;

procedure TWindowsMediaPlayer.SetTOleEnumProp(Index: Integer; Value: TOleEnum);
begin
  SetIntegerProp(Index, Value);
end;

procedure TWindowsMediaPlayer.close;
begin
  CreateControl;
  FIntf.close;
end;

procedure TWindowsMediaPlayer.launchURL(const bstrURL: WideString);
begin
  CreateControl;
  FIntf.launchURL(bstrURL);
end;

function TWindowsMediaPlayer.newPlaylist(const bstrName, bstrURL: WideString): IWMPPlaylist;
begin
  CreateControl;
  Result := FIntf.newPlaylist(bstrName, bstrURL);
end;

function TWindowsMediaPlayer.newMedia(const bstrURL: WideString): IWMPMedia;
begin
  CreateControl;
  Result := FIntf.newMedia(bstrURL);
end;

procedure TWindowsMediaPlayer.openPlayer(const bstrURL: WideString);
begin
  CreateControl;
  FIntf.openPlayer(bstrURL);
end;

function TWindowsMediaPlayer.Get_controls: IWMPControls;
begin
  CreateControl;
  Result := FIntf.controls;
end;

function TWindowsMediaPlayer.Get_settings: IWMPSettings;
begin
  CreateControl;
  Result := FIntf.settings;
end;

function TWindowsMediaPlayer.Get_currentMedia: IWMPMedia;
begin
  CreateControl;
  Result := FIntf.currentMedia;
end;

procedure TWindowsMediaPlayer.Set_currentMedia(const Value: IWMPMedia);
begin
  CreateControl;
  FIntf.currentMedia := Value;
end;

function TWindowsMediaPlayer.Get_mediaCollection: IWMPMediaCollection;
begin
  CreateControl;
  Result := FIntf.mediaCollection;
end;

function TWindowsMediaPlayer.Get_playlistCollection: IWMPPlaylistCollection;
begin
  CreateControl;
  Result := FIntf.playlistCollection;
end;

function TWindowsMediaPlayer.Get_network: IWMPNetwork;
begin
  CreateControl;
  Result := FIntf.network;
end;

function TWindowsMediaPlayer.Get_currentPlaylist: IWMPPlaylist;
begin
  CreateControl;
  Result := FIntf.currentPlaylist;
end;

procedure TWindowsMediaPlayer.Set_currentPlaylist(const Value: IWMPPlaylist);
begin
  CreateControl;
  FIntf.currentPlaylist := Value;
end;

function TWindowsMediaPlayer.Get_cdromCollection: IWMPCdromCollection;
begin
  CreateControl;
  Result := FIntf.cdromCollection;
end;

function TWindowsMediaPlayer.Get_closedCaption: IWMPClosedCaption;
begin
  CreateControl;
  Result := FIntf.closedCaption;
end;

function TWindowsMediaPlayer.Get_Error: IWMPError;
begin
  CreateControl;
  Result := FIntf.Error;
end;

function TWindowsMediaPlayer.Get_dvd: IWMPDVD;
begin
  CreateControl;
  Result := FIntf.dvd;
end;

function TWindowsMediaPlayer.Get_playerApplication: IWMPPlayerApplication;
begin
  CreateControl;
  Result := FIntf.playerApplication;
end;


procedure Register;
begin
  RegisterComponents('ActiveX', [TWindowsMediaPlayer]);
end;

end.
