program SoapPublisherDemo;

{$APPTYPE CONSOLE}

uses
  xmldoc,
  InvokeRegistry,
  SysUtils,
  BTJMSClient in '..\..\source\BTJMSClient.pas',
  BTStompInterfaces in '..\..\source\BTStompInterfaces.pas',
  BTActiveMQClient in '..\..\source\BTActiveMQClient.pas',
  BTJMSInterfaces in '..\..\source\BTJMSInterfaces.pas',
  BTStompTypes in '..\..\source\BTStompTypes.pas',
  BTStompConnection in '..\..\source\BTStompConnection.pas',
  BTActiveMQSoapClient in '..\..\source\BTActiveMQSoapClient.pas',
  BTSupportInterfaces in '..\..\source\BTSupportInterfaces.pas',
  BTCommAdapterIndy in '..\..\source\BTCommAdapterIndy.pas';

const
  Dest = '/queue/a';

  type
  TExampleClass = class(TRemotable)
  private
    FName: string;
    procedure SetName(const Value: string);
  published
  property Name: string read FName write SetName;
  end;

var
  Conn: TBTActiveMQSoapClient;
  I: Integer;
  L: ILogging;
  Compiler: string;
  ExampleObject: TExampleClass;


{ TExampleClass }

procedure TExampleClass.SetName(const Value: string);
begin
  FName := Value;
end;

begin
  {$IFDEF FPC}
  Compiler := 'Free Pascal';
  {$ELSE}
  Compiler := 'Borland Delphi';
  {$ENDIF}

  Conn := TBTActiveMQSoapClient.Create(nil);
  Conn.SoapAdapter.XMLDocument := TXmlDocument.Create(nil);

  try
    if ParamCount = 1 then
      Conn.Host := ParamStr(1)
    else
      Conn.Host := 'localhost';

    L := Conn.Logger;
    L.Info(Conn.ClassName + ' ' + Conn.Version + ' Compiler: '  + Compiler);
    L.Info('Connect to server');
    Conn.Connect;

    while not Conn.StompConnected do
    Sleep(50);

    for I := 0 to 7 do
    begin
      L.Info(Format('Sending test message to %s on %s...', [Dest, Conn.Host]));
      ExampleObject := TExampleClass.Create;
      try
        ExampleObject.Name := 'Name ' + IntToStr(I);
        Conn.Send(Dest, ExampleObject, 'ObjectName');
      finally
        ExampleObject.Free;
      end;
    end;

    Conn.Disconnect;

    L.Info('Hit any key');
    ReadLn;

  finally
    Conn.Free;
  end;

end.

